#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2021-2023. All rights reserved.

"""
@version: SmartKit V200R007C00
@time: 2021/08/06
@file: recover_control_cluster_ccdb.py
@function: 恢复控制集群的ccdb
@modify:
"""
from py.common.entity.item_status import ItemStatus
from py.common.service.auto_brush_item_progress import auto_brush_progress
from py.common.service.connection import ssh_cmd_util
from py.common.service.connection.ssh_connection_service import SshService
from py.fusion_storage.common.context import common_context_util
from py.fusion_storage.common.record import record_meta_usage_mode
from py.fusion_storage.common.service.recover_cluster_ccdb_service import \
    AbstractRecoverClusterCCDBService
from py.fusion_storage.common.service.cluster.cluster_info_util \
    import is_ocean_stor_pacific

CONTROL_CONFIG_DIR_PATH = \
    "/opt/dsware/client/conf/service/eds/serviceMediaConfig.xml"
MODIFY_MEDIA_CONFIG_CMD = "modify_eds_media_config {} {} {}"


@auto_brush_progress(60)
def execute(context):
    # 复制集群独立使用时不涉及
    if not record_meta_usage_mode.is_replication_use_alone(context):
        return RecoverControlClusterCCDB(context).recover_ccdb()
    return ItemStatus.NOT_INVOLVED, ""


class RecoverControlClusterCCDB(AbstractRecoverClusterCCDBService):
    def __init__(self, context):
        super(RecoverControlClusterCCDB, self).__init__(context)
        self.is_mini_system = SshService(context.getNode()).is_mini_system
        self.dsware_ssh_service = SshService(context.getDswareNode())
        self.dsware_node = context.getDswareNode()

    def _get_query_cluster_id_cmd(self):
        return ssh_cmd_util.get_control_cluster_id_cmd(self.is_mini_system)

    def _get_query_ccdb_server_process_id_cmd(self):
        return ssh_cmd_util.get_control_process_id_cmd(self.is_mini_system)

    def _get_replace_disk_cmd(self):
        return ssh_cmd_util.get_control_replace_disk_cmd(self.dsware_ssh_service.is_mini_system,
                                                         self.dsware_ssh_service.is_sandbox_open, self.dsware_node)

    def _get_remote_conf_dir_path(self):
        return CONTROL_CONFIG_DIR_PATH

    def _get_modify_media_config_cmd(self):
        return MODIFY_MEDIA_CONFIG_CMD

    def _is_need_y(self):
        return is_ocean_stor_pacific(self._context)
