#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2021-2023. All rights reserved.

"""
@version: SmartKit V200R007C00
@time: 2021/11/21
@file: replace_data_pilot_disk.py
@function: 更新备用硬盘模块的存储表（数据导航盘）
@modify:
"""
from py.common.entity.item_status import ItemStatus
from py.common.service import resource_service
from py.common.service.auto_brush_item_progress import auto_brush_progress
from py.common.service.connection import ssh_cmd_util
from py.common.service.connection.ssh_connection_service import SshService, \
    CustomEndingJudgeCmd, Cmd
from py.fusion_storage.common.context import disk_context_util

COMMON_SSH_ENDING = [
    ':/>', ':/', '#', '$', '~>', ':~ #', 'minisystem>',
    'enter y to continue:', 'input y to continue:'
]


@auto_brush_progress(60)
def execute(context):
    old_disk_esn = disk_context_util.get_disk_sn(context)
    new_disk_esn = disk_context_util.get_replace_disk_sn(context)
    ssh_conn = SshService(context.getNode())
    # 执行命令获得当前环境命令结束符
    origin_info = ssh_conn.exec_cmd(Cmd("lsscsi -g"))
    COMMON_SSH_ENDING.append(origin_info.splitlines()[-1])
    cmd = ssh_cmd_util.get_datapilot_replace_disk_cmd(ssh_conn.is_mini_system, old_disk_esn, new_disk_esn)
    res = ssh_conn.exec_cmd(CustomEndingJudgeCmd(cmd, COMMON_SSH_ENDING))
    while "please make sure and input y to continue:" in res:
        res = ssh_conn.exec_cmd(CustomEndingJudgeCmd('y', COMMON_SSH_ENDING))
    if "value=success" not in res.lower():
        return ItemStatus.FAILED, \
               resource_service.get_msg('replace.data.pilot.disk.failed')
    return ItemStatus.SUCCESS, ""
