#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2021-2021. All rights reserved.

"""
@version: SmartKit V200R007C00
@time: 2021/07/14
@file: restore_subhealth_node_normal.py
@function: 恢复亚健康
@modify:
"""
from py.common.entity.exception import ConnectionException
from py.common.entity.item_status import ItemStatus
from py.common.service import resource_service
from py.common.service.connection.rest_connection_service import RestService
from py.common.service.connection.ssh_connection_service import SshService
from py.fusion_storage.common.constant import ClusterRestUri
from py.fusion_storage.common.context import disk_context_util
from py.fusion_storage.common.record import record_cache_disk_match_main_disk
from py.fusion_storage.common.service.disk_init_factory.init_service_factory import \
    DiskInitServiceFactory
from py.fusion_storage.common.service.disk_out_storage_pool_service import \
    get_storage_pool_ids
from py.fusion_storage.common.service.os_util import disk_info_util
from py.fusion_storage.common.record import record_cache_disk_replace_type

DISK_FAULT_NUM_2_RESTORE_TYPE = {
    "33": 6,
    "129": 8
}


def execute(context):
    return RestoreSubHealthNodeNormal(context).check()


class RestoreSubHealthNodeNormal(object):
    def __init__(self, context):
        self._context = context
        self._ssh_service = SshService(context.getNode())
        self._rest_service = RestService(context.getCluster())
        self._node_mgr_ip = disk_context_util.get_belong_mgmt_ip(context)
        self._fault_num = None

    def check(self):
        # 离线更换和有down盘才涉及
        if not record_cache_disk_replace_type.is_online_replace_type(
                self._context) and self._has_down_main_disk():
            try:
                self._restore_sub_health_node()
            except ConnectionException as e:
                return ItemStatus.FAILED, resource_service.get_msg(
                    "failed.restore.node.normal").format(
                    str(self._node_mgr_ip),
                    RestService.get_description(e.response))
            return ItemStatus.SUCCESS, ""
        return ItemStatus.NOT_INVOLVED, ""

    def _get_node_remain_main_disk_sn_list(self, cache_match_disk_sns):
        """
        获取节点排查缓存盘对应的剩余主存盘
        :param cache_match_disk_sns: 缓存盘对应主存盘sn
        :return: sn list
        """
        storage_pool_ids = get_storage_pool_ids(
            self._context, self._rest_service)
        node_main_disks = DiskInitServiceFactory(self._context)\
            .get_pool_init_service().query_pool_node_main_disks(
            storage_pool_ids,
            disk_context_util.get_belong_mgmt_ip(self._context))

        remain_main_disk_sn_list = list()
        for disk in node_main_disks:
            if disk.getEsn() not in cache_match_disk_sns:
                remain_main_disk_sn_list.append(disk.getEsn())
        return remain_main_disk_sn_list

    def _get_main_disk_osd_fault(self):
        disk_sn_2_fault = dict()
        disk_osd_id_2_sn = self._get_main_disk_osd_id_2_sn()
        infos = disk_info_util.get_mdc_cmd_102_infos(self._ssh_service)
        for info in infos:
            disk_nid = info.get("NID")
            fault = info.get("FAULT DETAIL")
            disk_sn_2_fault[disk_osd_id_2_sn.get(disk_nid)] = fault
        return disk_sn_2_fault

    def _get_main_disk_osd_id_2_sn(self):
        infos = disk_info_util.get_mdc_cmd_101_infos(self._ssh_service)
        disk_osd_id_2_sn = dict()
        for info in infos:
            disk_osd_id_2_sn[info.get("OSD NID")] = info.get("OSD ESN")
        return disk_osd_id_2_sn

    def _has_down_main_disk(self):
        cache_match_disk_sns = record_cache_disk_match_main_disk \
            .get_recorded_cache_disk_match_main_disks(self._context)
        remain_main_disk_sn_list = self._get_node_remain_main_disk_sn_list(
            cache_match_disk_sns)
        disk_sn_2_fault = self._get_main_disk_osd_fault()
        for sn in remain_main_disk_sn_list:
            if disk_sn_2_fault.get(sn) in DISK_FAULT_NUM_2_RESTORE_TYPE:
                self._fault_num = disk_sn_2_fault.get(sn)
                return True
        return False

    def _restore_sub_health_node(self):
        self._rest_service.exec_post(
            ClusterRestUri.RESTORE_SUBHEALTH_NODE,
            {"nodeMgrIp": self._node_mgr_ip,
             "nsType": DISK_FAULT_NUM_2_RESTORE_TYPE.get(self._fault_num)})
