import re
import urllib.request
import json
import os
import codecs

from cbb.frame.base.funcUtils import wrap_all_exception_logged
from cbb.frame.util import public_ip_address_utils

data_url = public_ip_address_utils.get_support_bom_info_website()
current_path = os.path.dirname(__file__)
file_path = os.path.dirname(os.path.dirname(os.path.dirname(current_path))) + r"\res\common\bom_info.txt"

pattern_list = [
    r'-(\d+\.\d+|\d+)(TB|GB).*?(加密)?硬盘单元',
    r"-(\d+|\d+\.\d+)(TB|GB)-(.*)-(\d+|\d\.\d+)rpm",
]


def get_record(url):
    resp = urllib.request.urlopen(url)
    return json.loads(resp.read())


def get_disk_bom():
    disk_bom_info = get_record(data_url).get("data")
    disk_bom_list = list()

    for item in disk_bom_info:
        if '硬盘单元' not in item['partCategories']:
            continue

        bom_list = {
            'bomlist': [],
            'product': ''
        }

        item_bom_list = {
            'id': '',
            'version': '',
            'desc': ['', '', '']
        }

        found = False
        product_id = convert_product_id(item['productId'])
        for elem in disk_bom_list:
            if elem['product'] == product_id:
                # 解析并将值放到ITEM_BOM_LIST
                item_bom_list = set_bom_list_value(item_bom_list, item)
                elem['bomlist'].append(item_bom_list)
                found = True
                break
        if not found:
            bom_list['product'] = product_id
            item_bom_list = set_bom_list_value(item_bom_list, item)
            bom_list['bomlist'].append(item_bom_list)
            disk_bom_list.append(bom_list)
    return disk_bom_list


def convert_product_id(model_name):
    model_name = model_name.replace('_', ' ')
    model_name = model_name.title()
    return 'OceanStor ' + model_name


def set_bom_list_value(item_bom_list, item):
    """
    给每一项bomlist赋值
    :param item_bom_list: 模板
    :param item: 原信息中的每一项
    :return: item_bom_list 赋值后的列表
    """
    bom_value = item['number']
    desc = item['description']
    matcher = ''
    is_need_sed = ''
    disk_capacity = ''
    disk_unit = ''
    for pattern in pattern_list:
        matcher = re.compile(pattern).search(desc)
        if matcher:
            break
    if matcher:
        disk_capacity = matcher.group(1)
        disk_unit = matcher.group(2)
        is_need_sed = " SED" if "加密" in matcher.group(0) else ""

    disk_type = get_disk_type(is_need_sed, item)

    version = item.get('remark1', '')
    if version:
        version = version.split(' ')[0]
    item_bom_list['version'] = version
    item_bom_list['id'] = bom_value
    item_bom_list['desc'] = [disk_type, disk_capacity, disk_unit]
    return item_bom_list


def get_disk_type(is_need_sed, item):
    if '仲裁服务器硬盘单元' == item['partCategories']:
        disk_type = 'SAS'
    elif 'PALM国密硬盘单元' == item['partCategories']:
        if is_need_sed:
            disk_type = 'SSD NVMe SED'
        else:
            disk_type = 'SSD NVMe'
    else:
        pattern2 = r'.*?([A-Za-z ]+)硬盘单元'
        disk_type_prefix = re.search(pattern2, item['partCategories']).group(1)
        disk_type_prefix = disk_type_prefix.replace('NL', 'NearLine')
        disk_type = disk_type_prefix + is_need_sed
    return disk_type


@wrap_all_exception_logged(logger=None)
def create_bom_info_file():
    with codecs.open(file_path, 'w', encoding='utf-8') as f:
        write_text = str(get_disk_bom())
        f.write(write_text)


if __name__ == '__main__':
    create_bom_info_file()
