# -*- coding: UTF-8 -*-
import copy
import time

from cbb.business.operate.fru.common import BaseFactory
from cbb.business.operate.fru.common import config
from cbb.business.operate.fru.common import FuncFactory
from cbb.common.conf.productConfig import IP_DISK_ENCS
from cbb.frame.base import funcUtils
from cbb.frame.rest import restData, restUtil
from cbb.business.operate.fru.common.commonFunction import \
    record_fru_replace_log
from cbb.frame.rest.restDataConstants import OperateLogObj


@funcUtils.fakeProgress(totalSecs=config.IP_DISK_ENC_POST_CHECK_TIME_OUT_SECS,
                        intervalSec=5)
def execute(context, fru_type, fru_id, fru_name, multi_check=False,
            cache_data=None):
    """检查IP硬盘框或其子部件是否正常
    更换硬盘框使用框号匹配，其他使用ID匹配

    :param context:
    :param fru_type:
    :param fru_id:
    :param fru_name:
    :param multi_check:
    :param cache_data:
    :return:
    """
    start_time = time.time()
    fru_info = restUtil.Tlv2Rest.getStr(context, restData.EnumStr.StrObjEnum,
                                        fru_type)
    if fru_name:
        fru_info = fru_info + "(" + fru_name + ")"

    # 先睡眠2分钟，硬盘框拔了之后1分钟左右离线
    time.sleep(120)
    is_enc = fru_type == restData.Enum.ObjEnum.ENCLOSURE
    param = fru_name if is_enc else fru_id
    key = restData.PublicAttributes.NAME if is_enc else \
        restData.PublicAttributes.LOCATION
    while True:
        if time.time() - start_time > \
                config.IP_DISK_ENC_POST_CHECK_TIME_OUT_SECS:
            BaseFactory.log.info(context, "check timeout")
            break
        time.sleep(20)
        try:
            if multi_check and cache_data:
                check_multi_module_status(context, key, fru_type, cache_data)
            else:
                check_single_module_status(context, key, fru_type, fru_info,
                                           param)

            if not BaseFactory.result.isResultFail(context):
                BaseFactory.result.setResultPass(context)
                return

        except Exception as ex:
            BaseFactory.log.error(context,
                                  "check ip disk enc module exception:" + str(
                                      ex))

    BaseFactory.log.info(context, "expansion module exception check failed")
    return


def is_ip_disk_enclosure(context, fru_type, fru_id, location):
    """判断是否为IP框

    :param context:
    :param fru_type:
    :param fru_id:
    :param location:
    :return:
    """
    # 如果是控制器子模块，不检查
    if "DAE" not in location:
        return False
    if fru_type == restData.Enum.ObjEnum.ENCLOSURE:
        rec = FuncFactory.getFruInfo(context, fru_type, fru_id)
    else:
        rec = FuncFactory.getFruParentEncRec(context, fru_type, fru_id)
    if not rec:
        return False
    enc_model = restUtil.Tlv2Rest.getRecordValue(
        rec,
        restData.Hardware.Enclosure.MODEL)
    BaseFactory.log.info(context, "encModel is: %s" % str(enc_model))

    # 判断是否为IP框
    return enc_model in IP_DISK_ENCS


def check_multi_module_status(context, key, fru_type, cache_data):
    """检查多个更换备件状态

    :param context:
    :param key:
    :param fru_type:
    :param cache_data:
    :return:
    """
    tmp_locations = copy.deepcopy(cache_data.locations)
    fru_info = restUtil.Tlv2Rest.getStr(context, restData.EnumStr.StrObjEnum,
                                        fru_type)
    fru_name = fru_info + "(" + ",".join(cache_data.locations) + ")"
    BaseFactory.log.info(context, "fru check key: %s, param is :%s" % (
        str(key), str(tmp_locations)))
    fru_list = FuncFactory.getFruListInfo(context, fru_type)
    cond = restUtil.Tlv2Rest.getCondition(key,
                                          restData.Enum.ConditionTypeEnum.EQOR,
                                          tmp_locations)
    condition_list = restUtil.Tlv2Rest.getConditionList(cond)
    fru_list = restUtil.Tlv2Rest.filter(fru_list, condition_list)
    BaseFactory.log.info(context, str(fru_list))
    if not fru_list:
        BaseFactory.result.setResultFailByKey(
            context,
            FuncFactory.LangKey.FUNC_REPLEACED_FRU_X_ABNORMAL,
            fru_name)
        return
    for module in fru_list:
        location = restUtil.Tlv2Rest.getRecordValue(
            module, restData.PublicAttributes.LOCATION)
        if check_status(module):
            tmp_locations.remove(location)
    BaseFactory.log.info(context, "check fan names: %s" % str(tmp_locations))
    if tmp_locations:
        fru_name = fru_info + "(" + ",".join(tmp_locations) + ")"
        BaseFactory.result.setResultFailByKey(
            context,
            FuncFactory.LangKey.FUNC_REPLEACED_FRU_X_ABNORMAL,
            fru_name)
        return
    BaseFactory.result.setResultPass(context)


def check_single_module_status(context, key, fru_type, fru_info, param):
    """检查单个备件状态

    :param context:
    :param key:
    :param fru_type:
    :param fru_info:
    :param param:
    :return:
    """
    BaseFactory.log.info(context, "fru check key: %s, param is :%s" % (
        str(key), str(param)))
    fru_list = FuncFactory.getFruListInfo(context, fru_type)
    cond = restUtil.Tlv2Rest.getCondition(key,
                                          restData.Enum.ConditionTypeEnum.EQ,
                                          param)
    condition_list = restUtil.Tlv2Rest.getConditionList(cond)
    fru_list = restUtil.Tlv2Rest.filter(fru_list, condition_list)
    BaseFactory.log.info(context, str(fru_list))
    if not fru_list:
        BaseFactory.result.setResultFailByKey(
            context,
            FuncFactory.LangKey.FUNC_REPLEACED_FRU_X_ABNORMAL,
            fru_info)
        return
    module = fru_list[0]
    if check_status(module):
        if fru_type == restData.Enum.ObjEnum.ENCLOSURE:
            record_fru_replace_log(
                context, OperateLogObj.ENCLOSURE,
                restData.Hardware.Enclosure.SN,
                restData.Enum.ObjEnum.ENCLOSURE,
                "input_selectfru_diskEnclosureSelectedRow"
            )
        BaseFactory.result.setResultPass(context)
        return
    BaseFactory.result.setResultFailByKey(
        context,
        FuncFactory.LangKey.FUNC_REPLEACED_FRU_X_ABNORMAL,
        fru_info)


def check_status(module):
    """检查模块状态

    :param module:
    :return:
    """
    health_status = restUtil.Tlv2Rest.getRecordValue(
        module,
        restData.PublicAttributes.HEALTH_STATUS)
    running_status = restUtil.Tlv2Rest.getRecordValue(
        module,
        restData.PublicAttributes.RUNNING_STATUS)
    if health_status == restData.Enum.HealthStatusEnum.NORMAL and \
            running_status in [restData.Enum.RunningStatusEnum.ONLINE,
                               restData.Enum.RunningStatusEnum.RUNNING]:
        return True
    return False
