# -*- coding: UTF-8 -*-
from cbb.business.checkitems.cache_obj_num_check import CheckItem
from cbb.frame.checkitem.context_adapter import FruContext, CheckStatus


def execute(context):
    fru_context = FruContext(context)
    check_obj = CheckItem(fru_context.get_context())
    status, err_msg = check_obj.check()
    logger = fru_context.get_logger()
    logger.info("status={},err_msg={}".format(status, err_msg))
    suggestion = ""
    if status is CheckStatus.NOTPASS:
        suggestion = check_obj.get_msg("cache.obj.check.not.pass.suggestion")
    fru_context.get_result(status, err_msg, suggestion)
