# -*- coding: UTF-8 -*-
import time
import traceback

from com.huawei.ism.exception import IsmException
from com.huawei.ism.tlv import TLVUtils
from com.huawei.ism.tlv.bean import Param
from com.huawei.ism.tlv.docoder import ParamType
from com.huawei.ism.tlv.lang import UnsignedInt32
from com.huawei.ism.tool.protocol.tlv.cmds import CommandConstans

from cbb.business.operate.inspection import config
from cbb.frame.base import constants
from cbb.frame.base.exception import ErrorCode, ErrorCodeSet, TlvCmdException
from cbb.frame.context import contextUtil
from cbb.frame.tlv.tlvEnumFactory import TlvEnum
from cbb.frame.tlv.tlvFactory import Tlv
from cbb.frame.tlv import tlvUtil


def transException(fn):
    """ 将ISM异常转换为CliCmdException
        restUtil中的execCmd：
            抛出Exception异常
            CommonRest.REST_CAN_NOT_EXECUTE--
            若response中错误码不为0，则将错误码转为异常抛出
            自带3次重试

    :param fn:
    :return:
    """
    def inner(*params):
        self = params[0]
        # noinspection PyBroadException
        try:
            return fn(*params)
        except TlvCmdException as e:
            raise e
        except Exception:
            # noinspection PyBroadException
            try:
                return fn(*params)
            except Exception:
                self.logger.error("java excption:%s" % traceback.format_exc())
            raise TlvCmdException(ErrorCode(
                ErrorCodeSet.TLV_CONNECTION_EXCEPTION))

    return inner


"""
    执行升级前后检查
"""
CMD_DEFAULT_TIMEOUT = 300


class TlvService:
    def __init__(self, dataDict):
        self.dataDict = dataDict
        self.logger = dataDict.get('logger')

    def getHostLink(self, hostId):
        allDatas = []
        for initiatorType in [223, 222, 16499]:
            param0 = Tlv.Param.getParam(
                TlvEnum.PoolLunMap.HOST_LINK['parentType'],
                Tlv.Param.TYPE_ENUM, 21)
            param1 = Tlv.Param.getParam(
                TlvEnum.PoolLunMap.HOST_LINK['parentID'],
                Tlv.Param.TYPE_STR, hostId)
            param2 = Tlv.Param.getParam(
                TlvEnum.PoolLunMap.HOST_LINK['initiator_type'],
                Tlv.Param.TYPE_ENUM, initiatorType)
            param3 = Tlv.Param.getParam(TlvEnum.PoolLunMap.HOST_LINK['type'],
                                        Tlv.Param.TYPE_ENUM, 255)
            paramlist = Tlv.Param.getParamList(param3, param0, param1, param2)
            try:
                recs = Tlv.execmd(self.dataDict, True,
                                  TlvEnum.cmd["GET_BATCH_NEXT"], paramlist)
                if recs:
                    allDatas.extend(recs)
            except IsmException, e:
                if e.getErrorId() in [50331651]:
                    self.logger.error("cannot support initiatorType=%s"
                                      % initiatorType)
        return allDatas

    def getHostLinkByType(self, hostId, type):
        all_datas = []
        InitiatorTypeDict = dict(FC=223, ISCSI=222, IB=16499)
        initiatorType = InitiatorTypeDict.get(type.upper())
        param0 = Tlv.Param.getParam(TlvEnum.PoolLunMap.HOST_LINK['parentType'],
                                    Tlv.Param.TYPE_ENUM, 21)
        param1 = Tlv.Param.getParam(TlvEnum.PoolLunMap.HOST_LINK['parentID'],
                                    Tlv.Param.TYPE_STR, hostId)
        param2 = Tlv.Param.getParam(
            TlvEnum.PoolLunMap.HOST_LINK['initiator_type'],
            Tlv.Param.TYPE_ENUM,
            initiatorType)
        param3 = Tlv.Param.getParam(TlvEnum.PoolLunMap.HOST_LINK['type'],
                                    Tlv.Param.TYPE_ENUM, 255)
        param_list = Tlv.Param.getParamList(param3, param0, param1, param2)
        try:
            tlv = self.dataDict.get("tlv")
            recs = tlvUtil.exec_cmd(tlv, TlvEnum.cmd["GET_BATCH_NEXT"],
                                    param_list, getBatch=True,
                                    timeOut=CMD_DEFAULT_TIMEOUT)
            if recs:
                all_datas.extend(recs)
        except IsmException, e:
            if e.getErrorId() in [50331651]:
                self.logger.error(
                    "cannot support initiatorType=%s" % initiatorType)
        return all_datas


class TlvAdapter:
    def __init__(self, dataDict):
        self.dataDict = dataDict
        self.logger = dataDict.get('logger')

    @transException
    def excuteDiagnoseCmd(self, command, locationId):
        msgParam0 = Param(0, ParamType.UNSIGN_INT, UnsignedInt32(0))
        msgParam1 = Param(1, ParamType.STRING, "")
        msgParam2 = Param(2, ParamType.UNSIGN_INT, UnsignedInt32(0))
        msgParam3 = Param(3, ParamType.STRING, "")
        msgParam4 = Param(4, ParamType.STRING, "")
        msgParam5 = Param(5, ParamType.STRING, "")
        msgParam6 = Param(6, ParamType.STRING, "")
        msgParam7 = Param(7, ParamType.STRING, "")
        msgParam8 = Param(8, ParamType.STRING, "")
        msgParam9 = Param(9, ParamType.UNSIGN_INT, UnsignedInt32(1))
        msgParam12 = Param(12, ParamType.STRING, command)
        msgParam13 = Param(13, ParamType.UNSIGN_INT, UnsignedInt32(locationId))
        params = TLVUtils.paramList(msgParam0, msgParam1, msgParam2, msgParam3,
                                    msgParam4, msgParam5, msgParam6,
                                    msgParam7, msgParam8, msgParam9,
                                    msgParam12, msgParam13)
        self.logger.info('Execute cmd [code:%d] [%s]'
                         % (CommandConstans.EXC_UPD, params))
        recs = Tlv.execmd(self.dataDict, True, CommandConstans.EXC_UPD, params)

        return recs

    @transException
    def getParamStrValue(self, rec, index):
        return rec.getParamStrValue(index)

    @transException
    def getParamIntValue(self, rec, index):
        return rec.getParamIntValue(index).intValue()

    @transException
    def offlineController(self, ctrlId):
        # 下发控制器离线命令
        param0 = Tlv.Param.getParam(TlvEnum.Hardware.CONTROLLER['id'],
                                    Tlv.Param.TYPE_STR, ctrlId)
        paramlist = Tlv.Param.getParamList(param0)
        recs = Tlv.execmd(self.dataDict, False,
                          TlvEnum.cmd["OFFLINE_CONTROLLER"], paramlist)
        return recs

    def notifyDistributePkg(self):
        """通知阵列执行分发包操作

        :return:
        """
        uploadPath = "127.127.127.1:/OSM/update/software.tgz"
        pkgPathParam = Tlv.Param.getParam(
            TlvEnum.Upgrade.CMO_NOTIFY_PACKAGE_PATH_E[
                'CMO_NOTIFY_PACKAGE_PATH'],
            Tlv.Param.TYPE_STR, uploadPath)
        paramlist = Tlv.Param.getParamList(pkgPathParam)
        record = Tlv.execmd(self.dataDict, False,
                            TlvEnum.cmd['OM_MSG_OP_NOTIFY_PACKAGE_PATH'],
                            paramlist)
        return record

    def lstSysProgress(self):
        """查询升级进度

        :return:
        """
        record = Tlv.execmd(self.dataDict, False,
                            TlvEnum.cmd['OM_MSG_OP_UPD_LST_SYS_PROGRESS'],
                            TLVUtils.paramList())
        return record

    @transException
    def uploadDiskFw(self, pkgName, pkgType, patchSize):
        dev = contextUtil.getDevObj(self.dataDict).getDevNode()
        protocalContext = self.dataDict.get("protocalContext")
        sftp = protocalContext.get("SFTP")

        # 获取补丁包上传路径
        tlvCon = contextUtil.getTlvConn(self.dataDict)
        param0 = Param(0, ParamType.UNSIGN_INT, UnsignedInt32(pkgType))
        param2 = Param(2, ParamType.UNSIGN_INT, UnsignedInt32(patchSize))
        params = TLVUtils.paramList(param0, param2)
        self.logger.info('Execute cmd [%d] [%s]' % (
            constants.TLV_CMD.OM_MSG_OP_GET_PACKAGE_UPLOADPATH, str(params)))
        retRec = tlvCon.invoke(
            constants.TLV_CMD.OM_MSG_OP_GET_PACKAGE_UPLOADPATH, params,
            constants.CMD_DEFAULT_TIMEOUT)
        uploadPath = retRec.getParamStrValue(1)

        # 上传升级包
        # noinspection PyBroadException
        try:
            sftp.putFile(dev.getIp(), pkgName, uploadPath,
                         dev.getLoginUser(), None)
        except Exception:
            raise TlvCmdException(ErrorCode(
                ErrorCodeSet.TLV_CONNECTION_EXCEPTION))

        # 通知其他控制器同步升级包
        self.logger.info("pkg upload ip = %s, uploadpath=%s"
                         % (str(dev.getIp()), uploadPath))
        devPkgPath = dev.getIp() + ":" + uploadPath
        pkgPathParam0 = Param(0, ParamType.STRING, devPkgPath)
        params = TLVUtils.paramList(pkgPathParam0)
        retRec = tlvCon.invoke(
            constants.TLV_CMD.OM_MSG_OP_NOTIFY_PACKAGE_PATH, params,
            constants.CMD_DEFAULT_TIMEOUT)
        self.logger.info("retRec=%s" % retRec)

    def deleteUpgradePkg(self, pkgType):
        tlvCon = contextUtil.getTlvConn(self.dataDict)
        param0 = Param(0, ParamType.UNSIGN_INT, UnsignedInt32(pkgType))
        param2 = Param(2, ParamType.UNSIGN_INT, UnsignedInt32(0))
        params = TLVUtils.paramList(param0, param2)
        # noinspection PyBroadException
        try:
            retRec = tlvCon.invoke(
                constants.TLV_CMD.OM_MSG_OP_GET_PACKAGE_UPLOADPATH, params,
                constants.CMD_DEFAULT_TIMEOUT)
            self.logger.info(
                'Execute cmd [%d] [%s] receive[%s]' % (
                    constants.TLV_CMD.OM_MSG_OP_GET_PACKAGE_UPLOADPATH,
                    str(params), str(retRec)))
        except Exception:
            # noinspection PyBroadException
            try:
                tlvCon.reConnect()
                retRec = tlvCon.invoke(
                    constants.TLV_CMD.OM_MSG_OP_GET_PACKAGE_UPLOADPATH, params,
                    constants.CMD_DEFAULT_TIMEOUT)
                self.logger.error(
                    'Execute cmd [%d] [%s] receive[%s]'
                    % (constants.TLV_CMD.OM_MSG_OP_GET_PACKAGE_UPLOADPATH,
                       str(params), str(retRec)))
            except Exception:
                self.logger.error("Notify OM delete Package failed.")
        finally:
            contextUtil.releaseTlvConn(self.dataDict)

    @transException
    def queryExcuteResult(self):
        tlvCon = contextUtil.getTlvConn(self.dataDict)
        rec = tlvCon.invoke(constants.TLV_CMD.OM_MSG_OP_UPD_LST_SYS_PROGRESS,
                            TLVUtils.paramList(),
                            constants.CMD_DEFAULT_TIMEOUT)
        self.logger.info('TLV cmd [%d] send[%s] receive[%s]' % (
            constants.TLV_CMD.OM_MSG_OP_UPD_LST_SYS_PROGRESS,
            str(TLVUtils.paramList()), str(rec)))
        status = rec.getParamIntValue(3).intValue()
        return status

    @transException
    def queryExcuteDetail(self):
        errMsg = ''
        tlvCon = contextUtil.getTlvConn(self.dataDict)
        resource = self.dataDict.get("resource")
        # 查询处理详细信息
        recs = tlvCon.getBatch(
            constants.TLV_CMD.OM_MSG_OP_UPD_LIST_DETAILINFO,
            TLVUtils.paramList(), constants.CMD_DEFAULT_TIMEOUT)
        self.logger.info('TLV cmd [%d] send[%s] receive[%s]' % (
            constants.TLV_CMD.OM_MSG_OP_UPD_LIST_DETAILINFO,
            str(TLVUtils.paramList()), str(recs)))
        # 解析处理详细信息，生成返回信息
        itemNum = recs.size()
        for index in range(0, itemNum):
            rec = recs.get(index)
            nameKey = rec.getParamStrValue(0)
            errorKey = rec.getParamStrValue(2)
            nodeId = rec.getParamStrValue(3)
            errMsg += "%s--%s--%s\n" \
                      % (nodeId, resource.getString(nameKey),
                         resource.getString(errorKey))
        return errMsg

    def upgradeDisksFw(self, diskUpgradeMode, upgradeType=0, diskIdStr=None):
        # 0-升级方式（1-全盘升级；2-单盘升级；3-多盘升级）
        # 4-硬盘框号（）
        param0 = Param(0, ParamType.UNSIGN_INT, UnsignedInt32(diskUpgradeMode))
        param5 = Param(5, ParamType.UNSIGN_INT, UnsignedInt32(upgradeType))
        params = TLVUtils.paramList(param0, param5)
        if diskIdStr:
            param4 = Param(4, ParamType.STRING, diskIdStr)
            params.add(param4)
        self.logger.info(
            'Execute cmd [%d] [%s]'
            % (constants.TLV_CMD.OM_MSG_OP_UPD_DISK_FIRMWARE, str(params)))
        # 获取补丁包上传路径
        # noinspection PyBroadException
        try:
            self.tlvCon = contextUtil.getTlvConn(self.dataDict)
            retRec = self.tlvCon.invoke(
                constants.TLV_CMD.OM_MSG_OP_UPD_DISK_FIRMWARE, params,
                constants.CMD_DEFAULT_TIMEOUT)
            self.logger.info("invoke tlv disk upgrade response=%s" % retRec)

            # TODO 系统正在进行硬盘升级，该命令会报错；重试升级时，忽略该错（提示正在升级）
        except Exception:
            # noinspection PyBroadException
            try:
                # 重新获取TLV连接，重试一次
                time.sleep(5)
                self.tlvCon = contextUtil.getTlvConn(self.dataDict)
                retRec = self.tlvCon.invoke(
                    constants.TLV_CMD.OM_MSG_OP_UPD_DISK_FIRMWARE, params,
                    constants.CMD_DEFAULT_TIMEOUT)
                self.logger.error("invoke tlv disk upgrade response=%s"
                                  % retRec)
            except Exception:
                self.logger.error("invoke diskupgrade tlv cmd exception:%s"
                                  % traceback.format_exc())
                raise

    def queryDiskUpgradeResult(self, diskUpgradeMode, upgradeType=0):
        # noinspection PyBroadException
        try:
            param0 = Param(0, ParamType.UNSIGN_INT,
                           UnsignedInt32(diskUpgradeMode))
            param5 = Param(5, ParamType.UNSIGN_INT, UnsignedInt32(upgradeType))
            params = TLVUtils.paramList(param0, param5)
            if diskUpgradeMode == config.DISK_UPGRADE_MODE.MULTI:
                param4 = Param(4, ParamType.STRING, "CTE99.9")
                params.add(param4)
            self.logger.info(
                'Execute cmd [%d] [%s]'
                % (constants.TLV_CMD.OM_MSG_OP_UPD_GET_DISK_RESULT,
                   str(params)))
            self.tlvCon = contextUtil.getTlvConn(self.dataDict)
            response = self.tlvCon.getBatch(
                constants.TLV_CMD.OM_MSG_OP_UPD_GET_DISK_RESULT, params,
                constants.CMD_DEFAULT_TIMEOUT)
            self.logger.info(
                "cmd=%s response=%s"
                % (constants.TLV_CMD.OM_MSG_OP_UPD_GET_DISK_RESULT,
                   str(response)))
            return response
        except Exception:
            self.logger.error("invoke diskupgrade tlv cmd exception:%s"
                              % traceback.format_exc())
            # noinspection PyBroadException
            try:
                # 重新获取TLV连接
                self.tlvCon = contextUtil.getTlvConn(self.dataDict)
            except Exception:
                # 无法建立连接
                self.logger.error("create tlv con exception:%s"
                                  % traceback.format_exc())
                raise TlvCmdException(ErrorCode(
                    ErrorCodeSet.TLV_CONNECTION_EXCEPTION))
            raise TlvCmdException(ErrorCode(ErrorCodeSet.COMMON_CMD_ERROR))
