# -*- coding: UTF-8 -*-
from cbb.frame.util import public_ip_address_utils
# 该配置脚本只在frame框架中使用

# from FRU 4.8
HIGH_END_DEVS = ["18500 V3", "18800 V3", "18500F V3", "18800F V3", "18500 V5",
                 "18800 V5", "18500F V5", "18800F V5"]
ARM_DEVS = ["2100 V3", "2200 V3", "2600 V3", "2600F V3", "5100 V3",
            "2600 V3 for Video", "5110 V5", "5110F V5", "5100K V5", "5200K V5",
            "5210 V5", "5210F V5", "5300 V5", "5500 V5 Elite", "2600 V5",
            "2810 V5", "5110 V5 Enhanced", "5120 V5", "5110F V5 Enhanced",
            "5210 V5 Enhanced", "5220 V5", "5210F V5 Enhanced", "2800 V5", "2800K V5",
            '5310 V5', '5510 V5', '5610 V5', '5810 V5', '5310F V5', '5510F V5',
            '5610F V5', '5810F V5', '5500 V5', '5600 V5', '5800 V5', '5300F V5',
            '5500F V5', '5600F V5', '5800F V5', "2210", "2220", "2200 V5"]
ARM_DEVS_2U = ["2100 V3", "2200 V3", "2600 V3", "2600F V3",
               "2600 V3 for Video", "2210", "2220", "2200 V5",
               "5110 V5", "5120 V5", "5110F V5", "5100K V5", "5200K V5",
               "5210 V5", "5220 V5",
               "5210F V5", "5300 V5", "5500 V5 Elite"]

V6_SOLID_FULL_BAY_DELIVER_PDT_MODEL = ['OceanStor Dorado 18000 V6',
                                       'OceanStor Dorado 18500 V6',
                                       'OceanStor Dorado 18800 V6',
                                       'OceanStor Dorado 18800K V6',
                                       'OceanStor Dorado 18000',
                                       'OceanStor Dorado 18500',
                                       'OceanStor Dorado 18800',
                                       'OceanStor Dorado 18800K',
                                       'OceanStor 18510',
                                       'OceanStor 18500K',
                                       'OceanStor 18810']
V5_HYBRID_FULL_BAY_DELIVER_PDT_MODEL = ["18500 V5", "18510 V5",
                                        "18800 V5", "18810 V5",
                                        "18500F V5", "18510F V5",
                                        "18800F V5", "18810F V5",
                                        "18500K V5", "18800K V5"]
# V5整柜支持4U框的型号
V5_FULL_BAY_SUP_4U_ENC = ["18500 V5", "18510 V5",
                          "18800 V5", "18810 V5",
                          "18500K V5", "18800K V5"]
# 新融合整柜支持4U框的内部型号
HYBRID_V6_FULL_BAY_SUP_4U_ENC = ["18510_C", "18510_C_2P", "18510_M_C",
                                 "18510_M_C_2P", "18500K_C", "18500K_C_2P",
                                 "18500K_M_C", "18500K_M_C_2P", "18810_C",
                                 "18810_M_C"]
# V5高端不支持4U框的型号
V5_HIGH_END_NOT_SUP_4U_ENC = ["18500F V5", "18510F V5",
                              "18800F V5", "18810F V5"]
# V5中低端支持交换机扩控(注意5310v5为低端设备)
V5_MIDDLE_NEW = [
    "5310 V5", "5510 V5", "5610 V5",
    "5810 V5", "5300 V5", "5500 V5", "5600 V5", "5800 V5", "5300F V5",
    "5500F V5", "5600F V5", "5800F V5", "5300K V5", "5500K V5",
    "5600K V5", "5800K V5", "5310F V5", "5510F V5", "5610F V5",
    "5810F V5"]
# v5高端
V5_HIGH_NEW = [
    "6800 V5", "6810 V5", "18500 V5", "18510 V5", "18800 V5",
    "18810 V5", "6800F V5", "6810F V5", "18500F V5", "18510F V5", "18800F V5",
    "18810F V5", "6800K V5", "18500K V5", "18800K V5", "2600 V5",
    "5110 V5 Enhanced", "5110F V5 Enhanced", "5210 V5 Enhanced",
    "5210F V5 Enhanced", ]
# V5新硬件
ARM_DEVS_V5_NEW = [
    "2800 V5", "2800K V5", "2810 V5", "5310 V5", "5510 V5", "5610 V5",
    "5810 V5", "5300 V5", "5500 V5", "5600 V5", "5800 V5", "5300F V5",
    "5500F V5", "5600F V5", "5800F V5", "5300K V5", "5500K V5",
    "5600K V5", "5800K V5", "5310F V5", "5510F V5", "5610F V5",
    "5810F V5", "6800 V5", "6810 V5", "18500 V5", "18510 V5", "18800 V5",
    "18810 V5", "6800F V5", "6810F V5", "18500F V5", "18510F V5", "18800F V5",
    "18810F V5", "6800K V5", "18500K V5", "18800K V5", "2600 V5",
    "5110 V5 Enhanced", "5120 V5", "5110F V5 Enhanced", "5210 V5 Enhanced",
    "5220 V5", "5210F V5 Enhanced", "2210", "2220", "2200 V5"]
ARM_2810_NEW = ["2800 V5", "2800K V5", "2810 V5"]

# 2U超低端设备的型号。
ULTRA_LOW_END_NEW = ["2210", "2220", "2200 V5", "5120 V5", "5220 V5"]
ULTRA_LOW_END_NEW_INTERNAL_PRODUCT_MODEL = ["5110ES_V5_16G_P", "5110ES_V5_P", "5210ES_V5_P", "5210ES_V5_32G_P"]

# 新融合入门级
HYBRID_V6_ENTRY_LEVEL_END = [
    "OceanStor 2220", "OceanStor 5120", "OceanStor 2600", "OceanStor 2620", "OceanStor 5210", "OceanStor 5220",
    "OceanStor 2200"
]

# 支持虚拟机的ARM新硬件
ARM_SUP_VIRTUAL_MACHINE = [
    "2800 V5", "2800K V5", "2810 V5", "5310 V5", "5300K V5", "5300 V5",
    "5510 V5", "5500K V5", "5500 V5"]
ARM_LOWEND_ENHANCED = ["2600 V5", "5110 V5 Enhanced", "5110F V5 Enhanced",
                       "5120 V5", "5220 V5",
                       "5210 V5 Enhanced", "5210F V5 Enhanced"]
ARM_LOWEND_NEW = ["2800 V5", "2800K V5", "2810 V5", "2210", "2220", "2200 V5",
                  "5300 V5", "5300F V5", "5310 V5", "5310F V5", "5300K V5"]
ARM_MID_END_NEW = [
    "5510 V5", "5500 V5", "5610 V5", "5600 V5", "5810 V5", "5800 V5",
    "5510F V5", "5610F V5", "5810F V5", "5500F V5", "5600F V5", "5800F V5",
    "5500K V5", "5600K V5", "5800K V5"]
ARM_HIGH_END_NEW = [
    "6800 V5", "6810 V5", "18500 V5", "18510 V5", "18800 V5", "18810 V5",
    "6800F V5", "6810F V5", "18500F V5", "18510F V5", "18800F V5",
    "18810F V5", "6800K V5", "18500K V5", "18800K V5"]
# 需要画设备图的高端设备
HIGH_END_NEED_GRAPH_MODELS = [
    "Dorado18000 V6", "OceanStor Dorado 18000 V6", "OceanStor Dorado 18000", "OceanStor Dorado 18500",
    "OceanStor Dorado 18500 V6", "OceanStor Dorado 18800 V6", "OceanStor Dorado 18800", "OceanStor Dorado 18800K",
    "OceanStor Dorado 18800K V6",
    "18500 V5", "18510 V5", "18800 V5", "18810 V5",
    "18500F V5", "18510F V5", "18800F V5",
    "18810F V5", "18500K V5", "18800K V5",
    'OceanStor 18510', 'OceanStor 18500K', 'OceanStor 18810'
]
DORADO_DEVS_V3 = ['Dorado18000 V3', "Dorado6000 V3",
                  "Dorado5000 V3", "Dorado3000 V3"]

# 新融合
NEW_DORADO = ["OceanStor 5310", "OceanStor 5510", "OceanStor 5510S", "OceanStor 5610", "OceanStor 5320",
              "OceanStor 5310 Capacity Flash", "OceanStor 5510 Capacity Flash", "OceanStor A300",
              "OceanStor 6810", "OceanStor 18510", "OceanStor 18500K",
              "OceanStor 18810", "OceanStor 5810-HS", "OceanStor 5300K", "OceanStor 5500K", "OceanStor 2200",
              "OceanStor 2220", "OceanStor 5120", "OceanStor 2600", "OceanStor 2620", "OceanStor 5210",
              "OceanStor 5220"]

# 微存储
OCEAN_STOR_MICRO_DEVS = ["OceanStor Micro 1300", "OceanStor Micro 1500", "OceanDisk 1600", "OceanDisk 1300",
                         "OceanDisk 1500", "OceanDisk 1500T", "OceanDisk 1600T", "OceanDisk 1610", "OceanDisk 1610T"]

# 微存储混闪形态
MICRO_FLASHING_INTER_MODEL = ["M1600_H", "M5610_H", "M1500_H", "M1500T_H", "M1600T_H", "M1610_H", "M1610T_H"]

# 混闪形态
FLASHING_INTER_MODEL = [
    "D5600V6_S_H", "D5600V6_X_H", "D6800V6_C_X_H", "D5500V6_C_X_H", "D5600KV6_X_H", "D6800KV6_C_X_H", "D2000V6_C_X_H",
    "D5600V6_X_H_1P", "D5600KV6_X_H_1P"
]

# 微存储DISK中端设备，支持扩控，扩控查槽位为IOM4
OCEAN_DISK_DEVS_MID = [
    "OceanDisk 1500", "OceanDisk 1500T", "OceanDisk 1600", "OceanDisk 1600T", "OceanDisk 1610", "OceanDisk 1610T"
]

# 计算型存储
OCEAN_STOR_COMPUTING_DEVS = ["OceanStor 2910"]

# 大集群AI存储
BIG_CLUSTERS_AI_DEVS = ["OceanStor A800"]

OCEAN_PROTECT = ["OceanProtect X9000", "OceanProtect X8000", "OceanProtect X6000", "OceanProtect A8000",
                 "OceanProtect X8000K", "OceanProtect X9000K", "OceanProtect X3000", "OceanProtect E8000"]

OCEAN_PROTECT_SUPPORT_SWITCH = ["OceanProtect E8000"]

OCEAN_PROTECT_X = ["OceanProtect X9000", "OceanProtect X8000", "OceanProtect X6000", "OceanProtect E8000",
                   "OceanProtect X8000K", "OceanProtect X9000K", "OceanProtect X3000"]
OCEAN_PROTECT_MID = ["OceanProtect X8000", "OceanProtect A8000", "OceanProtect E8000",
                     "OceanProtect X6000", "OceanProtect X8000K"]
OCEAN_PROTECT_HIGH = ["OceanProtect X9000", "OceanProtect X9000K"]

# 32Dorado 5600/6000支持32节点, 5600/6000支持带NAS扩容至16控
DORADO_32_CTRL_DEVS = (
    "OceanStor Dorado 5600 V6", "OceanStor Dorado 5600", "OceanStor Dorado 6000", "OceanStor Dorado 6000 V6"
)

DORADO_DEVS_V6 = [
    'Dorado18000 V6', "Dorado8000 V6", "Dorado6000 V6", "Dorado5000 V6",
    "Dorado3000 V6", "OceanStor Dorado 3000 V6", "OceanStor Dorado 5000 V6", "OceanStor Dorado 2020",
    "OceanStor Dorado 6000 V6", "OceanStor Dorado 8000 V6", "OceanStor Dorado 2000", "OceanStor Dorado 2100",
    "OceanStor Dorado 18000 V6", "OceanStor Dorado 5300 V6",
    "OceanStor Dorado 5500 V6", "OceanStor Dorado 5600 V6",
    "OceanStor Dorado 5800 V6", "OceanStor Dorado 6800 V6",
    "OceanStor Dorado 18500 V6", "OceanStor Dorado 18800 V6",
    "OceanStor Dorado 5600K V6", "OceanStor 2910", "OceanStor 5310", "OceanStor 5510", "OceanStor 5510S",
    "OceanStor 5310 Capacity Flash", "OceanStor 5510 Capacity Flash", "OceanStor A300",
    "OceanStor 5300K", "OceanStor 5500K", "OceanStor 5320",
    "OceanStor 5610", "OceanStor 6810", "OceanStor 18510", "OceanStor 5810-HS",
    "OceanStor 18500K", "OceanStor 18810",
    "OceanStor 2200", "OceanStor 2220", "OceanStor 5120", "OceanStor 2600", "OceanStor 2620", "OceanStor 5210",
    "OceanStor 5220",
    "OceanStor Dorado 18800K V6", "OceanProtect X8000", "OceanProtect X9000", "OceanProtect E8000",
    "OceanProtect A8000", "OceanProtect X6000", "OceanProtect X8000K",
    "OceanProtect X9000K", "OceanProtect X3000", "OceanStor Micro 1300", "OceanStor Micro 1500", "OceanDisk 1600",
    "OceanDisk 1300", "OceanDisk 1500", "OceanDisk 1500T", "OceanDisk 1600T", "OceanDisk 1610", "OceanDisk 1610T",
    "OceanStor Dorado 3000", "OceanStor Dorado 5000", "OceanStor Dorado 6000", "OceanStor Dorado 8000",
    "OceanStor Dorado 18000", "OceanStor Dorado 5300", "OceanStor Dorado 5500", "OceanStor Dorado 5600",
    "OceanStor Dorado 6800", "OceanStor Dorado 18500", "OceanStor Dorado 18800", "OceanStor Dorado 5600K",
    "OceanStor Dorado 18800K"]
DORADO_DEVS_V6_HIGH = [
    "Dorado8000 V6", "Dorado18000 V6", "OceanStor Dorado 8000 V6",
    "OceanStor Dorado 18000 V6", "OceanStor Dorado 6800 V6",
    "OceanStor Dorado 18500 V6", "OceanStor Dorado 18800 V6",
    "OceanStor 6810", "OceanStor 18510",
    "OceanStor 18500K", "OceanStor 18810",
    "OceanStor Dorado 18800K V6", "OceanProtect X9000", "OceanProtect X9000K",
    "OceanStor Dorado 8000", "OceanStor Dorado 18000", "OceanStor Dorado 6800", "OceanStor Dorado 18500",
    "OceanStor Dorado 18800", "OceanStor Dorado 18800K"]
DORADO_DEVS_V6_MID = [
    "Dorado6000 V6", "Dorado5000 V6", "OceanStor Dorado 5000 V6",
    "OceanStor Dorado 6000 V6", "OceanStor Dorado 5500 V6",
    "OceanStor Dorado 5600 V6", "OceanStor Dorado 5800 V6",
    "OceanStor Dorado 5600K V6", "OceanStor 5510", "OceanStor 5510S", "OceanStor 5610",
    "OceanStor 5810-HS", "OceanStor 5500K", "OceanStor 5510 Capacity Flash", "OceanStor A300",
    "OceanProtect X8000", "OceanProtect A8000", "OceanProtect X6000", "OceanProtect E8000",
    "OceanProtect X8000K", "OceanStor Micro 1500", "OceanDisk 1600", "OceanDisk 1500", "OceanDisk 1500T",
    "OceanDisk 1600T", "OceanDisk 1610", "OceanDisk 1610T", "OceanStor Dorado 6000", "OceanStor Dorado 5500",
    "OceanStor Dorado 5600", "OceanStor Dorado 5600K", "OceanStor Dorado 5000"]
DORADO_DEVS_V6_LOW = ["Dorado3000 V6", "OceanStor Dorado 3000 V6", "OceanStor Dorado 2000", "OceanStor Dorado 2100",
                      "OceanStor Dorado 2020",
                      "OceanStor Dorado 5300 V6", "OceanStor 5310", "OceanStor 5320", "OceanStor 5310 Capacity Flash",
                      "OceanStor 5300K", "OceanStor Micro 1300", "OceanDisk 1300", "OceanProtect X3000",
                      "OceanStor 2910", "OceanStor 2200", "OceanStor 2220", "OceanStor 5120", "OceanStor 2600",
                      "OceanStor 2620", "OceanStor 5210", "OceanStor 5220",
                      "OceanStor Dorado 3000", "OceanStor Dorado 5300"]
DORADO_2000_AND_PROTECT_X3000 = [
    "OceanStor Dorado 2000", "OceanStor Dorado 2020", "OceanStor Dorado 2100", "OceanProtect X3000"
]
DORADO_DEVS = DORADO_DEVS_V3 + DORADO_DEVS_V6
CTRL_6U_PRODUCTS = [
    'Dorado18000 V3', "6800 V3", "18500 V3", "18800 V3", "6800F V3",
    "18500F V3", "18800F V3", "6800 V5", "18500 V5", "18800 V5", "18500F V5",
    "18800F V5"]
HIGH_MID_BIGSAS = [
    "6800 V5", "6800F V5", "18500 V3", "18800 V3", "18500F V3", "18800F V3",
    "18500 V5", "18800 V5", "18500F V5", "18800F V5"]
DEVS_V5 = ["2800 V5", "2800K V5", "2810 V5", "5110 V5", "5110F V5", "5210 V5",
           "5100K V5", "5200K V5", "5210F V5", "5300 V5", "5300 V5 Enhanced",
           "5300F V5", "Dorado NAS", "5500 V5", "5500 V5 Elite", "5500F V5",
           "5600 V5", "5600F V5", "5800 V5", "5800F V5", "6800 V5", "6800F V5",
           "18500 V5", "18500F V5", "18800 V5", "18800F V5",
           "5210 V5 Enhanced", "5210F V5 Enhanced", '5310 V5', '5510 V5',
           '5610 V5', '5810 V5', '5310F V5', '5510F V5', '5610F V5',
           '5810F V5', '5500K V5', '6810 V5', '6810F V5', '18510 V5',
           '18510F V5', '18810 V5', '18810F V5', "2600 V5", "5110 V5 Enhanced",
           "5120 V5", "5110F V5 Enhanced", "5210 V5 Enhanced", "5220 V5",
           "5210F V5 Enhanced", "2210", "2220", "2200 V5"
           ]
HIGH_END_DEVS_V5 = ["18500 V5", "18500F V5", "18800 V5", "18800F V5",
                    "18510 V5", "18510F V5", "18810 V5", "18810F V5"]
PDT_MODEL_6800V5 = ["6800 V5", "6800F V5", "6810 V5", "6810F V5"]

CONTROLLER_TIME_LIMIT_V5 = [
    "2800 V5", "5110 V5", "5110F V5", "5100K V5", "5200K V5", "5210 V5",
    "5210F V5", "5300 V5", "5300F V5", "Dorado NAS", "5500 V5",
    "5500 V5 Elite", "5500F V5", "2200 V3 Enhanced", "2600 V3 Enhanced",
    "2600F V3 Enhanced", "5300 V5 Enhanced"]
DORADO_NAS_DEVS = ["Dorado NAS"]

# 6U小卡设备型号
SMALL_SAS_6U_PRODUCTS = ["Dorado18000 V3", "6900 V3", "6800 V3", "6800F V3"]

NEED_DRAW_GRAPH_DEVS = HIGH_END_NEED_GRAPH_MODELS

SVP_REST_IP = '172.17.126.11'

REST_BASE_URI = r"https://%s:%s/deviceManager/rest/%s/"
REST_DEFAULT_PORT = "8088"
RETRY_TIMES = 3  # rest重试次数
ERR_CODE_SLAVE_NODE_HANDLE_MSG_IGNORE = "1089101853"
REST_DEFAULT_ERR_CODE = "0"
ERR_CODE_UNAUTHORIZED_REST = "-401"
ERR_CODE_COMMUNICATION_ABNOEMAL = "16797698"
ERR_CODE_ENGINE_CAN_NOT_MONITOR = ["1077949083"]  # 引擎无法监控，导致系统软件工作异常，禁止配置

# from FRU 4.8
REST_DEFAULT_RETRY_TIMES = 3  # 重试次数
REST_DEFAULT_RETRY_INTERVAL = 30  # 重试间隔时间
REST_DEFAULT_TIMEOUT = 120  # 默认超时时间
REST_RECORD_MAXNUM = 100  # TLV执行批量查询时的最大条数（自选）

'''
TLV预留异常ID范围：-10000 ~ -11000
'''
ERR_CODE_EMPTY = "-10001"  # TLV执行错误ID，执行结果为空（非None，即有一个不存在任何元素的行）。
ERR_CODE_NONE = "-10002"  # TLV执行错误ID，执行结果为None。

ERR_CODE_FILE_NOT_EXIST = "50334237"  # 若返回的错误信息包含license，则说明该文件不存在；否则继续抛出异常
# 命令下发超时。/Executing command time out.
# 通信异常或系统繁忙。The communication is abnormal or the system is busy.
ERR_CODE_CMD_TIME_OUT = "16797698"
# 删除、修改对象时检测到对象不存在 原因: 指定的对象不存在。
ERR_CODE_NOT_EXIST = "1077948996"
# connector与阵列之间网络通信异常。The connector failed to connect to the arrays.
# 原因：与设备通信异常。建议：请检查网络连接或设备状态是否正常。
ERR_CODE_COMMUNICATION_ABNORMAL = "1073949185"
# 网管消息中命令字未注册，非法命令字 原因: 系统不支持此操作。 建议: 请联系技术支持工程师。
ERR_CODE_CMD_NOT_SUPPORTED = "1077949002"
ERR_CODE_PAGES_FAILED = "1073794887"  # 在离线系统业务时，Cache中存在失效页面，导致业务无法离线。
ERR_CODE_OFF_OFFLINE_FAILED = "1073794888"  # 在离线系统业务时，系统存在故障，导致业务离线失败。
ERR_CODE_SYSTEM_BUSY = "1077949006"  # 系统繁忙请稍后重试

ERR_CODE_CAN_NOT_EXECUTE = "1077936891"  # 支持包脚本文件异常，执行查询支持包命令执行失败。
ERR_CODE_NORMAL = "0"  # 默认正常的返回值
ERR_CODE_ABEND = "9999900001"  # 自定义Rest下发命令后返回异常,不支持该命令
ERR_CODE_UPGRADE_ERROR_CODE = "1077949021"  # 系统正在升级时，不能配置业务。
ERR_CODE_FAIL_COMMUNICATION = [
    "16797697",  # 与设备断开连接
    ERR_CODE_COMMUNICATION_ABNORMAL,  # 与设备通信异常，请检查网络连接或设备状态是否正常
    ERR_CODE_CMD_TIME_OUT,  # 命令下发超时
]

COMMUNICATION_FAIL_ERROR_CODE = [
    "16797697",  # 与设备断开连接
    "1073949185",  # 与设备通信异常，请检查网络连接或设备状态是否正常
    "16797698",  # 与设备通信异常
]
# 导出配置数据，存储系统主控制器的系统盘故障。
RETURN_EXPORT_CONFIG_MASTER_CONTROL_SYSTEM_DISK_FAULT = "1073744476"
# 导出配置数据，当前登录的控制器系统盘故障。
RETURN_EXPORT_CONFIG_OTHER_CONTROL_SYSTEM_DISK_FAULT = "1073744477"

CONTROLLER_PAIR = {
    "A": "B",
    "B": "A",
    "C": "D",
    "D": "C",
    "0": "1",
    "1": "0",
    "2": "3",
    "3": "2",
}

NODE_ID_MAP = {
    "A": "0",
    "B": "1",
    "C": "2",
    "D": "3",
    "0": "A",
    "1": "B",
    "2": "C",
    "3": "D"
}
# 检查业务压力相关参数
CHECK_SYS_PRESSURE_PERIOD = 1  # 检查周期（秒）
CHECK_SYS_PRESSURE_TIMES = 30  # 检查业务压力的总次数
CHECK_SUCCESS_RATE = 0.3  # 检查成功达标率
MAX_CPUUSAGE_PER_CTRL = 40  # 单个控制器允许最大CPU利用率

g_frontEndIntfModels = (  # 所有的前端接口model
    1,  # 4x4G FC接口模块
    2,  # 2x4G FC接口模块
    3,  # 2xGE 电接口模块
    5,  # Swapped FC接口模块
    6,  # 2x10GE 光接口模块
    7,  # 1x8G FC光接口模块
    8,  # 2x8G FC光接口模块
    11,  # 2xFC+2xGE 接口模块
    12,  # 4xGE 电接口模块
    13,  # 4x8G FC光接口模块
    21,  # 4x10G FCoE光接口模块
    25,  # 4x10GE接口模块
    27,  # 2x10G FCoE光接口模块
    28,  # 4xGE光接口模块
    29,  # 2x16G FC光接口模块
    31,  # 4x10GE 电接口模块
    32,  # 2x40GE IB接口模块
    33,  # 2x56GE IB接口模块
    34,  # 4xGE 电接口模块
    36,  # 4x10GE 电接口模块
    37,  # 4xSmart 光接口模块
    38,  # 8x8G FC光接口模块
    39,  # 4x8G FC光接口卡
    40  # 4x16G FC光接口卡
)


class IpTypeEnum():
    IPV4 = 0
    IPV6 = 1


# 超时时间配置
REBOOT_CONTROLLER_TIME_OUT = 5 * 60  # 重启控制器
CHECK_POWERON_TIME_OUT = 30 * 60  # 检查重启上电
CHECK_BUSINESS_STATUS_TIME_OUT = 90 * 60  # 检查业务恢复
OFFLINE_CTRL_TIMEOUT = 30 * 60
OFFLINE_CTRL_FROM_INVISIBLE = 5 * 60  # 离线控制器，从控制器无法查询到处于离线状态等待时间
OFFLINE_SINGLE_CTRL_TIMEOUT = 900  # 离线轮训检查时间,停虚拟机5分钟，下电10分钟。
OFFLINE_CTRL_INTERVAL = 5


MGMT_PORT_CONFIG_FOR_DORADO = {
    "SWITCH": ["DSW0.MGMT.0",
               "DSW0.MGMT.1",
               "DSW1.MGMT.0",
               "DSW1.MGMT.1"],
    # 3U2E indicates the engines are 3U and there are 2 engines  in the system
    "3U2E": ["CTE0.SMM1.MGMT",
             "CTE1.SMM0.MGMT",
             "CTE1.SMM1.MGMT",
             "CTE0.SMM0.MAINTENANCE",
             "CTE0.SMM1.MAINTENANCE",
             "CTE1.SMM0.MAINTENANCE"]
}

SERIES_T = "T_SERIES"
SERIES_V3 = "V3_SERIES"
SERIES_ARM = "ARM_SERIES"
SERIES_Dorado = "Dorado_SERIES"
SERIES_18000V3 = "18000V3_SERIES"
SERIES_18000 = "18000_SERIES"
SERIES_68V5 = "68V5_SERIES"

STOR_DEV_INFO_DICT = {
    "S2600T": SERIES_T,
    "S5500T": SERIES_T,
    "S5600T": SERIES_T,
    "S5800T": SERIES_T,
    "S6800T": SERIES_T,
    "2200 V3": SERIES_ARM,
    "2600 V3": SERIES_ARM,
    "2600 V3 for Video": SERIES_ARM,
    "2600F V3": SERIES_ARM,
    "2800 V3": SERIES_V3,
    "5300 V3": SERIES_V3,
    "5500 V3": SERIES_V3,
    "5500F V3": SERIES_V3,
    "5600 V3": SERIES_V3,
    "5600F V3": SERIES_V3,
    "5800 V3": SERIES_V3,
    "5800F V3": SERIES_V3,
    "6800 V3": SERIES_V3,
    "6800F V3": SERIES_V3,
    "6900 V3": SERIES_V3,
    "2800 V5": SERIES_V3,
    "2210": SERIES_ARM,
    "2220": SERIES_ARM,
    "2200 V5": SERIES_ARM,
    "5110 V5": SERIES_ARM,
    "5120 V5": SERIES_ARM,
    "5110F V5": SERIES_ARM,
    "5100K V5": SERIES_ARM,
    "5200K V5": SERIES_ARM,
    "5210 V5": SERIES_ARM,
    "5220 V5": SERIES_ARM,
    "5210F V5": SERIES_ARM,
    "5300 V5": SERIES_ARM,
    "5500 V5": SERIES_V3,
    "5600 V5": SERIES_V3,
    "5800 V5": SERIES_V3,
    "6800 V5": SERIES_68V5,
    "5300F V5": SERIES_V3,
    "5500F V5": SERIES_V3,
    "5600F V5": SERIES_V3,
    "5800F V5": SERIES_V3,
    "6800F V5": SERIES_68V5,
    "Dorado3000 V3": SERIES_Dorado,
    'Dorado5000 V3': SERIES_Dorado,
    'Dorado6000 V3': SERIES_Dorado,
    "HVS85T": SERIES_18000,
    "HVS88T": SERIES_18000,
    "18500": SERIES_18000,
    "18800": SERIES_18000,
    "18800F": SERIES_18000,
    "18500 V3": SERIES_18000V3,
    "18500F V3": SERIES_18000V3,
    "18800 V3": SERIES_18000V3,
    "18800F V3": SERIES_18000V3,
    "18500 V5": SERIES_18000V3,
    "18800 V5": SERIES_18000V3,
    "18500F V5": SERIES_18000V3,
    "18800F V5": SERIES_18000V3,
}


class UserOpDataFields():
    # ---------- 记录在用户行为中选中的模块名称fruType
    CONTROLLER = "controller"
    CBU = "cbu"
    POWER = "power"
    DISK = "disk"
    FAN = "fan"
    BBU = "bbu"
    INFT = "interface"
    MGMT_INTF = "mgmt_interface"
    EXP_INTF = "exp_interface"
    ENCLOSURE = "enclosure"
    FIBER_MODULE = "fibre_module"
    FAN_CTRL_MODULE = "fan_ctrl_module"

    FRONT_END_CABLE = "front_end_cable"
    MGMT_CABLE = "mgmt_cable"
    IB_CABLE = "ib_cable"
    SAS_CABLE = "sas_cable"
    PCIE_CABLE = "pcie_cable"
    IP_SCALEOUT_CABLE = "ip_scaleOut_cable"

    DATA_SWITCH = "data_switch"
    GROUND_CABLE = "ground_cable"
    SVP_MGMT_CABLE = "svp_mgmt_cable"

    CONTROLLER_ENCLOSURE = "controller_enclosure"
    DISK_ENCLOSURE = "disk_enclosure"
    BACK_END_INTF = "back_end_interface"
    SMART_ACC_INTF = "smart_ACC_interface"
    FRONT_END_INTF = "front_end_interface"
    IP_SCALEOUT_FIBER_MODULE = "ip_scaleOut_fibre_module"
    IP_SCALEOUT_INTERFACE = "ip_scaleOut_interface"
    IP_SCALEOUT_SWITCH = "ip_scaleOut_data_switch"
    PCIE_INTERFACE = "pcie_interface"
    PCIE_SWITCH = "pcie_data_switch"
    # ---------------

    # ---------- 记录用户行为fru公共字段
    FRU_TYPE = "FruType"
    HEALTH_STATUS = "HealthStatus"
    RUNNING_STATUS = "RunningStatus"
    MODEL = "Model"  # model号
    STATUS = "Status"
    PRE_BARCODE = "pre_BarCode"  # 更换前部件的条码
    POST_BARCODE = "post_BarCode"  # 更换后部件的条码

    STARTPORT_HEALTHSTATUS = "StartPort_HealthStatus"  # 线缆始端健康状态
    STARTPORT_RUNNINGSTATUS = "StartPort_RunningStatus"  # 线缆始端运行状态
    ENDPORT_HEALTHSTATUS = "EndPort_HealthStatus"  # 线缆的末端健康状态
    ENDPORT_RUNNINGSTATUS = "EndPort_RunningStatus"  # 线缆的末端运行状态

    CLICK_REPLACED_BUTTON_TIME = "clickReplacedButtonTime"  # 点击“确认已更换”按钮的时间

    PRE_MODEL = "pre_Model"  # model号
    PRE_DISK_TYPE = "pre_DiskType"  # 硬盘类型
    PRE_RUN_TIME = "pre_RunTime"  # 运行时间
    PRE_FIRMWARE_VERSION = "pre_FirmwareVersion"  # 固件版本

    POST_MODEL = "post_Model"
    POST_PRE_DISK_TYPE = "post_DiskType"  # 更换后硬盘类型
    POST_RUN_TIME = "post_RunTime"  # 更换后运行时间
    POST_FIRMWARE_VERSION = "post_FirmwareVersion"  # 更换后固件版本

    CABLE_RUNSTATUS = "cableRunStatus"  # sas线缆连接状态

    # 扩容类型：扩控制器/硬盘柜/硬盘框
    EXPANSION_TYPE_CTRL = "CTRL"
    EXPANSION_TYPE_BAY = "BAY"
    EXPANSION_TYPE_ENCLOSURE = "ENCLOSURE"

    TYPE = "expansionType"
    ORIGIN_CTRL_NUM = "originCtrlNum"
    ORIGIN_CLUST_TYPE = "originCfgClustType"
    NEW_CTRL_NUM = "newCtrlNum"
    NEW_CLUST_TYPE = "newCfgClustType"
    ORIGIN_DISK_ENCLOSURE_NUM = "originDiskEnclosureNum"
    NEW_DISK_ENCLOSURE_NUM = "newDiskEnclosureNum"


# 升级前热补丁检查产品版本与补丁版本对应关系
# + 表示及以后的版本；
# 两个版本时表示按顺序安装两个版本补丁
# * 表示及以后的版本，不包含x99版本
HOT_PATCH_VERSION_DICT = {
    "V300R001C10B012": ["V300R001C10B012SPH099"],
    "V300R001C10SPC100": ["V300R001C10SPH199"],
    "V300R001C10SPC200": ["V300R001C10SPH299"],
    "V300R001C20": ["V300R001C20SPH007+"],
    "V300R001C20SPC200": ["V300R001C20SPH211+"],

    "V300R002C00": ["V300R002C00SPH099"],
    "V300R002C00SPC100": ["V300R002C00SPH199"],
    "V300R002C10": ["V300R002C10SPH005"],
    "V300R002C10SPC100": ["V300R002C10SPH190"],
    "V300R002C10SPC200": ["V300R002C10SPH212+"],

    "V300R003C00SPC100": ["V300R003C00SPH111+"],
    "V300R003C10SPC100": ["V300R003C10SPH119+"],
    "V300R003C20": ["V300R003C20SPH003*"],
    "V300R003C20SPC200": ["V300R003C20SPH220*"],
    "V300R005C00SPC300": ["V300R005C00SPH310*"],
    "V300R006C00SPC100": ["V300R006C00SPH116+"],
    "V300R006C10SPC100": ["V300R006C10SPH108+"],
    "V500R007C00SPC100": ["V500R007C00SPH108+"],
    "V300R006C20": ["V300R006C20SPH039+"],
    "V500R007C10": ["V500R007C10SPH039+"],
    "V300R006C50SPC100": ["V300R006C50SPH135+"],
    "V500R007C30SPC100": ["V500R007C30SPH135+"],
    "V300R006C60": ["V300R006C60SPH007+"],
    "V500R007C50": ["V500R007C50SPH007+"],
    "V100R001C00SPC200": ["V100R001C00SPH299"],
    "V100R001C00SPC300": ["V100R001C00SPC399", "V100R001C00SPH399"],
    "V100R001C20B013": ["V100R001C20B013SPH099"],
    "V100R001C20SPC100": ["V100R001C20SPH101+"],
    "V100R001C20SPC200": ["V100R001C20SPH299"],
    "V100R001C30": ["V100R001C30SPH001+"],
    "V100R001C30SPC100": ["V100R001C30SPH102+"],
    "V100R001C30SPC200": ["V100R001C30SPH215+"],

    "V200R002C00SPC200": ["V200R002C00SPH299"],
    "V200R002C00SPC300": ["V200R002C00SPH399"],
    "V200R002C00SPC400": ["V200R002C00SPC499", "V200R002C00SPH499"],
    "V200R002C20B013": ["V200R002C20B013SPH099"],
    "V200R002C20SPC100": ["V200R002C20SPH199"],
    "V200R002C20SPC200": ["V200R002C20SPH299"],
    "V200R002C30": ["V200R002C30SPH007+"],
    "V200R002C30SPC200": ["V200R002C30SPH212+"],
}

# Dorado升级前热补丁检查产品版本与补丁版本对应关系（+ 表示及以后的版本；两个版本时表示按顺序安装两个版本补丁）
HOT_PATCH_VERSION_DICT_DORADO = {
    "V300R001C00SPC100": ["V300R001C00SPH102+"],
    "V300R001C21": ["V300R001C21SPH070#"],
    "V300R002C10SPC100": ["V300R002C10SPH133+"],
}

# Dorado NAS 升级前热补丁检查产品版本与补丁版本对应关系（+ 表示及以后的版本；两个版本时表示按顺序安装两个版本补丁）
HOT_PATCH_VERSION_DICT_DORADO_NAS = {
    "V300R002C10SPC100": ["V300R002C10SPH112+"],
}

REQUIRED_PATCH_LIST = [
    {
        "product_version": "V300R001C01SPC100",
        "required_patch": "V300R001C01SPH107",
        "product_series": "Dorado",
        "emergency_patch": ["V300R001C01SPH170", ],
    },
    {
        "product_version": "V300R001C21SPC100",
        "required_patch": "V300R001C21SPH120",
        "product_series": "Dorado",
        "emergency_patch": ["V300R001C21SPH173"],
    },
    {
        "product_version": "V300R001C30SPC100",
        "required_patch": "V300R001C30SPH109",
        "product_series": "Dorado",
        "emergency_patch": [],
    },
    {
        "product_version": "V300R002C00SPC100",
        "required_patch": "V300R002C00SPH107",
        "product_series": "Dorado",
        "emergency_patch": ["V300R002C00SPH171", ],
    },
    {
        "product_version": "V300R002C20",
        "required_patch": "V300R002C20SPH009",
        "product_series": "Dorado",
        "emergency_patch": [],
    },
    {
        "product_version": "6.0.0",
        "required_patch": "SPH11",
        "product_series": "Dorado",
        "emergency_patch": [],
    },
    {
        "product_version": "6.0.1",
        "required_patch": "SPH28",
        "product_series": "Dorado",
        "emergency_patch": [],
    },
    {
        "product_version": "6.1.RC3",
        "required_patch": "SPH1",
        "product_series": "Dorado",
        "emergency_patch": [],
    },
    {
        "product_version": "6.1.0",
        "required_patch": "SPH22",
        "product_series": "Dorado",
        "emergency_patch": [],
    },
    {
        "product_version": "6.1.2",
        "required_patch": "SPH12",
        "product_series": "Dorado",
        "emergency_patch": [],
    }
]

# 没有解决补丁
NO_FIX_PATCH = "SPH999"
# Kunpeng设备要求的补丁版本配置，注意配置中版本号去掉Kunpeng字样
KUNPENG_PATCH_CONFIG = [
    {
        "product_version": "V500R007C60",
        "required_patch": NO_FIX_PATCH,
        "product_series": "ConvergedStorage",
    },
    {
        "product_version": "V500R007C60SPC100",
        "required_patch": "V500R007C60SPH108",
        "product_series": "ConvergedStorage",
    },
    {
        "product_version": "V500R007C60SPC200",
        "required_patch": NO_FIX_PATCH,
        "product_series": "ConvergedStorage",
    },
    {
        "product_version": "V500R007C60SPC300",
        "required_patch": "V500R007C60SPH326",
        "product_series": "ConvergedStorage",
    },
    {
        "product_version": "V500R007C71SPC100",
        "required_patch": "V500R007C71SPH115",
        "product_series": "ConvergedStorage",
    },
]

# V3R2C00SPH101 补丁合集地址（中文）
V3R2C00SPH101_PATCH_SET_URL_ZH = public_ip_address_utils.get_hot_patch_url(
    "V3R2C00SPH101_PATCH_SET_URL_ZH")
# V3R2C00SPH101 补丁合集地址（英文）
V3R2C00SPH101_PATCH_SET_URL_EN = public_ip_address_utils.get_hot_patch_url(
    "V3R2C00SPH101_PATCH_SET_URL_EN")

# V300R003C20SPH203 补丁合集
V3R3C20SPH203_PATCH_SET_URL_ZH = public_ip_address_utils.get_hot_patch_url(
    "V3R3C20SPH203_PATCH_SET_URL_ZH")
V3R3C20SPH203_PATCH_SET_URL_EN = public_ip_address_utils.get_hot_patch_url(
    "V3R3C20SPH203_PATCH_SET_URL_EN")

# 补丁合集 EmergencyTool（包含V300R003C10SPH190）
V3R3C10SPH190_PATCH_SET_URL_ZH = public_ip_address_utils.get_hot_patch_url(
    "V3R3C10SPH190_PATCH_SET_URL_ZH")
V3R3C10SPH190_PATCH_SET_URL_EN = public_ip_address_utils.get_hot_patch_url(
    "V3R3C10SPH190_PATCH_SET_URL_EN")
# support网址
SUPPORT_DEFAULT_SET_URL = public_ip_address_utils.get_support_website()

# 补丁集下载地址
SPECIAL_HOT_PATCH_DOWNLOAD_PATH = {
    "zh": {
        "Default": SUPPORT_DEFAULT_SET_URL,
        "V100R001C20B013": V3R2C00SPH101_PATCH_SET_URL_ZH,
        "V100R001C20SPC100": V3R2C00SPH101_PATCH_SET_URL_ZH,
        "V100R001C20SPC200": V3R2C00SPH101_PATCH_SET_URL_ZH,
        "V200R002C20B013": V3R2C00SPH101_PATCH_SET_URL_ZH,
        "V200R002C20SPC100": V3R2C00SPH101_PATCH_SET_URL_ZH,
        "V200R002C20SPC200": V3R2C00SPH101_PATCH_SET_URL_ZH,
        "V300R001C10B012": V3R2C00SPH101_PATCH_SET_URL_ZH,
        "V300R001C10SPC100": V3R2C00SPH101_PATCH_SET_URL_ZH,
        "V300R001C10SPC200": V3R2C00SPH101_PATCH_SET_URL_ZH,
        "V300R002C00": V3R2C00SPH101_PATCH_SET_URL_ZH,
        "V300R002C00SPC100": V3R2C00SPH101_PATCH_SET_URL_ZH,
        "V300R002C10": V3R3C20SPH203_PATCH_SET_URL_ZH,
        "V300R002C10SPC100": V3R3C10SPH190_PATCH_SET_URL_ZH,
    },
    "en": {
        "Default": SUPPORT_DEFAULT_SET_URL,
        "V100R001C20B013": V3R2C00SPH101_PATCH_SET_URL_EN,
        "V100R001C20SPC100": V3R2C00SPH101_PATCH_SET_URL_EN,
        "V100R001C20SPC200": V3R2C00SPH101_PATCH_SET_URL_EN,
        "V200R002C20B013": V3R2C00SPH101_PATCH_SET_URL_EN,
        "V200R002C20SPC100": V3R2C00SPH101_PATCH_SET_URL_EN,
        "V200R002C20SPC200": V3R2C00SPH101_PATCH_SET_URL_EN,
        "V300R001C10B012": V3R2C00SPH101_PATCH_SET_URL_EN,
        "V300R001C10SPC100": V3R2C00SPH101_PATCH_SET_URL_EN,
        "V300R001C10SPC200": V3R2C00SPH101_PATCH_SET_URL_EN,
        "V300R002C00": V3R2C00SPH101_PATCH_SET_URL_EN,
        "V300R002C00SPC100": V3R2C00SPH101_PATCH_SET_URL_EN,
        "V300R002C10": V3R3C20SPH203_PATCH_SET_URL_EN,
        "V300R002C10SPC100": V3R3C10SPH190_PATCH_SET_URL_EN,
    },
}

# 某些版本的某些设备类型不需要检查补丁
HOT_PATCH_DEVTYPE_WHITE_DICT = {
    "V300R003C20": ["2800 V3"],
}

PDT_MODEL_SUPPORT_SAS_NVME_MIX = ["18510M_V5", "18810M_V5",
                                  "18510M_V5_P", "18810M_V5_P",
                                  "18510_M_C", "18500K_M_C", "18810_M_C",
                                  "18510_M_C_2P", "18500K_M_C_2P"]


class SvpResult:
    """CBB检查是否带SVP的结果

    """
    NEW_TOOLBOX_HAS_SVP = "new_toolbox_hassvp"  # 新工具箱，带SVP
    NEW_TOOLBOX_NO_SVP = "new_toolbox_nosvp"  # 新工具箱，不带SVP
    OLD_TOOLBOX = "old_toolbox"  # 老工具箱


class TrVersion:
    """新硬件TR版本号

    """
    V6_TR5 = "6.0.RC1"
    V5_TR6 = "V500R007C60SPC300"


LUN_CACHE_MIRROR_PATCH_CHECK = {
    "V300R003C00SPC100": "V300R003C00SPH111",
    "V300R003C10SPC100": "V300R003C10SPH118",
    "V300R003C20SPC200": "V300R003C20SPH217",
    "V300R005C00SPC300": "V300R005C00SPH308",
    "V300R006C00SPC100": "V300R006C00SPH111"
}

LUN_CACHE_MIRROR_PATCH_CHECK_LATER_VERSION = {
    "V500R007C00SPC100": "V500R007C00SPH105",
    "V300R006C10SPC100": "V300R006C10SPH105",
    "V500R007C10": "V500R007C10SPH006",
    "V300R006C20": "V300R006C20SPH006",
    "V500R007C10SPC100": "V500R007C10SPH115",
    "V300R006C20SPC100": "V300R006C20SPH115",
}

# B21-P内存型号的BOM编码
BOM_INFO_OF_MEMORY_TYPE_B = (
    "03050HNY", "03050HPA", "03050HSA", "03050HSE", "03050HSL", "03050HPB",
    "03050HPC", "03050HSB", "03050HSF", "03050HSM", "03050HPD", "03050HPE",
    "03050HSG", "03050HPF", "03050HPG", "03050HSH", "03050HRV", "03050HRW",
    "03050HSJ", "03050HRX", "03050HRY", "03050HSK", "03050HPY", "03050HSU",
    "03050HQC", "03050HQD", "03050HQE", "03050HQF", "03050HQH", "03050HQG",
    "03050HRK", "03050HRL", "03050HRM", "03050HRN", "03050HSR", "03050HSS",
    "03050HST", "03050HPX", "03050HQT", "03050HQU", "03050HQV", "03050HQW",
    "03050HQX", "03050HQY", "03050HRA", "03050HRB", "03050HRC", "03050HRD",
    "03050HRE", "03050HRG", "03050HRU", "03050HRH", "03050HRJ", "03050HRP",
    "03050GWM", "03050HRS", "03050HRT", "03050HRQ", "03050HSN", "03050HRS",
    "03050HSP", "03050HSQ", "02355AVT", "02355AWF", "02355AVS", "02355AVX",
    "02355BBF", "02355BVY", "02355BUP", "02355BUQ", "02355BUR", "02355BUS",
    "02355BUT", "02355BUU", "02355BTR", "02355BTT", "02355BTX", "02355BUB",
    "02355CEQ", "02355CES", "02355CET", "02355CEU", "02355CEV", "02355CEW",
    "02355CFC"
)

# CXMT内存型号的BOM编码
BOM_INFO_OF_MEMORY_CXMT = (
    "03050NLU", "03050NKY", "03050NNE", "03050NMF", "03050NNF", "03050NMG", "03050NMM", "03050NNG", "03050NMQ",
    "03050NMP", "03050NLA", "03050NLY", "03050NMB", "03050NMC", "03050NMV", "03050NME", "03050NNA", "03050NNB",
    "03050NNH", "03050NNJ", "03050NNK", "03050NNL", "03050NWF", "03050NWG", "03050NWH", "03050NWJ", "03050NLB",
    "03050NMH", "03050NMN", "03050NNS", "03050NWK", "03050NMK", "03050NML", "03050NNT", "03050NPC", "03050NPE",
    "03050NWM", "03050NPM", "03050NPN", "03050NPP", "03050NPQ", "03050NMT", "03050NPR", "03050NPT", "03050NPV",
    "03050NWN", "03050NWP", "03050NWQ", "03050NPX", "03050NWT", "03050NWV", "02356GAF", "02356GBU", "02356KQP",
    "02356KQQ", "02356KQR", "02356KQT"
)
