/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.log.service;

import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.framework.pubservice.entity.OperaLog;
import com.huawei.ism.tool.log.util.OperaLogParser;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.excel.POIUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Sheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportLogFileWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExportLogFileWriter.class);
    private static final String SHEET_TITLE = "operalog";
    private static final int EXCEL_START_COLUMN = 0;
    private static final String NULL_STR = "--";
    private static HSSFCellStyle titleStyle = null;
    private static HSSFCellStyle contentStyle = null;
    private Sheet operaLogSheet = null;
    private HSSFWorkbook workbook = null;
    private FileOutputStream fos = null;
    private int currentRow = 0;
    private int currentColumn = 0;
    private List<OperaLog> logs = new ArrayList<OperaLog>(1);
    private OperaLogParser parser = new OperaLogParser();

    public void setLogs(List<OperaLog> logs) {
        this.logs = logs;
    }

    private void createDeployFile(String path) throws ToolException {
        File excelFile = new File(path);
        boolean result = false;
        if (excelFile.exists() && !(result = excelFile.delete())) {
            throw new ToolException("deploy.excel.export.createexportfileerror");
        }
        try {
            File file = excelFile.getParentFile();
            if (!file.exists()) {
                result = file.mkdirs();
                LOGGER.info("create export file dir :{}", (Object)result);
            }
            if (!(result = excelFile.createNewFile())) {
                throw new ToolException("deploy.excel.export.createexportfileerror");
            }
            this.fos = new FileOutputStream(excelFile);
            this.workbook = new HSSFWorkbook();
            this.operaLogSheet = this.workbook.createSheet(SHEET_TITLE);
            this.initFontAndStyle(this.workbook);
        }
        catch (IOException e) {
            LOGGER.error("create deploy workbook error!!!");
            throw new ToolException("", e);
        }
    }

    public boolean exportOperaFile(String path) throws ToolException {
        this.createDeployFile(path);
        boolean isSuccess = true;
        try {
            this.writeHead();
            this.newline();
            for (OperaLog log : this.logs) {
                this.writeLog(log);
                this.newline();
            }
            boolean bl = isSuccess;
            return bl;
        }
        catch (Exception e) {
            throw new ToolException("deploy.excel.export.exportfile.error", e);
        }
        finally {
            try {
                this.workbook.write((OutputStream)this.fos);
            }
            catch (Exception e) {
                LOGGER.error("Turn off the data flow fails", (Throwable)e);
                isSuccess = false;
            }
            StreamUtils.closeResource(null, (Closeable)this.workbook);
            StreamUtils.closeStream(this.fos, null);
            if (!isSuccess && !new File(path).delete()) {
                LOGGER.error("S8000/VIS export deploy file delete error!");
            }
        }
    }

    private void writeHead() {
        POIUtils.setCellValue(this.operaLogSheet, this.currentRow, this.currentColumn, ResourceUtil.getString("operalog.maintable.header.operaname"), titleStyle);
        ++this.currentColumn;
        POIUtils.setCellValue(this.operaLogSheet, this.currentRow, this.currentColumn, ResourceUtil.getString("operalog.maintable.header.time"), titleStyle);
        ++this.currentColumn;
        POIUtils.setCellValue(this.operaLogSheet, this.currentRow, this.currentColumn, ResourceUtil.getString("operalog.maintable.header.type"), titleStyle);
        ++this.currentColumn;
        POIUtils.setCellValue(this.operaLogSheet, this.currentRow, this.currentColumn, ResourceUtil.getString("operalog.maintable.header.device"), titleStyle);
        ++this.currentColumn;
        POIUtils.setCellValue(this.operaLogSheet, this.currentRow, this.currentColumn, ResourceUtil.getString("operalog.maintable.header.result"), titleStyle);
        ++this.currentColumn;
        POIUtils.setCellValue(this.operaLogSheet, this.currentRow, this.currentColumn, ResourceUtil.getString("operalog.maintable.header.user"), titleStyle);
        ++this.currentColumn;
        POIUtils.setCellValue(this.operaLogSheet, this.currentRow, this.currentColumn, ResourceUtil.getString("operalog.maintable.header.detail"), titleStyle);
        ++this.currentColumn;
    }

    private void writeLog(OperaLog log) {
        POIUtils.setCellValue(this.operaLogSheet, this.currentRow, this.currentColumn, ResourceUtil.getString(log.getOperaName()), contentStyle);
        ++this.currentColumn;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        POIUtils.setCellValue(this.operaLogSheet, this.currentRow, this.currentColumn, format.format(log.getOperateDate()), contentStyle);
        ++this.currentColumn;
        POIUtils.setCellValue(this.operaLogSheet, this.currentRow, this.currentColumn, ResourceUtil.getString(log.getOperateType()), contentStyle);
        ++this.currentColumn;
        String deviceName = NULL_STR;
        Locale locale = LanguageManager.getInstance().getCurrentLanguage();
        deviceName = "zh".equalsIgnoreCase(locale.getLanguage()) ? log.getDeviceName() : log.getDeviceNameEn();
        POIUtils.setCellValue(this.operaLogSheet, this.currentRow, this.currentColumn, deviceName, contentStyle);
        ++this.currentColumn;
        POIUtils.setCellValue(this.operaLogSheet, this.currentRow, this.currentColumn, this.parser.getResultString(log.isResult()), contentStyle);
        ++this.currentColumn;
        String userName = NULL_STR;
        if (!StringUtils.isNULLStr(log.getUserName())) {
            userName = log.getUserName();
        }
        POIUtils.setCellValue(this.operaLogSheet, this.currentRow, this.currentColumn, userName, contentStyle);
        ++this.currentColumn;
        String detailName = NULL_STR;
        if (!StringUtils.isNULLStr(log.getDetailInfo()) && NULL_STR.equals(detailName = ResourceUtil.getString(log.getDetailInfo()))) {
            detailName = log.getDetailInfo();
        }
        POIUtils.setCellValue(this.operaLogSheet, this.currentRow, this.currentColumn, detailName, contentStyle);
        ++this.currentColumn;
    }

    private void newline() {
        ++this.currentRow;
        this.currentColumn = 0;
    }

    private void initFontAndStyle(HSSFWorkbook book) {
        titleStyle = POIUtils.createTitleStyle(book);
        contentStyle = POIUtils.createContentStyle(book);
        contentStyle.setWrapText(false);
    }
}

