/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.log.ui;

import com.huawei.ism.tool.exttool.entity.Tool;
import com.huawei.ism.tool.exttool.service.ToolManager;
import com.huawei.ism.tool.framework.platform.util.JComponentNameUtils;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.framework.pubservice.PublicServiceManage;
import com.huawei.ism.tool.framework.pubservice.common.ILogSupportService;
import com.huawei.ism.tool.framework.pubservice.entity.OperaLog;
import com.huawei.ism.tool.log.entity.DebugLog;
import com.huawei.ism.tool.log.service.ExportDebugTask;
import com.huawei.ism.tool.obase.filechooser.ToolFileChooser;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StreamUtils;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DebugLogMainPanel
extends JPanel {
    private static final long serialVersionUID = -6723475272847020769L;
    private static final String EXPORT_FILE_PATH_ID = "com.huawei.ism.tool.log.ui.debugLogPanel";
    private IsmTable table;
    private DefaultTableModel tableModel;
    private JButton collectBtn;
    private JLabel descLabel;
    private JDialog parentDialog;

    public DebugLogMainPanel(JDialog parent) {
        this.parentDialog = parent;
        this.initUI();
        this.initData();
        this.initListener();
        this.addName();
    }

    private void addName() {
        JComponentNameUtils.setJComponentName(this.collectBtn, "logsupport_debug_log_export_btn");
    }

    private void initData() {
        List<Tool> tools = ToolManager.getInstance().getToolList();
        ArrayList<TableRow> tableRows = new ArrayList<TableRow>();
        this.addToolkit(tableRows);
        this.addTools(tools, tableRows);
        this.tableModel.addRow(tableRows);
        this.table.addRowSelectionInterval(0, 0);
    }

    private void addTools(List<Tool> tools, List<TableRow> tableRows) {
        if (null != tools && !tools.isEmpty()) {
            for (Tool tool : tools) {
                Locale locale = LanguageManager.getInstance().getCurrentLanguage();
                DebugLog debugLog = new DebugLog(tool.getId(), tool.getName(locale));
                String logPath = this.getLogPath(debugLog, true);
                String oldLogPath = this.getLogPath(debugLog, false);
                if (!new File(logPath).exists() && !new File(oldLogPath).exists()) continue;
                debugLog.setLogPath(logPath);
                debugLog.setLogOldPath(oldLogPath);
                if (new File(oldLogPath).exists()) {
                    debugLog.setBeginRecordTime(this.getRecordTime(oldLogPath));
                } else {
                    debugLog.setBeginRecordTime(this.getRecordTime(logPath));
                }
                tableRows.add(this.constructRow(debugLog));
            }
        }
    }

    private String getRecordTime(String logPath) {
        List<String> logPathList = this.getLogPathList(new File(logPath));
        String minTime = "--";
        String getTime = null;
        for (String path : logPathList) {
            getTime = this.getBeginRecordTime(path);
            if (StringUtils.isNULLStr(getTime) || "--".equals(getTime.trim()) || !"--".equals(minTime.trim()) && !this.compareDate(minTime, getTime)) continue;
            minTime = getTime;
        }
        return minTime;
    }

    private boolean compareDate(String minTime, String currTime) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date minDt = df.parse(minTime);
            Date currDt = df.parse(currTime);
            if (minDt.getTime() > currDt.getTime()) {
                return true;
            }
        }
        catch (ParseException e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("getter Time exception", (Throwable)e);
        }
        return false;
    }

    private List<String> getLogPathList(File logFile) {
        ArrayList<String> logPathList = new ArrayList<String>();
        this.getLogsFile(logFile, logPathList);
        return logPathList;
    }

    private void getLogsFile(File file, List<String> childList) {
        try {
            File[] listFiles = file.listFiles();
            if (null == listFiles) {
                return;
            }
            for (File childFile : listFiles) {
                if (childFile.isDirectory()) {
                    this.getLogsFile(childFile, childList);
                }
                if (!childFile.getName().contains(".log")) continue;
                childList.add(childFile.getCanonicalPath());
            }
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("getter log exception", (Throwable)e);
        }
    }

    private void addToolkit(List<TableRow> tableRows) {
        DebugLog debugLog1 = new DebugLog("Toolkit", "Smartkit");
        String logPath1 = this.getLogPath(debugLog1, true);
        debugLog1.setLogPath(logPath1);
        debugLog1.setBeginRecordTime(this.getRecordTime(logPath1));
        tableRows.add(this.constructRow(debugLog1));
    }

    private void initUI() {
        String[] tableHeaders = new String[]{ResourceUtil.getString("operalog.remind.debuglog.table.head.toolname"), ResourceUtil.getString("operalog.remind.debuglog.table.head.updatetime")};
        this.tableModel = new DefaultTableModel(tableHeaders, new int[0]);
        this.table = new IsmTable(this.tableModel);
        this.collectBtn = UiMethod.createButton(ResourceUtil.getString("operalog.type.toolstore.exp"), 'E');
        this.descLabel = new JLabel(ResourceUtil.getString("operalog.remind.debuglog.desc"));
        JComponent view = UCD.buildVerticalBox(null, UCD.buildHorizontalBoxLeft(this.descLabel), UCD.buildHorizontalBoxLeft(this.collectBtn), new TableScrollPane(this.table, true, true));
        this.setLayout(new BorderLayout());
        this.add(UiMethod.buildFrameSpace(view, 12));
    }

    private void initListener() {
        this.collectBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] indexs = DebugLogMainPanel.this.table.getSelectedRows();
                if (indexs.length < 1) {
                    DialogUtils.showInfoDialog(DebugLogMainPanel.this.parentDialog, ResourceUtil.getString("operalog.remind.debuglog.confirm"));
                    return;
                }
                String exportFileTitle = ResourceUtil.getString("operalog.remind.debuglog.export.title");
                String exportFileName = "SmartkitLogs_" + System.currentTimeMillis();
                String path = ToolFileChooser.getSaveFilePath(exportFileTitle, "zip", (Window)DebugLogMainPanel.this.parentDialog, exportFileName, DebugLogMainPanel.EXPORT_FILE_PATH_ID, 0);
                if (path == null) {
                    return;
                }
                List<TableRow> tableRows = DebugLogMainPanel.this.tableModel.getAllRows();
                HashSet<DebugLog> debugLogs = new HashSet<DebugLog>();
                for (int index : indexs) {
                    debugLogs.add((DebugLog)tableRows.get(index).getUserObject());
                }
                TaskResult tr = UiMethod.asyncExecute(DebugLogMainPanel.this.parentDialog, new ExportDebugTask(debugLogs, path));
                if (null != tr && tr.getResult().equals((Object)TaskResult.Result.SUCCESS)) {
                    DialogUtils.showInfoDialog(DebugLogMainPanel.this.parentDialog, ResourceUtil.getString("operalog.remind.debuglog.export.success"));
                    DebugLogMainPanel.this.addOperaLog(true, "");
                } else {
                    DialogUtils.showInfoDialog(DebugLogMainPanel.this.parentDialog, ResourceUtil.getString("operalog.remind.debuglog.export.faild"));
                    DebugLogMainPanel.this.addOperaLog(false, "");
                }
            }
        });
    }

    private void addOperaLog(boolean succeed, String detailInfo) {
        OperaLog log = new OperaLog();
        log.setUserName(com.huawei.ism.tool.framework.platform.util.ApplicationContext.getInstance().getCurToolkitUser());
        log.setDeviceName("Smartkit");
        log.setDeviceNameEn("Smartkit");
        log.setOperateType("operalog.type.system");
        log.setOperaName("operalog.remind.debuglog.export");
        log.setResult(succeed);
        log.setDetailInfo(detailInfo);
        ILogSupportService logService = PublicServiceManage.getInstance().getService(ILogSupportService.class);
        if (null != logService) {
            logService.addOperaLog(log);
        }
    }

    private String getLogPath(DebugLog debugLog, boolean isNewLog) {
        if ("Toolkit".equals(debugLog.getType())) {
            return ApplicationContext.getInstance().getRunnigLogPath() + File.separator + "log";
        }
        if (isNewLog) {
            return new StringBuffer().append(ApplicationContext.getInstance().getRunnigLogPath()).append(File.separator).append("tools").append(File.separator).append(debugLog.getType()).append(File.separator).append("log").toString();
        }
        return new StringBuffer().append(ApplicationContext.getInstance().getRunnigLogPath()).append(File.separator).append("tools").append(File.separator).append(debugLog.getType()).append(File.separator).append("log_old").toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getBeginRecordTime(String debugLogPath) {
        String string;
        File logFile = new File(debugLogPath);
        if (!logFile.exists()) {
            return "--";
        }
        InputStreamReader reader = null;
        BufferedReader fr = null;
        FileInputStream fileInputStream = null;
        String line = "";
        try {
            fileInputStream = new FileInputStream(logFile);
            reader = new InputStreamReader((InputStream)fileInputStream, Charset.forName("utf-8"));
            fr = new BufferedReader(reader);
            while ((line = fr.readLine()) != null) {
                String matchContent = StringUtils.findMatchStr(line, "\\d{4}(\\-\\d{2}){2}\\s\\d{2}(:\\d{2}){2}", 0);
                if (StringUtils.isNULLStr(matchContent)) continue;
                string = matchContent;
            }
        }
        catch (IOException e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("get beginRecord time error at " + line, (Throwable)e);
            {
                catch (Throwable throwable) {
                    StreamUtils.closeResource(null, fr);
                    StreamUtils.closeResource(null, reader);
                    StreamUtils.closeResource(null, fileInputStream);
                    throw throwable;
                }
            }
            StreamUtils.closeResource(null, fr);
            StreamUtils.closeResource(null, reader);
            StreamUtils.closeResource(null, fileInputStream);
            return "--";
            catch (Exception e2) {
                ToolLoggerFactory.getLogger(this.getClass()).error("get beginRecord time error at " + line, (Throwable)e2);
                StreamUtils.closeResource(null, fr);
                StreamUtils.closeResource(null, reader);
                StreamUtils.closeResource(null, fileInputStream);
                return "--";
            }
        }
        StreamUtils.closeResource(null, fr);
        StreamUtils.closeResource(null, reader);
        StreamUtils.closeResource(null, fileInputStream);
        return "--";
        StreamUtils.closeResource(null, fr);
        StreamUtils.closeResource(null, reader);
        StreamUtils.closeResource(null, fileInputStream);
        return string;
    }

    private TableRow constructRow(DebugLog debugLog) {
        DefaultTableRow<DebugLog, String> row = new DefaultTableRow<DebugLog, String>(2, debugLog, debugLog.getType());
        row.setValueAt(0, debugLog.getName());
        row.setValueAt(1, debugLog.getBeginRecordTime());
        return row;
    }
}

