/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.actions;

import com.huawei.bundleupgrade.constants.UpgradeParamConstants;
import com.huawei.bundleupgrade.entity.FirmwarePackageEntity;
import com.huawei.bundleupgrade.entity.UpgradeDeviceEntity;
import com.huawei.bundleupgrade.utils.BundleUpgradeContext;
import com.huawei.bundleupgrade.utils.UpgradeConstants;
import com.huawei.bundleupgrade.utils.UpgradeExecutionWatchDog;
import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.framework.pubservice.common.devmanage.ISceneEnvironment;
import com.huawei.ism.tool.framework.pubservice.entity.TaskResult;
import com.huawei.ism.tool.framework.pubservice.sceneimpl.SceneEnvironmentImpl;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.uMate.common.ftp.SFTPServer;
import com.huawei.uMate.common.utils.ResUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import javax.swing.JFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanUpExecutionContextsAction {
    private static final Logger log = LoggerFactory.getLogger(CleanUpExecutionContextsAction.class);
    private static final String BUNDLE_UPGRADE = "BundleUpgrade";
    private static final ResUtil RES = ResUtil.getInstance((String)"BundleUpgrade");

    public void doExecutionExit() {
        this.writeSceneResults();
        AsyncExcutor.execute((JFrame)((Object)BundleUpgradeContext.getInstance().getMainDialog()), (String)RES.getString("system.cleaning.up"), (int)150, (Callable[])new Callable[]{() -> {
            log.info("cleaning up daemons...");
            UpgradeExecutionWatchDog.killDog();
            log.info("cleaning tmp files...");
            FileUtils.clearDir((String)ApplicationContext.getInstance().getTmpPath());
            FileUtils.clearDir((String)UpgradeConstants.PACKAGE_TEMP);
            if (SFTPServer.stopSFTP()) {
                log.error("SFTP server stop successfully.");
            } else {
                log.error("SFTP server stop failed.");
            }
            BundleUpgradeContext.getInstance().getMainDialog().releaAllNodesFloatIpRestConn();
            return Boolean.TRUE;
        }});
        log.warn("BUNDLE UPGRADE TOOL NOW  SHUT DOWN......");
        BundleUpgradeContext.getInstance().getMainDialog().setDefaultCloseOperation(2);
        com.huawei.ism.tool.framework.platform.util.ApplicationContext.getInstance().fireToolStopped(BUNDLE_UPGRADE);
        System.exit(0);
    }

    private void writeSceneResults() {
        log.info("Write scene data files.");
        TaskResult result = null;
        ArrayList callBackMap = new ArrayList();
        try {
            List<UpgradeDeviceEntity> devices = BundleUpgradeContext.getInstance().getDeviceUpgradeInfos();
            devices.forEach(deviceEntity -> {
                HashMap<String, String> map = new HashMap<String, String>();
                if (deviceEntity.getProcessStatus() == UpgradeParamConstants.UpgradeStatus.FAILED || deviceEntity.getProcessStatus() == UpgradeParamConstants.UpgradeStatus.UPGRADE_PARTIAL_SUCCESS) {
                    map.put("status", TaskResult.Result.FAILED.toString());
                    this.encapsulateSceneData(callBackMap, (UpgradeDeviceEntity)deviceEntity, (Map<String, String>)map);
                }
                if (deviceEntity.getProcessStatus() == UpgradeParamConstants.UpgradeStatus.COMPLETED) {
                    map.put("status", TaskResult.Result.SUCCESS.toString());
                    this.encapsulateSceneData(callBackMap, (UpgradeDeviceEntity)deviceEntity, (Map<String, String>)map);
                }
            });
            ISceneEnvironment environmentImpl = SceneEnvironmentImpl.getInstance();
            result = environmentImpl.finishedSceneTask(callBackMap);
        }
        catch (Exception e) {
            log.error("Scene data files callback failed.", (Throwable)e);
        }
        if (result != null && !result.getResult().equals((Object)TaskResult.Result.SUCCESS)) {
            log.info("Scene data file callback failed.");
        }
    }

    private void encapsulateSceneData(List<Map<String, String>> callBackMap, UpgradeDeviceEntity deviceEntity, Map<String, String> map) {
        map.put("toolId", BUNDLE_UPGRADE);
        map.put("SN", StringUtils.isNULLStr((String)deviceEntity.getDeviceEntity().getSerialNumber()) ? deviceEntity.getDeviceEntity().getIp() : deviceEntity.getDeviceEntity().getSerialNumber());
        map.put("IP", deviceEntity.getDeviceEntity().getIp());
        callBackMap.add(map);
    }

    public void cleanUpDownloadedPackages() {
        AsyncExcutor.execute((JFrame)((Object)BundleUpgradeContext.getInstance().getMainDialog()), (String)RES.getString("system.cleaning.up"), (int)150, (Callable[])new Callable[]{() -> {
            BundleUpgradeContext.getInstance().getFirmwarePackageMap().values().stream().filter(this.filterThoseOnlineFirmwarePackage()).forEach(entity -> {
                FileUtils.deleteFile((File)new File(entity.getLocalPathAbs()));
                FileUtils.deleteFile((File)this.getZipPackageAesFile((FirmwarePackageEntity)entity));
            });
            return Boolean.TRUE;
        }});
    }

    private File getZipPackageAesFile(FirmwarePackageEntity entity) {
        return new File(entity.getLocalPathAbs() + ".asc");
    }

    private Predicate<FirmwarePackageEntity> filterThoseOnlineFirmwarePackage() {
        return firmwarePackageEntity -> !StringUtils.isNULLStr((String)firmwarePackageEntity.getOnlinePathAbs()) && firmwarePackageEntity.isDownloaded();
    }
}

