/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.actions;

import com.huawei.bundleupgrade.constants.UpgradeParamConstants;
import com.huawei.bundleupgrade.entity.DeviceEntity;
import com.huawei.bundleupgrade.entity.UpgradeDeviceEntity;
import com.huawei.bundleupgrade.service.connection.fusionstrg.FusionStorageRestConnector;
import com.huawei.bundleupgrade.tasks.DeviceUpgradeMainTask;
import com.huawei.bundleupgrade.tasks.PoolUpgradeTask;
import com.huawei.bundleupgrade.ui.BundleUpgradeMainDialog;
import com.huawei.bundleupgrade.ui.dialog.FoolProofingBeforeExecutionDialog;
import com.huawei.bundleupgrade.utils.BundleUpgradeContext;
import com.huawei.bundleupgrade.utils.ServiceUtil;
import com.huawei.bundleupgrade.utils.UpgradeThreadTaskExecutor;
import com.huawei.bundleupgrade.utils.fusionstrg.FusionStrgUpgradeContext;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.uMate.common.UMateException;
import com.huawei.uMate.common.utils.ResUtil;
import java.awt.Frame;
import java.awt.Window;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.CompletionService;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelUpgradeAction {
    private static final Logger log = LoggerFactory.getLogger(ParallelUpgradeAction.class);
    private static final ResUtil RES = ResUtil.getInstance((String)"BundleUpgrade");
    private static final String STEP_OPERATION_SUCC_MSG = "step.operation.basic.succ";
    private static CountDownLatch typeACountDownLatch;
    private static CountDownLatch typeCCountDownLatch;
    private List<UpgradeDeviceEntity> allDeviceList = new ArrayList<UpgradeDeviceEntity>();
    private Queue<UpgradeDeviceEntity> upgradeBQueue = new LinkedBlockingQueue<UpgradeDeviceEntity>();
    private Queue<UpgradeDeviceEntity> upgradeManagementQueue = new LinkedBlockingQueue<UpgradeDeviceEntity>();
    private Queue<Future<UpgradeDeviceEntity>> upgradedResultQueue = new LinkedBlockingQueue<Future<UpgradeDeviceEntity>>();
    private Queue<Future<UpgradeDeviceEntity>> rebootedResultQueue = new LinkedBlockingQueue<Future<UpgradeDeviceEntity>>();
    private CompletionService<UpgradeDeviceEntity> completionService;
    private ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(4, 10, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(100));
    private int nodeBCount = 0;
    private Map<String, Integer> poolNodeCountMap = new HashMap<String, Integer>();
    private Map<String, PoolUpgradeTask> poolTaskMap = FusionStrgUpgradeContext.getInstance().getPoolTaskMap();

    public void batchDoUpgrade(List<UpgradeDeviceEntity> deviceUpgradeInfos, BundleUpgradeMainDialog bundleUpgradeMainDialog) throws UMateException {
        this.checkIsAllDeviceReady2Upgrade(deviceUpgradeInfos, bundleUpgradeMainDialog);
        if (!this.checkDeviceTypeCanUpgrade(deviceUpgradeInfos)) {
            return;
        }
        FoolProofingBeforeExecutionDialog dialog = new FoolProofingBeforeExecutionDialog((Window)((Object)bundleUpgradeMainDialog), deviceUpgradeInfos, bundleUpgradeMainDialog.calculateRemainTime());
        dialog.setVisible(true);
        if (!dialog.isOKClick()) {
            log.info("User choose to cancel execution on fool-proof dialog.");
            return;
        }
        log.info("Now start to upgrade devices...");
        FusionStorageRestConnector.resetConn(deviceUpgradeInfos);
        FusionStrgUpgradeContext.getInstance().setEndUpgrade(false);
        bundleUpgradeMainDialog.getMainPanel().getTableContentPane().initDevsNum(deviceUpgradeInfos.size());
        this.allDeviceList = deviceUpgradeInfos;
        this.init();
        this.clearDevUIAndCache(deviceUpgradeInfos, bundleUpgradeMainDialog);
        this.createUpgradeTask();
        this.createTypeBRebootTask();
        log.info("Devices are pushed into the execution pool, now waits for all tasks' completion.");
    }

    private boolean checkDeviceTypeCanUpgrade(List<UpgradeDeviceEntity> upgradeDevice) {
        List deviceEntities = upgradeDevice.stream().map(UpgradeDeviceEntity::getDeviceEntity).collect(Collectors.toList());
        if (deviceEntities.stream().anyMatch(DeviceEntity::isDirectPlane) && !deviceEntities.stream().allMatch(DeviceEntity::isDirectPlane)) {
            DialogUtils.showInfoDialog((Frame)((Object)BundleUpgradeContext.getInstance().getMainDialog()), (String)RES.getString("bundle.upgrade.check.directPlane.waring"));
            return false;
        }
        return true;
    }

    private void clearDevUIAndCache(List<UpgradeDeviceEntity> deviceUpgradeInfos, BundleUpgradeMainDialog bundleUpgradeMainDialog) {
        deviceUpgradeInfos.stream().filter(info -> !info.canReboot()).forEach(UpgradeDeviceEntity::clearTime);
        deviceUpgradeInfos.forEach(info -> this.cleanUpUI((UpgradeDeviceEntity)info, bundleUpgradeMainDialog));
    }

    private void init() {
        ReentrantLock rLock = new ReentrantLock();
        FusionStrgUpgradeContext.getInstance().setrLock(rLock);
        int nodeACount = 0;
        int nodeCCount = 0;
        for (UpgradeDeviceEntity entity : this.allDeviceList) {
            if (entity.isParallelByPoolId()) {
                ++nodeACount;
                String poolId = entity.getDeviceEntity().getPoolId();
                int count = this.poolNodeCountMap.getOrDefault(poolId, 0);
                this.poolNodeCountMap.put(poolId, count + 1);
                continue;
            }
            if (entity.isUpgradeOneByOne()) {
                ++this.nodeBCount;
                continue;
            }
            if (!entity.isNodeC()) continue;
            ++nodeCCount;
        }
        typeACountDownLatch = new CountDownLatch(nodeACount);
        typeCCountDownLatch = new CountDownLatch(nodeCCount);
        this.completionService = new ExecutorCompletionService<UpgradeDeviceEntity>(UpgradeThreadTaskExecutor.getExecutor());
        this.poolTaskMap.clear();
        FusionStrgUpgradeContext.getInstance().getOffHealthIsolationList().clear();
    }

    private void createUpgradeTask() {
        for (UpgradeDeviceEntity entity : this.allDeviceList) {
            if (entity.canReboot() || entity.onlyNeedOfflineUpgrade()) {
                log.info(String.format(Locale.ENGLISH, "need reboot upgrade entity ip: %s", entity.getDeviceEntity().getIp()));
                entity.setRebootTask(true);
                entity.setProcessStatus(UpgradeParamConstants.UpgradeStatus.WAIT_REBOOT);
                if (entity.isUpgradeOneByOne()) {
                    this.upgradeBQueue.add(entity);
                } else {
                    this.addNode2RebootQueue(entity);
                }
                BundleUpgradeContext.getInstance().getMainDialog().refreshTable(entity);
                continue;
            }
            log.info(String.format(Locale.ENGLISH, "upgrade entity ip: %s", entity.getDeviceEntity().getIp()));
            DeviceUpgradeMainTask task = new DeviceUpgradeMainTask(entity, BundleUpgradeContext.getInstance().getMainDialog());
            Future<UpgradeDeviceEntity> result = this.completionService.submit(task);
            this.upgradedResultQueue.add(result);
        }
        this.threadPoolExecutor.execute(() -> this.watchUpgradeTaskFinished());
    }

    private void watchUpgradeTaskFinished() {
        while (this.upgradedResultQueue.size() > 0) {
            Future<UpgradeDeviceEntity> result = this.upgradedResultQueue.poll();
            if (!result.isDone()) {
                this.upgradedResultQueue.add(result);
                ServiceUtil.safeSleep(1000L);
                continue;
            }
            try {
                UpgradeDeviceEntity entity = result.get();
                log.info("upgrade finished device:{}", (Object)entity.getDeviceEntity().getIp());
                if (UpgradeParamConstants.UpgradeStatus.FAILED.equals((Object)entity.getProcessStatus())) {
                    if (entity.isUpgradeOneByOne()) {
                        --this.nodeBCount;
                    }
                    log.info("Device {} current status {},task ends", (Object)entity.getDeviceEntity().getIp(), (Object)entity.getProcessStatus());
                    continue;
                }
                if (!entity.needOffLineUpgrade() || !entity.isOnlineFirmwareUpgraded() || entity.onlyNeedOfflineUpgrade()) {
                    log.info("current node do not need reboot.");
                    continue;
                }
                entity.setRebootTask(true);
                if (entity.isUpgradeOneByOne()) {
                    this.upgradeBQueue.add(entity);
                } else {
                    this.addNode2RebootQueue(entity);
                }
            }
            catch (InterruptedException | ExecutionException e) {
                log.error("query upgrade task result failed:", (Throwable)e);
            }
            ServiceUtil.safeSleep(1000L);
        }
        log.info("all device upgrade success.");
    }

    private void createTypeBRebootTask() {
        this.threadPoolExecutor.execute(() -> {
            try {
                typeACountDownLatch.await();
                log.info("all type A node reboot finished.");
                this.addTypeBNode2RebootQueue();
                log.info("type B node add reboot queue.");
            }
            catch (InterruptedException ie) {
                log.error("create node typeB exception:", (Throwable)ie);
            }
        });
    }

    private void addTypeBNode2RebootQueue() {
        int addBCount = 0;
        while (addBCount < this.nodeBCount) {
            UpgradeDeviceEntity entity = this.upgradeBQueue.poll();
            if (entity == null) {
                ServiceUtil.safeSleep(1000L);
                continue;
            }
            if (entity.isManagementNode()) {
                this.upgradeManagementQueue.add(entity);
                ++addBCount;
                continue;
            }
            this.addNode2RebootQueue(entity);
            ++addBCount;
        }
        this.addManagementNode();
    }

    private void addManagementNode() {
        if (this.upgradeManagementQueue.isEmpty()) {
            return;
        }
        try {
            typeCCountDownLatch.await();
            log.info("all type C node reboot finished.");
        }
        catch (InterruptedException ie) {
            log.error("wait type C finish exception:", (Throwable)ie);
        }
        this.addManagementNode2RebootQueue();
        log.info("management node add reboot queue.");
    }

    private void addManagementNode2RebootQueue() {
        while (Objects.nonNull(this.upgradeManagementQueue.peek())) {
            this.addNode2RebootQueue(this.upgradeManagementQueue.poll());
        }
        ServiceUtil.safeSleep(1000L);
    }

    private void addNode2RebootQueue(UpgradeDeviceEntity entity) {
        if (FusionStrgUpgradeContext.getInstance().isEndUpgrade()) {
            BundleUpgradeContext.getInstance().getMainDialog().refreshAllWaitingDevices2Aborted();
            log.info(String.format(Locale.ENGLISH, "The upgrade and reboot task is terminited, No more added:%s", entity.getDeviceEntity().getIp()));
            return;
        }
        if (entity.isParallelByPoolId()) {
            String poolId = entity.getDeviceEntity().getPoolId();
            PoolUpgradeTask poolTask = this.poolTaskMap.getOrDefault(poolId, null);
            if (poolTask == null) {
                int nodeCount = this.poolNodeCountMap.get(poolId);
                poolTask = new PoolUpgradeTask(typeACountDownLatch, nodeCount);
                this.poolTaskMap.put(poolId, poolTask);
                this.completionService.submit(poolTask);
            }
            log.info(String.format(Locale.ENGLISH, "node to pool id: %s;entity ip: %s ;poolTask:%s", poolId, entity.getDeviceEntity().getIp(), poolTask));
            poolTask.addNode2RebootQueue(entity);
        } else if (entity.isUpgradeOneByOne()) {
            String poolId = "serviceBType";
            PoolUpgradeTask poolTask = this.poolTaskMap.getOrDefault(poolId, null);
            if (poolTask == null) {
                CountDownLatch countDownLatch = new CountDownLatch(this.nodeBCount);
                poolTask = new PoolUpgradeTask(countDownLatch, this.nodeBCount);
                this.poolTaskMap.put(poolId, poolTask);
                this.completionService.submit(poolTask);
            }
            log.info(String.format(Locale.ENGLISH, "node to pool id: %s;entity ip: %s ;poolTask:%s", poolId, entity.getDeviceEntity().getIp(), poolTask));
            poolTask.addNode2RebootQueue(entity);
        } else {
            DeviceUpgradeMainTask nodeTask = new DeviceUpgradeMainTask(entity, BundleUpgradeContext.getInstance().getMainDialog(), typeCCountDownLatch);
            Future<UpgradeDeviceEntity> resultFuture = this.completionService.submit(nodeTask);
            this.rebootedResultQueue.add(resultFuture);
            log.info(String.format(Locale.ENGLISH, "add device to reboot queue:%s", entity.getDeviceEntity().getIp()));
        }
    }

    private void checkIsAllDeviceReady2Upgrade(List<UpgradeDeviceEntity> deviceUpgradeInfos, BundleUpgradeMainDialog bundleUpgradeMainDialog) throws UMateException {
        if (deviceUpgradeInfos.isEmpty()) {
            throw new UMateException(RES.getString("you.must.select.at.least.one.device"));
        }
        List<UpgradeDeviceEntity> allNodes = bundleUpgradeMainDialog.getAllNodes();
        if (allNodes.stream().anyMatch(dev -> dev.isUpgrading())) {
            log.warn("Exist dev is upgrading.");
            throw new UMateException(RES.getString("wait.device.finished"));
        }
        if (deviceUpgradeInfos.stream().anyMatch(dev -> !dev.canUpgrade())) {
            log.warn("Exist dev is can not upgrade.");
            throw new UMateException(RES.getString("only.stg.set.and.failed.can.execute"));
        }
    }

    private void cleanUpUI(UpgradeDeviceEntity upgradeDeviceEntity, BundleUpgradeMainDialog bundleUpgradeMainDialog) {
        upgradeDeviceEntity.getExecuteInfo().getResults().clear();
        this.clearModuleUpgradeDetails(upgradeDeviceEntity);
        bundleUpgradeMainDialog.refreshTable(upgradeDeviceEntity);
    }

    private void clearModuleUpgradeDetails(UpgradeDeviceEntity upgradeDeviceEntity) {
        Map<UpgradeParamConstants.ModuleType, List<UpgradeDeviceEntity.FirmUpgradeResult>> upgradedDetails = upgradeDeviceEntity.getUpgradeDetails();
        if (upgradedDetails != null) {
            upgradedDetails.clear();
        }
    }
}

