/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.actions;

import com.huawei.bundleupgrade.entity.ComputeNodeUpgradeResult;
import com.huawei.bundleupgrade.service.ReportComputeNodeService;
import com.huawei.bundleupgrade.service.impl.ReportComputeNodeImpl;
import com.huawei.ism.tool.base.utils.DateUtil;
import com.huawei.ism.tool.base.utils.OSCmdUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.distributedfwupg.entity.FSDevNode;
import com.huawei.ism.tool.distributedfwupg.service.FsUpgradeService;
import com.huawei.ism.tool.distributedfwupg.ui.dialog.UpgradeComputeNodeDialog;
import com.huawei.ism.tool.distributedfwupg.utils.UpgradeContext;
import com.huawei.ism.tool.obase.filechooser.ToolFileChooser;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.uMate.common.utils.ResUtil;
import com.huawei.uMate.common.utils.SecurityUtils;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Date;
import java.util.List;
import javax.swing.JDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportComputeNodeAction
implements ActionListener {
    private static final Logger log = LoggerFactory.getLogger(ReportComputeNodeAction.class);
    private static final ResUtil RES = ResUtil.getInstance((String)"BundleUpgrade");
    private final UpgradeComputeNodeDialog dialog;
    private final ReportComputeNodeService<ComputeNodeUpgradeResult> reportComputeNode;

    public ReportComputeNodeAction(UpgradeComputeNodeDialog dialogLayout) {
        this.dialog = dialogLayout;
        this.reportComputeNode = new ReportComputeNodeImpl();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        log.info("click export upgrade result report button.");
        if (!this.canExportReport()) {
            return;
        }
        UpgradeContext.getInstance().setSceneCollectDir();
        String time = DateUtil.formatDate((Date)new Date(), (String)"yyyyMMddHHmmss");
        String saveFilePath = ToolFileChooser.getSaveFilePath((String)RES.getString("bundle.upgrade.main.btn.export.result"), (String)"zip", (Window)this.dialog, (String)("ComputeNodeUpgradeReport-" + time + ".zip"), (String)"BundleUpgradeResult");
        if (StringUtils.isNULLStr((String)saveFilePath)) {
            log.warn("the saveFilePath is null");
            return;
        }
        if (!SecurityUtils.isValidAndSafePath((String)saveFilePath)) {
            log.error(" {} is not valid and safe path", (Object)saveFilePath);
            return;
        }
        ComputeNodeUpgradeResult computeNodeUpgradeResult = FsUpgradeService.getComputeNodeUpgradeResult();
        computeNodeUpgradeResult.setNodeNumInfoToResult(this.dialog);
        if (!this.reportComputeNode.generateReport(saveFilePath, computeNodeUpgradeResult)) {
            DialogUtils.showInfoDialog((JDialog)this.dialog, (String)RES.getString("bundle.upgrade.main.btn.export.result.failed"));
            return;
        }
        this.showResultOnSuccess(saveFilePath);
    }

    private boolean canExportReport() {
        log.info("Check whether the report of the current task can be exported.");
        List<FSDevNode> toUpgradeDevs = this.dialog.getDialogLayout().getAllNodes();
        if (toUpgradeDevs.stream().anyMatch(FSDevNode::isRunning)) {
            DialogUtils.showInfoDialog((JDialog)this.dialog, (String)RES.getString("bundle.upgrade.task.running.export.tip"));
            log.info("no started device.");
            return false;
        }
        if (toUpgradeDevs.stream().noneMatch(FSDevNode::isFinished)) {
            DialogUtils.showInfoDialog((JDialog)this.dialog, (String)RES.getString("bundle.upgrade.task.no.done.export.tip"));
            log.info("no completed device.");
            return false;
        }
        return true;
    }

    private void showResultOnSuccess(String destPath) {
        log.info("report generate successfully! destPath:{}", (Object)destPath);
        WarningDialog wd = DialogUtils.showYesNoDialog((Window)this.dialog, (String)RES.getString("bundle.upgrade.task.export.complete.is.to.view.report"));
        if (wd.getValue() == 0) {
            OSCmdUtils.exeExportFile((String)new File(destPath).getParent());
        }
    }
}

