/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.constants;

import com.huawei.bundleupgrade.utils.SystemConfigUtil;
import com.huawei.uMate.common.utils.ResUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class UpgradeParamConstants {
    private static final String NOT_UPD_KEY = "report.result.result.not.upgrade";
    private static final String UPGRADING_KEY = "report.result.result.upgrading";
    private static final String WAIT_FOR_REBOOT = "report.result.result.wait.reboot";
    private static final String ABORT_FOR_REBOOT = "bundle.upgrade.main.table.status.ABORT_REBOOT";
    private static final String REBOOTING = "report.result.result.reboot";
    private static final String UPGRAD_SUCCESS_KEY = "report.result.result.success";
    private static final String UPGRAD_PART_SUCCESS_KEY = "report.result.result.part.success";
    private static final String UPGRAD_FAILED_KEY = "report.result.result.failed";
    private static final ResUtil RES = ResUtil.getInstance((String)"BundleUpgrade");

    public static List<String> versionDiffUpgradeModules() {
        return Arrays.asList(SystemConfigUtil.getSysConfig("different.version.allow.upgrade.module").split(","));
    }

    public static enum PowerStatus {
        POWER_IS_ON,
        POWER_IS_OFF;

    }

    public static enum SNMPPowerStatusOID {
        POWER_ON_OID("2"),
        POWER_RESET_OID("3"),
        POWER_OFF_THEN_ON_OID("4"),
        FORCE_POWER_OFF_OID("5"),
        IBMC_RESTART_OID("1.3.6.1.4.1.2011.2.235.1.1.1.19.0"),
        POWER_OFF_OID("1"),
        POWER_STATE_OID("1.3.6.1.4.1.2011.2.235.1.1.1.12.0");

        private String oid;

        private SNMPPowerStatusOID(String oid) {
            this.oid = oid;
        }

        public String toString() {
            return this.oid;
        }

        public String getCommand() {
            return this.oid;
        }
    }

    public static enum IPMIPowerOptType {
        IBMC_RESTART("raw 0x06 0x02"),
        POWER_STATUS("power status"),
        POWER_ON("power on"),
        POWER_OFF("power soft"),
        POWER_RESET("power reset"),
        POWER_OFF_THEN_ON("power cycle"),
        FORCED_POWER_OFF("power off");

        private String command;

        private IPMIPowerOptType(String cmd) {
            this.command = cmd;
        }

        public String getCommand() {
            return this.command;
        }

        public String toString() {
            return this.name();
        }
    }

    public static enum ModuleType {
        iBMC("iBMC"),
        BIOS("BIOS"),
        CPLD_MAIN("CPLD_MAIN"),
        CPLD("CPLD"),
        RAID("RAID"),
        FC("FC"),
        IB("IB"),
        NIC("NIC"),
        CNA("CNA"),
        HBA("HBA"),
        FPGA("FPGA"),
        SSD("SSD"),
        GPU("GPU"),
        NVDIMM("NVDIMM"),
        HDD("HDD"),
        PSU("PSU"),
        CDR("CDR"),
        ETH_CDR("eth_cdr"),
        BBU("bbu"),
        Retimer("Retimer"),
        PCIE_RETIMER("pcie_retimer"),
        PCIE_RETIMER_TI_RETIMER("pcie_retimer(Retimer-5)"),
        MCU("MCU"),
        FAN("fan"),
        SAS("SAS"),
        SATA("SATA"),
        BASE_KNL("BASE_KNL"),
        RDMA("RDMA"),
        RDMA_PACIFIC("RDMA_PACIFIC"),
        RDMA_ATLANTIC("RDMA_ATLANTIC"),
        NET("NET"),
        RDMA_ARM("RDMA_ARM"),
        RDMA_X86("RDMA_X86"),
        SES("SES"),
        DISK_FW("DISK_FW"),
        ES3000("ES3000"),
        SSD_SP("SSD_SP"),
        GLOUN("GLOUN"),
        DMI_KNL("DMI_KNL"),
        RAID_DRIVER("RAID_DRIVER"),
        RAID_FIRMWARE("RAID_FIRMWARE"),
        SP("SP"),
        NVME("NVME"),
        HIRAID("HIRAID"),
        HIRAID_DRIVER("HIRAID_DRIVER"),
        HIRAID_FIRMWARE("HIRAID_FIRMWARE"),
        RAID_CONFIG("RAID_CONFIG"),
        DRIVE("Drive"),
        DFS("Dfs"),
        NIC_ARM("NIC_ARM"),
        NIC_X86("NIC_X86"),
        VRD("VRD"),
        UNKNOWN("Unknown");

        private String module;

        private ModuleType(String module) {
            this.module = module;
        }

        public static ModuleType parseModule(String moduleStr) {
            return Arrays.stream(ModuleType.values()).filter(type -> moduleStr.equalsIgnoreCase(type.getModule())).findFirst().orElse(UNKNOWN);
        }

        public String toString() {
            if (ModuleType.getPanGeaInBandModules().contains((Object)this)) {
                return "module.pangea.intra.band." + this.module;
            }
            return "module.out.band." + this.module;
        }

        public String getModule() {
            return this.module;
        }

        public static List<ModuleType> getInBandModules() {
            return Arrays.asList(RAID, FC, IB, NIC, CNA, HBA, FPGA, SSD, GPU, NVDIMM, HDD);
        }

        public static List<ModuleType> getPcieModule() {
            return Arrays.asList(RAID, FC, IB, NIC, CNA, HBA, FPGA, SSD, GPU, NVDIMM, HDD, SSD_SP);
        }

        public static List<ModuleType> getVesionValid() {
            return Collections.singletonList(RAID_CONFIG);
        }

        public static List<ModuleType> getDiskModule() {
            return Arrays.asList(DRIVE, DFS);
        }

        public static List<ModuleType> getVersionByCustomMethod() {
            return Arrays.asList(DISK_FW, ES3000, DRIVE, DFS);
        }

        public static List<ModuleType> getAllDiskFw() {
            return Arrays.asList(DISK_FW, ES3000, DRIVE, DFS);
        }

        public static List<ModuleType> getVersionByBmc() {
            return Arrays.asList(PCIE_RETIMER, PCIE_RETIMER_TI_RETIMER, BIOS, iBMC, CDR, Retimer, MCU, FAN, ETH_CDR, BBU, CPLD, CPLD_MAIN, PSU, VRD);
        }

        public static List<ModuleType> getSpAgentModel() {
            return Arrays.asList(HDD, SSD_SP);
        }

        public static List<ModuleType> getOutBandModules() {
            return Arrays.asList(iBMC, BIOS, CPLD, CPLD_MAIN, PSU, CDR, Retimer, MCU, FAN, ETH_CDR, BBU, PCIE_RETIMER, PCIE_RETIMER_TI_RETIMER, VRD);
        }

        public static List<ModuleType> getPanGeaInBandModules() {
            return Arrays.asList(BASE_KNL, SATA, SAS, SES, RDMA_PACIFIC, RDMA_ATLANTIC, NET, RDMA_ARM, RDMA_X86, GLOUN, DMI_KNL, RAID_DRIVER, RAID_FIRMWARE, NVME, HIRAID_DRIVER, HIRAID_FIRMWARE, DRIVE, NIC_ARM, NIC_X86, DFS, RAID_CONFIG);
        }

        public static List<ModuleType> rebootBySshModules() {
            return Arrays.asList(RDMA, RDMA_ARM, RDMA_X86, NET);
        }

        public static List<ModuleType> getFsOnlineModules() {
            return new ArrayList<ModuleType>(Arrays.asList(iBMC, CPLD, CPLD_MAIN, SP));
        }

        public static List<ModuleType> getDiskModules() {
            return Arrays.asList(DISK_FW, ES3000, SSD_SP);
        }

        public static List<ModuleType> getOverridesCompareModule() {
            ArrayList<ModuleType> moduleTypes = new ArrayList<ModuleType>();
            moduleTypes.addAll(ModuleType.getOutBandModules());
            moduleTypes.addAll(ModuleType.getDiskModules());
            moduleTypes.addAll(ModuleType.getDiskModule());
            moduleTypes.add(SP);
            return moduleTypes;
        }

        public static List<ModuleType> noNeedRebootModules() {
            return new ArrayList<ModuleType>(Arrays.asList(iBMC, SSD, FAN, BBU, PSU, DISK_FW, ES3000, SES, DRIVE, DFS));
        }

        public static List<ModuleType> onlinePanGeaModules() {
            return Arrays.asList(SES);
        }
    }

    public static enum FirmUpgradeStatus {
        NOT_START("notStart"),
        SUCCESS("success"),
        FAILED("failed");

        private String stat;

        private FirmUpgradeStatus(String status) {
            this.stat = status;
        }

        public String toString() {
            return "firmware.upgrade.status." + this.stat;
        }
    }

    public static enum PCIeCardUpgradeMethod {
        ISO_ATTACH("isoAttach"),
        SMART_PROVISIONING("smartProvisioning");

        private String method;

        private PCIeCardUpgradeMethod(String method) {
            this.method = method;
        }

        public String toString() {
            return "pcie.card.upgrade.method." + this.method;
        }
    }

    public static enum SubProcessExecutionResult {
        PASS,
        PARITIAL_SUCC,
        FAILED,
        NOT_INVOLVED,
        IGNORE;

    }

    public static enum ScriptResultStatus {
        PASS,
        WARNING,
        FAILED;

    }

    public static enum UpgradeExpectEffect {
        UPGRADE("upgrade"),
        DEGRADATION("degradation"),
        COVER("cover"),
        NON_EXECUTION("non.execution");

        private String expectEffect;

        private UpgradeExpectEffect(String expect) {
            this.expectEffect = expect;
        }

        public String toString() {
            return "firmware.upgrade.strategy.expect." + this.expectEffect;
        }
    }

    public static enum FirmwareUpgradeStrategy {
        MANDATORY_UPGRADE("mandatory"),
        LOWER_VERSION_UPGRADE("lowerVersion");

        private String caseName;

        private FirmwareUpgradeStrategy(String method) {
            this.caseName = method;
        }

        public String toString() {
            return "firmware.upgrade.strategy." + this.caseName;
        }
    }

    public static enum UpgradeStatus {
        ASSOCIATED("report.result.result.not.upgrade"),
        WAITING("report.result.result.upgrading"),
        WAIT_REBOOT("report.result.result.wait.reboot"),
        REBOOT("report.result.result.reboot"),
        ABORT_REBOOT("bundle.upgrade.main.table.status.ABORT_REBOOT"),
        RUNNING("report.result.result.upgrading"),
        COMPLETED("report.result.result.success"),
        FAILED("report.result.result.failed"),
        NOTASSOCIATED("report.result.result.not.upgrade"),
        NOSUPPORTED("report.result.result.not.upgrade"),
        UNKNOWN("report.result.result.not.upgrade"),
        QUERYDEVINFO("report.result.result.not.upgrade"),
        SPCHECKING("report.result.result.not.upgrade"),
        UPGRADE_PARTIAL_SUCCESS("report.result.result.part.success"),
        NOT_INVOLVED("report.result.result.not.upgrade"),
        NOT_EXECUTED("report.result.result.not.upgrade");

        private String upgradeStatusMsgKey;

        private UpgradeStatus(String statusMsgKey) {
            this.upgradeStatusMsgKey = statusMsgKey;
        }

        public String getUpgradeStatusMsgKey() {
            return this.upgradeStatusMsgKey;
        }

        public static List<UpgradeStatus> notSupportSetStrategyUpgradeStatus() {
            return Arrays.asList(QUERYDEVINFO, NOSUPPORTED, UNKNOWN, RUNNING, WAITING, WAIT_REBOOT, REBOOT);
        }

        public static List<UpgradeStatus> notUpgradeStatus() {
            return Arrays.asList(QUERYDEVINFO, NOSUPPORTED, UNKNOWN, RUNNING, WAITING, NOTASSOCIATED, ASSOCIATED, NOT_EXECUTED);
        }

        public static List<UpgradeStatus> notSupportRepeatGetDevInfoStatus() {
            return Arrays.asList(QUERYDEVINFO, RUNNING, WAITING, ASSOCIATED, WAIT_REBOOT, REBOOT);
        }

        public static boolean isHaveUpgrade(UpgradeStatus status) {
            return status == COMPLETED || status == UPGRADE_PARTIAL_SUCCESS || status == FAILED || status == NOT_EXECUTED;
        }

        public String toString() {
            return RES.getString("bundle.upgrade.main.table.status." + this.name());
        }
    }

    public static enum FirmwareDownloadStatus {
        NOT_DOWNLOADED,
        DOWNLOADING,
        FINISHED,
        FAILED;

    }

    public static enum PackageImportMethod {
        ONLINE("online"),
        OFFLINE("offline");

        private String poi;

        private PackageImportMethod(String id) {
            this.poi = id;
        }

        public String toString() {
            return RES.getString("package.import.method." + this.poi);
        }
    }
}

