/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.entity;

import com.huawei.bundleupgrade.entity.ControllerMark;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum AssociationOfControllerAndRetimer {
    CONTROLLER_A(ControllerMark.MARK_OF_CONTROLLER_A, Arrays.asList("EXP1", "EXP3", "EXP4", "EXP6")),
    CONTROLLER_B(ControllerMark.MARK_OF_CONTROLLER_B, Arrays.asList("EXP0", "EXP2", "EXP5", "EXP7")),
    MAINBOARD(ControllerMark.MAINBOARD, Collections.singletonList("Mainboard")),
    UNKNOWN(ControllerMark.MARK_UNKNOWN, Collections.singletonList("--"));

    private final ControllerMark controllerMark;
    private final List<String> retimerPositions;

    public static AssociationOfControllerAndRetimer getAssociation(String controllerMarkFromChassis) {
        return Arrays.stream(AssociationOfControllerAndRetimer.values()).filter(association -> association.getControllerMark().getMark().equals(controllerMarkFromChassis)).findFirst().orElse(UNKNOWN);
    }

    public static boolean isAssociatedWith(String expRetimerId, String mark) {
        return AssociationOfControllerAndRetimer.getAssociation(mark).getRetimerPositions().stream().anyMatch(expRetimerId::contains);
    }

    public ControllerMark getControllerMark() {
        return this.controllerMark;
    }

    public List<String> getRetimerPositions() {
        return this.retimerPositions;
    }

    private AssociationOfControllerAndRetimer(ControllerMark controllerMark, List<String> retimerPositions) {
        this.controllerMark = controllerMark;
        this.retimerPositions = retimerPositions;
    }
}

