/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.entity;

import com.huawei.ism.tool.base.utils.StringUtils;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum BlackDiskModelEnum {
    DISK_MODEL(Arrays.asList("HWE62P4415TL002N", "HSSD-D7224DL15TN", "HWE62SS37T6L002N", "HSSD-D7223AL7T6N", "HSSD-D7223AL7T6S", "HWE62SS37T6L002S", "HSSD-D7223AL7T6E", "HWE62P446T4M002N", "HWE62P447T6L002N"), Arrays.asList("7306", "7310", "8217", "8219", "8305", "8306", "8308", "8310", "8312"));

    private static final Logger log;
    private final List<String> diskModels;
    private final List<String> diskFwVersions;

    public static boolean isBlackModel(String model, String version) {
        if (StringUtils.isNULLStr((String)model) || StringUtils.isNULLStr((String)version)) {
            log.warn("current model or version information is invalid. Failed to determine whether it is can upgrade");
            return false;
        }
        if (DISK_MODEL.getDiskModels().stream().anyMatch(model::equalsIgnoreCase)) {
            if (DISK_MODEL.getDiskFwVersions().stream().anyMatch(version::equalsIgnoreCase)) {
                log.info("current disk model {} not support upgrade to version {}", (Object)model, (Object)version);
                return true;
            }
        }
        return false;
    }

    private BlackDiskModelEnum(List<String> diskModels, List<String> diskFwVersions) {
        this.diskModels = diskModels;
        this.diskFwVersions = diskFwVersions;
    }

    public List<String> getDiskModels() {
        return this.diskModels;
    }

    public List<String> getDiskFwVersions() {
        return this.diskFwVersions;
    }

    static {
        log = LoggerFactory.getLogger(BlackDiskModelEnum.class);
    }
}

