/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.entity;

import com.huawei.ism.tool.distributedfwupg.entity.FSDevNode;
import com.huawei.ism.tool.distributedfwupg.service.FsUpgradeService;
import com.huawei.ism.tool.distributedfwupg.ui.dialog.UpgradeComputeNodeDialog;
import com.huawei.ism.tool.distributedfwupg.utils.CommonUtils;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.uMate.common.utils.ResUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class ComputeNodeUpgradeResult {
    private static final ResUtil RES = ResUtil.getInstance((String)"BundleUpgrade");
    private String computeNodeType = "--";
    private String upgradeMode = "--";
    private Date startTime;
    private Date endTime;
    private String upgradeStatistics = "";
    private List<FSDevNode> fsDevNodes = new ArrayList<FSDevNode>();

    public String getStartTimeString() {
        if (Objects.isNull(this.startTime)) {
            return "--";
        }
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(this.startTime);
    }

    public String getEndTimeString() {
        if (Objects.isNull(this.endTime)) {
            return "--";
        }
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(this.endTime);
    }

    public String getExecuteTimeString() {
        if (Objects.isNull(this.startTime) || Objects.isNull(this.endTime)) {
            return "--";
        }
        return StringUtils.millls2FormatString((long)(this.endTime.getTime() - this.startTime.getTime()));
    }

    public void setNodeNumInfoToResult(UpgradeComputeNodeDialog dialog) {
        List<FSDevNode> allNodes = dialog.getDialogLayout().getAllNodes();
        String rollbackInfo = "";
        if (dialog.getDialogLayout().getRollbackCom().isVisible()) {
            rollbackInfo = String.join((CharSequence)"  ", this.getRollBackSuccessShow(allNodes), this.getRollBackFailedShow(allNodes));
        }
        this.upgradeStatistics = String.join((CharSequence)"  ", this.getTotalNodShow(allNodes), this.getPullPkgSuccessShow(dialog), this.getPullPkgFaileShow(allNodes), this.getUpgradeSuccessShow(allNodes), this.getUpgradeFailedShow(allNodes), rollbackInfo);
    }

    private String getRollBackFailedShow(List<FSDevNode> allNodes) {
        return RES.getString("upgrade.compute.rollback.failed.desc").concat(String.valueOf(allNodes.stream().filter(FSDevNode::isRollbackFailed).count()));
    }

    private String getRollBackSuccessShow(List<FSDevNode> allNodes) {
        return RES.getString("upgrade.compute.rollback.success.desc").concat(String.valueOf(allNodes.stream().filter(FSDevNode::isRollbackSucceeded).count()));
    }

    private String getUpgradeFailedShow(List<FSDevNode> allNodes) {
        return RES.getString("upgrade.compute.failedNode.desc").concat(String.valueOf(allNodes.stream().filter(node -> node.isUpgradeFailed() || node.isRollbackStatus()).count()));
    }

    private String getUpgradeSuccessShow(List<FSDevNode> allNodes) {
        return RES.getString("upgrade.compute.successNode.desc").concat(String.valueOf(allNodes.stream().filter(node -> node.getUpgradeStatus().isSuccessStatus()).count()));
    }

    private String getPullPkgFaileShow(List<FSDevNode> allNodes) {
        return RES.getString("upgrade.compute.pull_pkg_failed_node.desc").concat(String.valueOf(allNodes.stream().filter(fsDevNode -> fsDevNode.getUpgradeStatus().isUpgradePrepareFailedStatus()).count()));
    }

    private String getPullPkgSuccessShow(UpgradeComputeNodeDialog dialog) {
        return RES.getString("upgrade.compute.pull_pkg_success_node.desc").concat(String.valueOf(dialog.getDialogLayout().getPullPkgSuccessNodeNum().getText()));
    }

    private String getTotalNodShow(List<FSDevNode> allNodes) {
        return RES.getString("upgrade.compute.allNode.desc").concat(String.valueOf(allNodes.size()));
    }

    public void initComputeNodeResult(UpgradeComputeNodeDialog dialog, String upgradeMode) {
        if (Objects.nonNull(this.getStartTime())) {
            return;
        }
        FsUpgradeService.getComputeNodeUpgradeResult().setStartTime(new Date());
        List<FSDevNode> allNodes = dialog.getDialogLayout().getAllNodes();
        allNodes.forEach(CommonUtils::initNodeResult);
        FsUpgradeService.initUpgradeResult(allNodes, upgradeMode);
    }

    public void setComputeNodeType(String computeNodeType) {
        this.computeNodeType = computeNodeType;
    }

    public void setUpgradeMode(String upgradeMode) {
        this.upgradeMode = upgradeMode;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public void setUpgradeStatistics(String upgradeStatistics) {
        this.upgradeStatistics = upgradeStatistics;
    }

    public void setFsDevNodes(List<FSDevNode> fsDevNodes) {
        this.fsDevNodes = fsDevNodes;
    }

    public String getComputeNodeType() {
        return this.computeNodeType;
    }

    public String getUpgradeMode() {
        return this.upgradeMode;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public String getUpgradeStatistics() {
        return this.upgradeStatistics;
    }

    public List<FSDevNode> getFsDevNodes() {
        return this.fsDevNodes;
    }
}

