/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.entity;

import com.huawei.bundleupgrade.constants.UpgradeParamConstants;
import com.huawei.bundleupgrade.entity.AccountEntity;
import com.huawei.bundleupgrade.entity.BaseModel;
import com.huawei.bundleupgrade.entity.BmcActiveModeEnum;
import com.huawei.bundleupgrade.entity.DiskVersionEntity;
import com.huawei.bundleupgrade.entity.ExpRetimer;
import com.huawei.bundleupgrade.entity.NodeServiceInfo;
import com.huawei.bundleupgrade.entity.NodeUpgradePriorityEnums;
import com.huawei.bundleupgrade.entity.PcieCardEntity;
import com.huawei.bundleupgrade.entity.RetimerTypeEnum;
import com.huawei.bundleupgrade.utils.UpgradeScenarioUtil;
import com.huawei.ism.tool.devicemanager.entity.ProductUniqueIdConfig;
import com.huawei.ism.tool.obase.connection.MultiRouteNode;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.uMate.common.SystemConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class DeviceEntity {
    public static final String PACIFIC_UID = "0x020d1700";
    public static final String ATLANTIC_MAIN = "0x020d1b00";
    public static final String VF_MARK = "1";
    private static final String ATLANTIC_SMM = "0x020d3000";
    private static final String SN_SEVER_UID = "0x020dfa00";
    private static final String NEW_SN_SEVER_UID = "0x020DFF00";
    private static final String NEW_ATLANTIC_UID = "0x020dc300";
    private static final List<String> PACIFIC_ATLANTIC = Collections.unmodifiableList(Arrays.asList("0x020d1700", "0x020d1b00", "0x020d3000", "0x020dc300"));
    private static final List<String> SUPPORT_DISK_FW_UID = Collections.unmodifiableList(Arrays.asList("0x020d1700", "0x020d1b00", "0x020dc300"));
    private String ip;
    private List<String> managementIps;
    private List<DiskVersionEntity> m2DiskVersions = new ArrayList<DiskVersionEntity>();
    private String type;
    private String productType;
    private String productName;
    private String serialNumber;
    private String activeCPLDVersion;
    private String biosVersion;
    private String masterBMC;
    private BmcActiveModeEnum bmcActiveMode;
    private String originalActiveCPLDVersion;
    private String originalBiosVersion;
    private String originalMasterBMC;
    private String slaveBMC;
    private String spVersion;
    private String cdrVersion;
    private String ethCdrVersion;
    private String mcuVersion;
    private String fanVersion;
    private String iobBiosVersion;
    private String vrdVersion;
    private String retimerVersion;
    private List<ExpRetimer> expRetimers = new ArrayList<ExpRetimer>();
    private List<String> sriovDiskEsnInOtherNode = new ArrayList<String>();
    private String controllerMark;
    private String sshPort;
    private String httpsPort;
    private AccountEntity account;
    private Map<String, List<PcieCardEntity>> pcieCardsInfos = new HashMap<String, List<PcieCardEntity>>();
    private String productUniqueId;
    private String processorArchitecture;
    private List<PsuModel> psuModels = new LinkedList<PsuModel>();
    private List<BbuModel> bbuModels = new LinkedList<BbuModel>();
    private List<CpldModel> cpldModels = new LinkedList<CpldModel>();
    private WatchDogModel watchDogModel = new WatchDogModel();
    private Map<String, String> panGeaInBandModuleVersion = new ConcurrentHashMap<String, String>();
    private String driveTarVersion = "NULL";
    private NodeServiceInfo nodeServiceInfo;
    private List<DiskModel> diskInfo = new ArrayList<DiskModel>();
    private boolean selected;
    private String chassisId = "--";
    private List<String> storageBackEndPortList = new ArrayList<String>();
    private List<String> storageFrontEndPortList = new ArrayList<String>();
    private boolean supportRedfish = true;
    private ClusterNode.BaseBoardType baseBoardType;
    private boolean isSwitchOverSuccess;
    private boolean isSriovDevice;
    private String cpuArchitecture = "";
    private String kernelVersion = "";
    private List<MultiRouteNode> sshForwardList;

    public void addM2DiskVersion(DiskVersionEntity diskVersionEntity) {
        this.m2DiskVersions.add(diskVersionEntity);
    }

    public String getMinRetimerVersion(UpgradeParamConstants.ModuleType moduleType) {
        return this.expRetimers.stream().filter(retimer -> retimer.getRetimerTypeEnum().getModuleType().equals((Object)moduleType)).map(ExpRetimer::getExpReTimerVersion).filter(version -> version.matches("\\d+(\\.\\d+){0,3}")).reduce(UpgradeScenarioUtil::getMinVersion).orElse("--");
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getProductType() {
        return this.productType;
    }

    public void setProductType(String productType) {
        this.productType = productType;
    }

    public String getProductTypeShow() {
        if (UpgradeScenarioUtil.isYinglong() && this.isDirectPlane()) {
            return this.productUniqueId;
        }
        return this.productType + "(" + this.productUniqueId + ")";
    }

    public String getProductTypeForReport() {
        if (this.isDirectPlane()) {
            return "Data Cluster Module";
        }
        return this.productType;
    }

    public String getProductName() {
        return this.productName == null ? "" : this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getSerialNumber() {
        return this.serialNumber == null ? "" : this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public String getPoolId() {
        return String.join((CharSequence)"_", this.getStoragePoolId(), this.getDiskPoolId());
    }

    public String getStoragePoolId() {
        if (Objects.isNull(this.nodeServiceInfo.getStoragePoolId())) {
            return "";
        }
        return this.nodeServiceInfo.getStoragePoolId();
    }

    public boolean isSupportDiskPool() {
        return this.nodeServiceInfo.isSupportDiskPool();
    }

    public String getDiskPoolId() {
        if (Objects.isNull(this.nodeServiceInfo.getDiskPoolId())) {
            return "";
        }
        return this.nodeServiceInfo.getDiskPoolId();
    }

    public NodeUpgradePriorityEnums getServiceType() {
        return this.nodeServiceInfo.getNodeUpgradePriority();
    }

    public String getActiveCPLDVersion() {
        return this.activeCPLDVersion == null ? "" : this.activeCPLDVersion;
    }

    public void setActiveCPLDVersion(String activeCPLDVersion) {
        this.activeCPLDVersion = activeCPLDVersion;
    }

    public String getBiosVersion() {
        return this.biosVersion == null ? "" : this.biosVersion;
    }

    public void setBiosVersion(String biosVersion) {
        this.biosVersion = biosVersion;
    }

    public String getMasterBMC() {
        return this.masterBMC == null ? "" : this.masterBMC;
    }

    public void setMasterBMC(String masterBMC) {
        this.masterBMC = masterBMC;
    }

    public String getSlaveBMC() {
        return this.slaveBMC;
    }

    public void setSlaveBMC(String slaveBMC) {
        this.slaveBMC = slaveBMC;
    }

    public String getSpVersion() {
        return this.spVersion;
    }

    public void setSpVersion(String spVersion) {
        this.spVersion = spVersion;
    }

    public String getSshPort() {
        return this.sshPort;
    }

    public void setSshPort(String sshPort) {
        this.sshPort = sshPort;
    }

    public String getHttpsPort() {
        return this.httpsPort;
    }

    public void setHttpsPort(String httpsPort) {
        this.httpsPort = httpsPort;
    }

    public String getProductUniqueId() {
        return this.productUniqueId;
    }

    public void setProductUniqueId(String productUniqueId) {
        this.productUniqueId = productUniqueId;
    }

    public String getProcessorArchitecture() {
        return this.processorArchitecture;
    }

    public void setProcessorArchitecture(String processorArchitecture) {
        this.processorArchitecture = processorArchitecture;
    }

    public AccountEntity getAccount() {
        return this.account;
    }

    public void setAccount(AccountEntity account) {
        this.account = account;
    }

    public Map<String, List<PcieCardEntity>> getPcieCardsInfos() {
        return this.pcieCardsInfos;
    }

    public void setPcieCardsInfos(Map<String, List<PcieCardEntity>> pcieCardsInfos) {
        this.pcieCardsInfos = pcieCardsInfos;
    }

    public List<PsuModel> getPsuModels() {
        return this.psuModels;
    }

    public void setPsuModels(List<PsuModel> psuModels) {
        this.psuModels = psuModels;
    }

    public List<CpldModel> getCpldModels() {
        return this.cpldModels;
    }

    public void setCpldModels(List<CpldModel> cpldModels) {
        this.cpldModels = cpldModels;
    }

    public WatchDogModel getWatchDogModel() {
        return this.watchDogModel;
    }

    public void setWatchDogModel(WatchDogModel watchDogModel) {
        this.watchDogModel = watchDogModel;
    }

    public void setOriginalActiveCPLDVersion(String originalActiveCPLDVersion) {
        this.originalActiveCPLDVersion = originalActiveCPLDVersion;
    }

    public void setOriginalBiosVersion(String originalBiosVersion) {
        this.originalBiosVersion = originalBiosVersion;
    }

    public void setOriginalMasterBMC(String originalMasterBMC) {
        this.originalMasterBMC = originalMasterBMC;
    }

    public String getOriginalActiveCPLDVersion() {
        return this.originalActiveCPLDVersion == null ? "" : this.originalActiveCPLDVersion;
    }

    public String getOriginalBiosVersion() {
        return this.originalBiosVersion == null ? "" : this.originalBiosVersion;
    }

    public String getOriginalMasterBMC() {
        return this.originalMasterBMC == null ? "" : this.originalMasterBMC;
    }

    public String getCdrVersion() {
        return this.cdrVersion == null ? "" : this.cdrVersion;
    }

    public void setCdrVersion(String cdrVersion) {
        this.cdrVersion = cdrVersion;
    }

    public String getRetimerVersion() {
        return this.retimerVersion == null ? "" : this.retimerVersion;
    }

    public void setRetimerVersion(String retimerVersion) {
        this.retimerVersion = retimerVersion;
    }

    public void setNodeServiceInfo(NodeServiceInfo nodeServiceInfo) {
        this.nodeServiceInfo = nodeServiceInfo;
    }

    public NodeServiceInfo getNodeServiceInfo() {
        return this.nodeServiceInfo;
    }

    public int getSshPortInt() {
        try {
            return Integer.parseInt(this.sshPort);
        }
        catch (NumberFormatException e) {
            return 22;
        }
    }

    public Map<String, String> getPanGeaInBandModuleVersion() {
        return this.panGeaInBandModuleVersion;
    }

    public String getEthCdrVersion() {
        return this.ethCdrVersion;
    }

    public void setEthCdrVersion(String ethCdrVersion) {
        this.ethCdrVersion = ethCdrVersion;
    }

    public String getMcuVersion() {
        return this.mcuVersion;
    }

    public void setMcuVersion(String mcuVersion) {
        this.mcuVersion = mcuVersion;
    }

    public static List<String> getSupportDiskFwServerUid() {
        return SUPPORT_DISK_FW_UID;
    }

    public boolean isTwoOceans() {
        return PACIFIC_ATLANTIC.contains(this.productUniqueId.toLowerCase(Locale.ENGLISH));
    }

    public boolean isEastSea() {
        return ProductUniqueIdConfig.INS.getPlatformTypeByUid(this.productUniqueId).equals((Object)ProductUniqueIdConfig.HardwarePlatform.EAST_SEA);
    }

    public boolean isSpecificDevice() {
        return this.isTwoOceans() || this.isEastSea() || this.isSnService();
    }

    public boolean isSupportSp() {
        return !this.isTwoOceans() && !this.isTaiShanV1() && !this.isEastSea() && !this.isSnService();
    }

    private boolean isTaiShanV1() {
        return ProductUniqueIdConfig.INS.getPlatformTypeByUid(this.productUniqueId).equals((Object)ProductUniqueIdConfig.HardwarePlatform.TAISHAN_V1);
    }

    public boolean isEastSeaDoubleServer() {
        return ClusterNode.BaseBoardType.DH_DOUBLE_SERVER_DOUBLE_PROCESSOR.equals((Object)this.baseBoardType) || ClusterNode.BaseBoardType.DH_DOUBLE_SERVER_SINGLE_PROCESSOR.equals((Object)this.baseBoardType) || ClusterNode.BaseBoardType.DH_DOUBLE_SERVER_DOUBLE_PROCESSOR_8054.equals((Object)this.baseBoardType);
    }

    public boolean isDirectPlane() {
        return ATLANTIC_SMM.equalsIgnoreCase(this.productUniqueId);
    }

    public boolean isSnService() {
        return SN_SEVER_UID.equalsIgnoreCase(this.productUniqueId) || NEW_SN_SEVER_UID.equalsIgnoreCase(this.productUniqueId);
    }

    public boolean isPacific() {
        return PACIFIC_UID.contains(this.productUniqueId.toLowerCase(Locale.ENGLISH));
    }

    public String getFanVersion() {
        return this.fanVersion;
    }

    public void setFanVersion(String fanVersion) {
        this.fanVersion = fanVersion;
    }

    public List<BbuModel> getBbuModels() {
        return this.bbuModels;
    }

    public String getBbuModel() {
        if (this.bbuModels == null || this.bbuModels.isEmpty()) {
            return "--";
        }
        return this.bbuModels.stream().map(BbuModel::toString).collect(Collectors.joining(";"));
    }

    public String getExpRetimerByType(RetimerTypeEnum retimerType) {
        if (CollectionUtil.isEmpty(this.expRetimers)) {
            return "--";
        }
        String tiRetimerVersion = this.expRetimers.stream().filter(expRetimer -> Objects.equals((Object)retimerType, (Object)expRetimer.getRetimerTypeEnum())).map(ExpRetimer::toString).collect(Collectors.joining(";"));
        return StringUtils.isNotEmpty((CharSequence)tiRetimerVersion) ? tiRetimerVersion : "--";
    }

    public String getControllerMark() {
        if (StringUtils.isEmpty((CharSequence)this.controllerMark)) {
            return "--";
        }
        return this.controllerMark;
    }

    public void setBbuModels(List<BbuModel> bbuModels) {
        this.bbuModels = bbuModels;
    }

    public String getIobBiosVersion() {
        return this.iobBiosVersion;
    }

    public void setIobBiosVersion(String iobBiosVersion) {
        this.iobBiosVersion = iobBiosVersion;
    }

    public String getUidOrType() {
        return StringUtils.isEmpty((CharSequence)this.productUniqueId) ? this.productType : this.productUniqueId;
    }

    public List<DiskModel> getDiskInfo() {
        return this.diskInfo;
    }

    public void setDiskInfo(List<DiskModel> diskInfo) {
        this.diskInfo = diskInfo;
    }

    public List<String> getBackEndPortAndFrontEndPortList() {
        LinkedList<String> list = new LinkedList<String>();
        list.addAll(this.storageBackEndPortList);
        list.addAll(this.storageFrontEndPortList);
        return list;
    }

    public void setManagementIps(List<String> managementIps) {
        this.managementIps = managementIps;
    }

    public List<String> getManagementIps() {
        return this.managementIps;
    }

    public List<DiskVersionEntity> getM2DiskVersions() {
        return this.m2DiskVersions;
    }

    public BmcActiveModeEnum getBmcActiveMode() {
        return this.bmcActiveMode;
    }

    public void setBmcActiveMode(BmcActiveModeEnum bmcActiveMode) {
        this.bmcActiveMode = bmcActiveMode;
    }

    public String getVrdVersion() {
        return this.vrdVersion;
    }

    public void setVrdVersion(String vrdVersion) {
        this.vrdVersion = vrdVersion;
    }

    public List<ExpRetimer> getExpRetimers() {
        return this.expRetimers;
    }

    public void setExpRetimers(List<ExpRetimer> expRetimers) {
        this.expRetimers = expRetimers;
    }

    public List<String> getSriovDiskEsnInOtherNode() {
        return this.sriovDiskEsnInOtherNode;
    }

    public void setControllerMark(String controllerMark) {
        this.controllerMark = controllerMark;
    }

    public String getDriveTarVersion() {
        return this.driveTarVersion;
    }

    public void setDriveTarVersion(String driveTarVersion) {
        this.driveTarVersion = driveTarVersion;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public void setChassisId(String chassisId) {
        this.chassisId = chassisId;
    }

    public String getChassisId() {
        return this.chassisId;
    }

    public List<String> getStorageBackEndPortList() {
        return this.storageBackEndPortList;
    }

    public void setStorageBackEndPortList(List<String> storageBackEndPortList) {
        this.storageBackEndPortList = storageBackEndPortList;
    }

    public List<String> getStorageFrontEndPortList() {
        return this.storageFrontEndPortList;
    }

    public void setStorageFrontEndPortList(List<String> storageFrontEndPortList) {
        this.storageFrontEndPortList = storageFrontEndPortList;
    }

    public boolean isSupportRedfish() {
        return this.supportRedfish;
    }

    public void setSupportRedfish(boolean supportRedfish) {
        this.supportRedfish = supportRedfish;
    }

    public void setBaseBoardType(ClusterNode.BaseBoardType baseBoardType) {
        this.baseBoardType = baseBoardType;
    }

    public void setSwitchOverSuccess(boolean isSwitchOverSuccess) {
        this.isSwitchOverSuccess = isSwitchOverSuccess;
    }

    public boolean isSwitchOverSuccess() {
        return this.isSwitchOverSuccess;
    }

    public boolean isSriovDevice() {
        return this.isSriovDevice;
    }

    public void setSriovDevice(boolean isSriovDevice) {
        this.isSriovDevice = isSriovDevice;
    }

    public String getCpuArchitecture() {
        return this.cpuArchitecture;
    }

    public void setCpuArchitecture(String cpuArchitecture) {
        this.cpuArchitecture = cpuArchitecture;
    }

    public String getKernelVersion() {
        return this.kernelVersion;
    }

    public void setKernelVersion(String kernelVersion) {
        this.kernelVersion = kernelVersion;
    }

    public List<MultiRouteNode> getSshForwardList() {
        return this.sshForwardList;
    }

    public void setSshForwardList(List<MultiRouteNode> sshForwardList) {
        this.sshForwardList = sshForwardList;
    }

    public class WatchDogModel {
        private String spBoot;
        private String bmcWdtEnable;
        private String osWdtEnable;

        public String getSpBoot() {
            return this.spBoot;
        }

        public void setSpBoot(String spBoot) {
            this.spBoot = spBoot;
        }

        public String getBmcWdtEnable() {
            return this.bmcWdtEnable;
        }

        public void setBmcWdtEnable(String bmcWdtEnable) {
            this.bmcWdtEnable = bmcWdtEnable;
        }

        public String getOsWdtEnable() {
            return this.osWdtEnable;
        }

        public void setOsWdtEnable(String osWdtEnable) {
            this.osWdtEnable = osWdtEnable;
        }
    }

    public class CpldModel
    extends BaseModel {
        String cpldVersion;
        String boardName;
        String boardId;
        String deviceType;

        public String getCpldVersion() {
            return this.cpldVersion;
        }

        public void setCpldVersion(String cpldVersion) {
            this.cpldVersion = cpldVersion;
        }

        public String getBoardName() {
            return this.boardName;
        }

        public void setBoardName(String boardName) {
            this.boardName = boardName;
        }

        public String getBoardId() {
            return this.boardId;
        }

        public void setBoardId(String boardId) {
            this.boardId = boardId;
        }

        public String getDeviceType() {
            return this.deviceType;
        }

        public void setDeviceType(String deviceType) {
            this.deviceType = deviceType;
        }

        @Override
        public String getSupportModelUID() {
            return String.format(Locale.ENGLISH, "%s#%s#%s", this.boardName, this.boardId, this.deviceType);
        }
    }

    public class BbuModel
    extends BaseModel {
        String bbuVersion = "--";
        String powerType = "--";

        public BbuModel(String bbuVersion, String powerType) {
            this.bbuVersion = bbuVersion;
            this.powerType = powerType;
        }

        @Override
        public String getSupportModelUID() {
            return this.powerType;
        }

        public String toString() {
            return this.bbuVersion;
        }

        public String getBbuVersion() {
            return this.bbuVersion;
        }

        public String getPowerType() {
            return this.powerType;
        }

        public void setBbuVersion(String bbuVersion) {
            this.bbuVersion = bbuVersion;
        }

        public void setPowerType(String powerType) {
            this.powerType = powerType;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BbuModel)) {
                return false;
            }
            BbuModel other = (BbuModel)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$bbuVersion = this.getBbuVersion();
            String other$bbuVersion = other.getBbuVersion();
            if (this$bbuVersion == null ? other$bbuVersion != null : !this$bbuVersion.equals(other$bbuVersion)) {
                return false;
            }
            String this$powerType = this.getPowerType();
            String other$powerType = other.getPowerType();
            return !(this$powerType == null ? other$powerType != null : !this$powerType.equals(other$powerType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof BbuModel;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $bbuVersion = this.getBbuVersion();
            result = result * 59 + ($bbuVersion == null ? 43 : $bbuVersion.hashCode());
            String $powerType = this.getPowerType();
            result = result * 59 + ($powerType == null ? 43 : $powerType.hashCode());
            return result;
        }
    }

    public class PsuModel
    extends BaseModel {
        String softwareId = "--";
        String psuVersion;
        String powerType;
        String name;

        @Override
        public String getSupportModelUID() {
            return this.powerType == null ? this.softwareId : this.powerType;
        }

        public String getSoftwareId() {
            return this.softwareId;
        }

        public String getPsuVersion() {
            return this.psuVersion;
        }

        public String getPowerType() {
            return this.powerType;
        }

        public String getName() {
            return this.name;
        }

        public void setSoftwareId(String softwareId) {
            this.softwareId = softwareId;
        }

        public void setPsuVersion(String psuVersion) {
            this.psuVersion = psuVersion;
        }

        public void setPowerType(String powerType) {
            this.powerType = powerType;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PsuModel)) {
                return false;
            }
            PsuModel other = (PsuModel)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$softwareId = this.getSoftwareId();
            String other$softwareId = other.getSoftwareId();
            if (this$softwareId == null ? other$softwareId != null : !this$softwareId.equals(other$softwareId)) {
                return false;
            }
            String this$psuVersion = this.getPsuVersion();
            String other$psuVersion = other.getPsuVersion();
            if (this$psuVersion == null ? other$psuVersion != null : !this$psuVersion.equals(other$psuVersion)) {
                return false;
            }
            String this$powerType = this.getPowerType();
            String other$powerType = other.getPowerType();
            if (this$powerType == null ? other$powerType != null : !this$powerType.equals(other$powerType)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PsuModel;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $softwareId = this.getSoftwareId();
            result = result * 59 + ($softwareId == null ? 43 : $softwareId.hashCode());
            String $psuVersion = this.getPsuVersion();
            result = result * 59 + ($psuVersion == null ? 43 : $psuVersion.hashCode());
            String $powerType = this.getPowerType();
            result = result * 59 + ($powerType == null ? 43 : $powerType.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        public String toString() {
            return "DeviceEntity.PsuModel(softwareId=" + this.getSoftwareId() + ", psuVersion=" + this.getPsuVersion() + ", powerType=" + this.getPowerType() + ", name=" + this.getName() + ")";
        }
    }

    public class DiskModel
    extends BaseModel {
        String firmwareVersion;
        String model;
        String driveLetter;
        String name;
        String diskType;
        String esn;
        String vendor;
        boolean isSriovDisk;

        @Override
        public String getSupportModelUID() {
            return this.model;
        }

        public String getSupportModelUidForMultichannelDisk() {
            return this.model + this.firmwareVersion;
        }

        public boolean isNVMeDisk() {
            return this.diskType.contains("NVME");
        }

        public boolean isSasOrSataDisk() {
            return this.diskType.contains("SATA") || this.diskType.contains("SAS");
        }

        public void setDiskType(String diskType) {
            this.diskType = diskType.toUpperCase(Locale.ENGLISH);
        }

        public void setName(String name) {
            this.name = name;
            this.driveLetter = "/dev/" + name;
        }

        public boolean isHuaweiSSD() {
            String huaweiVendor = SystemConfig.createSystemConfig().getConfigVlaue("disk.fw.huawei");
            if (huaweiVendor == null) {
                return false;
            }
            return huaweiVendor.toUpperCase(Locale.ENGLISH).contains(this.vendor.toUpperCase(Locale.ENGLISH)) && this.diskType.contains("SSD");
        }

        public String getEsnAndVersion() {
            return this.getEsn() + ":" + this.getFirmwareVersion();
        }

        public boolean modelStartsWith(String prefix) {
            return this.model.toUpperCase(Locale.ENGLISH).startsWith(prefix.toUpperCase(Locale.ENGLISH));
        }

        public String getFirmwareVersion() {
            return this.firmwareVersion;
        }

        public String getModel() {
            return this.model;
        }

        public String getDriveLetter() {
            return this.driveLetter;
        }

        public String getName() {
            return this.name;
        }

        public String getDiskType() {
            return this.diskType;
        }

        public String getEsn() {
            return this.esn;
        }

        public String getVendor() {
            return this.vendor;
        }

        public boolean isSriovDisk() {
            return this.isSriovDisk;
        }

        public void setFirmwareVersion(String firmwareVersion) {
            this.firmwareVersion = firmwareVersion;
        }

        public void setModel(String model) {
            this.model = model;
        }

        public void setDriveLetter(String driveLetter) {
            this.driveLetter = driveLetter;
        }

        public void setEsn(String esn) {
            this.esn = esn;
        }

        public void setVendor(String vendor) {
            this.vendor = vendor;
        }

        public void setSriovDisk(boolean isSriovDisk) {
            this.isSriovDisk = isSriovDisk;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DiskModel)) {
                return false;
            }
            DiskModel other = (DiskModel)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isSriovDisk() != other.isSriovDisk()) {
                return false;
            }
            String this$firmwareVersion = this.getFirmwareVersion();
            String other$firmwareVersion = other.getFirmwareVersion();
            if (this$firmwareVersion == null ? other$firmwareVersion != null : !this$firmwareVersion.equals(other$firmwareVersion)) {
                return false;
            }
            String this$model = this.getModel();
            String other$model = other.getModel();
            if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
                return false;
            }
            String this$driveLetter = this.getDriveLetter();
            String other$driveLetter = other.getDriveLetter();
            if (this$driveLetter == null ? other$driveLetter != null : !this$driveLetter.equals(other$driveLetter)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$diskType = this.getDiskType();
            String other$diskType = other.getDiskType();
            if (this$diskType == null ? other$diskType != null : !this$diskType.equals(other$diskType)) {
                return false;
            }
            String this$esn = this.getEsn();
            String other$esn = other.getEsn();
            if (this$esn == null ? other$esn != null : !this$esn.equals(other$esn)) {
                return false;
            }
            String this$vendor = this.getVendor();
            String other$vendor = other.getVendor();
            return !(this$vendor == null ? other$vendor != null : !this$vendor.equals(other$vendor));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DiskModel;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isSriovDisk() ? 79 : 97);
            String $firmwareVersion = this.getFirmwareVersion();
            result = result * 59 + ($firmwareVersion == null ? 43 : $firmwareVersion.hashCode());
            String $model = this.getModel();
            result = result * 59 + ($model == null ? 43 : $model.hashCode());
            String $driveLetter = this.getDriveLetter();
            result = result * 59 + ($driveLetter == null ? 43 : $driveLetter.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $diskType = this.getDiskType();
            result = result * 59 + ($diskType == null ? 43 : $diskType.hashCode());
            String $esn = this.getEsn();
            result = result * 59 + ($esn == null ? 43 : $esn.hashCode());
            String $vendor = this.getVendor();
            result = result * 59 + ($vendor == null ? 43 : $vendor.hashCode());
            return result;
        }

        public String toString() {
            return "DeviceEntity.DiskModel(firmwareVersion=" + this.getFirmwareVersion() + ", model=" + this.getModel() + ", driveLetter=" + this.getDriveLetter() + ", name=" + this.getName() + ", diskType=" + this.getDiskType() + ", esn=" + this.getEsn() + ", vendor=" + this.getVendor() + ", isSriovDisk=" + this.isSriovDisk() + ")";
        }
    }
}

