/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.entity;

import com.huawei.bundleupgrade.constants.UpgradeParamConstants;
import com.huawei.bundleupgrade.entity.DeviceEntity;
import com.huawei.bundleupgrade.entity.DiskPkgInfo;
import com.huawei.bundleupgrade.model.ModuleEnum;
import com.huawei.bundleupgrade.utils.BundleUpgradeContext;
import com.huawei.bundleupgrade.utils.ServiceUtil;
import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.uMate.common.utils.ResUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

public class FirmwarePackageEntity {
    private static final ResUtil RES = ResUtil.getInstance((String)"BundleUpgrade");
    private static final String ACTIVE_MODEL = "firmware.upgrade.strategy.activeModel.%s";
    private int size;
    private String type;
    private List<Product> products = new LinkedList<Product>();
    private String firmwarePackageVersion;
    private PackageInfo packageInfo;
    private InterfaceInfo interfaceInfo;
    private String baseline;
    private volatile UpgradeParamConstants.FirmwareDownloadStatus downloadStatus;
    private String localPathAbs;
    private String unzippedPackagePath;
    private String onlinePathAbs;
    private String onlineFilePath;
    private String onlineAesFilePathAbs;
    private String tempId = "--";
    private List<DiskPkgInfo> diskPkgInfos = new ArrayList<DiskPkgInfo>();

    public String getUnzippedPackagePath() {
        return this.unzippedPackagePath;
    }

    public void setUnzippedPackagePath(String unzippedPackagePath) {
        this.unzippedPackagePath = unzippedPackagePath;
    }

    public boolean isDownloaded() {
        return this.getDownloadStatus() == UpgradeParamConstants.FirmwareDownloadStatus.FINISHED;
    }

    public synchronized void setDownloadStatus(UpgradeParamConstants.FirmwareDownloadStatus downloadStatus) {
        this.downloadStatus = downloadStatus;
    }

    public synchronized UpgradeParamConstants.FirmwareDownloadStatus getDownloadStatus() {
        return this.downloadStatus;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public List<Product> getProducts() {
        return this.products;
    }

    public void setProducts(List<Product> products) {
        this.products = products;
    }

    public String getFirmwarePackageVersion() {
        return this.firmwarePackageVersion;
    }

    public void setFirmwarePackageVersion(String firmwarePackageVersion) {
        this.firmwarePackageVersion = firmwarePackageVersion;
    }

    public PackageInfo getPackageInfo() {
        return this.packageInfo;
    }

    public void setPackageInfo(PackageInfo packageInfo) {
        this.packageInfo = packageInfo;
    }

    public String getLocalPathAbs() {
        return FilePathUtils.checkFile((String)this.localPathAbs);
    }

    public void setLocalPathAbs(String localPathAbs) {
        this.localPathAbs = localPathAbs;
    }

    public String getOnlinePathAbs() {
        return this.onlinePathAbs;
    }

    public void setOnlinePathAbs(String onlinePathAbs) {
        this.onlinePathAbs = onlinePathAbs;
    }

    public String getOnlineFilePath() {
        return this.onlineFilePath;
    }

    public void setOnlineFilePath(String onlineFilePath) {
        this.onlineFilePath = onlineFilePath;
    }

    public String getOnlineAesFilePathAbs() {
        return this.onlineAesFilePathAbs;
    }

    public void setOnlineAesFilePathAbs(String onlineAesFilePathAbs) {
        this.onlineAesFilePathAbs = onlineAesFilePathAbs;
    }

    public String getBaseline() {
        return this.baseline;
    }

    public void setBaseline(String baseline) {
        this.baseline = baseline;
    }

    public InterfaceInfo getInterfaceInfo() {
        return this.interfaceInfo;
    }

    public void setInterfaceInfo(InterfaceInfo interfaceInfo) {
        this.interfaceInfo = interfaceInfo;
    }

    public boolean isProductNameOrAllMatchOnlineFirmware(DeviceEntity device) {
        String productStr = String.join((CharSequence)";", (CharSequence[])this.getProducts().stream().map(Product::getName).toArray(String[]::new)).toLowerCase(Locale.ENGLISH);
        if (productStr.contains("all")) {
            return true;
        }
        String[] realNames = BundleUpgradeContext.getInstance().getProductModelName(device.getProductName()).split(",");
        return Arrays.stream(realNames).anyMatch(realName -> productStr.contains(realName.toLowerCase(Locale.ENGLISH)));
    }

    public boolean isPCIeModulePackage() {
        return ServiceUtil.isPCIeModule(this.getPackageInfo().getModule());
    }

    public boolean isSameProcessorArchitecture(DeviceEntity device) {
        String deviceArchitecture = device.getProcessorArchitecture().toLowerCase(Locale.ROOT);
        String packageArchitecture = this.getPackageInfo().getProcessorArchitecture().toLowerCase(Locale.ROOT);
        return packageArchitecture.contains(deviceArchitecture) || packageArchitecture.contains("all");
    }

    public String getSupportModels() {
        if (this.getPackageInfo().getModule().equalsIgnoreCase(ModuleEnum.CPLD.getName())) {
            return this.getPackageInfo().getObject() + RES.getStringWithParams("bundle.upgrade.parentheses", new Object[]{this.getPackageInfo().getObject()});
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.getPackageInfo().getSupportModelUID())) {
            return this.getPackageInfo().getSupportModel() + RES.getStringWithParams("bundle.upgrade.parentheses", new Object[]{this.getPackageInfo().getSupportModelUID()});
        }
        return this.getPackageInfo().getSupportModel();
    }

    public String getTempId() {
        return this.tempId;
    }

    public void setTempId(String tempId) {
        this.tempId = tempId;
    }

    public List<DiskPkgInfo> getDiskPkgInfos() {
        return this.diskPkgInfos;
    }

    public void setDiskPkgInfos(List<DiskPkgInfo> diskPkgInfos) {
        this.diskPkgInfos = diskPkgInfos;
    }

    public class InterfaceInfo {
        private String getVersionCmd;
        private String uploadScript;
        private String upgradeCmd;
        private String getUpgradeStatusCmd;

        public String getGetVersionCmd() {
            return this.getVersionCmd;
        }

        public void setGetVersionCmd(String getVersionCmd) {
            this.getVersionCmd = getVersionCmd;
        }

        public String getUpgradeCmd() {
            return this.upgradeCmd;
        }

        public void setUpgradeCmd(String upgradeCmd) {
            this.upgradeCmd = upgradeCmd;
        }

        public String getGetUpgradeStatusCmd() {
            return this.getUpgradeStatusCmd;
        }

        public void setGetUpgradeStatusCmd(String getUpgradeStatusCmd) {
            this.getUpgradeStatusCmd = getUpgradeStatusCmd;
        }

        public String getUploadScript() {
            return this.uploadScript;
        }

        public void setUploadScript(String uploadScript) {
            this.uploadScript = uploadScript;
        }
    }

    public class PackageInfo {
        String packageName;
        String rpmName;
        String summary;
        String description;
        String versionPattern;
        String fileType;
        int maxUpgradeTime;
        int maxActiveTime;
        String upgradeAgent;
        String upgradeMode;
        String fileName;
        String module;
        String version;
        String activeMode;
        String vendor;
        String supportModel;
        String supportModelUID;
        String processorArchitecture;
        String cpuArchitecture = "";
        String supportKernelVersion = "";
        String packageType;
        boolean isExist = false;
        String object = "";
        String objectID = "";
        boolean isNeedUnzipTwice = false;

        public String getPackageName() {
            return this.packageName;
        }

        public void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        public String getRpmName() {
            return this.rpmName;
        }

        public void setRpmName(String rpmName) {
            this.rpmName = rpmName;
        }

        public String getSummary() {
            return this.summary;
        }

        public void setSummary(String summary) {
            this.summary = summary;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getVersionPattern() {
            return this.versionPattern;
        }

        public void setVersionPattern(String versionPattern) {
            this.versionPattern = versionPattern;
        }

        public String getFileType() {
            return this.fileType;
        }

        public void setFileType(String fileType) {
            this.fileType = fileType;
        }

        public int getMaxUpgradeTime() {
            return this.maxUpgradeTime;
        }

        public void setMaxUpgradeTime(int maxUpgradeTime) {
            this.maxUpgradeTime = maxUpgradeTime;
        }

        public int getMaxActiveTime() {
            return this.maxActiveTime;
        }

        public void setMaxActiveTime(int maxActiveTime) {
            this.maxActiveTime = maxActiveTime;
        }

        public String getUpgradeAgent() {
            return this.upgradeAgent;
        }

        public void setUpgradeAgent(String upgradeAgent) {
            this.upgradeAgent = upgradeAgent;
        }

        public String getUpgradeMode() {
            return this.upgradeMode;
        }

        public void setUpgradeMode(String upgradeMode) {
            this.upgradeMode = upgradeMode;
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public String getModule() {
            return this.module;
        }

        public void setModule(String module) {
            this.module = module;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getActiveMode() {
            return StringUtils.isNULLStr((String)this.activeMode) ? "--" : RES.getString(String.format(Locale.ENGLISH, FirmwarePackageEntity.ACTIVE_MODEL, this.activeMode));
        }

        public void setActiveMode(String activeMode) {
            this.activeMode = activeMode;
        }

        public String getVendor() {
            return this.vendor;
        }

        public void setVendor(String vendor) {
            this.vendor = vendor;
        }

        public String getSupportModel() {
            return this.supportModel;
        }

        public void setSupportModel(String supportModel) {
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)supportModel)) {
                this.supportModel = "--";
            }
            this.supportModel = supportModel;
        }

        public String getSupportModelUID() {
            return this.supportModelUID == null ? "" : this.supportModelUID;
        }

        public void setSupportModelUID(String supportModelUID) {
            this.supportModelUID = supportModelUID;
        }

        public String getObject() {
            return this.object;
        }

        public void setObject(String object) {
            this.object = object;
        }

        public String getObjectID() {
            return this.objectID;
        }

        public void setObjectID(String objectID) {
            this.objectID = objectID;
        }

        public String getProcessorArchitecture() {
            return this.processorArchitecture;
        }

        public void setProcessorArchitecture(String processorArchitecture) {
            this.processorArchitecture = processorArchitecture;
        }

        public Boolean isExist() {
            return this.isExist;
        }

        public void setIsExist(Boolean isExist) {
            this.isExist = isExist;
        }

        public String getRetimerId() {
            return this.object.concat("-").concat(this.objectID);
        }

        public void setCpuArchitecture(String cpuArchitecture) {
            this.cpuArchitecture = cpuArchitecture;
        }

        public String getCpuArchitecture() {
            return this.cpuArchitecture;
        }

        public void setSupportKernelVersion(String supportKernelVersion) {
            this.supportKernelVersion = supportKernelVersion;
        }

        public String getSupportKernelVersion() {
            return this.supportKernelVersion;
        }

        public void setPackageType(String packageType) {
            this.packageType = packageType;
        }

        public String getPackageType() {
            return this.packageType;
        }

        public boolean isNeedUnzipTwice() {
            return this.isNeedUnzipTwice;
        }

        public void setNeedUnzipTwice(boolean isNeedUnzipTwice) {
            this.isNeedUnzipTwice = isNeedUnzipTwice;
        }
    }

    public class Product {
        String name;
        String type;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }
}

