/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.entity;

import java.util.Arrays;

public class FwUpgradeScenarioAdaptation {

    public static enum BlockInspectEnum {
        DATA_TURBO("DataTurbo", "ALL");

        private final String productModule;
        private final String version;

        private BlockInspectEnum(String productModule, String version) {
            this.productModule = productModule;
            this.version = version;
        }

        public String getProductModule() {
            return this.productModule;
        }

        public String getVersion() {
            return this.version;
        }
    }

    public static enum ErasureBlockEnum {
        FUSION_STORAGE("FusionStorage", "ALL"),
        OCEANSTOR_100D("OceanStor 100D", "ALL"),
        DATA_TURBO("DataTurbo", "ALL"),
        OCEANSTOR_PACIFIC("OceanStor Pacific", "8.1,8.2.0");

        private final String productModule;
        private final String version;

        public static boolean isSupportErasureProduct(String productModule, String version) {
            return Arrays.stream(ErasureBlockEnum.values()).filter(block -> productModule.contains(block.getProductModule())).noneMatch(block -> ErasureBlockEnum.isBlockVersion(version, block));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static boolean isBlockVersion(String version, ErasureBlockEnum block) {
            if ("8.2.0L15Y01".equalsIgnoreCase(version)) {
                return false;
            }
            if ("ALL".equals(block.getVersion())) return true;
            if (!Arrays.stream(block.getVersion().split(",")).anyMatch(version::startsWith)) return false;
            return true;
        }

        private ErasureBlockEnum(String productModule, String version) {
            this.productModule = productModule;
            this.version = version;
        }

        public String getProductModule() {
            return this.productModule;
        }

        public String getVersion() {
            return this.version;
        }
    }

    public static enum PostCheckVrsion {
        FUSION_STORAGE("FusionStorage", "8.0.1"),
        OCEAN_STOR_100D("OceanStor 100D", "8.0.3,8.0.RC1"),
        OCEAN_STOR_PACIFIC("OceanStor Pacific", "8.1");

        private String productName;
        private String productVersion;

        public String getProductName() {
            return this.productName;
        }

        public String getProductVersion() {
            return this.productVersion;
        }

        private PostCheckVrsion(String productName, String productVersion) {
            this.productName = productName;
            this.productVersion = productVersion;
        }
    }
}

