/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.entity;

import com.huawei.bundleupgrade.entity.NodeUpgradePriorityEnums;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class NodeServiceInfo {
    public static final String NODE_SERVICE_INFO = "nodeServiceInfo";
    public static final String MGR_IP = "mgrIP";
    public static final String SERVICE_INFO = "serviceInfo";
    public static final String QUERY_SERVICE_ERROR = "queryServiceError";
    public static final String STORAGE_POOL_ID = "storagePoolId";
    public static final String DISK_POOL_ID = "diskPoolId";
    public static final String IS_SUPPORT_DISK_POOL = "isSupportDiskPool";
    public static final String PRODUCT_VERSION = "productVersion";
    public static final String QUERY_STORAGE_POOL_ERROR = "queryStoragePoolError";
    private static final String A_NODE_SERVICE_WITHOUT_VBS = "pool,pool_block,eds-b,pool_converged,eds,eds-f";
    private static final String A_NODE_SERVICE = "pool,pool_block,eds-b,pool_converged,eds,eds-f,vbs";
    private static final String[] EDS_F_BLACK_START_WITH = new String[]{"8.0", "8.1.0", "8.1.RC2"};
    public static final String VOLUME_NUM = "volumeNum";
    public static final String ISCSI_SERVER = "iscsi";
    public static final String MANAGEMENT_SERVER = "fsm_manager";
    private String sandboxStatus;
    private String mgrIP;
    private Set<String> serviceInfo = new HashSet<String>();
    private boolean queryServiceError = false;
    private String storagePoolId;
    private String diskPoolId = "";
    private boolean isSupportDiskPool;
    private String productVersion;
    private boolean queryStoragePoolError = false;
    private int volumeNum = -1;
    private NodeUpgradePriorityEnums nodeUpgradePriority = NodeUpgradePriorityEnums.NON_STORAGE_POOL_SERVICE_EXISTS;

    public NodeServiceInfo(String mgrIP) {
        this.mgrIP = mgrIP;
    }

    public String getMgrIP() {
        return this.mgrIP;
    }

    public Set<String> getServiceInfo() {
        return this.serviceInfo;
    }

    public void setServiceInfo(Set<String> serviceInfo) {
        this.serviceInfo = serviceInfo;
    }

    public NodeUpgradePriorityEnums getNodeUpgradePriority() {
        return this.nodeUpgradePriority;
    }

    public boolean isQueryServiceError() {
        return this.queryServiceError;
    }

    public void setQueryServiceError(boolean queryServiceError) {
        this.queryServiceError = queryServiceError;
        this.resetNodeUpgradePriorityByNodeServiceInfo();
    }

    public void setQueryStoragePoolError(boolean queryStoragePoolError) {
        this.queryStoragePoolError = queryStoragePoolError;
        this.resetNodeUpgradePriorityByNodeServiceInfo();
    }

    public boolean isQueryStoragePoolError() {
        return this.queryStoragePoolError;
    }

    public String getStoragePoolId() {
        return this.storagePoolId;
    }

    public void setStoragePoolId(String storagePoolId) {
        this.storagePoolId = storagePoolId;
    }

    public void resetNodeUpgradePriorityByNodeServiceInfo() {
        if (this.queryServiceError || this.queryStoragePoolError) {
            this.nodeUpgradePriority = NodeUpgradePriorityEnums.NON_STORAGE_POOL_SERVICE_EXISTS;
            return;
        }
        this.nodeUpgradePriority = this.serviceInfo.isEmpty() ? NodeUpgradePriorityEnums.NO_SERVICE : (this.isEdsFBlackVersion() ? NodeUpgradePriorityEnums.NON_STORAGE_POOL_SERVICE_EXISTS : (this.serviceInfo.stream().allMatch(service -> A_NODE_SERVICE_WITHOUT_VBS.contains(service.toLowerCase(Locale.ENGLISH))) ? NodeUpgradePriorityEnums.ONLY_STORAGE_POOL_SERVICE : (this.hasStorageAndVbsServiceButNoVolume() ? NodeUpgradePriorityEnums.ONLY_STORAGE_POOL_SERVICE : (this.containsIgnoreCase(this.serviceInfo, "DirectPlane") ? NodeUpgradePriorityEnums.DIRECT_PLANE : NodeUpgradePriorityEnums.NON_STORAGE_POOL_SERVICE_EXISTS))));
    }

    private boolean hasStorageAndVbsServiceButNoVolume() {
        return this.serviceInfo.stream().anyMatch(service -> A_NODE_SERVICE_WITHOUT_VBS.contains(service.toLowerCase(Locale.ENGLISH))) && this.serviceInfo.stream().allMatch(service -> A_NODE_SERVICE.contains(service.toLowerCase(Locale.ENGLISH))) && this.volumeNum == 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isEdsFBlackVersion() {
        if (!this.serviceInfo.contains("eds-f")) return false;
        if (!Arrays.stream(EDS_F_BLACK_START_WITH).anyMatch(this.productVersion::startsWith)) return false;
        return true;
    }

    private boolean containsIgnoreCase(Set<String> set, String targe) {
        return set.stream().anyMatch(targe::equalsIgnoreCase);
    }

    public int getVolumeNum() {
        return this.volumeNum;
    }

    public void setVolumeNum(int volumeNum) {
        this.volumeNum = volumeNum;
    }

    public boolean isFsmNode() {
        return this.serviceInfo.stream().anyMatch(MANAGEMENT_SERVER::equalsIgnoreCase);
    }

    public String getSandboxStatus() {
        return this.sandboxStatus;
    }

    public void setSandboxStatus(String sandboxStatus) {
        this.sandboxStatus = sandboxStatus;
    }

    public void setDiskPoolId(String diskPoolId) {
        this.diskPoolId = diskPoolId;
    }

    public String getDiskPoolId() {
        return this.diskPoolId;
    }

    public void setSupportDiskPool(boolean isSupportDiskPool) {
        this.isSupportDiskPool = isSupportDiskPool;
    }

    public boolean isSupportDiskPool() {
        return this.isSupportDiskPool;
    }

    public void setProductVersion(String productVersion) {
        this.productVersion = productVersion;
    }

    public String getProductVersion() {
        return this.productVersion;
    }
}

