/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.entity;

import com.google.common.collect.ArrayListMultimap;
import com.huawei.bundleupgrade.entity.DeviceEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class OperationResultEntity {
    private static final String SPILT = ";";
    private static final String POINT = ". ";
    private String returnParam = "";
    private boolean isPassed = false;
    private boolean isNextStep = true;
    private ArrayListMultimap<String, String> arrayListCheckInfo = ArrayListMultimap.create();
    private Map<String, Boolean> preUpgradeResult = new HashMap<String, Boolean>();

    public OperationResultEntity(boolean isPassed, String returnParam) {
        this.isPassed = isPassed;
        this.returnParam = returnParam;
    }

    public String getReturnParam() {
        return this.returnParam;
    }

    public void setReturnParam(String returnParam) {
        this.returnParam = returnParam;
    }

    public boolean isPassed() {
        return this.isPassed;
    }

    public void setPassed(boolean passed) {
        this.isPassed = passed;
    }

    public void cacheCheckBiosErrorInfo(List<DeviceEntity> deviceEntities, String errorMsg) {
        deviceEntities.forEach(device -> this.arrayListCheckInfo.put((Object)device.getIp(), (Object)errorMsg));
    }

    public void parseAndCacheResultInfo(List<DeviceEntity> deviceEntities, String errorMsg) {
        Arrays.stream(errorMsg.split("\n")).forEach(msg -> deviceEntities.stream().filter(device -> msg.startsWith(device.getIp())).findFirst().ifPresent(device -> this.arrayListCheckInfo.put((Object)device.getIp(), (Object)msg.split(SPILT)[1])));
    }

    public List<List<String>> getShowInfo() {
        return this.getArrayListCheckInfo().asMap().entrySet().stream().map(device -> this.getResultInfoSetNum((String)device.getKey(), (Collection)device.getValue())).collect(Collectors.toList());
    }

    private List<String> getResultInfoSetNum(String deviceIp, Collection<String> errorInfo) {
        ArrayList<String> resultInfo = new ArrayList<String>();
        resultInfo.add(deviceIp);
        AtomicInteger index = new AtomicInteger(0);
        resultInfo.add(errorInfo.stream().map(info -> String.join((CharSequence)POINT, String.valueOf(index.incrementAndGet()), info)).collect(Collectors.joining("<br/>")));
        return resultInfo;
    }

    public void setNextStep(boolean isNextStep) {
        this.isNextStep = isNextStep;
    }

    public boolean isNextStep() {
        return this.isNextStep;
    }

    public ArrayListMultimap<String, String> getArrayListCheckInfo() {
        return this.arrayListCheckInfo;
    }

    public void setPreUpgradeResult(Map<String, Boolean> preUpgradeResult) {
        this.preUpgradeResult = preUpgradeResult;
    }

    public Map<String, Boolean> getPreUpgradeResult() {
        return this.preUpgradeResult;
    }
}

