/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.entity;

import com.huawei.bundleupgrade.constants.UpgradeParamConstants;
import java.util.Arrays;

public enum RetimerTypeEnum {
    TI_RETIMER("Retimer-5", UpgradeParamConstants.ModuleType.PCIE_RETIMER_TI_RETIMER),
    RETIMER_5902H("Retimer-5902H", UpgradeParamConstants.ModuleType.PCIE_RETIMER);

    private final String retimerTypeKey;
    private final UpgradeParamConstants.ModuleType moduleType;

    public static RetimerTypeEnum getRetimerTypeByKey(String retimerType) {
        return Arrays.stream(RetimerTypeEnum.values()).filter(value -> value.getRetimerTypeKey().equalsIgnoreCase(retimerType)).findFirst().orElse(RETIMER_5902H);
    }

    public static boolean isRetimerModule(UpgradeParamConstants.ModuleType moduleType) {
        return Arrays.stream(RetimerTypeEnum.values()).anyMatch(value -> value.getModuleType().equals((Object)moduleType));
    }

    private RetimerTypeEnum(String retimerTypeKey, UpgradeParamConstants.ModuleType moduleType) {
        this.retimerTypeKey = retimerTypeKey;
        this.moduleType = moduleType;
    }

    public String getRetimerTypeKey() {
        return this.retimerTypeKey;
    }

    public UpgradeParamConstants.ModuleType getModuleType() {
        return this.moduleType;
    }
}

