/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.entity;

import com.huawei.bundleupgrade.constants.UpgradeParamConstants;
import com.huawei.bundleupgrade.entity.DeviceEntity;
import com.huawei.bundleupgrade.entity.DiskVersionEntity;
import com.huawei.bundleupgrade.entity.FirmwarePackageEntity;
import com.huawei.bundleupgrade.entity.NodeUpgradePriorityEnums;
import com.huawei.bundleupgrade.entity.UpgradeParams;
import com.huawei.bundleupgrade.entity.UpgradeStrategyEntity;
import com.huawei.bundleupgrade.model.ExecuteInfo;
import com.huawei.bundleupgrade.utils.BundleUpgradeContext;
import com.huawei.bundleupgrade.utils.ServiceUtil;
import com.huawei.bundleupgrade.utils.UpgradeScenarioUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.uMate.common.utils.ResUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeDeviceEntity {
    private static final Logger log = LoggerFactory.getLogger(UpgradeDeviceEntity.class);
    private static final ResUtil RES = ResUtil.getInstance((String)"BundleUpgrade");
    private DeviceEntity deviceEntity;
    private String associatedStrategyId;
    private Date endTaskTime;
    private Date startTaskTime;
    private boolean isOnlyUpgradeSesInVnodeEc = false;
    private List<UpgradeParamConstants.ModuleType> finishModules = new ArrayList<UpgradeParamConstants.ModuleType>();
    private int index;
    private UpgradeParamConstants.UpgradeStatus processStatus;
    private Map<UpgradeParamConstants.ModuleType, List<FirmUpgradeResult>> upgradeDetails = new HashMap<UpgradeParamConstants.ModuleType, List<FirmUpgradeResult>>();
    private String resultMsg;
    private String startTime = "";
    private String usedTimeSeconds = "";
    private int progress = 0;
    private ArrayList<UpgradeParams> upgradeParamsList = new ArrayList();
    private ExecuteInfo executeInfo = new ExecuteInfo();
    private boolean isRebootTask = false;
    private boolean isOnlineFirmwareUpgraded = false;
    private boolean isOsStarted = false;
    private boolean precheckFinish;
    private FirmRebootResult firmRebootResult = new FirmRebootResult();

    public boolean isRebootTask() {
        return this.isRebootTask;
    }

    public void setRebootTask(boolean rebootTask) {
        this.isRebootTask = rebootTask;
    }

    public FirmRebootResult getFirmRebootResult() {
        return this.firmRebootResult;
    }

    public void setFirmRebootResult(FirmRebootResult firmRebootResult) {
        this.firmRebootResult = firmRebootResult;
    }

    public UpgradeDeviceEntity(DeviceEntity deviceEntity) {
        this.deviceEntity = deviceEntity;
    }

    public DeviceEntity getDeviceEntity() {
        return this.deviceEntity;
    }

    public String getAssociatedStrategyId() {
        return this.associatedStrategyId;
    }

    public void setAssociatedStrategyId(String associatedStrategyId) {
        this.associatedStrategyId = associatedStrategyId;
    }

    public UpgradeParamConstants.UpgradeStatus getProcessStatus() {
        return this.processStatus;
    }

    public boolean isUpgrading() {
        return UpgradeParamConstants.UpgradeStatus.RUNNING == this.processStatus || UpgradeParamConstants.UpgradeStatus.WAITING == this.processStatus || UpgradeParamConstants.UpgradeStatus.WAIT_REBOOT == this.processStatus || UpgradeParamConstants.UpgradeStatus.REBOOT == this.processStatus;
    }

    public boolean isWaiting() {
        return UpgradeParamConstants.UpgradeStatus.WAITING == this.processStatus || UpgradeParamConstants.UpgradeStatus.WAIT_REBOOT == this.processStatus;
    }

    public boolean isSuccess() {
        return UpgradeParamConstants.UpgradeStatus.COMPLETED == this.processStatus;
    }

    public boolean isFailed() {
        return UpgradeParamConstants.UpgradeStatus.FAILED == this.processStatus;
    }

    public boolean isNotUpgrade() {
        return UpgradeParamConstants.UpgradeStatus.notUpgradeStatus().contains((Object)this.processStatus);
    }

    public boolean isUpdEnd() {
        return UpgradeParamConstants.UpgradeStatus.isHaveUpgrade(this.processStatus);
    }

    public String getUpgradeStatusKey() {
        return this.processStatus == null ? UpgradeParamConstants.UpgradeStatus.WAITING.getUpgradeStatusMsgKey() : this.processStatus.getUpgradeStatusMsgKey();
    }

    public void setProcessStatus(UpgradeParamConstants.UpgradeStatus processStatus) {
        if (UpgradeParamConstants.UpgradeStatus.isHaveUpgrade(processStatus)) {
            log.info("The upgrade task of node {} ends", (Object)this.getDeviceEntity().getIp());
            this.setEndTaskTime(new Date());
        }
        this.processStatus = processStatus;
    }

    public String getStartTaskTimeString() {
        if (Objects.isNull(this.startTaskTime)) {
            return "--";
        }
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(this.startTaskTime);
    }

    public String getEndTaskTimeString() {
        if (Objects.isNull(this.endTaskTime)) {
            return "--";
        }
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(this.endTaskTime);
    }

    public String getExecuteTimeString() {
        if (Objects.isNull(this.endTaskTime) || Objects.isNull(this.startTaskTime)) {
            return "--";
        }
        return StringUtils.millls2FormatString((long)(this.endTaskTime.getTime() - this.startTaskTime.getTime()));
    }

    public Map<UpgradeParamConstants.ModuleType, List<FirmUpgradeResult>> getUpgradeDetails() {
        return this.upgradeDetails == null ? new HashMap() : this.upgradeDetails;
    }

    public Map<String, List<FirmUpgradeResult>> getUpgradeStrKeyDetails() {
        HashMap<String, List<FirmUpgradeResult>> newResult = new HashMap<String, List<FirmUpgradeResult>>();
        this.upgradeDetails.forEach((key, value) -> newResult.put(key.getModule(), (List<FirmUpgradeResult>)value));
        return newResult;
    }

    public void setUpgradeDetails(Map<UpgradeParamConstants.ModuleType, List<FirmUpgradeResult>> upgradeDetails) {
        this.upgradeDetails = upgradeDetails;
    }

    public int getSubCompnentSize() {
        if (this.upgradeDetails == null || this.upgradeDetails.isEmpty()) {
            return 0;
        }
        int totalSize = 0;
        for (Map.Entry<UpgradeParamConstants.ModuleType, List<FirmUpgradeResult>> entry : this.upgradeDetails.entrySet()) {
            totalSize = (short)(totalSize + entry.getValue().size());
        }
        return totalSize;
    }

    public void setSpecifiedFirmwareUpgradeDetail(UpgradeParamConstants.ModuleType module, FirmUpgradeResult upgradeDetail) {
        if (this.upgradeDetails.get((Object)module) != null) {
            this.upgradeDetails.get((Object)module).add(upgradeDetail);
        } else {
            ArrayList<FirmUpgradeResult> firmwareResults = new ArrayList<FirmUpgradeResult>();
            firmwareResults.add(upgradeDetail);
            this.upgradeDetails.put(module, firmwareResults);
        }
    }

    public String getResultMsg() {
        return this.resultMsg == null ? "" : this.resultMsg;
    }

    public String getResultDisplayMsg() {
        if (this.isFailed() && org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.resultMsg)) {
            return RES.getString("upgrade.errror.not.common");
        }
        return this.resultMsg == null ? "" : this.resultMsg;
    }

    public void setResultMsg(String resultMsg) {
        this.resultMsg = resultMsg;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getUsedTimeSeconds() {
        return this.usedTimeSeconds;
    }

    public void setUsedTimeSeconds(String usedTimeSeconds) {
        this.usedTimeSeconds = usedTimeSeconds;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public List<UpgradeParams> getUpgradeParamsList() {
        return this.upgradeParamsList;
    }

    public void setUpgradeParamsList(ArrayList<UpgradeParams> upgradeParamsList) {
        this.upgradeParamsList = upgradeParamsList;
    }

    public ExecuteInfo getExecuteInfo() {
        return this.executeInfo;
    }

    public void setExecuteInfo(ExecuteInfo executeInfo) {
        this.executeInfo = executeInfo;
    }

    public void resetEntityStatus() {
        this.setRebootTask(false);
        this.setResultMsg("");
        this.upgradeDetails.clear();
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public boolean isNodeA() {
        return this.getDeviceEntity().getServiceType().equals((Object)NodeUpgradePriorityEnums.ONLY_STORAGE_POOL_SERVICE);
    }

    public boolean isNodeB() {
        return this.getDeviceEntity().getServiceType().equals((Object)NodeUpgradePriorityEnums.NON_STORAGE_POOL_SERVICE_EXISTS);
    }

    public boolean isNodeC() {
        return this.getDeviceEntity().getServiceType().equals((Object)NodeUpgradePriorityEnums.NO_SERVICE);
    }

    public boolean isPlaneNode() {
        return this.getDeviceEntity().getServiceType().equals((Object)NodeUpgradePriorityEnums.DIRECT_PLANE);
    }

    public boolean canUpgrade() {
        return UpgradeParamConstants.UpgradeStatus.ASSOCIATED.equals((Object)this.processStatus) || UpgradeParamConstants.UpgradeStatus.FAILED.equals((Object)this.processStatus) || UpgradeParamConstants.UpgradeStatus.UPGRADE_PARTIAL_SUCCESS.equals((Object)this.processStatus) || UpgradeParamConstants.UpgradeStatus.ABORT_REBOOT.equals((Object)this.processStatus);
    }

    public boolean canReboot() {
        return UpgradeParamConstants.UpgradeStatus.ABORT_REBOOT.equals((Object)this.processStatus) || this.isRebootTask && UpgradeParamConstants.UpgradeStatus.FAILED.equals((Object)this.processStatus);
    }

    public boolean isParallelByPoolId() {
        return this.isNodeA() || this.isPlaneNode();
    }

    public boolean isUpgradeOneByOne() {
        return this.isNodeB();
    }

    public boolean isOnlineFirmwareUpgraded() {
        return this.isOnlineFirmwareUpgraded;
    }

    public void setOnlineFirmwareUpgraded(boolean onlineFirmwareUpgraded) {
        this.isOnlineFirmwareUpgraded = onlineFirmwareUpgraded;
    }

    public boolean needReboot() {
        UpgradeStrategyEntity strategy = BundleUpgradeContext.getInstance().getStrategyEntityMap().get(this.getAssociatedStrategyId());
        return this.isDfsNeedRebot(strategy) || strategy.getUpgradeOrders().stream().flatMap(Collection::stream).anyMatch(module -> !UpgradeParamConstants.ModuleType.noNeedRebootModules().contains(module));
    }

    private boolean isDfsNeedRebot(UpgradeStrategyEntity strategy) {
        boolean isContainDfs = strategy.getUpgradeOrders().stream().flatMap(Collection::stream).anyMatch(module -> Objects.equals(module, (Object)UpgradeParamConstants.ModuleType.DFS));
        if (isContainDfs) {
            return this.getDeviceEntity().getM2DiskVersions().stream().anyMatch(DiskVersionEntity::isShouldResetActive);
        }
        return false;
    }

    public boolean onlyNeedOfflineUpgrade() {
        if (UpgradeScenarioUtil.isYinglong()) {
            return false;
        }
        UpgradeStrategyEntity strategy = BundleUpgradeContext.getInstance().getStrategyEntityMap().get(this.getAssociatedStrategyId());
        List moduleList = strategy.getUpgradeOrders().stream().flatMap(Collection::stream).collect(Collectors.toList());
        List<UpgradeParamConstants.ModuleType> onlineModules = ServiceUtil.getOnlineUpgModuleByVer(this);
        return moduleList.stream().noneMatch(onlineModules::contains);
    }

    public boolean needOffLineUpgrade() {
        if (UpgradeScenarioUtil.isYinglong()) {
            return this.needReboot();
        }
        UpgradeStrategyEntity strategy = BundleUpgradeContext.getInstance().getStrategyEntityMap().get(this.getAssociatedStrategyId());
        List moduleList = strategy.getUpgradeOrders().stream().flatMap(Collection::stream).collect(Collectors.toList());
        List<UpgradeParamConstants.ModuleType> onlineModules = ServiceUtil.getOnlineUpgModuleByVer(this);
        return moduleList.stream().anyMatch(module -> !onlineModules.contains(module)) || this.needReboot();
    }

    public boolean needOffLineUpgradePanGea() {
        UpgradeStrategyEntity strategy = BundleUpgradeContext.getInstance().getStrategyEntityMap().get(this.getAssociatedStrategyId());
        List moduleList = strategy.getUpgradeOrders().stream().flatMap(Collection::stream).collect(Collectors.toList());
        return moduleList.stream().anyMatch(module -> !UpgradeParamConstants.ModuleType.onlinePanGeaModules().contains(module));
    }

    public boolean isManagementNode() {
        return this.deviceEntity.getNodeServiceInfo() != null && this.deviceEntity.getNodeServiceInfo().isFsmNode();
    }

    public void clearTime() {
        this.setStartTaskTime(null);
        this.setEndTaskTime(null);
    }

    public boolean isFinishModule(UpgradeParamConstants.ModuleType module) {
        return this.getFinishModules().contains((Object)module);
    }

    public void setEndTaskTime(Date endTaskTime) {
        this.endTaskTime = endTaskTime;
    }

    public Date getStartTaskTime() {
        return this.startTaskTime;
    }

    public void setStartTaskTime(Date startTaskTime) {
        this.startTaskTime = startTaskTime;
    }

    public void setOnlyUpgradeSesInVnodeEc(boolean isOnlyUpgradeSesInVnodeEc) {
        this.isOnlyUpgradeSesInVnodeEc = isOnlyUpgradeSesInVnodeEc;
    }

    public boolean isOnlyUpgradeSesInVnodeEc() {
        return this.isOnlyUpgradeSesInVnodeEc;
    }

    public List<UpgradeParamConstants.ModuleType> getFinishModules() {
        return this.finishModules;
    }

    public void setFinishModules(List<UpgradeParamConstants.ModuleType> finishModules) {
        this.finishModules = finishModules;
    }

    public void setOsStarted(boolean isOsStarted) {
        this.isOsStarted = isOsStarted;
    }

    public boolean isOsStarted() {
        return this.isOsStarted;
    }

    public boolean isPrecheckFinish() {
        return this.precheckFinish;
    }

    public void setPrecheckFinish(boolean precheckFinish) {
        this.precheckFinish = precheckFinish;
    }

    public static class FirmRebootResult {
        private String resultMsg = "";

        public String getResultMsg() {
            return this.resultMsg;
        }

        public boolean isSuccess() {
            return "".equals(this.resultMsg);
        }

        public void setResultMsg(String resultMsg) {
            this.resultMsg = resultMsg;
        }
    }

    public static class FirmUpgradeResult {
        String resultMsg = "";
        UpgradeParamConstants.FirmUpgradeStatus status;
        String firmwareUid;
        String fromVersion;
        String toVersion;
        FirmwarePackageEntity firmwarePackage;
        Boolean isSuccessVerify;
        boolean isActivated;

        public FirmwarePackageEntity getFirmwarePackage() {
            return this.firmwarePackage;
        }

        public void setFirmwarePackage(FirmwarePackageEntity firmwarePackage) {
            this.firmwarePackage = firmwarePackage;
        }

        public String getFromVersion() {
            return this.fromVersion == null ? "" : this.fromVersion;
        }

        public void setFromVersion(String fromVersion) {
            this.fromVersion = fromVersion;
        }

        public String getToVersion() {
            return this.toVersion == null ? "" : this.toVersion;
        }

        public void setToVersion(String toVersion) {
            this.toVersion = toVersion;
        }

        public String getFirmwareUid() {
            return this.firmwareUid;
        }

        public void setFirmwareUid(String firmwareUid) {
            this.firmwareUid = firmwareUid;
        }

        public boolean isSuc() {
            return this.status == UpgradeParamConstants.FirmUpgradeStatus.SUCCESS;
        }

        public String getResultMsg() {
            return this.resultMsg == null ? "" : this.resultMsg;
        }

        public void setResultMsg(String resultMsg) {
            this.resultMsg = resultMsg;
        }

        public UpgradeParamConstants.FirmUpgradeStatus getStatus() {
            return this.status;
        }

        public void setStatus(UpgradeParamConstants.FirmUpgradeStatus status) {
            this.status = status;
        }

        public Boolean isNeedVerify() {
            return this.isSuccessVerify == null && this.status.equals((Object)UpgradeParamConstants.FirmUpgradeStatus.SUCCESS) || this.isSuccessVerify == Boolean.FALSE && this.status.equals((Object)UpgradeParamConstants.FirmUpgradeStatus.FAILED);
        }

        public Boolean getSuccessVerify() {
            return this.isSuccessVerify;
        }

        public void setSuccessVerify(Boolean successVerify) {
            this.isSuccessVerify = successVerify;
        }
    }
}

