/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.entity.fusionstrg;

import com.huawei.ism.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanGeaPackageEntity {
    private static final Logger LOGGER = LoggerFactory.getLogger(PanGeaPackageEntity.class);
    private HashMap<String, List<Pair<String, List<String>>>> subModule = new HashMap();
    private HashMap<String, List<String>> modulesAsUidKey = new HashMap();

    public void addModuleWithUid(String uid, String module) {
        if (!this.modulesAsUidKey.containsKey(uid)) {
            this.modulesAsUidKey.put(uid, new ArrayList());
        }
        this.modulesAsUidKey.get(uid).add(module);
    }

    public List<String> getModulesWithUid(String uid) {
        return this.modulesAsUidKey.getOrDefault(uid.toLowerCase(Locale.ENGLISH), Collections.emptyList());
    }

    public List<String> getSubModuleDependence(String key, String name) {
        if (!this.subModule.containsKey(key)) {
            LOGGER.warn("Current pangea package not contains borderType {},try search in all", (Object)key);
            return this.getSubModuleDependence(name);
        }
        return this.getSubModuleDependence(this.subModule.get(key), name);
    }

    public List<String> getSubModuleDependence(String name) {
        LOGGER.info("Search submodule in all module.");
        ArrayList<Pair<String, List<String>>> pairList = new ArrayList<Pair<String, List<String>>>();
        this.subModule.values().forEach(pairList::addAll);
        return this.getSubModuleDependence(pairList, name);
    }

    private List<String> getSubModuleDependence(List<Pair<String, List<String>>> pairList, String name) {
        LOGGER.info("Find {} module's subModule", (Object)name);
        Optional<Pair> pairOpt = pairList.stream().filter(kv -> ((String)kv.getKey()).equals(name)).findFirst();
        if (!pairOpt.isPresent()) {
            LOGGER.info("Can not find {} module's subModule", (Object)name);
            return Collections.emptyList();
        }
        return (List)pairOpt.get().getValue();
    }

    public void addSubModuleDependence(String key, String name, List<String> dependence) {
        if (!this.subModule.containsKey(key)) {
            ArrayList pairList = new ArrayList();
            this.subModule.put(key, pairList);
        }
        this.subModule.get(key).add((Pair<String, List<String>>)new Pair((Object)name, dependence));
    }
}

