/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.model;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.huawei.bundleupgrade.constants.UpgradeParamConstants;
import com.huawei.bundleupgrade.entity.DeviceEntity;
import com.huawei.bundleupgrade.entity.DiskVersionEntity;
import com.huawei.bundleupgrade.entity.FirmwarePackageEntity;
import com.huawei.bundleupgrade.entity.UpgradeDeviceEntity;
import com.huawei.bundleupgrade.model.ModuleUpdateBySsh;
import com.huawei.bundleupgrade.service.connection.fusionstrg.FusionStorageSshConnector;
import com.huawei.bundleupgrade.service.connection.fusionstrg.FusionStorageSshPool;
import com.huawei.bundleupgrade.utils.BundleUpgradeContext;
import com.huawei.bundleupgrade.utils.ServiceUtil;
import com.huawei.bundleupgrade.utils.UpgradeConstants;
import com.huawei.bundleupgrade.utils.UpgradeCustomizationUtil;
import com.huawei.bundleupgrade.utils.UpgradeScenarioUtil;
import com.huawei.bundleupgrade.utils.fusionstrg.FusionStrgUpgradeContext;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.uMate.common.SystemConfig;
import com.huawei.uMate.common.UMateException;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DfsModule
extends ModuleUpdateBySsh {
    private static final Logger log = LoggerFactory.getLogger(DfsModule.class);
    private static final String NAME = UpgradeParamConstants.ModuleType.DFS.getModule();
    private static final String SUCCESS = "success";
    private static final int VERSION_INFO_ECHO_LINE_COUNT = 3;
    private static final String NOT_TARGET_VERSION = "notFound";

    @Override
    protected String getModuleName() {
        return NAME;
    }

    @Override
    public String getVersion(DeviceEntity device, FirmwarePackageEntity pkg) {
        if (device.getPanGeaInBandModuleVersion().containsKey(this.getModuleName())) {
            pkg.getPackageInfo().setVersion(device.getDriveTarVersion());
            return device.getPanGeaInBandModuleVersion().getOrDefault(this.getModuleName(), "--");
        }
        if (!this.isSupportM2DiskUpgrade(device)) {
            return "NOT_MATCH";
        }
        return this.getOriginVersion(device, pkg);
    }

    private boolean isSupportM2DiskUpgrade(DeviceEntity device) {
        if (UpgradeScenarioUtil.isYinglong()) {
            return false;
        }
        UpgradeDeviceEntity upgradeDevice = BundleUpgradeContext.getInstance().getDeviceNodeByIp(device.getIp());
        String productVer = ServiceUtil.getFSClusterVersion(upgradeDevice);
        String supportVersion = SystemConfig.createSystemConfig().getConfigVlaue("fw.m2.support.version");
        return Arrays.stream(supportVersion.trim().split(";")).anyMatch(productVer::contains);
    }

    public String getOriginVersion(DeviceEntity device, FirmwarePackageEntity pkg) {
        if (!UpgradeCustomizationUtil.canConnectOs(device)) {
            log.info("Node {} does not need to query the dfs info in the yinglong outBond  or directPlane", (Object)device.getIp());
            return "NOT_MATCH";
        }
        log.info("Node {} querying the dfs version by creating an SSH connection", (Object)device.getIp());
        return this.parseM2DiskVersion(device, this.getM2DisksInfo(device, pkg), pkg);
    }

    public String getOriginVersion(DeviceEntity device, FirmwarePackageEntity pkg, FusionStorageSshConnector ssh) {
        if (!UpgradeCustomizationUtil.canConnectOs(device)) {
            log.info("Node {} does not need to query the dfs info in the yinglong outBond  or directPlane", (Object)device.getIp());
            return "NOT_MATCH";
        }
        log.info("Node {} querying the dfs version by an existing SSH connection", (Object)device.getIp());
        return this.parseM2DiskVersion(device, this.getM2DisksInfoBySsh(device, pkg, ssh), pkg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DiskVersionEntity> getM2DisksInfo(DeviceEntity device, FirmwarePackageEntity pkg) {
        try {
            FusionStorageSshConnector ssh = FusionStorageSshPool.getFsSshConnectionByBmcIp(device.getIp());
            List<DiskVersionEntity> list = this.getM2DisksInfoBySsh(device, pkg, ssh);
            return list;
        }
        catch (UMateException e) {
            log.error("get ssh connector fail.", (Throwable)e);
            DialogUtils.showInfoDialog((Frame)((Object)BundleUpgradeContext.getInstance().getMainDialog()), (String)RES.getString("bundle.upgrade.match.ssh.error"));
        }
        finally {
            FusionStorageSshPool.releaseFsSshConnection(FusionStrgUpgradeContext.getInstance().getFsDeviceEntityByBmcIp(device.getIp()));
        }
        return Collections.emptyList();
    }

    private List<DiskVersionEntity> getM2DisksInfoBySsh(DeviceEntity device, FirmwarePackageEntity pkg, FusionStorageSshConnector ssh) {
        try {
            Optional<JSONObject> versionInfoOfJson = this.verifyAndToJson(this.getVersionResponse(pkg, ssh));
            if (!versionInfoOfJson.isPresent()) {
                log.error("parse node {} M2 disk version failed", (Object)device.getIp());
                return Collections.emptyList();
            }
            if (!SUCCESS.equals(versionInfoOfJson.get().getOrDefault((Object)"status", (Object)""))) {
                log.error("parse node {} M2 disk version failed error detail : {}", (Object)device.getIp(), versionInfoOfJson.get().getOrDefault((Object)"desc", (Object)""));
                return Collections.emptyList();
            }
            List<String> infos = Arrays.asList(versionInfoOfJson.get().getOrDefault((Object)"info", (Object)"").toString().split("\r|\n"));
            return infos.stream().map(info -> info.split(":")).filter(info -> ((String[])info).length == 5).map(this::buildDiskVersionEntity).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.error("execute ssh cmd fail", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private DiskVersionEntity buildDiskVersionEntity(String[] info) {
        return DiskVersionEntity.builder().sn(info[0]).module(info[1]).currentVersion(info[2]).targetVersion(info[3]).shouldResetActive("true".equals(info[4])).build();
    }

    private String parseM2DiskVersion(DeviceEntity device, List<DiskVersionEntity> infos, FirmwarePackageEntity pkg) {
        if (CollectionUtil.isEmpty(infos)) {
            return "NOT_MATCH";
        }
        ArrayList<String> tempCurVers = new ArrayList<String>();
        ArrayList<String> tempTarVers = new ArrayList<String>();
        for (DiskVersionEntity info : infos) {
            if (NOT_TARGET_VERSION.equalsIgnoreCase(info.getTargetVersion())) continue;
            tempCurVers.add(info.getCurrentVersionToShow());
            tempTarVers.add(info.getTargetVersionToShow());
            device.addM2DiskVersion(info);
        }
        String curVersion = String.join((CharSequence)";\r", tempCurVers);
        String tarVersion = String.join((CharSequence)";\r", tempTarVers);
        pkg.getPackageInfo().setVersion(tarVersion);
        device.getPanGeaInBandModuleVersion().put(this.getModuleName(), curVersion);
        device.setDriveTarVersion(tarVersion);
        return curVersion;
    }

    public Optional<JSONObject> verifyAndToJson(String response) {
        if (UpgradeConstants.NOT_MATCH_CMD_VERSION_RESPONSE.stream().anyMatch(response::contains)) {
            return Optional.empty();
        }
        List responses = Arrays.stream(response.split("\r\n")).filter(respon -> !StringUtils.isNULLStr((String)respon)).collect(Collectors.toList());
        if (responses.size() < 3) {
            return Optional.empty();
        }
        try {
            JSONObject versionInfoOfJson = JSON.parseObject((String)((String)responses.get(1)));
            return Optional.of(versionInfoOfJson);
        }
        catch (JSONException e) {
            log.error("parse M.2 version error", (Throwable)e);
            return Optional.empty();
        }
    }

    @Override
    public String verifyDeviceVersionAndFwVersion(DeviceEntity device, UpgradeDeviceEntity.FirmUpgradeResult result) {
        List<DiskVersionEntity> m2DiskInfos = this.getM2DisksInfo(device, result.getFirmwarePackage());
        ArrayList<String> failedDisk = new ArrayList<String>();
        ArrayList<String> tempCurVers = new ArrayList<String>();
        ArrayList<String> tempTarVers = new ArrayList<String>();
        for (DiskVersionEntity info : m2DiskInfos) {
            this.setVersionForReportAndVerify(device, failedDisk, tempCurVers, tempTarVers, info);
        }
        String curVersion = String.join((CharSequence)";\r", tempCurVers);
        String tarVersion = String.join((CharSequence)";\r", tempTarVers);
        device.getPanGeaInBandModuleVersion().put(this.getModuleName(), curVersion);
        return this.getErrorDetailSetResult(result, failedDisk, tarVersion);
    }

    private void setVersionForReportAndVerify(DeviceEntity device, List<String> failedDisk, List<String> curVers, List<String> tarVers, DiskVersionEntity info) {
        Optional<DiskVersionEntity> oldVersion = device.getM2DiskVersions().stream().filter(diskVer -> Objects.equals(diskVer.getSn(), info.getSn())).findFirst();
        if (oldVersion.isPresent()) {
            curVers.add(info.getCurrentVersionToShow());
            tarVers.add(String.join((CharSequence)" -> ", info.getCurrentVersionToShow(), oldVersion.get().getTargetVersion()));
            this.versionVerify(device, failedDisk, info, oldVersion.get());
        }
    }

    private void versionVerify(DeviceEntity device, List<String> failedDisk, DiskVersionEntity diskinfo, DiskVersionEntity oldDiskInfo) {
        if (!Objects.equals(diskinfo.getCurrentVersion(), oldDiskInfo.getTargetVersion())) {
            log.info("node: {} module M2 updated by ssh verify, disk esn {} , source version {} , target version {} ", new Object[]{device.getIp(), diskinfo.getSn(), diskinfo.getCurrentVersion(), oldDiskInfo.getTargetVersion()});
            failedDisk.add(diskinfo.getSn());
        }
    }

    private String getErrorDetailSetResult(UpgradeDeviceEntity.FirmUpgradeResult result, List<String> failedDisk, String tarVersion) {
        if (failedDisk.isEmpty()) {
            result.setResultMsg("");
            result.setToVersion(tarVersion);
            result.setStatus(UpgradeParamConstants.FirmUpgradeStatus.SUCCESS);
            result.setSuccessVerify(true);
            return "";
        }
        String failedMsg = String.join((CharSequence)",", failedDisk);
        String detail = RES.getStringWithParams("upgrade.disk.failed", new Object[]{failedMsg});
        result.setSuccessVerify(false);
        result.setResultMsg(detail);
        result.setToVersion(tarVersion);
        result.setStatus(UpgradeParamConstants.FirmUpgradeStatus.FAILED);
        return detail;
    }

    public static String combineVersion(String curVersion) {
        return Arrays.stream(curVersion.split(";\r")).map(singleVersion -> singleVersion.split(":")).filter(versionSplit -> ((String[])versionSplit).length > 1).map(versionSplit -> versionSplit[1]).distinct().collect(Collectors.joining(";"));
    }
}

