/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.model;

import com.huawei.bundleupgrade.constants.UpgradeParamConstants;
import com.huawei.bundleupgrade.entity.DeviceEntity;
import com.huawei.bundleupgrade.entity.FirmwarePackageEntity;
import com.huawei.bundleupgrade.entity.StrategySettingTableRowEntity;
import com.huawei.bundleupgrade.entity.UpgradeDeviceEntity;
import com.huawei.bundleupgrade.model.ModuleUpdateBySsh;
import com.huawei.bundleupgrade.service.connection.fusionstrg.FusionStorageSshConnector;
import com.huawei.bundleupgrade.service.connection.fusionstrg.FusionStorageSshPool;
import com.huawei.bundleupgrade.utils.BundleUpgradeContext;
import com.huawei.bundleupgrade.utils.UpgradeScenarioUtil;
import com.huawei.bundleupgrade.utils.VersionComparisonTools;
import com.huawei.bundleupgrade.utils.fusionstrg.FusionStrgUpgradeContext;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.uMate.common.UMateException;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DriveModule
extends ModuleUpdateBySsh {
    private static final Logger log = LoggerFactory.getLogger(DriveModule.class);
    private static final String NAME = UpgradeParamConstants.ModuleType.DRIVE.getModule();

    @Override
    protected String getModuleName() {
        return NAME;
    }

    @Override
    public String getVersion(DeviceEntity device, FirmwarePackageEntity pkg) {
        if (device.getPanGeaInBandModuleVersion().containsKey(this.getModuleName())) {
            pkg.getPackageInfo().setVersion(device.getDriveTarVersion());
            return device.getPanGeaInBandModuleVersion().getOrDefault(this.getModuleName(), "--");
        }
        return this.parseCurrentVersion(device, pkg, this.getOriginVersion(device, pkg));
    }

    private String parseCurrentVersion(DeviceEntity device, FirmwarePackageEntity pkg, String cmdResult) {
        if ("--".equals(cmdResult) || cmdResult.contains("NOT_MATCH")) {
            return cmdResult;
        }
        String[] diskInfos = cmdResult.split("\r|\n");
        ArrayList<String> targetVersions = new ArrayList<String>();
        ArrayList<String> currentVersions = new ArrayList<String>();
        for (String diskInfo : diskInfos) {
            String[] singleDiskInfo = diskInfo.split(":");
            if (singleDiskInfo.length < 4) continue;
            currentVersions.add(singleDiskInfo[0] + "," + singleDiskInfo[1] + ":" + singleDiskInfo[2]);
            targetVersions.add(singleDiskInfo[0] + "," + singleDiskInfo[1] + ":" + singleDiskInfo[3]);
        }
        String curVersion = currentVersions.stream().collect(Collectors.joining(";\r"));
        String tarVersion = targetVersions.stream().distinct().collect(Collectors.joining(";\r"));
        pkg.getPackageInfo().setVersion(tarVersion);
        device.getPanGeaInBandModuleVersion().put(this.getModuleName(), curVersion);
        device.setDriveTarVersion(tarVersion);
        return curVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getOriginVersion(DeviceEntity device, FirmwarePackageEntity pkg) {
        if (UpgradeScenarioUtil.isOutBound()) {
            log.info("End query when the scene is yinglong outBond");
            return "--";
        }
        if (device.isDirectPlane()) {
            log.info("End query when the device is a Direct Plane.");
            return "--";
        }
        try {
            FusionStorageSshConnector ssh = FusionStorageSshPool.getFsSshConnectionByBmcIp(device.getIp());
            String string = DriveModule.getDriverModelVersion(pkg, ssh);
            return string;
        }
        catch (UMateException e) {
            log.error("get ssh connector fail.", (Throwable)e);
            DialogUtils.showInfoDialog((Frame)((Object)BundleUpgradeContext.getInstance().getMainDialog()), (String)RES.getString("bundle.upgrade.match.ssh.error"));
            String string = "--";
            return string;
        }
        catch (Exception e) {
            log.error("execute ssh cmd fail", (Throwable)e);
            String string = "--";
            return string;
        }
        finally {
            FusionStorageSshPool.releaseFsSshConnection(FusionStrgUpgradeContext.getInstance().getFsDeviceEntityByBmcIp(device.getIp()));
        }
    }

    @Override
    public String verifyDeviceVersionAndFwVersion(DeviceEntity device, UpgradeDeviceEntity.FirmUpgradeResult result) {
        String cmdResult = this.getOriginVersion(device, result.getFirmwarePackage());
        String[] diskInfos = cmdResult.split("\r|\n");
        ArrayList<String> failedDisk = new ArrayList<String>();
        ArrayList<String> currentVersions = new ArrayList<String>();
        ArrayList<String> targetVersions = new ArrayList<String>();
        for (String diskInfo : diskInfos) {
            String[] singleDiskInfo = diskInfo.split(":");
            if (singleDiskInfo.length < 4) continue;
            currentVersions.add(singleDiskInfo[0] + "," + singleDiskInfo[1] + ":" + singleDiskInfo[2]);
            targetVersions.add(singleDiskInfo[0] + "," + singleDiskInfo[1] + ":" + singleDiskInfo[2] + " -> " + singleDiskInfo[3]);
            if (singleDiskInfo[2].equalsIgnoreCase(singleDiskInfo[3])) continue;
            log.info("node: {} module Drive updated by ssh verify, disk esn {} ,source version {} , target version {} ", new Object[]{device.getIp(), singleDiskInfo[0], singleDiskInfo[2], singleDiskInfo[3]});
            failedDisk.add(singleDiskInfo[0]);
        }
        String curVersion = currentVersions.stream().collect(Collectors.joining(";\r"));
        device.getPanGeaInBandModuleVersion().put(this.getModuleName(), curVersion);
        String tarVersion = targetVersions.stream().collect(Collectors.joining(";\r"));
        if (failedDisk.isEmpty()) {
            result.setResultMsg("");
            result.setToVersion(tarVersion);
            result.setStatus(UpgradeParamConstants.FirmUpgradeStatus.SUCCESS);
            result.setSuccessVerify(Boolean.TRUE);
            return "";
        }
        String failedMsg = failedDisk.stream().collect(Collectors.joining(","));
        String detail = RES.getStringWithParams("upgrade.disk.failed", new Object[]{failedMsg});
        result.setSuccessVerify(Boolean.FALSE);
        result.setResultMsg(detail);
        result.setToVersion(tarVersion);
        result.setStatus(UpgradeParamConstants.FirmUpgradeStatus.FAILED);
        return detail;
    }

    public static String combineVersion(String curVersion) {
        return Arrays.stream(curVersion.split(";\r")).map(singleVersion -> singleVersion.split(":")).filter(versionSplit -> ((String[])versionSplit).length > 1).map(versionSplit -> versionSplit[1]).distinct().collect(Collectors.joining(";"));
    }

    public String queryCurrentVersion(DeviceEntity device, FirmwarePackageEntity pkg, FusionStorageSshConnector ssh) throws Exception {
        String originResult = DriveModule.getDriverModelVersion(pkg, ssh);
        return this.parseCurrentVersion(device, pkg, originResult);
    }

    @Override
    public void setUpgradeExpectEffect(StrategySettingTableRowEntity tableRowEntity) {
        VersionComparisonTools.updateExpectEffect(tableRowEntity);
    }
}

