/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.model;

import com.huawei.bundleupgrade.constants.UpgradeParamConstants;
import com.huawei.bundleupgrade.entity.DeviceEntity;
import com.huawei.bundleupgrade.entity.FirmwarePackageEntity;
import com.huawei.bundleupgrade.entity.StrategySettingTableRowEntity;
import com.huawei.bundleupgrade.entity.UpgradeDeviceEntity;
import com.huawei.bundleupgrade.model.Module;
import com.huawei.bundleupgrade.utils.VersionComparisonTools;
import com.huawei.ism.tool.distributedfwupg.utils.CommonUtils;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EthCdrModule
extends Module {
    private static final Logger log = LoggerFactory.getLogger(EthCdrModule.class);
    private static final String MODULE_NAME = UpgradeParamConstants.ModuleType.ETH_CDR.getModule();

    @Override
    public List<StrategySettingTableRowEntity> matchAndCreateRow(DeviceEntity device, List<FirmwarePackageEntity> fwPackageList) {
        if (device.isDirectPlane() && Boolean.parseBoolean(CommonUtils.getSystemConfig("ignore.fw.eth.cdr.model", "true"))) {
            log.info("cuerernt node [{}] is DirectPlane ignore eth_cdr model upgrade", (Object)device.getIp());
            return Collections.emptyList();
        }
        return EthCdrModule.createMatchRows(device, fwPackageList, MODULE_NAME).stream().peek(row -> row.setMatch(row.isMatch() && !"--".equals(device.getEthCdrVersion()))).peek(row -> row.setCurrentVersion(this.getVersion(device))).collect(Collectors.toList());
    }

    public static String getName() {
        return MODULE_NAME;
    }

    @Override
    public String getVersion(DeviceEntity device) {
        return device.getEthCdrVersion();
    }

    @Override
    public String getVersion(DeviceEntity device, FirmwarePackageEntity pkg) {
        return this.getVersion(device);
    }

    @Override
    public String verifyDeviceVersionAndFwVersion(DeviceEntity device, UpgradeDeviceEntity.FirmUpgradeResult upgradeResult) {
        log.info("node: {} eth_cdr verify, device version {} , package version {} ", new Object[]{device.getIp(), this.getVersion(device), upgradeResult.getFirmwarePackage().getPackageInfo().getVersion()});
        return EthCdrModule.versionVerifyDetail(MODULE_NAME, this.getVersion(device), upgradeResult);
    }

    @Override
    public void setUpgradeExpectEffect(StrategySettingTableRowEntity tableRowEntity) {
        VersionComparisonTools.compareVersionByCommonWay(tableRowEntity);
    }
}

