/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.model;

import com.huawei.bundleupgrade.entity.UpgradeDeviceEntity;
import com.huawei.bundleupgrade.model.ExecuteResult;
import java.util.ArrayList;
import java.util.List;

public class ExecuteInfo {
    private List<ExecuteResult> results = new ArrayList<ExecuteResult>();

    public List<ExecuteResult> getResults() {
        return this.results;
    }

    public void setResults(List<ExecuteResult> results) {
        this.results = results;
    }

    public void addResult(ExecuteResult result) {
        ExecuteResult lastResult = this.getLastExecuteResult();
        if (lastResult.isSuccess() && lastResult.isRunning()) {
            lastResult.setRunning(false);
        }
        this.results.add(result);
        if (!result.isSuccess() || !lastResult.isSuccess()) {
            return;
        }
        if (lastResult.getDescription().equals(result.getDescription())) {
            this.results.remove(lastResult);
        }
        if (!result.isRunning()) {
            lastResult.setRunning(false);
        }
    }

    public int getTotalProgressByNode(UpgradeDeviceEntity node) {
        int div = node.getUpgradeParamsList().size();
        if (div == 0 || this.results.isEmpty()) {
            return 0;
        }
        int progress = 0;
        for (int i = this.results.size() - 1; i > 0; --i) {
            progress += this.results.get(i).getProgress();
        }
        return progress / div;
    }

    private ExecuteResult getLastExecuteResult() {
        if (this.results.isEmpty()) {
            ExecuteResult result = new ExecuteResult();
            result.setRunning(false);
            result.setProgress(0);
            return result;
        }
        return this.results.get(this.results.size() - 1);
    }

    public void clear() {
        this.results.clear();
    }

    public double getTotalProcess() {
        if (this.results.isEmpty()) {
            return 0.0;
        }
        for (int lastIndex = this.results.size() - 1; lastIndex >= 0; --lastIndex) {
            ExecuteResult lastResult = this.results.get(lastIndex);
            if (lastResult.isRunning()) continue;
            return lastResult.getTotalProgress();
        }
        return 0.0;
    }
}

