/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.model;

import com.huawei.bundleupgrade.constants.UpgradeParamConstants;
import com.huawei.bundleupgrade.entity.DeviceEntity;
import com.huawei.bundleupgrade.entity.ExpRetimer;
import com.huawei.bundleupgrade.entity.FirmwarePackageEntity;
import com.huawei.bundleupgrade.entity.RetimerTypeEnum;
import com.huawei.bundleupgrade.entity.StrategySettingTableRowEntity;
import com.huawei.bundleupgrade.entity.UpgradeDeviceEntity;
import com.huawei.bundleupgrade.model.Module;
import com.huawei.bundleupgrade.service.DeviceInfoByRedfishService;
import com.huawei.bundleupgrade.utils.BundleUpgradeContext;
import com.huawei.bundleupgrade.utils.VersionComparisonTools;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpRetimerModule
extends Module {
    private static final Logger log = LoggerFactory.getLogger(ExpRetimerModule.class);
    private static final String NAME = UpgradeParamConstants.ModuleType.PCIE_RETIMER.getModule();

    @Override
    public List<StrategySettingTableRowEntity> matchAndCreateRow(DeviceEntity device, List<FirmwarePackageEntity> fwPackages) {
        return ExpRetimerModule.filterPkgByModuleName(fwPackages, NAME).stream().map(pkg -> ExpRetimerModule.createMatchRow(device, pkg)).collect(Collectors.toList());
    }

    public static StrategySettingTableRowEntity createMatchRow(DeviceEntity device, FirmwarePackageEntity pkg) {
        StrategySettingTableRowEntity row = new StrategySettingTableRowEntity();
        String supportModelUid = pkg.getPackageInfo().getSupportModelUID().toLowerCase(Locale.ENGLISH);
        if (BundleUpgradeContext.isOnlineFirmware()) {
            row.setIsOnlineFirmwareMatch(ExpRetimerModule.isOnlineFwMatch(device, pkg, supportModelUid));
        }
        String version = device.getExpRetimerByType(RetimerTypeEnum.getRetimerTypeByKey(pkg.getPackageInfo().getRetimerId()));
        row.setMatch(ExpRetimerModule.isSupportModelUid(device, supportModelUid) && !"--".equals(version));
        row.setCurrentVersion(version);
        row.setStrategyComboBoxCell(ExpRetimerModule.getDefaultComboBoxCell());
        row.setModule(pkg.getPackageInfo().getModule());
        ExpRetimerModule.setTableRowCommonInfo(row, pkg);
        return row;
    }

    @Override
    public String getVersion(DeviceEntity device) {
        return device.getExpRetimerByType(RetimerTypeEnum.RETIMER_5902H);
    }

    @Override
    public String getVersion(DeviceEntity device, FirmwarePackageEntity pkg) {
        return device.getExpRetimerByType(RetimerTypeEnum.getRetimerTypeByKey(pkg.getPackageInfo().getRetimerId()));
    }

    @Override
    public boolean isFrameModule(DeviceEntity device) {
        return device.isPacific();
    }

    @Override
    public void updateVersion(DeviceEntity device) {
        log.info("Update {} version for {}.", (Object)NAME, (Object)device.getIp());
        try (DeviceInfoByRedfishService service = new DeviceInfoByRedfishService(device);){
            device.setExpRetimers(service.getExpRetimers(device));
        }
    }

    @Override
    public String verifyDeviceVersionAndFwVersion(DeviceEntity device, UpgradeDeviceEntity.FirmUpgradeResult upgradeResult) {
        String targetVersion = upgradeResult.getFirmwarePackage().getPackageInfo().getVersion();
        String retimerId = upgradeResult.getFirmwarePackage().getPackageInfo().getRetimerId();
        RetimerTypeEnum retimerType = RetimerTypeEnum.getRetimerTypeByKey(retimerId);
        List expRetimers = device.getExpRetimers().stream().filter(expRetimer -> retimerType.equals((Object)expRetimer.getRetimerTypeEnum())).collect(Collectors.toList());
        List failExpRetimers = expRetimers.stream().filter(expRetimer -> !expRetimer.getExpReTimerVersion().equalsIgnoreCase(targetVersion)).collect(Collectors.toList());
        if (failExpRetimers.isEmpty()) {
            upgradeResult.setResultMsg("");
            upgradeResult.setToVersion(targetVersion);
            upgradeResult.setStatus(UpgradeParamConstants.FirmUpgradeStatus.SUCCESS);
            upgradeResult.setSuccessVerify(Boolean.TRUE);
            return "";
        }
        String failedMsg = failExpRetimers.stream().map(ExpRetimer::toString).collect(Collectors.joining("\n"));
        String detail = RES.getStringWithParams("upgrade.retimer.failed", new Object[]{failedMsg});
        upgradeResult.setSuccessVerify(Boolean.FALSE);
        upgradeResult.setResultMsg(detail);
        upgradeResult.setToVersion(targetVersion);
        upgradeResult.setStatus(UpgradeParamConstants.FirmUpgradeStatus.FAILED);
        return detail;
    }

    @Override
    public void setUpgradeExpectEffect(StrategySettingTableRowEntity tableRowEntity) {
        VersionComparisonTools.compareVersionExpRetimer(tableRowEntity);
    }
}

