/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.model;

import com.huawei.bundleupgrade.constants.UpgradeParamConstants;
import com.huawei.bundleupgrade.entity.DeviceEntity;
import com.huawei.bundleupgrade.entity.FirmwarePackageEntity;
import com.huawei.bundleupgrade.entity.StrategySettingTableRowEntity;
import com.huawei.bundleupgrade.model.Module;
import com.huawei.ism.tool.base.utils.StringUtils;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HddModule
extends Module {
    private static final Logger LOGGER = LoggerFactory.getLogger(HddModule.class);
    private static final String NAME = UpgradeParamConstants.ModuleType.HDD.getModule();

    @Override
    @NotNull
    public String getVersion(@NotNull DeviceEntity device, @NotNull FirmwarePackageEntity pkg) {
        String currentVer = device.getDiskInfo().stream().filter(disk -> disk.getModel().equalsIgnoreCase(pkg.getPackageInfo().getSupportModel())).map(disk -> disk.getEsn() + ":" + disk.getFirmwareVersion()).collect(Collectors.joining(";"));
        return StringUtils.isNULLStr((String)currentVer) ? "--" : currentVer;
    }

    @Override
    public List<StrategySettingTableRowEntity> matchAndCreateRow(DeviceEntity device, List<FirmwarePackageEntity> fwPackages) {
        return this.filterPkgByModuleName(fwPackages).stream().map(pkg -> this.createMatchRow(device, (FirmwarePackageEntity)pkg)).collect(Collectors.toList());
    }

    private List<FirmwarePackageEntity> filterPkgByModuleName(List<FirmwarePackageEntity> fwPackages) {
        LOGGER.info("start to match {}.", (Object)NAME);
        return fwPackages.stream().filter(fw -> fw.getPackageInfo().getModule().equals(NAME)).collect(Collectors.toList());
    }

    private StrategySettingTableRowEntity createMatchRow(DeviceEntity device, FirmwarePackageEntity pkg) {
        StrategySettingTableRowEntity row = new StrategySettingTableRowEntity();
        row.setMatch(this.isSupportFw(device, pkg));
        row.setStrategyComboBoxCell(HddModule.getDefaultComboBoxCell());
        row.setModule(pkg.getPackageInfo().getModule());
        row.setCurrentVersion(this.getVersion(device, pkg));
        HddModule.setTableRowCommonInfo(row, pkg);
        return row;
    }

    private boolean isSupportFw(DeviceEntity device, FirmwarePackageEntity pkg) {
        return device.getDiskInfo().stream().anyMatch(disk -> pkg.getPackageInfo().getSupportModel().equalsIgnoreCase(disk.getModel()));
    }

    @Override
    public List<DeviceEntity.DiskModel> filterSupportDisk(DeviceEntity device, FirmwarePackageEntity pkg) {
        List<DeviceEntity.DiskModel> disks = device.getDiskInfo();
        return disks.stream().filter(disk -> disk.getModel().equalsIgnoreCase(pkg.getPackageInfo().getSupportModel())).collect(Collectors.toList());
    }
}

