/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.model;

import com.huawei.bundleupgrade.constants.UpgradeParamConstants;
import com.huawei.bundleupgrade.entity.DeviceEntity;
import com.huawei.bundleupgrade.entity.DiskPkgInfo;
import com.huawei.bundleupgrade.entity.FirmwarePackageEntity;
import com.huawei.bundleupgrade.entity.StrategySettingTableRowEntity;
import com.huawei.bundleupgrade.entity.UpgradeDeviceEntity;
import com.huawei.bundleupgrade.model.ModuleUpdateBySsh;
import com.huawei.bundleupgrade.service.DeviceInfoByRedfishService;
import com.huawei.bundleupgrade.service.connection.fusionstrg.FusionStorageSshConnector;
import com.huawei.bundleupgrade.utils.BundleUpgradeContext;
import com.huawei.bundleupgrade.utils.ScriptExecuteUtil;
import com.huawei.bundleupgrade.utils.UpgradeConstants;
import com.huawei.bundleupgrade.utils.UpgradeScenarioUtil;
import com.huawei.bundleupgrade.utils.VersionComparisonTools;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.uMate.common.SystemConfig;
import com.huawei.uMate.common.UMateException;
import com.huawei.uMate.common.utils.ResUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Module {
    private static final Logger log = LoggerFactory.getLogger(Module.class);
    protected static final ResUtil RES = ResUtil.getInstance((String)"BundleUpgrade");
    private static final String CELL_VALUE_DEFAULT = "bundle.upgrade.param.strategy.table.cell.default";
    private static final String CELL_VALUE_UPGRADE = "bundle.upgrade.param.strategy.table.cell.upgrade";
    private static final String CELL_VALUE_DEMOTION = "bundle.upgrade.param.strategy.table.cell.demotion";
    private static final Object LOCK = new Object();

    public static List<FirmwarePackageEntity> filterPkgByModuleName(List<FirmwarePackageEntity> fwPackageList, String module) {
        log.info("start to match {}.", (Object)module);
        return fwPackageList.stream().filter(fw -> fw.getPackageInfo().getModule().equalsIgnoreCase(module)).filter(fw -> !fw.getPackageInfo().getVersion().contains(RES.getString("bundle.upgrade.type.panel.local.not.support"))).collect(Collectors.toList());
    }

    public static List<StrategySettingTableRowEntity> createMatchRows(DeviceEntity device, List<FirmwarePackageEntity> fwPackageList, String module) {
        return Module.filterPkgByModuleName(fwPackageList, module).stream().map(pkg -> Module.createMatchRow(device, pkg)).collect(Collectors.toList());
    }

    protected static void setTableRowCommonInfo(StrategySettingTableRowEntity tableRowEntity, FirmwarePackageEntity fwEntity) {
        tableRowEntity.setSupportModel(fwEntity.getPackageInfo().getSupportModel());
        tableRowEntity.setSupportModelUid(fwEntity.getPackageInfo().getSupportModelUID());
        tableRowEntity.setObject(fwEntity.getPackageInfo().getObject());
        tableRowEntity.setObjectId(fwEntity.getPackageInfo().getObjectID());
        tableRowEntity.setActiveMode(fwEntity.getPackageInfo().getActiveMode());
        tableRowEntity.setTargetVersion(fwEntity.getPackageInfo().getVersion());
        tableRowEntity.setUpgradeAgent(fwEntity.getPackageInfo().getUpgradeAgent());
        tableRowEntity.setFwPackageName(fwEntity.getPackageInfo().getPackageName());
        tableRowEntity.setFirmwarePackageEntity(fwEntity);
    }

    private static StrategySettingTableRowEntity createMatchRow(DeviceEntity device, FirmwarePackageEntity pkg) {
        StrategySettingTableRowEntity row = new StrategySettingTableRowEntity();
        String supportModelUID = pkg.getPackageInfo().getSupportModelUID();
        if (BundleUpgradeContext.isOnlineFirmware()) {
            row.setIsOnlineFirmwareMatch(Module.isOnlineFwMatch(device, pkg, supportModelUID));
        }
        row.setMatch(Module.isSupportModelUid(device, supportModelUID));
        row.setStrategyComboBoxCell(Module.getDefaultComboBoxCell());
        row.setModule(pkg.getPackageInfo().getModule());
        Module.setTableRowCommonInfo(row, pkg);
        return row;
    }

    protected static boolean isSupportModelUid(DeviceEntity device, String supportModelUID) {
        return supportModelUID.toLowerCase().contains(device.getProductUniqueId().toLowerCase()) || supportModelUID.toLowerCase().contains("all");
    }

    protected static IsmTableCell.ComboBoxCell getDefaultComboBoxCell() {
        Object[] comboValues = new String[]{RES.getString(CELL_VALUE_DEFAULT), RES.getString(CELL_VALUE_UPGRADE), RES.getString(CELL_VALUE_DEMOTION)};
        IsmTableCell.ComboBoxCell cell = new IsmTableCell.ComboBoxCell(comboValues, (Object)RES.getString(CELL_VALUE_DEFAULT));
        cell.getComboBox().setName("strategy_out_band_comboBox");
        return cell;
    }

    protected static boolean isOnlineFwMatch(DeviceEntity device, FirmwarePackageEntity fwEntity, String supportModelUID) {
        return supportModelUID.toLowerCase().contains(device.getProductUniqueId().toLowerCase()) && fwEntity.isProductNameOrAllMatchOnlineFirmware(device);
    }

    public static String getPanGeaInBandVersionOnServer(FirmwarePackageEntity fwEntity, FusionStorageSshConnector ssh) throws Exception {
        String versionCmd = fwEntity.getInterfaceInfo().getGetVersionCmd();
        String cmdResponse = Module.uploadAndInitCmd(fwEntity, ssh, versionCmd);
        log.info("Remove temporary files from the environment.");
        ssh.executeCmd(UpgradeConstants.CMD_RM_LOG_AND_PACKAGE, false);
        return Module.getPanGeaInBandVerFromResponse(cmdResponse);
    }

    public static String getDriverModelVersion(FirmwarePackageEntity fwEntity, FusionStorageSshConnector ssh) throws Exception {
        String versionCmd = fwEntity.getInterfaceInfo().getGetVersionCmd();
        String cmdResponse = Module.uploadAndInitCmd(fwEntity, ssh, versionCmd);
        ssh.executeCmd(UpgradeConstants.CMD_RM_LOG_AND_PACKAGE);
        return Module.getDriverVersionFromResponse(cmdResponse, versionCmd);
    }

    public String getVersionResponse(FirmwarePackageEntity fwEntity, FusionStorageSshConnector ssh) throws Exception {
        String versionCmd = fwEntity.getInterfaceInfo().getGetVersionCmd();
        String cmdResponse = Module.uploadAndInitCmd(fwEntity, ssh, versionCmd);
        ssh.executeCmd(UpgradeConstants.CMD_RM_LOG_AND_PACKAGE);
        return cmdResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String uploadAndInitCmd(FirmwarePackageEntity fwEntity, FusionStorageSshConnector ssh, String versionCmd) throws IOException, UMateException {
        String uploadScript = fwEntity.getInterfaceInfo().getUploadScript();
        if ("all".equals(uploadScript)) {
            log.info("Begin read {} and write to server", (Object)fwEntity.getPackageInfo().getPackageName());
            return Module.uploadFileAndInitCmd(fwEntity, ssh, versionCmd);
        }
        if (uploadScript == null) {
            return Module.executeVersionCmd(ssh, "", versionCmd);
        }
        log.info("Begin read {} and write to server", (Object)uploadScript);
        String scriptFileName = new File(fwEntity.getLocalPathAbs()).getParent() + File.separator + fwEntity.getPackageInfo().getModule().trim() + File.separator + uploadScript;
        File file = new File(scriptFileName);
        if (file.exists()) {
            file.delete();
        }
        Object object = LOCK;
        synchronized (object) {
            Module.extractUploadScriptAsFile(fwEntity.getLocalPathAbs(), uploadScript, scriptFileName);
        }
        String scriptToServer = UpgradeConstants.PAN_GEA_PACKAGE_UPLOAD_PATH + '/' + uploadScript;
        ssh.mkdirs(UpgradeConstants.PAN_GEA_PACKAGE_UPLOAD_PATH);
        ssh.uploadFile(scriptToServer, scriptFileName, true);
        return Module.executeVersionCmd(ssh, UpgradeConstants.PAN_GEA_PACKAGE_UPLOAD_PATH, versionCmd);
    }

    private static String uploadFileAndInitCmd(FirmwarePackageEntity fwEntity, FusionStorageSshConnector ssh, String versionCmd) throws IOException, UMateException {
        String upGrade = fwEntity.getLocalPathAbs();
        String fileName = new File(upGrade).getName();
        String targetFile = UpgradeConstants.PAN_GEA_PACKAGE_UPLOAD_PATH + '/' + fileName;
        ssh.mkdirs(UpgradeConstants.PAN_GEA_PACKAGE_UPLOAD_PATH);
        ssh.uploadFile(targetFile, upGrade, true);
        String unzipPath = Module.getUnzipPath(fileName);
        try {
            unzipPath = Module.executeUnzip(ScriptExecuteUtil.needUnzipTwice(fwEntity), ssh, targetFile, unzipPath);
        }
        catch (Exception e) {
            log.error("upload pangea in band package fail", (Throwable)e);
        }
        return Module.executeVersionCmd(ssh, unzipPath, versionCmd);
    }

    private static String executeUnzip(boolean isNeedUnzipTwice, FusionStorageSshConnector ssh, String targetFile, String unzipPath) throws Exception {
        if (!isNeedUnzipTwice) {
            String unzipCmd = String.format(Locale.ENGLISH, "unzip -qo %s -d %s", targetFile, unzipPath);
            ssh.executeCmd(unzipCmd, false);
            log.info("Perform a single decompression operation,to File:{}", (Object)new File(unzipPath).getName());
            return unzipPath;
        }
        return ScriptExecuteUtil.unzipTwice(ssh, targetFile, unzipPath);
    }

    private static String executeVersionCmd(FusionStorageSshConnector ssh, String unzipPath, String versionCmd) {
        try {
            ssh.executeCmd(String.format(Locale.ENGLISH, "cd %s", unzipPath), false);
            log.info("Begin execute ssh cmd: {} for obtaining the version information", (Object)versionCmd);
            String response = ssh.executeCmd(versionCmd);
            ssh.executeCmd(String.format(Locale.ENGLISH, "cd %s", Character.valueOf('/')));
            return response;
        }
        catch (Exception e) {
            log.error(" execute cd to path and getVersion fail", (Throwable)e);
            return "";
        }
    }

    private static String getUnzipPath(String fileName) {
        return UpgradeConstants.PAN_GEA_PACKAGE_UPLOAD_PATH + "/" + fileName.split("\\.")[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractUploadScriptAsFile(String zipPath, String fileName, String localFile) throws IOException {
        ZipFile zipFile = new ZipFile(zipPath, StandardCharsets.UTF_8);
        ZipEntry entry = zipFile.getEntry(fileName);
        File localFileDir = new File(localFile).getParentFile();
        if (!localFileDir.exists()) {
            localFileDir.mkdirs();
        }
        try (InputStream input = zipFile.getInputStream(entry);
             BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(localFile));){
            int len;
            byte[] buffer = new byte[1024];
            while ((len = input.read(buffer)) != -1) {
                out.write(buffer, 0, len);
            }
            out.flush();
        }
        finally {
            zipFile.close();
        }
    }

    private static String getPanGeaInBandVerFromResponse(String cmdResponse) {
        String noVersion = "--";
        List<String> resultList = Arrays.asList(cmdResponse.split("\n"));
        if (resultList.size() < 2) {
            return noVersion;
        }
        String cmdStr = resultList.get(0);
        List<String> validList = resultList.subList(1, resultList.size() - 1);
        if (validList.isEmpty()) {
            return noVersion;
        }
        String validStr = String.join((CharSequence)"\n", resultList);
        for (String notMatchStr : UpgradeConstants.NOT_MATCH_CMD_VERSION_RESPONSE) {
            if (!validStr.contains(notMatchStr)) continue;
            return noVersion;
        }
        List verList = validList.stream().filter(verStr -> !verStr.contains(cmdStr)).collect(Collectors.toList());
        if (verList.size() == 1) {
            return ((String)verList.get(0)).replace("\r", "");
        }
        ArrayList<String> versions = new ArrayList<String>();
        for (String verStr2 : verList) {
            if (verStr2.startsWith("/")) {
                verStr2 = verStr2.substring(1, verStr2.length() - 1);
            }
            verStr2 = verStr2.replace(" ", "");
            versions.add(verStr2);
        }
        return String.join((CharSequence)" ", versions);
    }

    public static String getDriverVersionFromResponse(String cmdResponse, String versionCmd) {
        if (UpgradeConstants.NOT_MATCH_CMD_VERSION_RESPONSE.stream().anyMatch(cmdResponse::contains)) {
            return "--";
        }
        List<String> results = Arrays.asList(cmdResponse.split("\n"));
        if (results.size() < 2) {
            return "--";
        }
        List versions = results.subList(1, results.size() - 1).stream().filter(verStr -> !verStr.contains(versionCmd)).map(String::trim).collect(Collectors.toList());
        if (versions.isEmpty()) {
            return "--";
        }
        return String.join((CharSequence)"\r", versions);
    }

    public String getVersion(DeviceEntity device) {
        return "--";
    }

    public abstract String getVersion(DeviceEntity var1, FirmwarePackageEntity var2);

    public String verifyDeviceVersionAndFwVersion(DeviceEntity device, UpgradeDeviceEntity.FirmUpgradeResult upgradeResult) {
        return "";
    }

    public abstract List<StrategySettingTableRowEntity> matchAndCreateRow(DeviceEntity var1, List<FirmwarePackageEntity> var2);

    String queryVersion() {
        return "--";
    }

    public void updateVersion(DeviceEntity entity) {
        log.info("Update module version empty impl.");
    }

    public boolean isFrameModule(DeviceEntity device) {
        return false;
    }

    public void setUpgradeExpectEffect(StrategySettingTableRowEntity tableRowEntity) {
        tableRowEntity.setExpectEffect(UpgradeParamConstants.UpgradeExpectEffect.UPGRADE);
    }

    public static String versionVerifyDetail(String module, String currentVersion, UpgradeDeviceEntity.FirmUpgradeResult result) {
        String targetVersion = result.getFirmwarePackage().getPackageInfo().getVersion();
        if (currentVersion.equalsIgnoreCase(targetVersion)) {
            result.setResultMsg("");
            result.setToVersion(currentVersion);
            result.setStatus(UpgradeParamConstants.FirmUpgradeStatus.SUCCESS);
            result.setSuccessVerify(Boolean.TRUE);
            return "";
        }
        String detail = RES.getStringWithParams("bundle.upgrade.verify.device.firmware.version.error", new Object[]{module, currentVersion, targetVersion});
        result.setSuccessVerify(Boolean.FALSE);
        result.setResultMsg(detail);
        result.setToVersion(currentVersion);
        result.setStatus(UpgradeParamConstants.FirmUpgradeStatus.FAILED);
        return detail;
    }

    public void setFromVersion(UpgradeDeviceEntity upgradeDevice, UpgradeDeviceEntity.FirmUpgradeResult firmUpgradeResult) {
        FirmwarePackageEntity pkg = firmUpgradeResult.getFirmwarePackage();
        List<DeviceEntity.DiskModel> diskModels = this.filterSupportDisk(upgradeDevice.getDeviceEntity(), pkg);
        firmUpgradeResult.setFromVersion(this.getDiskModuleMinVersion(diskModels));
    }

    public String getDiskModuleMinVersion(List<DeviceEntity.DiskModel> diskModels) {
        return diskModels.stream().map(DeviceEntity.DiskModel::getFirmwareVersion).reduce(UpgradeScenarioUtil::getMinVersion).orElse("");
    }

    public List<DeviceEntity.DiskModel> filterSupportDisk(DeviceEntity device, FirmwarePackageEntity pkg) {
        return Collections.emptyList();
    }

    public static class UnSupportModule
    extends Module {
        private static final String NAME = "unknown";

        @Override
        public String getVersion(DeviceEntity device, FirmwarePackageEntity pkg) {
            return "--";
        }

        @Override
        public List<StrategySettingTableRowEntity> matchAndCreateRow(DeviceEntity device, List<FirmwarePackageEntity> fwPackageList) {
            return Collections.emptyList();
        }

        public static String getName() {
            return NAME;
        }
    }

    public static class Sp
    extends Module {
        private static final String NAME = UpgradeParamConstants.ModuleType.SP.getModule();

        @Override
        public String getVersion(DeviceEntity device) {
            return device.getSpVersion();
        }

        @Override
        public String getVersion(DeviceEntity device, FirmwarePackageEntity pkg) {
            return this.getVersion(device);
        }

        @Override
        public List<StrategySettingTableRowEntity> matchAndCreateRow(DeviceEntity device, List<FirmwarePackageEntity> fwPackageList) {
            return Collections.emptyList();
        }

        public StrategySettingTableRowEntity matchAndCreateRow(DeviceEntity device, FirmwarePackageEntity fwPackage) {
            StrategySettingTableRowEntity matchRow = this.createMatchRow(device, fwPackage);
            matchRow.setCurrentVersion(this.getVersion(device));
            return matchRow;
        }

        @Override
        private StrategySettingTableRowEntity createMatchRow(DeviceEntity device, FirmwarePackageEntity pkg) {
            StrategySettingTableRowEntity row = new StrategySettingTableRowEntity();
            row.setMatch(this.isSameArchitecture(device, pkg));
            row.setStrategyComboBoxCell(this.getExecuteUpgradeComboBoxCell());
            row.setModule(pkg.getPackageInfo().getModule());
            Sp.setTableRowCommonInfo(row, pkg);
            row.setTargetVersion(pkg.getPackageInfo().getVersion());
            return row;
        }

        private IsmTableCell.ComboBoxCell getExecuteUpgradeComboBoxCell() {
            Object[] comboValues = new String[]{RES.getString(Module.CELL_VALUE_DEMOTION)};
            IsmTableCell.ComboBoxCell cell = new IsmTableCell.ComboBoxCell(comboValues, (Object)RES.getString(Module.CELL_VALUE_DEMOTION));
            cell.getComboBox().setName("strategy_out_band_comboBox");
            return cell;
        }

        private boolean isSameArchitecture(DeviceEntity device, FirmwarePackageEntity pkg) {
            return pkg.getPackageInfo().getProcessorArchitecture().toLowerCase(Locale.ENGLISH).contains(device.getProcessorArchitecture().toLowerCase(Locale.ENGLISH));
        }

        @Override
        public String verifyDeviceVersionAndFwVersion(DeviceEntity device, UpgradeDeviceEntity.FirmUpgradeResult upgradeResult) {
            FirmwarePackageEntity pkg = upgradeResult.getFirmwarePackage();
            String targetVersion = upgradeResult.getToVersion();
            String currentVersion = device.getSpVersion();
            List failList = Arrays.stream(currentVersion.split("/")).filter(version -> !version.trim().equalsIgnoreCase(targetVersion)).collect(Collectors.toList());
            if (!failList.isEmpty()) {
                return RES.getStringWithParams("bundle.upgrade.check.sp.failed", new Object[]{currentVersion, targetVersion});
            }
            return "";
        }

        public static String getName() {
            return NAME;
        }
    }

    public static class DmiKnl
    extends ModuleUpdateBySsh {
        private static final String NAME = UpgradeParamConstants.ModuleType.DMI_KNL.getModule();

        @Override
        protected String getModuleName() {
            return NAME;
        }

        @Override
        public void setUpgradeExpectEffect(StrategySettingTableRowEntity tableRowEntity) {
            VersionComparisonTools.compareVersionByCommonWay(tableRowEntity);
        }
    }

    public static class SsdSp
    extends Module {
        private static final String NAME = UpgradeParamConstants.ModuleType.SSD_SP.getModule();

        @Override
        public String getVersion(DeviceEntity device) {
            String currentVer = device.getDiskInfo().stream().map(disk -> disk.getEsn() + ":" + disk.getFirmwareVersion()).collect(Collectors.joining(";"));
            return StringUtils.isNULLStr((String)currentVer) ? "--" : currentVer;
        }

        @Override
        public String getVersion(DeviceEntity device, FirmwarePackageEntity pkg) {
            return this.getVersion(device);
        }

        @Override
        public List<StrategySettingTableRowEntity> matchAndCreateRow(DeviceEntity device, List<FirmwarePackageEntity> fwPackageList) {
            return this.filterPkgByModuleName(fwPackageList).stream().map(pkg -> this.createMatchRow(device, (FirmwarePackageEntity)pkg)).peek(row -> row.setCurrentVersion(this.getVersion(device))).collect(Collectors.toList());
        }

        private List<FirmwarePackageEntity> filterPkgByModuleName(List<FirmwarePackageEntity> fwPackageList) {
            log.info("start to match {}.", (Object)NAME);
            return fwPackageList.stream().filter(fw -> fw.getPackageInfo().getModule().contains(NAME)).collect(Collectors.toList());
        }

        @Override
        private StrategySettingTableRowEntity createMatchRow(DeviceEntity device, FirmwarePackageEntity pkg) {
            StrategySettingTableRowEntity row = new StrategySettingTableRowEntity();
            row.setMatch(this.hasSupportFw(device, pkg) && this.hasSignature(pkg));
            row.setStrategyComboBoxCell(SsdSp.getDefaultComboBoxCell());
            row.setModule(pkg.getPackageInfo().getModule());
            SsdSp.setTableRowCommonInfo(row, pkg);
            row.setTargetVersion(this.getTargetVersion(device, pkg.getDiskPkgInfos()));
            return row;
        }

        private String getTargetVersion(DeviceEntity device, List<DiskPkgInfo> diskPackages) {
            List<DeviceEntity.DiskModel> disks = device.getDiskInfo();
            Map<String, DiskPkgInfo> diskMap = diskPackages.stream().collect(Collectors.toMap(DiskPkgInfo::getUid, pkg -> pkg));
            String targetVer = disks.stream().map(disk -> (DiskPkgInfo)diskMap.get(disk.getSupportModelUID())).filter(Objects::nonNull).map(DiskPkgInfo::getTargetVersion).distinct().collect(Collectors.joining(";"));
            return StringUtils.isNULLStr((String)targetVer) ? "NOT_MATCH" : targetVer;
        }

        private boolean hasSignature(FirmwarePackageEntity pkg) {
            return pkg.getPackageInfo().getModule().equals(NAME);
        }

        private boolean hasSupportFw(DeviceEntity device, FirmwarePackageEntity pkg) {
            return device.getDiskInfo().stream().anyMatch(disk -> pkg.getDiskPkgInfos().stream().anyMatch(diskPkg -> diskPkg.getUid().equalsIgnoreCase(disk.getSupportModelUID())));
        }

        @Override
        public String verifyDeviceVersionAndFwVersion(DeviceEntity device, UpgradeDeviceEntity.FirmUpgradeResult upgradeResult) {
            FirmwarePackageEntity pkg = upgradeResult.getFirmwarePackage();
            String targetVersion = pkg.getPackageInfo().getVersion();
            List<DeviceEntity.DiskModel> diskModels = this.filterSupportDisk(device, pkg);
            List failedDisk = diskModels.stream().filter(disk -> !disk.getFirmwareVersion().equalsIgnoreCase(targetVersion)).collect(Collectors.toList());
            if (failedDisk.isEmpty()) {
                return "";
            }
            String failedMsg = failedDisk.stream().map(DeviceEntity.DiskModel::getEsn).collect(Collectors.toList()).toString();
            return RES.getStringWithParams("upgrade.disk.failed", new Object[]{failedMsg});
        }

        @Override
        public List<DeviceEntity.DiskModel> filterSupportDisk(DeviceEntity device, FirmwarePackageEntity pkg) {
            List<DeviceEntity.DiskModel> disks = device.getDiskInfo();
            return disks.stream().filter(disk -> pkg.getDiskPkgInfos().stream().anyMatch(diskPkg -> diskPkg.getUid().equalsIgnoreCase(disk.getSupportModelUID()))).collect(Collectors.toList());
        }

        public static String getName() {
            return NAME;
        }

        @Override
        public void setUpgradeExpectEffect(StrategySettingTableRowEntity tableRowEntity) {
            VersionComparisonTools.compareSsdSp(tableRowEntity);
        }
    }

    public static class Gloun
    extends ModuleUpdateBySsh {
        private static final String NAME = UpgradeParamConstants.ModuleType.GLOUN.getModule();

        @Override
        protected String getModuleName() {
            return NAME;
        }

        @Override
        public void setUpgradeExpectEffect(StrategySettingTableRowEntity tableRowEntity) {
            VersionComparisonTools.compareGlounVersion(tableRowEntity);
        }
    }

    public static class DiskFw
    extends Module {
        private static final String NAME = UpgradeParamConstants.ModuleType.DISK_FW.getModule();

        @Override
        public List<StrategySettingTableRowEntity> matchAndCreateRow(DeviceEntity device, List<FirmwarePackageEntity> fwPackageList) {
            return DiskFw.filterPkgByModuleName(fwPackageList, NAME).stream().map(pkg -> this.createMatchRow(device, (FirmwarePackageEntity)pkg)).peek(row -> row.setCurrentVersion(this.getVersion(device))).collect(Collectors.toList());
        }

        @Override
        private StrategySettingTableRowEntity createMatchRow(DeviceEntity device, FirmwarePackageEntity pkg) {
            StrategySettingTableRowEntity row = new StrategySettingTableRowEntity();
            row.setMatch(this.isSupportUid(device, pkg) && this.hasSupportFw(device, pkg));
            row.setStrategyComboBoxCell(DiskFw.getDefaultComboBoxCell());
            row.setModule(pkg.getPackageInfo().getModule());
            DiskFw.setTableRowCommonInfo(row, pkg);
            row.setTargetVersion(this.getTargetVersion(device, pkg.getDiskPkgInfos()));
            return row;
        }

        private String getTargetVersion(DeviceEntity device, List<DiskPkgInfo> diskPackages) {
            List<DeviceEntity.DiskModel> disks = device.getDiskInfo();
            Map diskMap = diskPackages.stream().collect(Collectors.toMap(DiskPkgInfo::getUid, Function.identity()));
            return disks.stream().map(disk -> this.getTargetFw(diskMap, (DeviceEntity.DiskModel)disk)).filter(Objects::nonNull).map(DiskPkgInfo::getTargetVersion).distinct().collect(Collectors.joining(";"));
        }

        private DiskPkgInfo getTargetFw(Map<String, DiskPkgInfo> diskMap, DeviceEntity.DiskModel disk) {
            return diskMap.getOrDefault(disk.getSupportModelUidForMultichannelDisk(), diskMap.get(disk.getSupportModelUID()));
        }

        private boolean isSupportUid(DeviceEntity device, FirmwarePackageEntity pkg) {
            if (!Boolean.parseBoolean(SystemConfig.createSystemConfig().getConfigVlaue("disk.fw.limit"))) {
                log.info("Ignore disk fw uid limit.");
                return true;
            }
            return pkg.getPackageInfo().getSupportModelUID().toLowerCase(Locale.ENGLISH).contains(device.getProductUniqueId().toLowerCase(Locale.ENGLISH));
        }

        private boolean hasSupportFw(DeviceEntity device, FirmwarePackageEntity pkg) {
            return device.getDiskInfo().stream().anyMatch(disk -> this.hasSupportFw(pkg, (DeviceEntity.DiskModel)disk));
        }

        private boolean hasSupportFw(FirmwarePackageEntity pkg, DeviceEntity.DiskModel disk) {
            return pkg.getDiskPkgInfos().stream().anyMatch(diskPkg -> diskPkg.getUid().equalsIgnoreCase(disk.getSupportModelUidForMultichannelDisk()) || diskPkg.getUid().equalsIgnoreCase(disk.getSupportModelUID()));
        }

        public static String getName() {
            return NAME;
        }

        @Override
        public String getVersion(DeviceEntity device) {
            return device.getDiskInfo().stream().map(disk -> disk.getEsn() + ":" + disk.getFirmwareVersion()).collect(Collectors.joining(";"));
        }

        @Override
        public String getVersion(DeviceEntity device, FirmwarePackageEntity pkg) {
            return this.getVersion(device);
        }

        @Override
        public String verifyDeviceVersionAndFwVersion(DeviceEntity device, UpgradeDeviceEntity.FirmUpgradeResult upgradeResult) {
            return "";
        }

        public static Map<String, DiskPkgInfo> buildDiskUidMap(List<DiskPkgInfo> diskPkgInfos) {
            return diskPkgInfos.stream().collect(Collectors.toMap(DiskPkgInfo::getUid, Function.identity()));
        }

        public static Optional<DiskPkgInfo> findDiskInfo(Map<String, DiskPkgInfo> diskUidMap, DeviceEntity.DiskModel disk) {
            return Optional.ofNullable(diskUidMap.getOrDefault(disk.getSupportModelUidForMultichannelDisk(), diskUidMap.get(disk.getSupportModelUID())));
        }

        public static boolean canUpgrade(Map<String, DiskPkgInfo> updateUid2FwPkg, DeviceEntity.DiskModel disk) {
            Optional<DiskPkgInfo> fwInfo = DiskFw.findDiskInfo(updateUid2FwPkg, disk);
            return fwInfo.filter(diskPkgInfo -> !DiskFw.isSameVersion(disk, diskPkgInfo)).isPresent();
        }

        private static boolean isSameVersion(DeviceEntity.DiskModel disk, DiskPkgInfo diskPkgInfo) {
            if (disk.getFirmwareVersion().equalsIgnoreCase(diskPkgInfo.getTargetVersion())) {
                log.info("Disk,SN: {} MODEL: {} curver {} equals targetver {},No upgrade required.", new Object[]{disk.getEsn(), disk.getModel(), disk.getFirmwareVersion(), diskPkgInfo.getTargetVersion()});
                return true;
            }
            return false;
        }

        @Override
        public void setUpgradeExpectEffect(StrategySettingTableRowEntity tableRowEntity) {
            VersionComparisonTools.compareDiskFw(tableRowEntity);
        }
    }

    public static class Psu
    extends Module {
        private static final String NAME = UpgradeParamConstants.ModuleType.PSU.getModule();

        @Override
        public List<StrategySettingTableRowEntity> matchAndCreateRow(DeviceEntity device, List<FirmwarePackageEntity> fwPackageList) {
            return Psu.filterPkgByModuleName(fwPackageList, NAME).stream().map(pkg -> this.createMatchRow(device, (FirmwarePackageEntity)pkg)).collect(Collectors.toList());
        }

        @Override
        private StrategySettingTableRowEntity createMatchRow(DeviceEntity device, FirmwarePackageEntity pkg) {
            StrategySettingTableRowEntity row = new StrategySettingTableRowEntity();
            List<DeviceEntity.PsuModel> psuModels = this.getMatchedPsu(pkg, device.getPsuModels());
            row.setModule(pkg.getPackageInfo().getModule());
            row.setMatch(!psuModels.isEmpty());
            if (row.isMatch() && BundleUpgradeContext.isOnlineFirmware()) {
                row.setIsOnlineFirmwareMatch(pkg.isProductNameOrAllMatchOnlineFirmware(device));
            }
            String versions = psuModels.stream().map(DeviceEntity.PsuModel::getPsuVersion).collect(Collectors.joining(";"));
            row.setCurrentVersion(row.isMatch() ? versions : "--");
            row.setStrategyComboBoxCell(Psu.getDefaultComboBoxCell());
            Psu.setTableRowCommonInfo(row, pkg);
            return row;
        }

        private List<DeviceEntity.PsuModel> getMatchedPsu(FirmwarePackageEntity fwEntity, List<DeviceEntity.PsuModel> psuModels) {
            String supportModelUID = fwEntity.getPackageInfo().getSupportModelUID().toLowerCase(Locale.ENGLISH);
            return psuModels.stream().filter(psuModel -> supportModelUID.contains(psuModel.getSupportModelUID().toLowerCase(Locale.ENGLISH))).collect(Collectors.toList());
        }

        @Override
        public String getVersion(DeviceEntity device) {
            return device.getPsuModels().stream().map(DeviceEntity.PsuModel::getPsuVersion).collect(Collectors.joining(";"));
        }

        @Override
        public String getVersion(DeviceEntity device, FirmwarePackageEntity pkg) {
            return this.getVersion(device);
        }

        public static String getName() {
            return NAME;
        }

        @Override
        public boolean isFrameModule(DeviceEntity device) {
            return device.isTwoOceans() || device.isEastSeaDoubleServer();
        }

        @Override
        public void updateVersion(DeviceEntity device) {
            log.info("Update {} version for {}.", (Object)NAME, (Object)device.getIp());
            try (DeviceInfoByRedfishService service = new DeviceInfoByRedfishService(device);){
                device.setPsuModels(service.getPsuModeList(device));
            }
        }

        @Override
        public String verifyDeviceVersionAndFwVersion(DeviceEntity device, UpgradeDeviceEntity.FirmUpgradeResult upgradeResult) {
            List<DeviceEntity.PsuModel> matchedModel = this.getMatchedPsu(upgradeResult.getFirmwarePackage(), device.getPsuModels());
            String psuModelVersions = matchedModel.stream().map(DeviceEntity.PsuModel::getPsuVersion).distinct().collect(Collectors.joining(";"));
            log.info("node: {} psu verify, device version {} , package version {} ", new Object[]{device.getIp(), psuModelVersions, upgradeResult.getFirmwarePackage().getPackageInfo().getVersion()});
            return Psu.versionVerifyDetail(NAME, psuModelVersions, upgradeResult);
        }

        @Override
        public void setUpgradeExpectEffect(StrategySettingTableRowEntity tableRowEntity) {
            VersionComparisonTools.comparePsuVersion(tableRowEntity);
        }
    }

    public static class Cpld
    extends CpldMain {
        private static final String NAME = UpgradeParamConstants.ModuleType.CPLD.getModule();

        @Override
        public List<StrategySettingTableRowEntity> matchAndCreateRow(DeviceEntity device, List<FirmwarePackageEntity> fwPackageList) {
            return Cpld.filterPkgByModuleName(fwPackageList, NAME).stream().map(pkg -> this.createMatchRow(device, (FirmwarePackageEntity)pkg)).collect(Collectors.toList());
        }

        @Override
        protected boolean getCpldMatchedResult(FirmwarePackageEntity fwEntity, DeviceEntity device, StrategySettingTableRowEntity tableRowEntity) {
            String supportModelUID = fwEntity.getPackageInfo().getSupportModelUID().toLowerCase();
            List<DeviceEntity.CpldModel> cpldModels = device.getCpldModels();
            tableRowEntity.setCurrentVersion("--");
            if (!supportModelUID.contains(device.getProductUniqueId().toLowerCase(Locale.ENGLISH))) {
                return false;
            }
            List<DeviceEntity.CpldModel> matchModels = this.filterMatchedCpld(fwEntity, cpldModels);
            if (matchModels.isEmpty()) {
                return false;
            }
            tableRowEntity.setCurrentVersion(this.mapCpldVersion2Str(matchModels));
            UpgradeParamConstants.ModuleType module = "MainBoard".equals(matchModels.get(0).getDeviceType()) ? UpgradeParamConstants.ModuleType.CPLD_MAIN : UpgradeParamConstants.ModuleType.CPLD;
            tableRowEntity.setModule(module.getModule());
            return true;
        }

        private String mapCpldVersion2Str(List<DeviceEntity.CpldModel> matchModels) {
            return matchModels.stream().map(DeviceEntity.CpldModel::getCpldVersion).collect(Collectors.joining(";"));
        }

        private List<DeviceEntity.CpldModel> filterMatchedCpld(FirmwarePackageEntity fwEntity, List<DeviceEntity.CpldModel> cpldModels) {
            return cpldModels.stream().filter(model -> this.matchCpldModel(fwEntity, (DeviceEntity.CpldModel)model)).collect(Collectors.toList());
        }

        @Override
        public String getVersion(DeviceEntity device) {
            return device.getCpldModels().stream().filter(cpldModel -> !"MainBoard".equals(cpldModel.getDeviceType())).map(DeviceEntity.CpldModel::getCpldVersion).collect(Collectors.joining(";"));
        }

        public static String getName() {
            return NAME;
        }

        @Override
        public String verifyDeviceVersionAndFwVersion(DeviceEntity device, UpgradeDeviceEntity.FirmUpgradeResult upgradeResult) {
            Optional<DeviceEntity.CpldModel> cpldModelOptional = device.getCpldModels().stream().filter(model -> upgradeResult.getFirmwarePackage().getPackageInfo().getObjectID().toLowerCase(Locale.ENGLISH).contains(model.getBoardId().toLowerCase(Locale.ENGLISH))).findFirst();
            if (!cpldModelOptional.isPresent()) {
                log.error("node: {} cpld verify is empty ", (Object)device.getIp());
                return "";
            }
            DeviceEntity.CpldModel cpldModel = cpldModelOptional.get();
            log.info("node: {} cpld verify, device version {} , package version {} ", new Object[]{device.getIp(), cpldModel.getCpldVersion(), upgradeResult.getFirmwarePackage().getPackageInfo().getVersion()});
            return Cpld.versionVerifyDetail(NAME, cpldModel.getCpldVersion(), upgradeResult);
        }
    }

    public static class CpldMain
    extends Module {
        private static final String NAME = UpgradeParamConstants.ModuleType.CPLD_MAIN.getModule();

        @Override
        public List<StrategySettingTableRowEntity> matchAndCreateRow(DeviceEntity device, List<FirmwarePackageEntity> fwPackageList) {
            return CpldMain.filterPkgByModuleName(fwPackageList, NAME).stream().map(pkg -> this.createMatchRow(device, (FirmwarePackageEntity)pkg)).collect(Collectors.toList());
        }

        @Override
        StrategySettingTableRowEntity createMatchRow(DeviceEntity device, FirmwarePackageEntity pkg) {
            StrategySettingTableRowEntity row = new StrategySettingTableRowEntity();
            if (BundleUpgradeContext.isOnlineFirmware()) {
                row.setIsOnlineFirmwareMatch(this.isCpldMatchOnlineFirmware(device, pkg, row));
            }
            row.setModule(pkg.getPackageInfo().getModule());
            row.setMatch(this.getCpldMatchedResult(pkg, device, row));
            row.setStrategyComboBoxCell(CpldMain.getDefaultComboBoxCell());
            CpldMain.setTableRowCommonInfo(row, pkg);
            return row;
        }

        @Override
        public String getVersion(DeviceEntity device) {
            if (device.isSpecificDevice()) {
                return device.getActiveCPLDVersion();
            }
            return device.getCpldModels().stream().filter(cpld -> "MainBoard".equals(cpld.getDeviceType())).map(DeviceEntity.CpldModel::getCpldVersion).collect(Collectors.joining(";"));
        }

        @Override
        public String getVersion(DeviceEntity device, FirmwarePackageEntity pkg) {
            return this.getVersion(device);
        }

        boolean isCpldMatchOnlineFirmware(DeviceEntity device, FirmwarePackageEntity fwEntity, StrategySettingTableRowEntity tableRowEntity) {
            return this.getCpldMatchedResult(fwEntity, device, tableRowEntity) && fwEntity.isProductNameOrAllMatchOnlineFirmware(device);
        }

        boolean getCpldMatchedResult(FirmwarePackageEntity fwEntity, DeviceEntity device, StrategySettingTableRowEntity tableRowEntity) {
            String supportModelUID = fwEntity.getPackageInfo().getSupportModelUID().toLowerCase();
            List<DeviceEntity.CpldModel> cpldModels = device.getCpldModels();
            tableRowEntity.setCurrentVersion("--");
            if (!supportModelUID.contains(device.getProductUniqueId().toLowerCase(Locale.ENGLISH))) {
                return false;
            }
            if (device.isSpecificDevice()) {
                tableRowEntity.setCurrentVersion(device.getActiveCPLDVersion());
                return true;
            }
            List matchModels = cpldModels.stream().filter(model -> this.matchCpldModel(fwEntity, (DeviceEntity.CpldModel)model)).collect(Collectors.toList());
            if (!matchModels.isEmpty()) {
                String versions = matchModels.stream().map(DeviceEntity.CpldModel::getCpldVersion).collect(Collectors.joining(";"));
                tableRowEntity.setCurrentVersion(versions);
                return true;
            }
            return false;
        }

        boolean matchCpldModel(FirmwarePackageEntity fwEntity, DeviceEntity.CpldModel cpldModel) {
            String objectId = fwEntity.getPackageInfo().getObjectID();
            String object = fwEntity.getPackageInfo().getObject();
            String boardId = cpldModel.getBoardId();
            String boardName = cpldModel.getBoardName();
            return !StringUtils.isNULLStr((String)boardId) && !StringUtils.isNULLStr((String)objectId) && objectId.toLowerCase().contains(cpldModel.getBoardId()) || !StringUtils.isNULLStr((String)boardName) && !StringUtils.isNULLStr((String)object) && object.contains(cpldModel.getBoardName());
        }

        public static String getName() {
            return NAME;
        }

        @Override
        public String verifyDeviceVersionAndFwVersion(DeviceEntity device, UpgradeDeviceEntity.FirmUpgradeResult upgradeResult) {
            log.info("node: {} cpld_main verify, device version {} , package version {} ", new Object[]{device.getIp(), this.getVersion(device), upgradeResult.getFirmwarePackage().getPackageInfo().getVersion()});
            return CpldMain.versionVerifyDetail(NAME, this.getVersion(device), upgradeResult);
        }

        @Override
        public void setUpgradeExpectEffect(StrategySettingTableRowEntity tableRowEntity) {
            VersionComparisonTools.compareVersionByCommonWay(tableRowEntity);
        }
    }

    public static class Fan
    extends Module {
        private static final String NAME = UpgradeParamConstants.ModuleType.FAN.getModule();

        @Override
        public List<StrategySettingTableRowEntity> matchAndCreateRow(DeviceEntity device, List<FirmwarePackageEntity> fwPackageList) {
            return Fan.createMatchRows(device, fwPackageList, NAME).stream().peek(row -> row.setMatch(row.isMatch() && !"--".equals(device.getFanVersion()))).peek(row -> row.setCurrentVersion(this.getVersion(device))).collect(Collectors.toList());
        }

        public static String getName() {
            return NAME;
        }

        @Override
        public String getVersion(DeviceEntity device) {
            return device.getFanVersion();
        }

        @Override
        public String getVersion(DeviceEntity device, FirmwarePackageEntity pkg) {
            return this.getVersion(device);
        }

        @Override
        public boolean isFrameModule(DeviceEntity device) {
            return device.isPacific();
        }

        @Override
        public void updateVersion(DeviceEntity device) {
            log.info("Update {} version for {}.", (Object)NAME, (Object)device.getIp());
            try (DeviceInfoByRedfishService service = new DeviceInfoByRedfishService(device);){
                device.setFanVersion(service.getFanVersion(device));
            }
        }

        @Override
        public String verifyDeviceVersionAndFwVersion(DeviceEntity device, UpgradeDeviceEntity.FirmUpgradeResult upgradeResult) {
            String versions = Arrays.stream(this.getVersion(device).split(";")).distinct().collect(Collectors.joining(";"));
            log.info("node: {} fan verify, device version {} , package version {} ", new Object[]{device.getIp(), versions, upgradeResult.getFirmwarePackage().getPackageInfo().getVersion()});
            return Fan.versionVerifyDetail(NAME, versions, upgradeResult);
        }

        @Override
        public void setUpgradeExpectEffect(StrategySettingTableRowEntity tableRowEntity) {
            VersionComparisonTools.compareVersionByCommonWay(tableRowEntity);
        }
    }

    public static class RdmaX86
    extends ModuleUpdateBySsh {
        private static final String NAME = UpgradeParamConstants.ModuleType.RDMA_X86.getModule();

        @Override
        protected String getModuleName() {
            return NAME;
        }

        @Override
        public void setUpgradeExpectEffect(StrategySettingTableRowEntity tableRowEntity) {
            VersionComparisonTools.updateExpectEffect(tableRowEntity);
        }
    }

    public static class RdmaArm
    extends ModuleUpdateBySsh {
        private static final String NAME = UpgradeParamConstants.ModuleType.RDMA_ARM.getModule();

        @Override
        protected String getModuleName() {
            return NAME;
        }

        @Override
        public void setUpgradeExpectEffect(StrategySettingTableRowEntity tableRowEntity) {
            VersionComparisonTools.updateExpectEffect(tableRowEntity);
        }
    }

    public static class ES3000
    extends Module {
        private static final String NAME = UpgradeParamConstants.ModuleType.ES3000.getModule();

        @Override
        public List<StrategySettingTableRowEntity> matchAndCreateRow(DeviceEntity device, List<FirmwarePackageEntity> fwPackageList) {
            return ES3000.filterPkgByModuleName(fwPackageList, NAME).stream().map(pkg -> this.createMatchRow(device, (FirmwarePackageEntity)pkg)).collect(Collectors.toList());
        }

        @Override
        private StrategySettingTableRowEntity createMatchRow(DeviceEntity device, FirmwarePackageEntity pkg) {
            StrategySettingTableRowEntity row = new StrategySettingTableRowEntity();
            row.setMatch(this.hasSupportFw(device, pkg));
            row.setStrategyComboBoxCell(ES3000.getDefaultComboBoxCell());
            row.setModule(pkg.getPackageInfo().getModule());
            row.setCurrentVersion(this.getVersion(device, pkg));
            ES3000.setTableRowCommonInfo(row, pkg);
            return row;
        }

        private boolean hasSupportFw(DeviceEntity device, FirmwarePackageEntity pkg) {
            return !this.filterSupportDisk(device, pkg).isEmpty();
        }

        @Override
        public List<DeviceEntity.DiskModel> filterSupportDisk(DeviceEntity device, FirmwarePackageEntity pkg) {
            List<DeviceEntity.DiskModel> disks = device.getDiskInfo();
            String supportModelPrefix = pkg.getPackageInfo().getSupportModelUID();
            List<String> supportUids = !StringUtils.isNULLStr((String)supportModelPrefix) ? Arrays.asList(pkg.getPackageInfo().getSupportModelUID().split("/")) : UpgradeConstants.HUAWEI_NVME_MODEL_NAME;
            return disks.stream().filter(disk -> supportUids.stream().anyMatch(disk::modelStartsWith)).collect(Collectors.toList());
        }

        public static String getName() {
            return NAME;
        }

        @Override
        public String getVersion(DeviceEntity device) {
            return device.getDiskInfo().stream().map(disk -> disk.getEsn() + ":" + disk.getFirmwareVersion()).collect(Collectors.joining(";"));
        }

        @Override
        public String getVersion(DeviceEntity device, FirmwarePackageEntity pkg) {
            return this.filterSupportDisk(device, pkg).stream().map(disk -> disk.getEsn() + ":" + disk.getFirmwareVersion()).collect(Collectors.joining(";"));
        }

        @Override
        public String verifyDeviceVersionAndFwVersion(DeviceEntity device, UpgradeDeviceEntity.FirmUpgradeResult upgradeResult) {
            FirmwarePackageEntity pkg = upgradeResult.getFirmwarePackage();
            String targetVersion = pkg.getPackageInfo().getVersion();
            List failedDisk = this.filterSupportDisk(device, pkg).stream().filter(disk -> !disk.getFirmwareVersion().equalsIgnoreCase(targetVersion)).collect(Collectors.toList());
            if (failedDisk.isEmpty()) {
                return "";
            }
            String failedMsg = failedDisk.stream().map(DeviceEntity.DiskModel::getEsn).collect(Collectors.toList()).toString();
            return RES.getStringWithParams("upgrade.disk.failed", new Object[]{failedMsg});
        }

        @Override
        public void setUpgradeExpectEffect(StrategySettingTableRowEntity tableRowEntity) {
            VersionComparisonTools.compareES3000(tableRowEntity);
        }
    }

    public static class BaseKnl
    extends Module {
        private static final String NAME = UpgradeParamConstants.ModuleType.BASE_KNL.getModule();

        public static boolean isCurrentLowerThanTarget(String current, String target) {
            return !current.equals(target);
        }

        @Override
        public String getVersion(DeviceEntity device) {
            return device.getPanGeaInBandModuleVersion().getOrDefault(NAME, "--");
        }

        @Override
        public String getVersion(DeviceEntity device, FirmwarePackageEntity pkg) {
            return this.getVersion(device);
        }

        @Override
        public List<StrategySettingTableRowEntity> matchAndCreateRow(DeviceEntity device, List<FirmwarePackageEntity> fwPackageList) {
            return Collections.emptyList();
        }

        @Override
        public void setUpgradeExpectEffect(StrategySettingTableRowEntity tableRowEntity) {
            VersionComparisonTools.compareBaseKnl(tableRowEntity);
        }
    }

    public static class Bbu
    extends Module {
        private static final String NAME = UpgradeParamConstants.ModuleType.BBU.getModule();

        @Override
        public List<StrategySettingTableRowEntity> matchAndCreateRow(DeviceEntity device, List<FirmwarePackageEntity> fwPackageList) {
            return Bbu.filterPkgByModuleName(fwPackageList, NAME).stream().map(pkg -> this.createMatchRow(device, (FirmwarePackageEntity)pkg)).peek(row -> row.setCurrentVersion(this.getVersion(device))).collect(Collectors.toList());
        }

        @Override
        private StrategySettingTableRowEntity createMatchRow(DeviceEntity device, FirmwarePackageEntity pkg) {
            StrategySettingTableRowEntity row = new StrategySettingTableRowEntity();
            String supportModelUID = pkg.getPackageInfo().getSupportModelUID().toLowerCase();
            boolean match = device.getBbuModels().stream().anyMatch(module -> supportModelUID.contains(module.getSupportModelUID().toLowerCase(Locale.ENGLISH)));
            if (BundleUpgradeContext.isOnlineFirmware()) {
                row.setIsOnlineFirmwareMatch(match);
            }
            row.setMatch(match);
            row.setStrategyComboBoxCell(Bbu.getDefaultComboBoxCell());
            row.setModule(pkg.getPackageInfo().getModule());
            Bbu.setTableRowCommonInfo(row, pkg);
            return row;
        }

        public static String getName() {
            return NAME;
        }

        @Override
        public String getVersion(DeviceEntity device) {
            return device.getBbuModel();
        }

        @Override
        public String getVersion(DeviceEntity device, FirmwarePackageEntity pkg) {
            return this.getVersion(device);
        }

        @Override
        public String verifyDeviceVersionAndFwVersion(DeviceEntity device, UpgradeDeviceEntity.FirmUpgradeResult upgradeResult) {
            String supportModelUID = upgradeResult.getFirmwarePackage().getPackageInfo().getSupportModelUID().toLowerCase(Locale.ENGLISH);
            String deviceBbuVersion = device.getBbuModels().stream().filter(psuModel -> supportModelUID.contains(psuModel.getSupportModelUID().toLowerCase(Locale.ENGLISH))).map(DeviceEntity.BbuModel::getBbuVersion).distinct().collect(Collectors.joining(";"));
            log.info("node: {} bbu verify, device version {} , package version {} ", new Object[]{device.getIp(), deviceBbuVersion, upgradeResult.getFirmwarePackage().getPackageInfo().getVersion()});
            return Bbu.versionVerifyDetail(NAME, deviceBbuVersion, upgradeResult);
        }

        @Override
        public void setUpgradeExpectEffect(StrategySettingTableRowEntity tableRowEntity) {
            VersionComparisonTools.compareVersionByCommonWay(tableRowEntity);
        }
    }

    public static class Cdr
    extends Module {
        private static final String NAME = UpgradeParamConstants.ModuleType.CDR.getModule();

        @Override
        public List<StrategySettingTableRowEntity> matchAndCreateRow(DeviceEntity device, List<FirmwarePackageEntity> fwPackageList) {
            return Cdr.createMatchRows(device, fwPackageList, NAME).stream().peek(row -> row.setCurrentVersion(this.getVersion(device))).collect(Collectors.toList());
        }

        public static String getName() {
            return NAME;
        }

        @Override
        public String getVersion(DeviceEntity device) {
            return device.getCdrVersion();
        }

        @Override
        public String getVersion(DeviceEntity device, FirmwarePackageEntity pkg) {
            return this.getVersion(device);
        }

        @Override
        public String verifyDeviceVersionAndFwVersion(DeviceEntity device, UpgradeDeviceEntity.FirmUpgradeResult upgradeResult) {
            log.info("node: {} Cdr verify, device version {} , package version {} ", new Object[]{device.getIp(), this.getVersion(device), upgradeResult.getFirmwarePackage().getPackageInfo().getVersion()});
            return Cdr.versionVerifyDetail(NAME, this.getVersion(device), upgradeResult);
        }

        @Override
        public void setUpgradeExpectEffect(StrategySettingTableRowEntity tableRowEntity) {
            VersionComparisonTools.compareVersionByCommonWay(tableRowEntity);
        }
    }

    public static class Bios
    extends Module {
        private static final String NAME = UpgradeParamConstants.ModuleType.BIOS.getModule();

        @Override
        public List<StrategySettingTableRowEntity> matchAndCreateRow(DeviceEntity device, List<FirmwarePackageEntity> fwPackageList) {
            return Bios.createMatchRows(device, fwPackageList, NAME).stream().peek(row -> {
                if (Bios.isIobBios(row.getFwPackageName())) {
                    row.setCurrentVersion(device.getIobBiosVersion());
                } else {
                    row.setCurrentVersion(device.getBiosVersion());
                }
            }).collect(Collectors.toList());
        }

        public static String getName() {
            return NAME;
        }

        @Override
        public String getVersion(DeviceEntity device) {
            return device.getBiosVersion();
        }

        @Override
        public String getVersion(DeviceEntity device, FirmwarePackageEntity targetFwPkg) {
            if (Bios.isIobBios(targetFwPkg.getPackageInfo().getFileName())) {
                log.info("node: {} iob-bios, device version {} , package version {} ", new Object[]{device.getIp(), device.getIobBiosVersion(), targetFwPkg.getPackageInfo().getVersion()});
                return device.getIobBiosVersion();
            }
            log.info("node: {} bios, device version {} , package version {} ", new Object[]{device.getIp(), this.getVersion(device), targetFwPkg.getPackageInfo().getVersion()});
            return device.getBiosVersion();
        }

        @Override
        public String verifyDeviceVersionAndFwVersion(DeviceEntity device, UpgradeDeviceEntity.FirmUpgradeResult upgradeResult) {
            return Bios.versionVerifyDetail(NAME, this.getVersion(device, upgradeResult.getFirmwarePackage()), upgradeResult);
        }

        private static boolean isIobBios(String upgradeResult) {
            return upgradeResult.toLowerCase(Locale.ENGLISH).contains("iob");
        }

        @Override
        public void setUpgradeExpectEffect(StrategySettingTableRowEntity tableRowEntity) {
            VersionComparisonTools.updateExpectEffect(tableRowEntity);
        }
    }

    public static class Bmc
    extends Module {
        private static final String NAME = UpgradeParamConstants.ModuleType.iBMC.getModule();

        @Override
        public List<StrategySettingTableRowEntity> matchAndCreateRow(DeviceEntity device, List<FirmwarePackageEntity> fwPackageList) {
            return Bmc.createMatchRows(device, fwPackageList, NAME).stream().peek(row -> row.setCurrentVersion(this.getVersion(device))).collect(Collectors.toList());
        }

        public static String getName() {
            return NAME;
        }

        @Override
        public String getVersion(DeviceEntity device) {
            return device.getMasterBMC();
        }

        @Override
        public String getVersion(DeviceEntity device, FirmwarePackageEntity pkg) {
            return this.getVersion(device);
        }

        @Override
        public String verifyDeviceVersionAndFwVersion(DeviceEntity device, UpgradeDeviceEntity.FirmUpgradeResult upgradeResult) {
            log.info("node: {} ibmc verify, device version {} , package version {} ", new Object[]{device.getIp(), this.getVersion(device), upgradeResult.getFirmwarePackage().getPackageInfo().getVersion()});
            return Bmc.versionVerifyDetail(NAME, this.getVersion(device), upgradeResult);
        }

        @Override
        public void setUpgradeExpectEffect(StrategySettingTableRowEntity tableRowEntity) {
            VersionComparisonTools.compareVersionByCommonWay(tableRowEntity);
        }
    }

    public static class Mcu
    extends Module {
        private static final String NAME = UpgradeParamConstants.ModuleType.MCU.getModule();

        @Override
        public List<StrategySettingTableRowEntity> matchAndCreateRow(DeviceEntity device, List<FirmwarePackageEntity> fwPackageList) {
            return Mcu.createMatchRows(device, fwPackageList, NAME).stream().peek(row -> row.setCurrentVersion(this.getVersion(device))).collect(Collectors.toList());
        }

        public static String getName() {
            return NAME;
        }

        @Override
        public String getVersion(DeviceEntity device) {
            return device.getMcuVersion();
        }

        @Override
        public String getVersion(DeviceEntity device, FirmwarePackageEntity pkg) {
            return this.getVersion(device);
        }

        @Override
        public String verifyDeviceVersionAndFwVersion(DeviceEntity device, UpgradeDeviceEntity.FirmUpgradeResult upgradeResult) {
            log.info("node: {} mcu verify, device version {} , package version {} ", new Object[]{device.getIp(), this.getVersion(device), upgradeResult.getFirmwarePackage().getPackageInfo().getVersion()});
            return Mcu.versionVerifyDetail(NAME, this.getVersion(device), upgradeResult);
        }

        @Override
        public void setUpgradeExpectEffect(StrategySettingTableRowEntity tableRowEntity) {
            VersionComparisonTools.compareVersionByCommonWay(tableRowEntity);
        }
    }
}

