/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.model;

import com.huawei.bundleupgrade.entity.DeviceEntity;
import com.huawei.bundleupgrade.entity.FirmwarePackageEntity;
import com.huawei.bundleupgrade.entity.StrategySettingTableRowEntity;
import com.huawei.bundleupgrade.entity.UpgradeDeviceEntity;
import com.huawei.bundleupgrade.model.Module;
import com.huawei.bundleupgrade.service.connection.fusionstrg.FusionStorageSshConnector;
import com.huawei.bundleupgrade.service.connection.fusionstrg.FusionStorageSshPool;
import com.huawei.bundleupgrade.utils.BundleUpgradeContext;
import com.huawei.bundleupgrade.utils.UpgradeScenarioUtil;
import com.huawei.bundleupgrade.utils.fusionstrg.FusionStrgUpgradeContext;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.uMate.common.UMateException;
import com.huawei.uMate.common.utils.ResUtil;
import java.awt.Frame;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ModuleUpdateBySsh
extends Module {
    private static final Logger log = LoggerFactory.getLogger(ModuleUpdateBySsh.class);
    protected static final ResUtil RES = ResUtil.getInstance((String)"BundleUpgrade");

    protected abstract String getModuleName();

    @Override
    public List<StrategySettingTableRowEntity> matchAndCreateRow(DeviceEntity device, List<FirmwarePackageEntity> fwPackageList) {
        return ModuleUpdateBySsh.filterPkgByModuleName(fwPackageList, this.getModuleName()).stream().map(pkg -> this.createMatchRow(device, (FirmwarePackageEntity)pkg)).collect(Collectors.toList());
    }

    private StrategySettingTableRowEntity createMatchRow(DeviceEntity device, FirmwarePackageEntity pkg) {
        StrategySettingTableRowEntity row = new StrategySettingTableRowEntity();
        String curVersion = "--";
        boolean isSupport = this.isSupportUid(device, pkg);
        if (isSupport) {
            curVersion = this.getVersion(device, pkg);
        }
        row.setMatch(isSupport && UpgradeScenarioUtil.isValidVersion(curVersion, pkg.getPackageInfo().getModule()));
        row.setStrategyComboBoxCell(ModuleUpdateBySsh.getDefaultComboBoxCell());
        row.setModule(pkg.getPackageInfo().getModule());
        row.setCurrentVersion(curVersion);
        ModuleUpdateBySsh.setTableRowCommonInfo(row, pkg);
        return row;
    }

    private boolean isSupportUid(DeviceEntity device, FirmwarePackageEntity pkg) {
        return "all".equalsIgnoreCase(pkg.getPackageInfo().getSupportModelUID()) || pkg.getPackageInfo().getSupportModelUID().toLowerCase(Locale.ENGLISH).contains(device.getProductUniqueId().toLowerCase(Locale.ENGLISH));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getVersion(DeviceEntity device, FirmwarePackageEntity pkg) {
        if (UpgradeScenarioUtil.isOutBound()) {
            log.info("End query when the scene is yinglong outBond");
            return "--";
        }
        if (device.isDirectPlane()) {
            log.info("End query when the device is a Direct Plane.");
            return "--";
        }
        if (device.getPanGeaInBandModuleVersion().containsKey(this.getModuleName())) {
            return device.getPanGeaInBandModuleVersion().getOrDefault(this.getModuleName(), "--");
        }
        try {
            FusionStorageSshConnector ssh = FusionStorageSshPool.getFsSshConnectionByBmcIp(device.getIp());
            String curVersion = ModuleUpdateBySsh.getPanGeaInBandVersionOnServer(pkg, ssh);
            device.getPanGeaInBandModuleVersion().put(this.getModuleName(), curVersion);
            String string = curVersion;
            return string;
        }
        catch (UMateException e) {
            log.error("get ssh connector fail.", (Throwable)e);
            DialogUtils.showInfoDialog((Frame)((Object)BundleUpgradeContext.getInstance().getMainDialog()), (String)RES.getString("bundle.upgrade.match.ssh.error"));
            String string = "--";
            return string;
        }
        catch (Exception e) {
            log.error("execute ssh cmd fail", (Throwable)e);
            String string = "--";
            return string;
        }
        finally {
            FusionStorageSshPool.releaseFsSshConnection(FusionStrgUpgradeContext.getInstance().getFsDeviceEntityByBmcIp(device.getIp()));
        }
    }

    @Override
    public String verifyDeviceVersionAndFwVersion(DeviceEntity device, UpgradeDeviceEntity.FirmUpgradeResult upgradeResult) {
        String curVersion = this.getVersion(device, upgradeResult.getFirmwarePackage());
        log.info("node: {} module updated by ssh verify, device version {} , package version {} ", new Object[]{device.getIp(), curVersion, upgradeResult.getFirmwarePackage().getPackageInfo().getVersion()});
        return ModuleUpdateBySsh.versionVerifyDetail(this.getModuleName(), curVersion, upgradeResult);
    }
}

