/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.model;

import com.huawei.bundleupgrade.constants.UpgradeParamConstants;
import com.huawei.bundleupgrade.entity.DeviceEntity;
import com.huawei.bundleupgrade.entity.FirmwarePackageEntity;
import com.huawei.bundleupgrade.entity.StrategySettingTableRowEntity;
import com.huawei.bundleupgrade.entity.UpgradeDeviceEntity;
import com.huawei.bundleupgrade.model.Module;
import com.huawei.bundleupgrade.utils.VersionComparisonTools;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetimerModule
extends Module {
    private static final Logger log = LoggerFactory.getLogger(RetimerModule.class);
    private static final String MODULE_NAME = UpgradeParamConstants.ModuleType.Retimer.getModule();

    @Override
    public List<StrategySettingTableRowEntity> matchAndCreateRow(DeviceEntity device, List<FirmwarePackageEntity> fwPackageList) {
        return RetimerModule.createMatchRows(device, fwPackageList, MODULE_NAME).stream().peek(row -> row.setCurrentVersion(this.getVersion(device))).collect(Collectors.toList());
    }

    public static String getName() {
        return MODULE_NAME;
    }

    @Override
    public String getVersion(DeviceEntity device) {
        return device.getRetimerVersion();
    }

    @Override
    public String getVersion(DeviceEntity device, FirmwarePackageEntity pkg) {
        return this.getVersion(device);
    }

    @Override
    public String verifyDeviceVersionAndFwVersion(DeviceEntity device, UpgradeDeviceEntity.FirmUpgradeResult upgradeResult) {
        log.info("node: {} retimer verify, device version {} , package version {} ", new Object[]{device.getIp(), this.getVersion(device), upgradeResult.getFirmwarePackage().getPackageInfo().getVersion()});
        return RetimerModule.versionVerifyDetail(MODULE_NAME, this.getVersion(device), upgradeResult);
    }

    @Override
    public void setUpgradeExpectEffect(StrategySettingTableRowEntity tableRowEntity) {
        VersionComparisonTools.compareVersionByCommonWay(tableRowEntity);
    }
}

