/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.model;

import com.huawei.bundleupgrade.constants.UpgradeParamConstants;
import com.huawei.bundleupgrade.entity.DeviceEntity;
import com.huawei.bundleupgrade.entity.FirmwarePackageEntity;
import com.huawei.bundleupgrade.entity.RetimerTypeEnum;
import com.huawei.bundleupgrade.entity.StrategySettingTableRowEntity;
import com.huawei.bundleupgrade.model.ExpRetimerModule;
import com.huawei.bundleupgrade.service.DeviceInfoByRedfishService;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TiRetimerModule
extends ExpRetimerModule {
    private static final Logger log = LoggerFactory.getLogger(TiRetimerModule.class);
    private static final String NAME = UpgradeParamConstants.ModuleType.PCIE_RETIMER_TI_RETIMER.getModule();

    @Override
    public List<StrategySettingTableRowEntity> matchAndCreateRow(DeviceEntity device, List<FirmwarePackageEntity> fwPackages) {
        return TiRetimerModule.filterPkgByModuleName(fwPackages, NAME).stream().map(pkg -> TiRetimerModule.createMatchRow(device, pkg)).collect(Collectors.toList());
    }

    @Override
    public void updateVersion(DeviceEntity device) {
        log.info("Update {} version for {}.", (Object)NAME, (Object)device.getIp());
        try (DeviceInfoByRedfishService service = new DeviceInfoByRedfishService(device);){
            device.setExpRetimers(service.getExpRetimers(device));
        }
    }

    @Override
    public String getVersion(DeviceEntity device) {
        return device.getExpRetimerByType(RetimerTypeEnum.TI_RETIMER);
    }
}

