/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.model;

import com.huawei.bundleupgrade.constants.UpgradeParamConstants;
import com.huawei.bundleupgrade.entity.DeviceEntity;
import com.huawei.bundleupgrade.entity.FirmwarePackageEntity;
import com.huawei.bundleupgrade.entity.StrategySettingTableRowEntity;
import com.huawei.bundleupgrade.entity.UpgradeDeviceEntity;
import com.huawei.bundleupgrade.model.Module;
import com.huawei.bundleupgrade.utils.VersionComparisonTools;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VrdModule
extends Module {
    private static final Logger log = LoggerFactory.getLogger(VrdModule.class);
    private static final String NAME = UpgradeParamConstants.ModuleType.VRD.getModule();

    @Override
    public List<StrategySettingTableRowEntity> matchAndCreateRow(DeviceEntity device, List<FirmwarePackageEntity> fwPackageList) {
        log.info("start to match {}.", (Object)NAME);
        return fwPackageList.stream().filter(fw -> NAME.equals(fw.getPackageInfo().getModule())).map(pkg -> this.createMatchRow(device, (FirmwarePackageEntity)pkg)).collect(Collectors.toList());
    }

    private StrategySettingTableRowEntity createMatchRow(DeviceEntity device, FirmwarePackageEntity pkg) {
        StrategySettingTableRowEntity row = new StrategySettingTableRowEntity();
        row.setMatch(this.isMatchFw(device, pkg));
        row.setStrategyComboBoxCell(VrdModule.getDefaultComboBoxCell());
        row.setModule(pkg.getPackageInfo().getModule());
        row.setCurrentVersion(this.getVersion(device, pkg));
        VrdModule.setTableRowCommonInfo(row, pkg);
        return row;
    }

    private boolean isMatchFw(DeviceEntity device, FirmwarePackageEntity pkg) {
        return !"--".equals(device.getVrdVersion()) && pkg.getPackageInfo().getSupportModelUID().toLowerCase(Locale.ROOT).contains(device.getProductUniqueId().toLowerCase(Locale.ROOT));
    }

    public static String getName() {
        return NAME;
    }

    @Override
    public String getVersion(DeviceEntity device) {
        return device.getVrdVersion();
    }

    @Override
    public String getVersion(DeviceEntity device, FirmwarePackageEntity pkg) {
        return this.getVersion(device);
    }

    @Override
    public String verifyDeviceVersionAndFwVersion(DeviceEntity device, UpgradeDeviceEntity.FirmUpgradeResult upgradeResult) {
        String version = Arrays.stream(this.getVersion(device).split("\\.")).distinct().collect(Collectors.joining("."));
        log.info("node: {} vrd version verify, device version {} , package version {} ", new Object[]{device.getIp(), this.getVersion(device), upgradeResult.getFirmwarePackage().getPackageInfo().getVersion()});
        return VrdModule.versionVerifyDetail(NAME, version, upgradeResult);
    }

    @Override
    public void setUpgradeExpectEffect(StrategySettingTableRowEntity tableRowEntity) {
        VersionComparisonTools.compareVrdVersion(tableRowEntity);
    }
}

