/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.ParserConfig;
import com.huawei.bundleupgrade.constants.UpgradeParamConstants;
import com.huawei.bundleupgrade.entity.AssociationOfControllerAndRetimer;
import com.huawei.bundleupgrade.entity.BmcActiveModeEnum;
import com.huawei.bundleupgrade.entity.ControllerMark;
import com.huawei.bundleupgrade.entity.DeviceEntity;
import com.huawei.bundleupgrade.entity.ExpRetimer;
import com.huawei.bundleupgrade.entity.FirmwarePackageEntity;
import com.huawei.bundleupgrade.entity.OperationResultEntity;
import com.huawei.bundleupgrade.entity.PcieCardEntity;
import com.huawei.bundleupgrade.entity.RetimerTypeEnum;
import com.huawei.bundleupgrade.entity.UpgradeDeviceEntity;
import com.huawei.bundleupgrade.entity.UpgradeSpParams;
import com.huawei.bundleupgrade.utils.BundleUpgradeContext;
import com.huawei.bundleupgrade.utils.ServiceUtil;
import com.huawei.bundleupgrade.utils.SystemConfigUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.distributedfwupg.utils.CommonUtils;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.uMate.Interface.manage.redfish.DeviceRedfishService;
import com.huawei.uMate.common.SystemConfig;
import com.huawei.uMate.common.model.SFTPModel;
import com.huawei.uMate.common.rest.RedfishConnestion;
import com.huawei.uMate.common.rest.RedfishResult;
import com.huawei.uMate.common.thread.CommonRunnable;
import com.huawei.uMate.common.utils.RedfishUtils;
import com.huawei.uMate.common.utils.ResUtil;
import java.io.Closeable;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceInfoByRedfishService
extends DeviceRedfishService
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeviceInfoByRedfishService.class);
    private static final String[] ACTIVEMODE_HUAWEI_KEYS = new String[]{"Oem", "Huawei", "ActiveMode"};
    private static final String[] ACTIVEMODE_PUBLIC_KEYS = new String[]{"Oem", "Public", "ActiveMode"};
    private static final ResUtil RES = ResUtil.getInstance((String)"BundleUpgrade");
    private static final String SPVER_SPLIT = "\n";
    private static final String SPVER_NULL_CHAR = "---";
    private static final String PSU_START = "PSU-";
    private static final String KEY_HUAWEI = "Huawei";
    private static final String KEY_PUBLIC = "Public";
    private String userName;
    private String pasd;
    private boolean supportRedfish = true;
    private final Map<String, ParseResponseFunction> functionMap = new HashMap<String, ParseResponseFunction>();

    public DeviceInfoByRedfishService(String ip, String port, String userName, String pasd, boolean supportRedfish) {
        this.functionMap.put("obj2array", this::parseObjectGetArrayByKey);
        this.functionMap.put("obj2obj", this::parseObjectGetObjectByKey);
        this.functionMap.put("array2list", this::parseObjectGetResultsFromArrayByKey);
        this.functionMap.put("obj2str", this::parseObjectGetStrByKey);
        this.functionMap.put("obj2map", this::parseObjectGetStrMapByKeys);
        this.functionMap.put("array2map", this::parseArrayGetStrMapByKeys);
        this.userName = userName;
        this.pasd = pasd;
        this.supportRedfish = supportRedfish;
        this.conn = new RedfishConnestion(ip, port, userName, pasd);
        if (BundleUpgradeContext.getInstance().isBmcAuthCheckOpen() && this.supportRedfish) {
            this.conn.connect();
        }
    }

    public DeviceInfoByRedfishService(DeviceEntity device) {
        this(device.getIp(), device.getHttpsPort(), device.getAccount().getUserName(), device.getAccount().getPassword(), device.isSupportRedfish());
    }

    public OperationResultEntity getDevBaseInfo(String sign) {
        LOGGER.info(String.format(Locale.ENGLISH, "%s get %s infomation", this.conn.getDestIp(), sign));
        RedfishResult result = null;
        switch (sign) {
            case "ActiveBMC": {
                result = this.conn.executeGet("/redfish/v1/UpdateService/FirmwareInventory/ActiveBMC");
                break;
            }
            case "BackupBMC": {
                result = this.conn.executeGet("/redfish/v1/UpdateService/FirmwareInventory/BackupBMC");
                break;
            }
            case "BIOS": {
                result = this.conn.executeGet("/redfish/v1/UpdateService/FirmwareInventory/bios");
                break;
            }
            case "MainBoardCPLD": {
                result = this.conn.executeGet("/redfish/v1/UpdateService/FirmwareInventory/MainBoardCPLD");
                break;
            }
        }
        if (result == null) {
            LOGGER.error(String.format(Locale.ENGLISH, "Failure: %s get %s infomation is null.", this.conn.getDestIp(), sign));
            return new OperationResultEntity(false, RES.getStringWithParams("bundle.upgrade.query.device.info.devbaseinfo", new Object[]{sign}));
        }
        if (!result.isSuccess()) {
            LOGGER.error(String.format(Locale.ENGLISH, "Failure: %s get %s infomation Failed.", this.conn.getDestIp(), sign));
            return new OperationResultEntity(false, RES.getStringWithParams("bundle.upgrade.query.device.info.devbaseinfo", new Object[]{sign}));
        }
        LOGGER.info(String.format(Locale.ENGLISH, "Success: %s get %s infomation Success.", this.conn.getDestIp(), sign));
        return new OperationResultEntity(true, (String)RedfishUtils.getObjectAttr((String)result.getResult(), String.class, (String[])new String[]{"Version"}));
    }

    public BmcActiveModeEnum getBmcActiveMode() {
        RedfishResult result = this.conn.executeGet("/redfish/v1/UpdateService/FirmwareInventory/ActiveBMC");
        if (result == null) {
            LOGGER.error("Failure: node [{}] get [{}] infomation is null.", (Object)this.conn.getDestIp(), (Object)"ActiveMode");
            return BmcActiveModeEnum.RESET_BMC;
        }
        if (!result.isSuccess()) {
            LOGGER.error("Failure:node [{}] get [{}] infomation Failed.", (Object)this.conn.getDestIp(), (Object)"ActiveMode");
            return BmcActiveModeEnum.RESET_BMC;
        }
        String activeMode = (String)RedfishUtils.getObjectAttr((String)result.getResult(), String.class, (String[])ACTIVEMODE_HUAWEI_KEYS);
        if (activeMode == null) {
            activeMode = (String)RedfishUtils.getObjectAttr((String)result.getResult(), String.class, (String[])ACTIVEMODE_PUBLIC_KEYS);
        }
        return BmcActiveModeEnum.getModeEnumByKey(activeMode);
    }

    public OperationResultEntity getSPVersionPretty(boolean isSupportSp) {
        if (!isSupportSp) {
            return new OperationResultEntity(true, RES.getString("reboot.method.reboot.not_involved"));
        }
        String spVer = this.getSPVersion();
        if (StringUtils.isNULLStr((String)spVer)) {
            LOGGER.info(String.format(Locale.ENGLISH, "%s faile to get spVer by redfish", this.conn.getDestIp()));
            return new OperationResultEntity(false, RES.getString("bundle.upgrade.query.device.info.spinfo"));
        }
        String osRevision = "";
        String appVersion = "";
        String dataVersion = "";
        if (spVer.contains("SysRestartDelaySeconds")) {
            for (String str : spVer.split(SPVER_SPLIT)) {
                String trim = str.substring(str.indexOf(":") + 1).trim();
                if (str.contains("OSRevision")) {
                    osRevision = trim;
                    continue;
                }
                if (str.contains("APPVersion")) {
                    appVersion = trim;
                    continue;
                }
                if (str.contains("DataVersion")) {
                    dataVersion = trim;
                    continue;
                }
                String cpuArchitecture = trim;
                LOGGER.info(String.format(Locale.ROOT, "cpuarchitecture is %s.", cpuArchitecture));
            }
        }
        osRevision = this.checkStrAndIfEmptyReturnDefault(osRevision);
        appVersion = this.checkStrAndIfEmptyReturnDefault(appVersion);
        dataVersion = this.checkStrAndIfEmptyReturnDefault(dataVersion);
        spVer = String.format(Locale.ENGLISH, " %s / %s / %s ", appVersion, osRevision, dataVersion);
        return new OperationResultEntity(true, spVer);
    }

    private String checkStrAndIfEmptyReturnDefault(String str) {
        if (StringUtils.isNULLStr((String)str) || str.equals("null")) {
            return SPVER_NULL_CHAR;
        }
        return str;
    }

    public JSONArray getPcieJsonArray() {
        String slotId = this.getDeviceSlotId();
        JSONArray pcieJsonArray = new JSONArray();
        if (StringUtils.isNULLStr((String)slotId)) {
            LOGGER.error(String.format(Locale.ENGLISH, "device %s get slotId failed.", this.conn.getDestIp()));
            return pcieJsonArray;
        }
        String url = String.format(Locale.ENGLISH, "/redfish/v1/Managers/%s/SPService/DeviceInfo", slotId);
        RedfishResult resp = this.conn.executeGet(url);
        if (!resp.isSuccess()) {
            LOGGER.error(String.format(Locale.ENGLISH, "device %s cmd %s send error.", this.conn.getDestIp(), url));
            return pcieJsonArray;
        }
        String pcieStr = (String)RedfishUtils.getObjectAttr((String)resp.getResult(), String.class, (String[])new String[]{"PCIeCards"});
        if (!StringUtils.isNULLStr((String)pcieStr)) {
            LOGGER.info(String.format(Locale.ENGLISH, "device %s get PCIE JSONArray success.", this.conn.getDestIp()));
            return (JSONArray)RedfishUtils.getObjectAttr((String)resp.getResult(), JSONArray.class, (String[])new String[]{"PCIeCards"});
        }
        LOGGER.error(String.format(Locale.ENGLISH, "device %s get PCIE JSONArray failed.", this.conn.getDestIp()));
        return pcieJsonArray;
    }

    public Map<String, List<PcieCardEntity>> getPcieCardsInfo(JSONArray jsonArray) {
        HashMap<String, List<PcieCardEntity>> pcieCardsMap = new HashMap<String, List<PcieCardEntity>>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject pcieCardJson = jsonArray.getJSONObject(i);
            PcieCardEntity pcieCard = new PcieCardEntity();
            pcieCard.setDeviceName(pcieCardJson.getString("DeviceName"));
            pcieCard.setPosition(pcieCardJson.getString("Position"));
            LOGGER.info(pcieCardJson.getString("Controllers"));
            ParserConfig.getGlobalInstance().setAutoTypeSupport(false);
            JSONArray controller = (JSONArray)JSONObject.parseObject((String)pcieCardJson.getString("Controllers"), JSONArray.class);
            if (controller.size() > 0) {
                JSONObject controllersJson = controller.getJSONObject(0);
                pcieCard.setModel(controllersJson.getString("Model"));
                pcieCard.setFirmwareVersion(controllersJson.getString("FirmwareVersion"));
                JSONArray functions = (JSONArray)JSONObject.parseObject((String)controllersJson.getString("Functions"), JSONArray.class);
                if (functions.size() > 0) {
                    JSONObject functionsJson = functions.getJSONObject(0);
                    if (functionsJson.getString("CardType").equals("StorageControllers")) {
                        pcieCard.setCardType(String.valueOf((Object)UpgradeParamConstants.ModuleType.RAID));
                    } else {
                        pcieCard.setCardType(functionsJson.getString("CardType"));
                    }
                }
                List<String> quaternaryinfos = this.getPcieQuaternary(functions);
                pcieCard.setQuaternaryList(quaternaryinfos);
            }
            this.addPcieCardsMap(pcieCardsMap, pcieCard);
        }
        return pcieCardsMap;
    }

    public List<String> getPcieQuaternary(JSONArray functions) {
        LinkedList<String> qtrnryList = new LinkedList<String>();
        if (!functions.isEmpty()) {
            for (int i = 0; i < functions.size(); ++i) {
                JSONObject functionsJson = functions.getJSONObject(i);
                String vendorId = functionsJson.getString("VendorId");
                String deviceId = functionsJson.getString("DeviceId");
                String subsystemId = functionsJson.getString("SubsystemId");
                String subsystemVendorId = functionsJson.getString("SubsystemVendorId");
                String quaternary = String.format(Locale.ENGLISH, "%s.%s.%s.%s", vendorId, deviceId, subsystemVendorId, subsystemId);
                LOGGER.info(String.format(Locale.ENGLISH, "device %s get vendorId is %s, deviceId is %s, subsystemId is %s, subsystemVendorId is %s", this.conn.getDestIp(), vendorId, deviceId, subsystemVendorId, subsystemId));
                if (this.ifInclude(qtrnryList, quaternary)) continue;
                qtrnryList.add(quaternary);
            }
        }
        return qtrnryList;
    }

    public boolean ifInclude(List<String> list, String quaternary) {
        return list.stream().anyMatch(str -> str.equalsIgnoreCase(quaternary));
    }

    public void addPcieCardsMap(Map<String, List<PcieCardEntity>> pcieCardsMap, PcieCardEntity pcieCardEntity) {
        pcieCardsMap.computeIfAbsent(pcieCardEntity.getQuaternaryList().toString(), quaternary -> new LinkedList()).add(pcieCardEntity);
    }

    public String getMcuVersion(DeviceEntity device) {
        if (!device.isTwoOceans()) {
            return "--";
        }
        String url = "/redfish/v1/Chassis";
        List<String> urls = this.getResultByUrls(Collections.singletonList(url), "Members:obj2array->Blade:array2list");
        List<String> tempUrls = urls = this.getResultByUrls(urls, "Links:obj2obj->PCIeDevices:obj2array->PCIeCard:array2list");
        List<String> result = this.getResultByUrls(urls, "Oem:obj2obj->Huawei:obj2obj->McuFirmwareVersion:obj2str");
        if (result.isEmpty()) {
            result = this.getResultByUrls(tempUrls, "Oem:obj2obj->Public:obj2obj->McuFirmwareVersion:obj2str");
        }
        if (result.isEmpty()) {
            return "--";
        }
        return result.get(0);
    }

    private String getPacificFanVersion(DeviceEntity device) {
        if (!device.isPacific()) {
            return "--";
        }
        long timeOut = Long.parseLong(ApplicationContext.getInstance().getAppConfig("yinglong.fwupgrade.os.restrated.max.time"));
        int interval = Integer.parseInt(ApplicationContext.getInstance().getAppConfig("yinglong.fwupgrade.os.restrated.interval"));
        long startTime = System.currentTimeMillis();
        String fanVersion = this.getPacificFanVersion();
        while (fanVersion.toLowerCase(Locale.ROOT).contains("na") || fanVersion.contains("--")) {
            if (System.currentTimeMillis() - startTime > timeOut) {
                LOGGER.warn("The fan version {} of node {} is invalid, and query time out", (Object)fanVersion, (Object)device.getIp());
                break;
            }
            CommonUtils.safeSleep(interval);
            LOGGER.info("The fan version {} of node {} is invalid, and wait to query again", (Object)fanVersion, (Object)device.getIp());
            fanVersion = this.getPacificFanVersion();
        }
        return fanVersion;
    }

    String getPacificFanVersion() {
        String url = "/redfish/v1/UpdateService/FirmwareInventory";
        List<String> urls = this.getResultByUrls(Collections.singletonList(url), "Members:obj2array->chassisFanBox:array2list");
        List<String> result = this.getResultByUrls(urls, "Version:obj2str");
        if (result.isEmpty()) {
            return "--";
        }
        return String.join((CharSequence)";", result);
    }

    public List<DeviceEntity.BbuModel> getBbuVersion(DeviceEntity deviceEntity) {
        List<Map<String, String>> result;
        List<String> urls;
        if (!deviceEntity.isSpecificDevice()) {
            LOGGER.info("Device is not two oceans or east sea, uid : {}", (Object)deviceEntity.getProductUniqueId());
            return Collections.emptyList();
        }
        String url = "/redfish/v1/Chassis";
        List<String> tempUrls = urls = this.getResultByUrls(Collections.singletonList(url), "Members:obj2array->Blade:array2list");
        if ((urls = this.getResultByUrls(urls, "Oem:obj2obj->Huawei:obj2obj->BackupBatteryUnits:obj2obj->@odata.id:obj2str")).isEmpty()) {
            urls = this.getResultByUrls(tempUrls, "Oem:obj2obj->Public:obj2obj->BackupBatteryUnits:obj2obj->@odata.id:obj2str");
        }
        if ((result = this.getResultListMapByUrls(urls = this.getResultByUrls(urls, "Members:obj2array->BackupBatteryUnits:array2list"), "FirmwareVersion;PowerType:obj2map")).isEmpty()) {
            return Collections.emptyList();
        }
        return result.stream().map(map -> {
            DeviceEntity deviceEntity2 = deviceEntity;
            deviceEntity2.getClass();
            return deviceEntity2.new DeviceEntity.BbuModel((String)map.get("FirmwareVersion"), (String)map.get("PowerType"));
        }).collect(Collectors.toList());
    }

    public String getEthCdrVersion(DeviceEntity device) {
        List<String> result;
        if (!device.isSpecificDevice()) {
            return "--";
        }
        String url = "/redfish/v1/UpdateService/FirmwareInventory";
        List<String> urls = this.getResultByUrls(Collections.singletonList(url), "Members:obj2array->CDR:array2list");
        if (CollectionUtils.isEmpty(urls) && device.isPacific()) {
            urls = this.getResultByUrls(Collections.singletonList(url), "Members:obj2array->Retimer0:array2list");
        }
        if (CollectionUtils.isEmpty(urls) && device.isDirectPlane()) {
            urls = this.getResultByUrls(Collections.singletonList(url), "Members:obj2array->Retimer:array2list");
        }
        return (result = this.getResultByUrls(urls, "Version:obj2str")).isEmpty() ? "--" : result.get(0);
    }

    public String getFanVersion(DeviceEntity device) {
        LOGGER.info("query fan version of {}", (Object)device.getIp());
        if (!device.isTwoOceans()) {
            return "--";
        }
        if (device.isPacific()) {
            return this.getPacificFanVersion(device);
        }
        if (device.isDirectPlane()) {
            return this.getDirectPlaneFanVersion();
        }
        String url = "/redfish/v1/UpdateService/FirmwareInventory/mainboardFanBoardCPLD";
        List<String> result = this.getResultByUrls(Collections.singletonList(url), "Version:obj2str");
        if (result.isEmpty()) {
            return "--";
        }
        return String.join((CharSequence)";", result);
    }

    private String getDirectPlaneFanVersion() {
        String url = "/redfish/v1/UpdateService/FirmwareInventory";
        List<String> urls = this.getResultByUrls(Collections.singletonList(url), "Members:obj2array->chassisFanBoard:array2list");
        List<String> result = this.getResultByUrls(urls, "Version:obj2str");
        if (result.isEmpty()) {
            return "--";
        }
        return String.join((CharSequence)";", result);
    }

    private List<String> getResultByUrls(List<String> urls, String exp) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            urls.forEach(url -> {
                List<String> list;
                RedfishResult resp = this.conn.executeGet(url);
                if (!resp.isSuccess()) {
                    LOGGER.error(String.format(Locale.ENGLISH, "device %s cmd %s send error.", this.conn.getDestIp(), url));
                }
                if (!(list = this.parseResponse2List(exp, JSON.parseObject((String)resp.getResult()))).isEmpty()) {
                    result.addAll(list);
                }
            });
        }
        catch (Exception e) {
            LOGGER.error("Query info error", (Throwable)e);
        }
        return result;
    }

    private List<Map<String, String>> getResultListMapByUrls(List<String> urls, String exp) {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        try {
            urls.forEach(url -> {
                Map<String, String> resultMap;
                RedfishResult resp = this.conn.executeGet(url);
                if (!resp.isSuccess()) {
                    LOGGER.error(String.format(Locale.ENGLISH, "device %s cmd %s send error.", this.conn.getDestIp(), url));
                }
                if (!(resultMap = this.parseResponse2Map(exp, JSON.parseObject((String)resp.getResult()))).isEmpty()) {
                    result.add(resultMap);
                }
            });
        }
        catch (Exception e) {
            LOGGER.error("Query info error", (Throwable)e);
        }
        return result;
    }

    private List<String> parseResponse2List(String exp, JSONObject data) {
        Object result = this.getResult(exp, data);
        if (result instanceof List) {
            return (List)result;
        }
        if (result instanceof String) {
            return Collections.singletonList(result.toString());
        }
        return Collections.emptyList();
    }

    private Map<String, String> parseResponse2Map(String exp, JSONObject data) {
        Object result = this.getResult(exp, data);
        if (result instanceof Map) {
            return (Map)result;
        }
        return Collections.emptyMap();
    }

    private Object getResult(String exp, JSONObject data) {
        String[] ops = exp.split("->");
        Object result = data;
        for (String op : ops) {
            String[] keyAndOpType = op.split(":");
            String key = keyAndOpType[0].trim();
            String opType = keyAndOpType[1].trim();
            result = this.functionMap.get(opType).parse(key, result);
        }
        return result;
    }

    @Override
    public void close() {
        if (null != this.conn) {
            LOGGER.info("Close conn {} ", (Object)this.conn.getDestIp());
            this.conn.release();
        }
    }

    private Object parseObjectGetArrayByKey(String keyExp, Object data) {
        if (data instanceof JSONObject) {
            JSONObject json = (JSONObject)data;
            return json.getJSONArray(keyExp);
        }
        return null;
    }

    private Object parseObjectGetObjectByKey(String keyExp, Object data) {
        if (data instanceof JSONObject) {
            JSONObject json = (JSONObject)data;
            return json.getJSONObject(keyExp);
        }
        return null;
    }

    private Object parseObjectGetStrByKey(String keyExp, Object data) {
        if (data instanceof JSONObject) {
            JSONObject json = (JSONObject)data;
            return json.getString(keyExp);
        }
        return null;
    }

    private Object parseObjectGetStrMapByKeys(String keyExp, Object data) {
        if (data instanceof JSONObject) {
            JSONObject json = (JSONObject)data;
            HashMap result = new HashMap();
            Arrays.stream(keyExp.split(";")).forEach(key -> result.put(key, json.getString(key)));
            return result;
        }
        return Collections.emptyMap();
    }

    private Object parseArrayGetStrMapByKeys(String keyExp, Object data) {
        if (!(data instanceof JSONArray)) {
            return Collections.emptyMap();
        }
        ArrayList map = new ArrayList();
        String[] keys = keyExp.split(";");
        JSONArray arrayData = (JSONArray)data;
        for (int i = 0; i < arrayData.size(); ++i) {
            JSONObject psuObj = arrayData.getJSONObject(i);
            HashMap psuDataMap = new HashMap();
            Arrays.stream(keys).forEach(key -> psuDataMap.put(key, psuObj.getString(key)));
            map.add(psuDataMap);
        }
        return map;
    }

    private Object parseObjectGetResultsFromArrayByKey(String keyExp, Object data) {
        ArrayList<String> list = new ArrayList<String>();
        if (data instanceof JSONArray) {
            JSONArray src = (JSONArray)data;
            for (int i = 0; i < src.size(); ++i) {
                String url = src.getJSONObject(i).getString("@odata.id");
                if (!url.contains(keyExp)) continue;
                LOGGER.info(String.format(Locale.ENGLISH, "device %s get redfish url is %s.", this.conn.getDestIp(), url));
                list.add(url);
            }
        }
        return list;
    }

    public JSONArray getFrimwareUrlJsonArrayByMark(String mark) {
        JSONArray firmwareUrlJsonArray = new JSONArray();
        RedfishResult resp = this.conn.executeGet("/redfish/v1/UpdateService/FirmwareInventory");
        if (!resp.isSuccess()) {
            LOGGER.error(String.format(Locale.ENGLISH, "device %s cmd %s send error.", this.conn.getDestIp(), "/redfish/v1/UpdateService/FirmwareInventory"));
            return firmwareUrlJsonArray;
        }
        ParserConfig.getGlobalInstance().setAutoTypeSupport(false);
        JSONObject jsonObject1 = JSON.parseObject((String)resp.getResult());
        JSONArray membersArray = jsonObject1.getJSONArray("Members");
        if (membersArray.size() == 0) {
            LOGGER.error(String.format(Locale.ENGLISH, "device %s FirmwareInventory members is empty.", this.conn.getDestIp()));
            return firmwareUrlJsonArray;
        }
        for (int i = 0; i < membersArray.size(); ++i) {
            String url = membersArray.getJSONObject(i).getString("@odata.id");
            if (!url.contains(mark)) continue;
            LOGGER.error(String.format(Locale.ENGLISH, "device %s get redfish url is %s.", this.conn.getDestIp(), url));
            firmwareUrlJsonArray.add((Object)membersArray.getJSONObject(i));
        }
        return firmwareUrlJsonArray;
    }

    public List<DeviceEntity.PsuModel> getPsuModeList(DeviceEntity device) {
        String url = "/redfish/v1/UpdateService/FirmwareInventory";
        List<String> urls = this.getResultByUrls(Collections.singletonList(url), "Members:obj2array->chassisPS:array2list");
        List<Map<String, String>> result = this.getResultListMapByUrls(urls, "Version;Oem;SoftwareId;Name:obj2map");
        return result.stream().map(data -> {
            DeviceEntity.PsuModel psuModel = device.new DeviceEntity.PsuModel();
            psuModel.setPsuVersion((String)data.get("Version"));
            psuModel.setName((String)data.get("Name"));
            psuModel.setSoftwareId((String)data.get("SoftwareId"));
            this.parsePsuPowerType((Map<String, String>)data, psuModel);
            return psuModel;
        }).collect(Collectors.toList());
    }

    private void parsePsuPowerType(Map<String, String> data, DeviceEntity.PsuModel psuModel) {
        try {
            JSONObject oemObj = JSONObject.parseObject((String)data.get("Oem"));
            JSONObject powerTypeParent = oemObj.getJSONObject(KEY_HUAWEI);
            if (powerTypeParent == null) {
                powerTypeParent = oemObj.getJSONObject(KEY_PUBLIC);
            }
            psuModel.setPowerType(powerTypeParent.getString("PowerType"));
        }
        catch (Exception e) {
            LOGGER.info("Query psu power type error.");
        }
    }

    public List<DeviceEntity.CpldModel> getCpldModelList(JSONArray firmwareUrlJsonArray, DeviceEntity device) {
        LinkedList<DeviceEntity.CpldModel> cpldModels = new LinkedList<DeviceEntity.CpldModel>();
        if (firmwareUrlJsonArray.size() != 0) {
            for (int i = 0; i < firmwareUrlJsonArray.size(); ++i) {
                String url = firmwareUrlJsonArray.getJSONObject(i).getString("@odata.id");
                RedfishResult result = this.conn.executeGet(url);
                if (!result.isSuccess()) {
                    LOGGER.error(String.format(Locale.ENGLISH, "device %s cmd %s send error.", this.conn.getDestIp(), url));
                    continue;
                }
                ParserConfig.getGlobalInstance().setAutoTypeSupport(false);
                JSONObject jsonObject1 = JSON.parseObject((String)result.getResult());
                JSONArray dataidArray = jsonObject1.getJSONArray("RelatedItem");
                String cpldInfoUrl = dataidArray.getJSONObject(0).getString("@odata.id");
                LOGGER.info(dataidArray.get(0).toString());
                this.queryCplds(cpldModels, cpldInfoUrl, device);
            }
        }
        return cpldModels;
    }

    private void queryCplds(List<DeviceEntity.CpldModel> cpldModels, String cpldInfoUrl, DeviceEntity device) {
        this.queryCommonCplds(cpldModels, cpldInfoUrl);
    }

    private void queryCommonCplds(List<DeviceEntity.CpldModel> cpldModels, String cpldInfoUrl) {
        RedfishResult cpldResult = this.conn.executeGet(cpldInfoUrl);
        DeviceEntity device = new DeviceEntity();
        DeviceEntity.CpldModel cpldModel = device.new DeviceEntity.CpldModel();
        if (!cpldResult.isSuccess()) {
            LOGGER.error("device {} cmd {} send error.", (Object)this.conn.getDestIp(), (Object)cpldInfoUrl);
        } else {
            String cpldVersion = (String)RedfishUtils.getObjectAttr((String)cpldResult.getResult(), String.class, (String[])new String[]{"CPLDVersion"});
            String boardName = (String)RedfishUtils.getObjectAttr((String)cpldResult.getResult(), String.class, (String[])new String[]{"BoardName"});
            String boardId = (String)RedfishUtils.getObjectAttr((String)cpldResult.getResult(), String.class, (String[])new String[]{"BoardId"});
            String deviceType = (String)RedfishUtils.getObjectAttr((String)cpldResult.getResult(), String.class, (String[])new String[]{"DeviceType"});
            if (!StringUtils.isNULLStr((String)deviceType)) {
                if (deviceType.equalsIgnoreCase("MainBoard")) {
                    cpldModel.setDeviceType("MainBoard");
                } else {
                    cpldModel.setDeviceType("Backplane");
                }
                cpldModel.setCpldVersion(DeviceInfoByRedfishService.getCpldVersionPretty(cpldVersion));
                cpldModel.setBoardName(boardName);
                cpldModel.setBoardId(boardId);
                cpldModels.add(cpldModel);
            }
            LOGGER.info("device {} get CPLDVersion is {}, boardName is {}, boardId is {}", new Object[]{this.conn.getDestIp(), cpldVersion, boardName, boardId});
        }
    }

    public String getCDROrRetimerVersion(String mark) {
        JSONArray firmwareUrlJsonArray = this.getFrimwareUrlJsonArrayByMark(mark);
        if (firmwareUrlJsonArray.size() != 0) {
            String url = firmwareUrlJsonArray.getJSONObject(0).getString("@odata.id");
            RedfishResult result = this.conn.executeGet(url);
            if (!result.isSuccess()) {
                LOGGER.error(String.format(Locale.ENGLISH, "device %s cmd %s send error.", this.conn.getDestIp(), url));
                return "--";
            }
            return (String)RedfishUtils.getObjectAttr((String)result.getResult(), String.class, (String[])new String[]{"Version"});
        }
        return "--";
    }

    public List<ExpRetimer> getExpRetimers(DeviceEntity device) {
        if (!(device.isEastSea() || this.hasBlade(device) || device.isSnService())) {
            return Collections.emptyList();
        }
        return this.queryRetimers().stream().filter(retimer -> device.isEastSea() || device.isSnService() || AssociationOfControllerAndRetimer.isAssociatedWith(retimer.getExpReTimerID(), device.getControllerMark())).collect(Collectors.toList());
    }

    private boolean hasBlade(DeviceEntity device) {
        return !"--".equals(device.getControllerMark()) && device.isPacific();
    }

    public List<ExpRetimer> queryRetimers() {
        String firmwareinventorUrl = "/redfish/v1/UpdateService/FirmwareInventory";
        List<String> retimerUrls = this.getResultByUrls(Collections.singletonList(firmwareinventorUrl), "Members:obj2array->Retimer:array2list");
        return this.getResultListMapByUrls(retimerUrls, "Id;Version;SoftwareId:obj2map").stream().map(retimer -> new ExpRetimer((String)retimer.get("Id"), (String)retimer.get("Version"), RetimerTypeEnum.getRetimerTypeByKey(retimer.getOrDefault("SoftwareId", "")))).collect(Collectors.toList());
    }

    private static String getCpldVersionPretty(String cpldVersion) {
        if (cpldVersion == null) {
            return "--";
        }
        if (cpldVersion.contains("(")) {
            return cpldVersion.substring(0, cpldVersion.indexOf("("));
        }
        return cpldVersion;
    }

    public OperationResultEntity getToken() {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("UserName", this.userName);
        dataMap.put("Password", this.pasd);
        RedfishResult resp = this.conn.executePost("/redfish/v1/SessionService/Sessions", JSON.toJSONString(dataMap));
        if (!resp.isSuccess()) {
            LOGGER.error(String.format(Locale.ENGLISH, "device %s cmd %s send error.", this.conn.getDestIp(), "/redfish/v1/SessionService/Sessions"));
            return new OperationResultEntity(false, String.format(Locale.ENGLISH, "device %s cmd %s send error.", this.conn.getDestIp(), "/redfish/v1/SessionService/Sessions"));
        }
        LOGGER.info(String.format(Locale.ENGLISH, "device %s get X-Auth-Token success...", this.conn.getDestIp()));
        String token = (String)resp.getHeaders().get("X-Auth-Token");
        if (StringUtils.isNULLStr((String)token)) {
            return new OperationResultEntity(false, String.format(Locale.ENGLISH, "device %s get X-Auth-Token is empty...", this.conn.getDestIp()));
        }
        return new OperationResultEntity(true, token);
    }

    public Boolean startSp() {
        OperationResultEntity token = this.getToken();
        if (token.isPassed()) {
            int count = 0;
            while (count < 4) {
                HashMap<String, String> hearderMap = new HashMap<String, String>();
                hearderMap.put("content-type", "application/json");
                hearderMap.put("X-Auth-Token", token.getReturnParam());
                Map<String, Object> dataMap = this.getRebootSpDataMap();
                String slotId = this.getDeviceSlotId();
                if (StringUtils.isNULLStr((String)slotId)) {
                    LOGGER.error(String.format(Locale.ENGLISH, "device %s get slotId failed.", this.conn.getDestIp()));
                    ++count;
                    continue;
                }
                String url = String.format(Locale.ENGLISH, "/redfish/v1/Managers/%s/SPService", slotId);
                RedfishResult resp = this.conn.executePatch(url, JSON.toJSONString(dataMap), JSON.toJSONString(hearderMap));
                if (!resp.isSuccess()) {
                    LOGGER.error(String.format(Locale.ENGLISH, "device %s cmd %s send error.", this.conn.getDestIp(), url));
                    LOGGER.error(String.format(Locale.ENGLISH, "%s : %s", resp.getErrorCode(), resp.getErrorMsg()));
                    ++count;
                    continue;
                }
                return true;
            }
            LOGGER.info(String.format(Locale.ENGLISH, "device %s reboot from SP failed.", this.conn.getDestIp()));
            return false;
        }
        LOGGER.info(String.format(Locale.ENGLISH, "device %s get X-Auth-Token failed.", this.conn.getDestIp()));
        return false;
    }

    private Map<String, Object> getRebootSpDataMap() {
        HashMap<String, Object> dataMap = new HashMap<String, Object>(4);
        dataMap.put("SPStartEnabled", true);
        dataMap.put("SysRestartDelaySeconds", 30);
        dataMap.put("SPTimeout", 1800);
        dataMap.put("SPFinished", false);
        return dataMap;
    }

    public OperationResultEntity getPowerState() throws InterruptedException {
        RedfishResult resp;
        long firstTime = System.currentTimeMillis();
        while (true) {
            CommonRunnable.sleep((int)5000);
            long currentTime = System.currentTimeMillis();
            if (currentTime - firstTime >= 180000L) {
                LOGGER.error(String.format(Locale.ENGLISH, "device %s get powser state time out", this.conn.getDestIp()));
                return new OperationResultEntity(false, "Get powser state time out");
            }
            String slotId = this.getDeviceSlotId();
            if (StringUtils.isNULLStr((String)slotId)) {
                LOGGER.error(String.format(Locale.ENGLISH, "device %s get slotId failed.", this.conn.getDestIp()));
                continue;
            }
            String url = String.format(Locale.ENGLISH, "/redfish/v1/Systems/%s", slotId);
            resp = this.conn.executeGet(url);
            if (resp.isSuccess()) break;
            LOGGER.error(String.format(Locale.ENGLISH, "device %s cmd %s send error.", this.conn.getDestIp(), url));
        }
        String powerState = (String)RedfishUtils.getObjectAttr((String)resp.getResult(), String.class, (String[])new String[]{"PowerState"});
        LOGGER.info(String.format(Locale.ENGLISH, "Success: %s get powerState Success. powerState is %s", this.conn.getDestIp(), powerState));
        return new OperationResultEntity(true, powerState);
    }

    public OperationResultEntity downloadFwFileListBySftp(ArrayList<String> ipv4list, ArrayList<String> pciePackageFileNameList) throws InterruptedException {
        String pcieFileName = pciePackageFileNameList.get(0);
        String benchmarkingIP = "";
        String slotId = this.getDeviceSlotId();
        if (StringUtils.isNULLStr((String)slotId)) {
            return new OperationResultEntity(false, RES.getString("bundle.upgrade.task.pcie.download.failed1"));
        }
        boolean downloadResult = true;
        for (String ip : ipv4list) {
            if (ip.contains(":")) {
                ip = String.format(Locale.ENGLISH, "[%s]", ip);
            }
            Map<String, String> dataMap = this.getSpFwUpdateMap(ip, pcieFileName);
            String url = String.format(Locale.ENGLISH, "/redfish/v1/Managers/%s/SPService/SPFWUpdate/1/Actions/SPFWUpdate.SimpleUpdate", slotId);
            RedfishResult resp = this.conn.executePost(url, JSON.toJSONString(dataMap));
            if (!resp.isSuccess()) {
                return new OperationResultEntity(false, RES.getStringWithParams("bundle.upgrade.task.pcie.download.failed", new Object[]{pcieFileName}));
            }
            if (this.checkSftpDownloadFile(pcieFileName, 5000, 600000, slotId, pcieFileName).booleanValue()) {
                benchmarkingIP = ip;
                downloadResult = true;
                break;
            }
            benchmarkingIP = ip;
            downloadResult = false;
        }
        StringBuilder detailStr = new StringBuilder();
        for (int i = 1; i < pciePackageFileNameList.size(); ++i) {
            String firmwareName = pciePackageFileNameList.get(i);
            CommonRunnable.sleep((int)30000);
            OperationResultEntity repeateDownloadFileResult = this.repeateDownloadFile(benchmarkingIP, firmwareName, slotId);
            if (repeateDownloadFileResult.isPassed()) continue;
            downloadResult = false;
            detailStr.append(repeateDownloadFileResult.getReturnParam());
        }
        return new OperationResultEntity(downloadResult, detailStr.toString());
    }

    public OperationResultEntity repeateDownloadFile(String benchmarkingIP, String firmwareName, String slotId) throws InterruptedException {
        Map<String, String> dataMap = this.getSpFwUpdateMap(benchmarkingIP, firmwareName);
        String url = String.format(Locale.ENGLISH, "/redfish/v1/Managers/%s/SPService/SPFWUpdate/1/Actions/SPFWUpdate.SimpleUpdate", slotId);
        for (int count = 0; count < 3; ++count) {
            RedfishResult resp = this.conn.executePost(url, JSON.toJSONString(dataMap));
            if (!resp.isSuccess()) {
                return new OperationResultEntity(false, RES.getStringWithParams("bundle.upgrade.task.pcie.download.failed", new Object[]{firmwareName}));
            }
            CommonRunnable.sleep((int)10000);
            if (this.checkSftpDownloadFile(firmwareName, 5000, 600000, slotId, firmwareName).booleanValue()) {
                LOGGER.info(String.format(Locale.ENGLISH, "device %s download fileName %s success.", this.conn.getDestIp(), firmwareName));
                return new OperationResultEntity(true, RES.getStringWithParams("bundle.upgrade.task.pcie.download.success", new Object[]{firmwareName}));
            }
            LOGGER.error(String.format(Locale.ENGLISH, "device %s download fileName %s failed.try %d times", this.conn.getDestIp(), firmwareName, count));
        }
        return new OperationResultEntity(false, RES.getStringWithParams("bundle.upgrade.task.pcie.download.failed", new Object[]{firmwareName}));
    }

    private Map<String, String> getSpFwUpdateMap(String benchmarkingIP, String firmwareName) {
        String imageUrl = String.format(Locale.ENGLISH, "sftp://%s:%s@%s:%s/%s", SFTPModel.getSFTP_User(), SFTPModel.getPassword(), benchmarkingIP, SFTPModel.getSFTP_SERVER_PORT(), firmwareName);
        String signalUrl = String.format(Locale.ENGLISH, "sftp://%s:%s@%s:%s/%s.%s", SFTPModel.getSFTP_User(), SFTPModel.getPassword(), benchmarkingIP, SFTPModel.getSFTP_SERVER_PORT(), firmwareName, "asc");
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("ImageURI", imageUrl);
        dataMap.put("SignalURI", signalUrl);
        dataMap.put("ImageType", "Firmware");
        dataMap.put("Parameter", "all");
        dataMap.put("UpgradeMode", "Auto");
        dataMap.put("ActiveMethod", "RestartOS");
        return dataMap;
    }

    public Boolean checkSftpDownloadFile(String fileName, int intervalTime, int timeout, String slotId, String firmwareName) throws InterruptedException {
        String url;
        String transferFileName;
        String transferProgressPercent;
        String transferState;
        LOGGER.info(String.format(Locale.ENGLISH, "device %s downLoad %s start...", this.conn.getDestIp(), fileName));
        long firstTime = System.currentTimeMillis();
        do {
            CommonRunnable.sleep((int)intervalTime);
            long currentTime = System.currentTimeMillis();
            if (currentTime - firstTime >= (long)timeout) {
                LOGGER.error(String.format(Locale.ENGLISH, "Check download %s time out", fileName));
                return false;
            }
            url = String.format(Locale.ENGLISH, "/redfish/v1/Managers/%s/SPService/SPFWUpdate/1", slotId);
            RedfishResult resp = this.conn.executeGet(url);
            if (!resp.isSuccess()) {
                LOGGER.error(String.format(Locale.ENGLISH, "device %s cmd %s send error.", this.conn.getDestIp(), "/redfish/v1/SessionService/Sessions"));
                return false;
            }
            transferState = (String)RedfishUtils.getObjectAttr((String)resp.getResult(), String.class, (String[])new String[]{"TransferState"});
            transferProgressPercent = (String)RedfishUtils.getObjectAttr((String)resp.getResult(), String.class, (String[])new String[]{"TransferProgressPercent"});
            transferFileName = (String)RedfishUtils.getObjectAttr((String)resp.getResult(), String.class, (String[])new String[]{"TransferFileName"});
            if (!"Failure".equals(transferState)) continue;
            LOGGER.error(resp.getResult());
            LOGGER.error(String.format(Locale.ENGLISH, "device %s get PCIE Upgrade End flag failed...", this.conn.getDestIp()));
            return false;
        } while (!"Success".equalsIgnoreCase(transferState) || !"100".equals(transferProgressPercent) || !firmwareName.equals(transferFileName));
        return this.checkFileListResult(url);
    }

    private Boolean checkFileListResult(String url) {
        LOGGER.info("check Filelist Result...");
        RedfishResult resp1 = this.conn.executeGet(url);
        if (!resp1.isSuccess()) {
            LOGGER.error(String.format(Locale.ENGLISH, "device %s cmd %s send error.", this.conn.getDestIp(), "/redfish/v1/SessionService/Sessions"));
            return false;
        }
        String fileList = (String)RedfishUtils.getObjectAttr((String)resp1.getResult(), String.class, (String[])new String[]{"FileList"});
        if (!StringUtils.isNULLStr((String)fileList)) {
            LOGGER.info(String.format(Locale.ENGLISH, "Filelist Content: %s", fileList));
            return true;
        }
        LOGGER.error(String.format(Locale.ENGLISH, "device %s fileList content is null.", this.conn.getDestIp()));
        return false;
    }

    public ArrayList<String> getLocalIP() {
        ArrayList<String> iplist = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
            if (netInterfaces == null) {
                return iplist;
            }
            while (netInterfaces.hasMoreElements()) {
                NetworkInterface ni = netInterfaces.nextElement();
                Enumeration<InetAddress> addresses = ni.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress ip = addresses.nextElement();
                    if (ip.isLoopbackAddress()) continue;
                    String ipStr = ip.getHostAddress();
                    if (ipStr.contains(":") && ipStr.contains("%")) {
                        ipStr = ipStr.substring(0, ipStr.indexOf("%"));
                    }
                    iplist.add(ipStr);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Get ip error.", (Throwable)e);
        }
        return iplist;
    }

    public OperationResultEntity getPCIECardsResult(UpgradeDeviceEntity upgradeDevice) {
        String pcieUpgradeInfo;
        String slotId = this.getDeviceSlotId();
        if (StringUtils.isNULLStr((String)slotId)) {
            LOGGER.error(String.format(Locale.ENGLISH, "device %s get slotId failed.", this.conn.getDestIp()));
            return new OperationResultEntity(false, "");
        }
        String url = String.format(Locale.ENGLISH, "/redfish/v1/Managers/%s/SPService/SPResult/1", slotId);
        try {
            OperationResultEntity pcieUpgradeEndFlag = this.getUpgradeEndFlag(url, 5000, 3600000);
            if (!pcieUpgradeEndFlag.isPassed()) {
                return this.getPCIEFwVersionIfUpgradeResultIsIdle(upgradeDevice);
            }
            LOGGER.info(String.format(Locale.ENGLISH, "device %s get PCIE Upgrade End flag success...", this.conn.getDestIp()));
            pcieUpgradeInfo = pcieUpgradeEndFlag.getReturnParam();
        }
        catch (InterruptedException e) {
            LOGGER.info(String.format(Locale.ENGLISH, "device %s get PCIE Upgrade End flag failed...", this.conn.getDestIp()));
            return new OperationResultEntity(false, "");
        }
        return new OperationResultEntity(true, pcieUpgradeInfo);
    }

    public OperationResultEntity getUpgradeEndFlag(String url, int intervalTime, int timeout) throws InterruptedException {
        String upgradeStr;
        LOGGER.info(String.format(Locale.ENGLISH, "device %s get PCIE Upgrade End flag...", this.conn.getDestIp()));
        long firstTime = System.currentTimeMillis();
        while (true) {
            CommonRunnable.sleep((int)intervalTime);
            long currentTime = System.currentTimeMillis();
            if (currentTime - firstTime >= (long)timeout) {
                return new OperationResultEntity(false, "get PCIE Upgrade End flag timeout...");
            }
            RedfishResult resp = this.conn.executeGet(url);
            if (!resp.isSuccess()) {
                LOGGER.error(String.format(Locale.ENGLISH, "device %s cmd %s send error.", this.conn.getDestIp(), "/redfish/v1/SessionService/Sessions"));
                continue;
            }
            LOGGER.info(String.format(Locale.ENGLISH, "device %s PCIE Upgrade result is:%s", this.conn.getDestIp(), resp.getResult()));
            JSONObject upgradeObject = JSON.parseObject((String)resp.getResult());
            upgradeStr = upgradeObject.getString("Upgrade");
            String progress = (String)RedfishUtils.getObjectAttr((String)upgradeStr, String.class, (String[])new String[]{"Progress"});
            if (StringUtils.isNULLStr((String)upgradeStr)) continue;
            LOGGER.info(String.format(Locale.ENGLISH, "device %s PCIE Upgrade process is %s...", this.conn.getDestIp(), progress));
            if ("100.0".equals(progress)) break;
        }
        return new OperationResultEntity(true, upgradeStr);
    }

    public OperationResultEntity obtainProductName(boolean isProductName) {
        String[] stringArray;
        String slotId = this.getDeviceSlotId();
        if (StringUtils.isNULLStr((String)slotId)) {
            LOGGER.error(String.format(Locale.ENGLISH, "device %s get slotId failed.", this.conn.getDestIp()));
            return new OperationResultEntity(false, String.format(Locale.ENGLISH, RES.getString("bundle.upgrade.query.device.info.aliasname"), this.conn.getDestIp()));
        }
        String url = String.format(Locale.ENGLISH, "/redfish/v1/Systems/%s", slotId);
        RedfishResult resp = this.conn.executeGet(url);
        if (!resp.isSuccess()) {
            LOGGER.error(String.format(Locale.ENGLISH, "device %s cmd %s send error.", this.conn.getDestIp(), url));
            return new OperationResultEntity(false, String.format(Locale.ENGLISH, RES.getString("bundle.upgrade.query.device.info.aliasname"), this.conn.getDestIp(), url));
        }
        if (isProductName) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "Oem";
            stringArray2[1] = KEY_HUAWEI;
            stringArray = stringArray2;
            stringArray2[2] = "ProductName";
        } else {
            String[] stringArray3 = new String[3];
            stringArray3[0] = "Oem";
            stringArray3[1] = KEY_HUAWEI;
            stringArray = stringArray3;
            stringArray3[2] = "ProductAlias";
        }
        String[] productNameKeys = stringArray;
        String productName = (String)RedfishUtils.getObjectAttr((String)resp.getResult(), String.class, (String[])productNameKeys);
        if (productName == null) {
            String[] stringArray4;
            if (isProductName) {
                String[] stringArray5 = new String[3];
                stringArray5[0] = "Oem";
                stringArray5[1] = KEY_PUBLIC;
                stringArray4 = stringArray5;
                stringArray5[2] = "ProductName";
            } else {
                String[] stringArray6 = new String[3];
                stringArray6[0] = "Oem";
                stringArray6[1] = KEY_PUBLIC;
                stringArray4 = stringArray6;
                stringArray6[2] = "ProductAlias";
            }
            productNameKeys = stringArray4;
            productName = (String)RedfishUtils.getObjectAttr((String)resp.getResult(), String.class, (String[])productNameKeys);
        }
        if (!StringUtils.isNULLStr((String)productName)) {
            LOGGER.info(String.format(Locale.ENGLISH, "device %s get alias name success.", this.conn.getDestIp()));
            return new OperationResultEntity(true, productName);
        }
        return new OperationResultEntity(false, productName);
    }

    public OperationResultEntity checkStartSP(int intervalTime, int timeout, String url) throws InterruptedException {
        LOGGER.info(String.format(Locale.ENGLISH, "device %s get PCIE Upgrade End flag...", this.conn.getDestIp()));
        long firstTime = System.currentTimeMillis();
        while (true) {
            CommonRunnable.sleep((int)intervalTime);
            long currentTime = System.currentTimeMillis();
            if (currentTime - firstTime >= (long)timeout) {
                return new OperationResultEntity(false, "Checking the Startup of the SP timeout ...");
            }
            RedfishResult resp = this.conn.executeGet(url);
            if (!resp.isSuccess()) {
                LOGGER.error(String.format(Locale.ENGLISH, "device %s cmd %s send error.", this.conn.getDestIp(), "/redfish/v1/SessionService/Sessions"));
                continue;
            }
            String[] spStatuskeys = new String[]{"Oem", KEY_HUAWEI, "SPStatus"};
            String spStatus = (String)RedfishUtils.getObjectAttr((String)resp.getResult(), String.class, (String[])spStatuskeys);
            if (spStatus == null) {
                spStatuskeys = new String[]{"Oem", KEY_PUBLIC, "SPStatus"};
                spStatus = (String)RedfishUtils.getObjectAttr((String)resp.getResult(), String.class, (String[])spStatuskeys);
            }
            if (!StringUtils.isNULLStr((String)spStatus) && spStatus.equals("SPIsWorking")) break;
        }
        return new OperationResultEntity(true, "");
    }

    public OperationResultEntity checkGetPCIEinfo(int intervalTime, int timeout, String url) throws InterruptedException {
        LOGGER.info(String.format(Locale.ENGLISH, "device %s get PCIE info flag...", this.conn.getDestIp()));
        long firstTime = System.currentTimeMillis();
        while (true) {
            CommonRunnable.sleep((int)intervalTime);
            long currentTime = System.currentTimeMillis();
            if (currentTime - firstTime >= (long)timeout) {
                return new OperationResultEntity(false, "Checking get PCIE info flag timeout ...");
            }
            RedfishResult resp = this.conn.executeGet(url);
            if (resp.isSuccess()) break;
            LOGGER.error(String.format(Locale.ENGLISH, "device %s cmd %s send error.", this.conn.getDestIp(), "/redfish/v1/SessionService/Sessions"));
        }
        return new OperationResultEntity(true, "");
    }

    public Boolean checkIsSupport() {
        String productUniqueOID = this.getProductUniqueId();
        if (StringUtils.isNULLStr((String)productUniqueOID)) {
            return false;
        }
        return Arrays.asList(SystemConfigUtil.getSysConfig("allow.upgrade.version.support").split(";")).contains(productUniqueOID.substring(2, 4));
    }

    public String getChassisType() {
        String slotId = this.getDeviceSlotId();
        String chassisType = "";
        if (StringUtils.isNULLStr((String)slotId)) {
            LOGGER.error(String.format(Locale.ENGLISH, "device %s get slotId failed.", this.conn.getDestIp()));
            return chassisType;
        }
        String url = String.format(Locale.ENGLISH, "/redfish/v1/Chassis/%s", slotId);
        RedfishResult resp = this.conn.executeGet(url);
        if (!resp.isSuccess()) {
            LOGGER.error(String.format(Locale.ENGLISH, "device %s cmd %s send error.", this.conn.getDestIp(), url));
            return chassisType;
        }
        chassisType = (String)RedfishUtils.getObjectAttr((String)resp.getResult(), String.class, (String[])new String[]{"ChassisType"});
        return chassisType;
    }

    public String getProcessorArchitecture() {
        String slotId = this.getDeviceSlotId();
        String processorArchitecture = "x86";
        if (StringUtils.isNULLStr((String)slotId)) {
            LOGGER.error(String.format(Locale.ENGLISH, "device %s get slotId failed.", this.conn.getDestIp()));
            return processorArchitecture;
        }
        String url = String.format(Locale.ENGLISH, "/redfish/v1/Systems/%s/Processors/1", slotId);
        RedfishResult resp = this.conn.executeGet(url);
        if (!resp.isSuccess()) {
            LOGGER.error(String.format(Locale.ENGLISH, "device %s cmd %s send error.", this.conn.getDestIp(), url));
            return processorArchitecture;
        }
        processorArchitecture = (String)RedfishUtils.getObjectAttr((String)resp.getResult(), String.class, (String[])new String[]{"ProcessorArchitecture"});
        LOGGER.info(String.format(Locale.ENGLISH, "device %s get processorArchitecture is %s", this.conn.getDestIp(), processorArchitecture));
        return processorArchitecture;
    }

    public String getBiosConfigurationByField(String fieldStr) {
        String slotId = this.getDeviceSlotId();
        String configurationItem = "";
        if (StringUtils.isNULLStr((String)slotId)) {
            LOGGER.error(String.format(Locale.ENGLISH, "device %s get slotId failed.", this.conn.getDestIp()));
            return configurationItem;
        }
        String url = String.format(Locale.ENGLISH, "/redfish/v1/Systems/%s/Bios", slotId);
        RedfishResult resp = this.conn.executeGet(url);
        if (!resp.isSuccess()) {
            LOGGER.error(String.format(Locale.ENGLISH, "device %s cmd %s send error.", this.conn.getDestIp(), url));
            return configurationItem;
        }
        String[] fieldArray = new String[]{"Attributes", fieldStr};
        configurationItem = (String)RedfishUtils.getObjectAttr((String)resp.getResult(), String.class, (String[])fieldArray);
        LOGGER.info(String.format(Locale.ENGLISH, "device %s get %s is %s", this.conn.getDestIp(), fieldStr, configurationItem));
        return configurationItem;
    }

    public OperationResultEntity setBiosConfiguration(Map<String, String> dataMap) {
        OperationResultEntity token = this.getToken();
        if (token.isPassed()) {
            HashMap<String, String> hearderMap = new HashMap<String, String>();
            hearderMap.put("content-type", "application/json");
            hearderMap.put("X-Auth-Token", token.getReturnParam());
            String slotId = this.getDeviceSlotId();
            if (StringUtils.isNULLStr((String)slotId)) {
                LOGGER.error(String.format(Locale.ENGLISH, "device %s get slotId failed.", this.conn.getDestIp()));
                return new OperationResultEntity(false, "");
            }
            JSONObject dataParams = new JSONObject();
            dataParams.put("Attributes", dataMap);
            String url = String.format(Locale.ENGLISH, "/redfish/v1/Systems/%s/Bios/Settings", slotId);
            RedfishResult resp = this.conn.executePatch(url, JSON.toJSONString((Object)dataParams), JSON.toJSONString(hearderMap));
            if (!resp.isSuccess()) {
                LOGGER.error(String.format(Locale.ENGLISH, "device %s cmd %s send error.", this.conn.getDestIp(), url));
                LOGGER.error(String.format(Locale.ENGLISH, "%s : %s", resp.getErrorCode(), resp.getErrorMsg()));
                return new OperationResultEntity(false, "");
            }
            return new OperationResultEntity(true, "");
        }
        LOGGER.error(String.format(Locale.ENGLISH, "device %s get token failed.", this.conn.getDestIp()));
        return new OperationResultEntity(false, "");
    }

    public DeviceEntity.WatchDogModel getDevWatchDogModle() {
        String spBoot = this.getBiosConfigurationByField("SPBoot");
        String bmcWdtEnable = this.getBiosConfigurationByField("BMCWDTEnable");
        String osWdtEnable = this.getBiosConfigurationByField("OSWDTEnable");
        DeviceEntity device = new DeviceEntity();
        DeviceEntity.WatchDogModel watchDogModel = device.new DeviceEntity.WatchDogModel();
        if (!StringUtils.isNULLStr((String)spBoot)) {
            watchDogModel.setSpBoot(spBoot);
        }
        if (!StringUtils.isNULLStr((String)bmcWdtEnable)) {
            watchDogModel.setBmcWdtEnable(bmcWdtEnable);
        }
        if (!StringUtils.isNULLStr((String)osWdtEnable)) {
            watchDogModel.setOsWdtEnable(osWdtEnable);
        }
        return watchDogModel;
    }

    public String getIobBiosVersion() {
        String url = "/redfish/v1/Chassis/1/Boards/mainboardIOBridgeCard";
        RedfishResult result = this.conn.executeGet(url);
        if (!result.isSuccess()) {
            return "--";
        }
        JSONObject resultJson = result.getResultJSON();
        return resultJson == null ? "--" : resultJson.getString("FirmwareVersion");
    }

    public String queryBlade() {
        String bladeUrl = String.format(Locale.ENGLISH, "/redfish/v1/Chassis/%s", "");
        String urlParsing = this.conn.executeGet(bladeUrl).getResult();
        return ControllerMark.getBladeMark(urlParsing).getMark();
    }

    public OperationResultEntity getPCIEFwVersionIfUpgradeResultIsIdle(UpgradeDeviceEntity upgradeDevice) {
        Map<String, FirmwarePackageEntity> upgradeFirmwarePackages = this.getCurrentInBandFirmwarePackage(upgradeDevice);
        Map<String, List<PcieCardEntity>> pcieCardsInfos = this.getPcieCardsInfo(this.getPcieJsonArray());
        if (pcieCardsInfos.isEmpty()) {
            return new OperationResultEntity(false, "get pcie info cards error");
        }
        JSONObject upgradeResult = new JSONObject();
        this.composePCIeUpgradeResultWhenStatusIdle(upgradeFirmwarePackages, pcieCardsInfos, upgradeResult);
        return new OperationResultEntity(true, upgradeResult.toJSONString());
    }

    private Map<String, FirmwarePackageEntity> getCurrentInBandFirmwarePackage(UpgradeDeviceEntity upgradeDevice) {
        Map<UpgradeParamConstants.ModuleType, List<String>> moduleTargetFirmwareMap = BundleUpgradeContext.getInstance().getStrategyEntityMap().get(upgradeDevice.getAssociatedStrategyId()).getModuleTargetFirmwareMap();
        ArrayList inBandFirmwareInfos = new ArrayList();
        moduleTargetFirmwareMap.forEach((moduleType, firmwares) -> {
            if (!UpgradeParamConstants.ModuleType.getInBandModules().contains(moduleType) && !UpgradeParamConstants.ModuleType.SSD_SP.equals(moduleType)) {
                return;
            }
            inBandFirmwareInfos.addAll(firmwares);
        });
        ConcurrentHashMap<String, FirmwarePackageEntity> firmwarePackageMap = BundleUpgradeContext.getInstance().getFirmwarePackageMap();
        HashMap<String, FirmwarePackageEntity> upgradeFirmwarePackages = new HashMap<String, FirmwarePackageEntity>();
        inBandFirmwareInfos.forEach(info -> {
            FirmwarePackageEntity cfr_ignored_0 = (FirmwarePackageEntity)upgradeFirmwarePackages.put(((FirmwarePackageEntity)firmwarePackageMap.get(info)).getPackageInfo().getSupportModelUID(), (FirmwarePackageEntity)firmwarePackageMap.get(info));
        });
        return upgradeFirmwarePackages;
    }

    private void composePCIeUpgradeResultWhenStatusIdle(Map<String, FirmwarePackageEntity> upgradeFirmwarePackages, Map<String, List<PcieCardEntity>> pcieCardsInfos, JSONObject upgradeResult) {
        ArrayList details = new ArrayList();
        Set<String> pcieCardsModelUID = pcieCardsInfos.keySet();
        upgradeFirmwarePackages.forEach((supportModel, firmware) -> {
            List modelList = pcieCardsModelUID.stream().filter(modeUid -> modeUid.contains((CharSequence)supportModel)).collect(Collectors.toList());
            if (modelList.isEmpty() || StringUtils.isNULLStr((String)supportModel)) {
                this.composeNotMatchPCIeResult((FirmwarePackageEntity)firmware, details);
                return;
            }
            List pcieCardsList = (List)pcieCardsInfos.get(modelList.get(0));
            this.composeEachPCIeResult((FirmwarePackageEntity)firmware, (PcieCardEntity)pcieCardsList.get(0), details);
        });
        upgradeResult.put("Operation", (Object)"Upgrade");
        upgradeResult.put("Progress", (Object)"100.0");
        upgradeResult.put("Detail", details);
    }

    private void composeNotMatchPCIeResult(FirmwarePackageEntity firmware, List<Map<String, String>> details) {
        HashMap<String, String> pcieDetail = new HashMap<String, String>();
        pcieDetail.put("Firmware", ServiceUtil.getFirmwarePackageName(firmware));
        pcieDetail.put("Status", "upgraded");
        pcieDetail.put("Description", "not match");
        pcieDetail.put("NewVersion", "--");
        pcieDetail.put("DeviceType", firmware.getPackageInfo().getModule());
        pcieDetail.put("Device", firmware.getPackageInfo().getSupportModel());
        details.add(pcieDetail);
    }

    private void composeEachPCIeResult(FirmwarePackageEntity firmware, PcieCardEntity pcieCards, List<Map<String, String>> details) {
        HashMap<String, String> pcieDetail = new HashMap<String, String>();
        pcieDetail.put("Firmware", ServiceUtil.getFirmwarePackageName(firmware));
        LOGGER.info("{} pcie {} version {} , firmware {} version {}", new Object[]{this.conn.getDestIp(), pcieCards.getCardType(), pcieCards.getFirmwareVersion(), firmware.getPackageInfo().getModule(), firmware.getPackageInfo().getVersion()});
        if (firmware.getPackageInfo().getVersion().equals(pcieCards.getFirmwareVersion())) {
            pcieDetail.put("Status", "upgraded");
            pcieDetail.put("Description", "upgrade successfully");
            pcieDetail.put("NewVersion", firmware.getPackageInfo().getVersion());
        } else {
            pcieDetail.put("Status", "failed");
            pcieDetail.put("Description", "upgrade failed");
            pcieDetail.put("NewVersion", "--");
        }
        pcieDetail.put("DeviceType", firmware.getPackageInfo().getModule());
        pcieDetail.put("Device", firmware.getPackageInfo().getSupportModel());
        details.add(pcieDetail);
    }

    public OperationResultEntity transportSpPackageByCifs(UpgradeSpParams upgradeSpParams) throws InterruptedException {
        String slotId = this.getDeviceSlotId();
        if (StringUtils.isNULLStr((String)slotId)) {
            return new OperationResultEntity(false, RES.getString("bundle.upgrade.task.pcie.download.failed1"));
        }
        boolean downloadResult = true;
        Map<String, String> spSoftwareUpdateMap = this.getSpSoftwareUpdateMap(upgradeSpParams);
        StringBuilder detailStr = new StringBuilder();
        int maxUpgradeTime = upgradeSpParams.getMaxUpgradeTime();
        int timeout = maxUpgradeTime == 0 ? 3600000 : maxUpgradeTime * 1000;
        OperationResultEntity repeatDownloadFileResult = this.repeatSpFile(upgradeSpParams.getFileName(), slotId, spSoftwareUpdateMap, timeout);
        if (!repeatDownloadFileResult.isPassed()) {
            downloadResult = false;
            detailStr.append(repeatDownloadFileResult.getReturnParam());
        }
        return new OperationResultEntity(downloadResult, detailStr.toString());
    }

    private Map<String, String> getSpSoftwareUpdateMap(UpgradeSpParams upgradeSpParams) {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("ImageURI", upgradeSpParams.getRealImageUrl());
        dataMap.put("SignalURI", "NULL");
        dataMap.put("ImageType", "SP");
        dataMap.put("Parameter", "all");
        dataMap.put("UpgradeMode", upgradeSpParams.getUpgradeMode());
        dataMap.put("ActiveMethod", upgradeSpParams.getActiveMethod());
        return dataMap;
    }

    public OperationResultEntity repeatSpFile(String firmwareName, String slotId, Map<String, String> spUpdateMap, int timeout) throws InterruptedException {
        String url = String.format(Locale.ENGLISH, "/redfish/v1/Managers/%s/SPService/SPFWUpdate/1/Actions/SPFWUpdate.SimpleUpdate", slotId);
        for (int count = 0; count < 3; ++count) {
            RedfishResult resp = this.conn.executePost(url, JSON.toJSONString(spUpdateMap));
            if (!resp.isSuccess()) {
                return new OperationResultEntity(false, RES.getStringWithParams("bundle.upgrade.task.pcie.download.failed", new Object[]{firmwareName}));
            }
            CommonRunnable.sleep((int)10000);
            if (this.checkTransportFile(firmwareName, 30000, timeout, slotId, firmwareName).booleanValue()) {
                LOGGER.info("device {} download fileName {} success.", (Object)this.conn.getDestIp(), (Object)firmwareName);
                return new OperationResultEntity(true, RES.getStringWithParams("bundle.upgrade.task.pcie.download.success", new Object[]{firmwareName}));
            }
            LOGGER.error("device {} download fileName {} failed. try {} times", new Object[]{this.conn.getDestIp(), firmwareName, count});
        }
        return new OperationResultEntity(false, RES.getStringWithParams("bundle.upgrade.task.pcie.download.failed", new Object[]{firmwareName}));
    }

    public Boolean checkTransportFile(String fileName, int intervalTime, int timeout, String slotId, String firmwareName) throws InterruptedException {
        LOGGER.info(String.format(Locale.ENGLISH, "device %s  transport sp %s start...", this.conn.getDestIp(), fileName));
        long firstTime = System.currentTimeMillis();
        String lastTransferProgressPercent = "0";
        while (true) {
            CommonRunnable.sleep((int)intervalTime);
            long currentTime = System.currentTimeMillis();
            String url = String.format(Locale.ENGLISH, "/redfish/v1/Managers/%s/SPService/SPFWUpdate/1", slotId);
            RedfishResult resp = this.conn.executeGet(url);
            if (!resp.isSuccess()) {
                LOGGER.error("device{} cmd {} send error.", (Object)this.conn.getDestIp(), (Object)"/redfish/v1/SessionService/Sessions");
                return false;
            }
            String transferState = (String)RedfishUtils.getObjectAttr((String)resp.getResult(), String.class, (String[])new String[]{"TransferState"});
            String transferProgressPercent = (String)RedfishUtils.getObjectAttr((String)resp.getResult(), String.class, (String[])new String[]{"TransferProgressPercent"});
            if (lastTransferProgressPercent.equalsIgnoreCase(transferProgressPercent) && currentTime - firstTime >= (long)timeout) {
                LOGGER.error("Check transport sp {} time out", (Object)fileName);
                return false;
            }
            lastTransferProgressPercent = transferProgressPercent;
            String transferFileName = (String)RedfishUtils.getObjectAttr((String)resp.getResult(), String.class, (String[])new String[]{"TransferFileName"});
            if ("Failure".equals(transferState)) {
                LOGGER.error(resp.getResult());
                LOGGER.error("device {} get transport sp End flag failed...", (Object)this.conn.getDestIp());
                return false;
            }
            if ("Success".equalsIgnoreCase(transferState) && "100".equals(transferProgressPercent) && firmwareName.equals(transferFileName)) {
                return this.checkFileListResult(url);
            }
            LOGGER.info("device {} transport sp percent:{}.", (Object)this.conn.getDestIp(), (Object)transferProgressPercent);
        }
    }

    public String getVrdVersion(String mark) {
        JSONArray firmwareUrlJsonArray = this.getFrimwareUrlJsonArrayByMark(mark);
        if (firmwareUrlJsonArray.isEmpty()) {
            LOGGER.info("The VRD information cannot be found.");
            return "--";
        }
        String versionUrl = firmwareUrlJsonArray.getJSONObject(0).getString("@odata.id");
        RedfishResult result = this.conn.executeGet(versionUrl);
        if (!result.isSuccess()) {
            LOGGER.error("device {} cmd {} send error.", (Object)this.conn.getDestIp(), (Object)versionUrl);
            return "--";
        }
        return (String)RedfishUtils.getObjectAttr((String)result.getResult(), String.class, (String[])new String[]{"Version"});
    }

    public String getProductUniqueId() {
        if (!this.supportQuery()) {
            return SystemConfig.createSystemConfig().getConfigVlaue("fw.product.uid");
        }
        return super.getProductUniqueId();
    }

    public String getDeviceSlotId() {
        if (!this.supportQuery()) {
            return null;
        }
        return super.getDeviceSlotId();
    }

    public String getMainBordInfo(String sign) {
        if (!this.supportQuery()) {
            return "";
        }
        return super.getMainBordInfo(sign);
    }

    public String getESN() {
        if (!this.supportQuery()) {
            return "";
        }
        return super.getESN();
    }

    public String getSPVersion() {
        if (!this.supportQuery()) {
            return "";
        }
        return super.getSPVersion();
    }

    public String getDeviceTimeZone() {
        if (!this.supportQuery()) {
            return "";
        }
        return super.getDeviceTimeZone();
    }

    public JSONObject getDiskHealth() {
        if (!this.supportQuery()) {
            return null;
        }
        return super.getDiskHealth();
    }

    public String getCPUArchitecture() {
        if (!this.supportQuery()) {
            return "--";
        }
        return super.getCPUArchitecture();
    }

    private boolean supportQuery() {
        return BundleUpgradeContext.getInstance().isBmcAuthCheckOpen() && this.supportRedfish;
    }

    static interface ParseResponseFunction {
        public Object parse(String var1, Object var2);
    }
}

