/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.service;

import com.huawei.bundleupgrade.entity.DeviceEntity;
import com.huawei.bundleupgrade.entity.DiskPkgInfo;
import com.huawei.bundleupgrade.entity.FirmwarePackageEntity;
import com.huawei.bundleupgrade.model.Module;
import com.huawei.bundleupgrade.service.UpgradeTypeSelectionService;
import com.huawei.bundleupgrade.utils.BundleUpgradeContext;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.obase.utils.FileUtils;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskFwParseService {
    private static final Logger log = LoggerFactory.getLogger(DiskFwParseService.class);
    private static final int MIN_DATA_COLS_LENGTH = 3;
    private static final int MIN_VERSION_LIST_LENGTH = 2;
    private final UpgradeTypeSelectionService upgradeTypeSelectionService;

    public DiskFwParseService(UpgradeTypeSelectionService upgradeTypeSelectionService) {
        this.upgradeTypeSelectionService = upgradeTypeSelectionService;
    }

    public Optional<FirmwarePackageEntity> parseDiskFwPackage(String disksFwFilePath) {
        log.info("{} is disk fw package, begin unzip", (Object)disksFwFilePath);
        String unzipRootDir = BundleUpgradeContext.getInstance().getCurrentDiskFwTempPath();
        List<String> legalFilePaths = this.upgradeTypeSelectionService.cmsCheckAndGetPassPaths(disksFwFilePath, unzipRootDir);
        List<DiskPkgInfo> diskInfos = this.loadSingleChannelDiskConfAndFilterLegalDiskInfos(unzipRootDir, legalFilePaths);
        diskInfos.addAll(this.loadMultichannelDiskConfAndFilterLegalDiskInfos(unzipRootDir, legalFilePaths));
        if (diskInfos.isEmpty()) {
            log.warn("disk info is empty.");
            FileUtils.clearDir((String)unzipRootDir);
            return Optional.empty();
        }
        return Optional.of(DiskFwParseService.buildFirmwarePackageEntity(disksFwFilePath, diskInfos));
    }

    private List<DiskPkgInfo> loadMultichannelDiskConfAndFilterLegalDiskInfos(String tempPath, List<String> legalFilePaths) {
        Optional<String> multichannelDiskConfOpt = legalFilePaths.stream().filter(path -> path.contains("hddfw-NewMaterial.conf")).findAny();
        if (!multichannelDiskConfOpt.isPresent()) {
            log.warn("hdd new conf do not exist or cms check failed,abort parse pkg.");
            return Collections.emptyList();
        }
        Set fwFiles = legalFilePaths.stream().map(path -> new File((String)path).getName()).collect(Collectors.toSet());
        return this.loadNewHDDFwConf(multichannelDiskConfOpt.get()).stream().filter(disk -> fwFiles.contains(disk.getFileName())).peek(this.setLocalRelativePath(tempPath)).collect(Collectors.toList());
    }

    private List<DiskPkgInfo> loadSingleChannelDiskConfAndFilterLegalDiskInfos(String rootPath, List<String> legalFilePaths) {
        Optional<String> hddfwConfOpt = legalFilePaths.stream().filter(path -> path.contains("hddfw.conf")).findAny();
        if (!hddfwConfOpt.isPresent()) {
            log.warn("hdd conf do not exist or cms check failed,abort parse pkg");
            return Collections.emptyList();
        }
        Set fwFiles = legalFilePaths.stream().map(path -> new File((String)path).getName()).collect(Collectors.toSet());
        return this.loadHDDFwConf(hddfwConfOpt.get()).stream().filter(disk -> fwFiles.contains(disk.getFileName())).peek(this.setLocalRelativePath(rootPath)).collect(Collectors.toList());
    }

    @NonNull
    private Consumer<DiskPkgInfo> setLocalRelativePath(String tempPath) {
        return disk -> disk.setLocalRelativePath(tempPath + File.separator + disk.getFileName());
    }

    private List<DiskPkgInfo> loadHDDFwConf(String path) {
        String content = StreamUtils.readStringFormFile((File)new File(path));
        String[] lines = content.split("\r\n");
        return Arrays.stream(lines).filter(line -> !line.startsWith("//")).map(this::buildSingleChannelDiskInfos).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private List<DiskPkgInfo> loadNewHDDFwConf(String path) {
        String content = StreamUtils.readStringFormFile((File)new File(path));
        String[] lines = content.split("\r\n");
        return Arrays.stream(lines).filter(line -> !line.startsWith("//")).map(this::buildMultichannelDiskInfo).flatMap(Collection::stream).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().filter(this::isDiskUpgradePathUnique).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    private boolean isDiskUpgradePathUnique(Map.Entry<DiskPkgInfo, Long> ele) {
        if (ele.getValue() > 1L) {
            log.warn("Disk info repeat,abandon it, model {}, sourceVersion {}", (Object)ele.getKey().getModel(), (Object)ele.getKey().getSourceVersion());
            return false;
        }
        return true;
    }

    private Optional<DiskPkgInfo> buildSingleChannelDiskInfos(String line) {
        String[] data = line.split(":");
        if (data.length < 3) {
            log.warn("Invalid disk info : {}", (Object)line);
            return Optional.empty();
        }
        DiskPkgInfo disk = new DiskPkgInfo();
        disk.setModel(data[0]);
        disk.setTargetVersion(data[1]);
        disk.setFileName(data[2]);
        return Optional.of(disk);
    }

    private List<DiskPkgInfo> buildMultichannelDiskInfo(String line) {
        String[] data = line.split(":");
        if (data.length < 3) {
            log.warn("Invalid disk info : {}", (Object)line);
            return Collections.emptyList();
        }
        String[] versions = data[1].split(",");
        if (versions.length < 2) {
            log.warn("Invalid disk info : {}", (Object)line);
            return Collections.emptyList();
        }
        String targetVersion = versions[versions.length - 1];
        return IntStream.range(0, versions.length - 1).mapToObj(index -> this.buildDiskInfo(data, versions[index], targetVersion)).peek(DiskPkgInfo::setDiskInfoToMultichannel).collect(Collectors.toList());
    }

    private static FirmwarePackageEntity buildFirmwarePackageEntity(String absolutePath, List<DiskPkgInfo> diskPkgInfos) {
        FirmwarePackageEntity fwPkg = new FirmwarePackageEntity();
        FirmwarePackageEntity.PackageInfo info = fwPkg.new FirmwarePackageEntity.PackageInfo();
        fwPkg.setTempId(BundleUpgradeContext.getInstance().getFwTempId());
        fwPkg.setPackageInfo(info);
        fwPkg.setDiskPkgInfos(diskPkgInfos);
        fwPkg.setLocalPathAbs(absolutePath);
        info.setPackageName(new File(absolutePath).getName());
        info.setSupportModel("OceanStor Pacific");
        info.setActiveMode("Immediately");
        info.setModule(Module.DiskFw.getName());
        info.setFileType("Firmware");
        info.setUpgradeAgent("SSH");
        info.setSupportModelUID(String.join((CharSequence)";", DeviceEntity.getSupportDiskFwServerUid()));
        info.setVersion("");
        return fwPkg;
    }

    @NonNull
    private DiskPkgInfo buildDiskInfo(String[] data, String version, String targetVersion) {
        DiskPkgInfo disk = new DiskPkgInfo();
        disk.setModel(data[0]);
        disk.setSourceVersion(version);
        disk.setTargetVersion(targetVersion);
        disk.setFileName(data[2]);
        return disk;
    }
}

