/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.service;

import com.alibaba.fastjson.JSONObject;
import com.huawei.bundleupgrade.entity.AccountEntity;
import com.huawei.bundleupgrade.entity.DeviceEntity;
import com.huawei.bundleupgrade.entity.NodeServiceInfo;
import com.huawei.bundleupgrade.entity.UpgradeDeviceEntity;
import com.huawei.bundleupgrade.entity.fusionstrg.FusionStorageClusterInfoEntity;
import com.huawei.bundleupgrade.entity.fusionstrg.UpgDeviceExtendFSDataEntity;
import com.huawei.bundleupgrade.model.ExecuteResult;
import com.huawei.bundleupgrade.service.ScenesParseDeviceInfoService;
import com.huawei.bundleupgrade.ui.listener.UpgradeWindowListener;
import com.huawei.bundleupgrade.utils.BundleUpgradeContext;
import com.huawei.bundleupgrade.utils.UpgradeScenarioUtil;
import com.huawei.bundleupgrade.utils.fusionstrg.FusionStrgUpgradeContext;
import com.huawei.ism.tool.base.utils.AESEncrypt;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.Base64EncodeUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.uMate.common.SystemConfig;
import com.huawei.uMate.common.UMateException;
import com.huawei.uMate.common.utils.ResUtil;
import com.huawei.yinglong.river.devicemanager.storage.distribution.devicecache.entity.Server;
import com.huawei.yinglong.river.upgrade.storage.distributed.fireware.entity.UpgradeToolParams;
import java.awt.Window;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;

public class ParseAllDeviceNodesCallable
implements Callable<Boolean> {
    @Override
    public Boolean call() throws UMateException {
        if (UpgradeScenarioUtil.isYinglong()) {
            this.parseDeviceFromYinglong();
            return !BundleUpgradeContext.getInstance().getDeviceUpgradeInfos().isEmpty();
        }
        this.parseDevice();
        return !BundleUpgradeContext.getInstance().getDeviceUpgradeInfos().isEmpty();
    }

    private void parseDeviceFromYinglong() {
        String deviceInfo = System.getenv("deviceInfo");
        String data = StreamUtils.readStringFormFile((File)new File(deviceInfo));
        UpgradeToolParams toolParams = (UpgradeToolParams)JSONObject.parseObject((String)data, UpgradeToolParams.class);
        List<UpgradeDeviceEntity> entities = toolParams.getServers().stream().map(this::buildUpgradeDeviceEntity).collect(Collectors.toList());
        BundleUpgradeContext.getInstance().setDeviceUpgradeInfos(entities);
        BundleUpgradeContext.getInstance().setAllDeviceList(entities);
        if ("out-band".equals(toolParams.getUpgradeType())) {
            SystemConfig.createSystemConfig().setConfigVlaue("fw.os.auth.check", "false");
            System.setProperty("upgradeType", "out-band");
        }
    }

    public UpgradeDeviceEntity buildUpgradeDeviceEntity(Server server) {
        String sshOsRootPassword;
        DeviceEntity device = new DeviceEntity();
        device.setIp(server.getBmcIp());
        device.setSerialNumber(server.getUid());
        device.setHttpsPort("443");
        device.setSshPort("22");
        device.setSupportRedfish(true);
        device.setAccount(new AccountEntity(server.getLoginUser().getName(), AESEncrypt.decrypt((String)server.getLoginUser().getPwd())));
        NodeServiceInfo serviceInfo = new NodeServiceInfo(server.getOsIp());
        serviceInfo.setServiceInfo(Collections.emptySet());
        serviceInfo.resetNodeUpgradePriorityByNodeServiceInfo();
        device.setNodeServiceInfo(serviceInfo);
        UpgradeDeviceEntity upgradeDeviceEntity = new UpgradeDeviceEntity(device);
        if (server.getOsUser() == null) {
            return upgradeDeviceEntity;
        }
        UpgDeviceExtendFSDataEntity extendFSDataEntity = new UpgDeviceExtendFSDataEntity();
        extendFSDataEntity.setDeviceEntity(upgradeDeviceEntity);
        extendFSDataEntity.setManagementIp(server.getOsIp());
        String sshUserName = server.getOsUser().getName();
        String sshPassword = AESEncrypt.decrypt((String)server.getOsUser().getPwd());
        String string = sshOsRootPassword = server.getOsRootUser() == null ? "" : Base64EncodeUtils.decode((String)AESEncrypt.decrypt((String)server.getOsRootUser().getPwd()));
        if (StringUtils.isNULLStr((String)sshUserName)) {
            sshUserName = "root";
            sshPassword = sshOsRootPassword;
        }
        extendFSDataEntity.setSshAccount(new AccountEntity(sshUserName, sshPassword, sshOsRootPassword));
        FusionStorageClusterInfoEntity clusterInfoEntity = new FusionStorageClusterInfoEntity();
        clusterInfoEntity.setFloatIp("--");
        extendFSDataEntity.setBelongsClusterEntity(clusterInfoEntity);
        FusionStrgUpgradeContext.getInstance().getBusinessIpMapper().put(upgradeDeviceEntity, extendFSDataEntity);
        return upgradeDeviceEntity;
    }

    private void parseDevice() throws UMateException {
        ScenesParseDeviceInfoService parseDevice = new ScenesParseDeviceInfoService();
        List<UpgradeDeviceEntity> deviceEntities = parseDevice.getDevicesList();
        BundleUpgradeContext.getInstance().setAllDeviceList(deviceEntities);
        List<UpgradeDeviceEntity> selectDevices = deviceEntities.stream().filter(dev -> dev.getDeviceEntity().isSelected()).collect(Collectors.toList());
        for (UpgradeDeviceEntity upgradeDeviceEntity : selectDevices) {
            ArrayList<ExecuteResult> executeResults = new ArrayList<ExecuteResult>();
            ExecuteResult result = new ExecuteResult();
            result.setDescription(String.format(Locale.ROOT, "%s device info query success.", upgradeDeviceEntity.getDeviceEntity().getIp()));
            executeResults.add(result);
        }
        BundleUpgradeContext.getInstance().setDeviceUpgradeInfos(selectDevices);
        try {
            parseDevice.parseFusionStorageInfo();
        }
        catch (Exception e) {
            DialogUtils.showErrorDialog((Window)((Object)BundleUpgradeContext.getInstance().getMainDialog()), (String)ResUtil.getInstance((String)"BundleUpgrade").getString("error.fusion.storage.info.not.valid"));
            new UpgradeWindowListener().windowClosing(null);
        }
    }
}

