/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.huawei.bundleupgrade.constants.BundleUpgradeConstants;
import com.huawei.bundleupgrade.constants.UpgradeParamConstants;
import com.huawei.bundleupgrade.entity.DeviceEntity;
import com.huawei.bundleupgrade.entity.ExpRetimer;
import com.huawei.bundleupgrade.entity.OperationResultEntity;
import com.huawei.bundleupgrade.entity.PcieCardEntity;
import com.huawei.bundleupgrade.entity.RetimerTypeEnum;
import com.huawei.bundleupgrade.entity.UpgradeDeviceEntity;
import com.huawei.bundleupgrade.model.ExecuteInfo;
import com.huawei.bundleupgrade.service.DeviceInfoByRedfishService;
import com.huawei.bundleupgrade.service.connection.fusionstrg.FusionStorageSshConnector;
import com.huawei.bundleupgrade.service.connection.fusionstrg.FusionStorageSshPool;
import com.huawei.bundleupgrade.utils.BundleUpgradeContext;
import com.huawei.bundleupgrade.utils.ServiceUtil;
import com.huawei.bundleupgrade.utils.UpgradeScenarioUtil;
import com.huawei.bundleupgrade.utils.fusionstrg.FusionStrgUpgradeContext;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.distributedfwupg.utils.CommonUtils;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.obase.connection.SshConnection;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.CliResolverUtils;
import com.huawei.ism.tool.protocol.rest.RestConnection;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.uMate.common.SystemConfig;
import com.huawei.uMate.common.UMateException;
import com.huawei.uMate.common.utils.ResUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryDeviceInfoService {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryDeviceInfoService.class);
    private static final ResUtil RES = ResUtil.getInstance((String)"BundleUpgrade");
    private static final QueryDeviceInfoService INSTANCE = new QueryDeviceInfoService();
    private static final Pattern OS_VESION_REGEX = Pattern.compile("[\\d.].*euleros[a-zA-Z.0-9_]+");
    private static Set<String> comboBoxValues = new HashSet<String>();
    private static boolean isOsStarted;
    private static final Object LOCK;

    private QueryDeviceInfoService() {
    }

    public static QueryDeviceInfoService getInstance() {
        return INSTANCE;
    }

    public void queryDeviceInfo(List<UpgradeDeviceEntity> devNodes) {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(50, 200, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        for (UpgradeDeviceEntity node : devNodes) {
            ExecuteInfo info = node.getExecuteInfo();
            info.clear();
            LOGGER.error(String.format(Locale.ROOT, "%s  : begin to query device info.", node.getDeviceEntity().getIp()));
            node.setProcessStatus(UpgradeParamConstants.UpgradeStatus.QUERYDEVINFO);
            executor.execute(new QueryTask(node));
        }
        executor.shutdown();
    }

    public String obtainDevBaseInfo(String url, StringBuffer detailStr, DeviceInfoByRedfishService service) {
        OperationResultEntity getDevBaseInfoResult = service.getDevBaseInfo(url);
        if (!getDevBaseInfoResult.isPassed()) {
            detailStr.append(getDevBaseInfoResult.getReturnParam());
            return "--";
        }
        return getDevBaseInfoResult.getReturnParam();
    }

    public void updateFwInfo(DeviceInfoByRedfishService service, UpgradeDeviceEntity device, StringBuffer detailStr) throws UMateException {
        this.queryInfoByBMC(service, device, detailStr);
        this.queryInfoBySSH(device.getDeviceEntity());
    }

    private void queryInfoByBMC(DeviceInfoByRedfishService service, UpgradeDeviceEntity upgradeDevice, StringBuffer detailStr) {
        DeviceEntity device = upgradeDevice.getDeviceEntity();
        if (!BundleUpgradeContext.getInstance().isBmcAuthCheckOpen() || !device.isSupportRedfish()) {
            LOGGER.info("Do not open bmc auth,think do not has bmc info");
            return;
        }
        device.setMasterBMC(this.obtainDevBaseInfo("ActiveBMC", detailStr, service));
        device.setBmcActiveMode(service.getBmcActiveMode());
        device.setCpldModels(service.getCpldModelList(service.getFrimwareUrlJsonArrayByMark("CPLD"), device));
        device.setSlaveBMC(this.obtainDevBaseInfo("BackupBMC", detailStr, service));
        device.setActiveCPLDVersion(this.obtainDevBaseInfo("MainBoardCPLD", detailStr, service));
        device.setFanVersion(service.getFanVersion(device));
        this.queryPsuInfo(service, detailStr);
        device.setPsuModels(service.getPsuModeList(device));
        device.setEthCdrVersion(this.getEthCdrVersion(service, upgradeDevice, device));
        if (device.isDirectPlane()) {
            return;
        }
        device.setVrdVersion(this.getVrdVersion(service, upgradeDevice, device));
        device.setBiosVersion(this.getBiosVersion(service, upgradeDevice, detailStr, device));
        device.setCdrVersion(service.getCDROrRetimerVersion("CDR"));
        device.setRetimerVersion(service.getCDROrRetimerVersion("Retimer"));
        device.setControllerMark(service.queryBlade());
        device.setExpRetimers(this.getExpRetimerVersion(service, upgradeDevice, device));
        device.setPcieCardsInfos(this.getPcieCardInfos(service, detailStr));
        this.queryCpldInfo(service, detailStr);
        device.setMcuVersion(service.getMcuVersion(device));
        device.setBbuModels(service.getBbuVersion(device));
        device.setIobBiosVersion(service.getIobBiosVersion());
        device.setSpVersion(this.updateSpVersionPretty(service, detailStr, device));
    }

    private String updateSpVersionPretty(DeviceInfoByRedfishService service, StringBuffer detailStr, DeviceEntity device) {
        OperationResultEntity getDevBaseInfoResult = service.getSPVersionPretty(device.isSupportSp());
        if (!getDevBaseInfoResult.isPassed()) {
            detailStr.append(getDevBaseInfoResult.getReturnParam());
        }
        return getDevBaseInfoResult.getReturnParam();
    }

    private void queryCpldInfo(DeviceInfoByRedfishService service, StringBuffer detailStr) {
        if (service.getFrimwareUrlJsonArrayByMark("CPLD").size() == 0) {
            detailStr.append(RES.getString("bundle.upgrade.query.device.info.backcpldinfo"));
        }
    }

    private Map<String, List<PcieCardEntity>> getPcieCardInfos(DeviceInfoByRedfishService service, StringBuffer detailStr) {
        Map<String, List<PcieCardEntity>> pcieCardsInfos = service.getPcieCardsInfo(service.getPcieJsonArray());
        if (pcieCardsInfos.isEmpty()) {
            detailStr.append(RES.getString("bundle.upgrade.query.device.info.pcieinfo"));
        }
        return pcieCardsInfos;
    }

    private String getBiosVersion(DeviceInfoByRedfishService service, UpgradeDeviceEntity upgradeDevice, StringBuffer detailStr, DeviceEntity device) {
        return this.queryAfterOsRestartIfNeeded(device::getBiosVersion, () -> this.obtainDevBaseInfo("BIOS", detailStr, service), upgradeDevice, UpgradeParamConstants.ModuleType.BIOS);
    }

    private void queryPsuInfo(DeviceInfoByRedfishService service, StringBuffer detailStr) {
        String chassisType;
        if (service.getFrimwareUrlJsonArrayByMark("chassisPS").size() == 0 && !StringUtils.isNULLStr((String)(chassisType = service.getChassisType())) && !chassisType.equals("Blade")) {
            detailStr.append(RES.getString("bundle.upgrade.query.device.info.psuinfo"));
        }
    }

    private String getVrdVersion(DeviceInfoByRedfishService service, UpgradeDeviceEntity upgradeDevice, DeviceEntity device) {
        return this.queryAfterOsRestartIfNeeded(device::getVrdVersion, () -> service.getVrdVersion("MainboardVRD"), upgradeDevice, UpgradeParamConstants.ModuleType.VRD);
    }

    String getEthCdrVersion(DeviceInfoByRedfishService service, UpgradeDeviceEntity upgradeDevice, DeviceEntity device) {
        return this.queryAfterOsRestartIfNeeded(device::getEthCdrVersion, () -> service.getEthCdrVersion(device), upgradeDevice, UpgradeParamConstants.ModuleType.ETH_CDR);
    }

    List<ExpRetimer> getExpRetimerVersion(DeviceInfoByRedfishService service, UpgradeDeviceEntity upgradeDevice, DeviceEntity device) {
        String orgExpRetimerVersionInfo = this.getOrgRetimerVersionInfo(device);
        if (!orgExpRetimerVersionInfo.isEmpty()) {
            boolean is5902retimer = device.getExpRetimers().stream().anyMatch(retimer -> RetimerTypeEnum.RETIMER_5902H.equals((Object)retimer.getRetimerTypeEnum()));
            if (is5902retimer) {
                this.queryExpRetimerRetry(orgExpRetimerVersionInfo, service, device, upgradeDevice, UpgradeParamConstants.ModuleType.PCIE_RETIMER);
            } else {
                this.queryExpRetimerRetry(orgExpRetimerVersionInfo, service, device, upgradeDevice, UpgradeParamConstants.ModuleType.PCIE_RETIMER_TI_RETIMER);
            }
        }
        return service.getExpRetimers(device);
    }

    private String getOrgRetimerVersionInfo(DeviceEntity device) {
        return device.getExpRetimers().stream().map(retimer -> retimer.getExpReTimerVersion()).filter(Objects::nonNull).distinct().sorted().collect(Collectors.joining(","));
    }

    private void queryExpRetimerRetry(String versionInfo, DeviceInfoByRedfishService service, DeviceEntity device, UpgradeDeviceEntity upgradeDevice, UpgradeParamConstants.ModuleType retimerType) {
        LOGGER.info("Query the exp retimer version information in retry mode.");
        this.queryAfterOsRestartIfNeeded(() -> versionInfo, () -> service.getExpRetimers(device).stream().map(retimer -> retimer.getExpReTimerVersion()).distinct().sorted().collect(Collectors.joining(",")), upgradeDevice, retimerType);
    }

    private String queryAfterOsRestartIfNeeded(Supplier<String> getOldVersion, Supplier<String> versionQuery, UpgradeDeviceEntity node, UpgradeParamConstants.ModuleType type) {
        String targetVersion;
        String currentVersion = versionQuery.get();
        Optional<UpgradeDeviceEntity.FirmUpgradeResult> needVerifyResult = node.getUpgradeDetails().getOrDefault((Object)type, Collections.emptyList()).stream().filter(UpgradeDeviceEntity.FirmUpgradeResult::isSuc).findAny();
        if (!needVerifyResult.isPresent()) {
            LOGGER.info("Module: {} not performing upgrade, no need to recheck version", (Object)type.getModule());
            return currentVersion;
        }
        String oldVersion = getOldVersion.get();
        if (this.isOldVersionEqualsTargetVersion(type, currentVersion, oldVersion, targetVersion = needVerifyResult.get().getFirmwarePackage().getPackageInfo().getVersion())) {
            LOGGER.info("Mdlule: {} org version {} equls traget version {}, no need to recheck version", new Object[]{type.getModule(), oldVersion, targetVersion});
            return currentVersion;
        }
        long startTime = System.currentTimeMillis();
        long timeOut = Long.valueOf(ApplicationContext.getInstance().getAppConfig("yinglong.fwupgrade.os.restrated.max.time"));
        int interval = Integer.valueOf(ApplicationContext.getInstance().getAppConfig("yinglong.fwupgrade.os.restrated.interval"));
        String ip = node.getDeviceEntity().getIp();
        while (Objects.equals(currentVersion, oldVersion) || "--".equals(currentVersion)) {
            if (System.currentTimeMillis() - startTime > timeOut) {
                LOGGER.warn("The {} version of {} does not change, and query time out", (Object)type, (Object)ip);
                break;
            }
            LOGGER.info("The {} version of {} dose not change, and wait to query again", (Object)type, (Object)ip);
            CommonUtils.safeSleep(interval);
            currentVersion = versionQuery.get();
        }
        return currentVersion;
    }

    boolean isOldVersionEqualsTargetVersion(UpgradeParamConstants.ModuleType type, String currentVersion, String oldVersion, String targetVersion) {
        if ("--".equals(currentVersion) || Objects.isNull(oldVersion)) {
            return false;
        }
        if (UpgradeParamConstants.ModuleType.VRD.equals((Object)type)) {
            String singelVrdVer = Arrays.stream(oldVersion.split("\\.")).distinct().collect(Collectors.joining("."));
            return Objects.equals(singelVrdVer, targetVersion);
        }
        return Objects.equals(oldVersion, targetVersion);
    }

    void queryInfoBySSH(DeviceEntity device) throws UMateException {
        if (!BundleUpgradeContext.getInstance().isSshAuthCheckOpen()) {
            LOGGER.info("Do not open ssh auth,think do not has ssh info");
            return;
        }
        try {
            if (!device.isDirectPlane()) {
                FusionStorageSshConnector sshConnector = FusionStorageSshPool.getFsSshConnectionByBmcIp(device.getIp());
                String kernelVerisonAndCpuArchitecture = this.getKernelVersionAndCpuArchitecture(device, sshConnector);
                LOGGER.info("the node ip {} version {} ", (Object)device.getIp(), (Object)kernelVerisonAndCpuArchitecture);
                device.setCpuArchitecture(kernelVerisonAndCpuArchitecture);
                device.setKernelVersion(kernelVerisonAndCpuArchitecture);
                device.setDiskInfo(this.getDiskList(device, sshConnector));
            }
        }
        catch (UMateException e) {
            LOGGER.error("Get node {} info by ssh error ", (Object)device.getIp());
            device.setDiskInfo(Collections.emptyList());
            throw e;
        }
        finally {
            FusionStorageSshPool.releaseFsSshConnection(FusionStrgUpgradeContext.getInstance().getFsDeviceEntityByBmcIp(device.getIp()));
        }
    }

    public String getKernelVersionAndCpuArchitecture(DeviceEntity device, FusionStorageSshConnector sshConnector) {
        try {
            String result = sshConnector.executeCmd("uname -r");
            Matcher matcher = OS_VESION_REGEX.matcher(result);
            if (matcher.find()) {
                return matcher.group().toLowerCase(Locale.ROOT);
            }
        }
        catch (Exception e) {
            LOGGER.error("Get node {} Bversion and CpuArchitecture error", (Object)device.getIp(), (Object)e);
        }
        return "";
    }

    public List<DeviceEntity.DiskModel> getDiskList(DeviceEntity device, FusionStorageSshConnector sshConnector) {
        try {
            List<DeviceEntity.DiskModel> disks = this.queryAndBuildDisks(device, sshConnector);
            return disks;
        }
        catch (Exception e) {
            LOGGER.error("Get node {} Disk list exist error. ", (Object)device.getIp(), (Object)e);
            return Collections.emptyList();
        }
    }

    private void updateHDDDisksModelAndVer(List<DeviceEntity.DiskModel> disks, FusionStorageSshConnector ssh) throws Exception {
        if (!disks.stream().anyMatch(DeviceEntity.DiskModel::isSasOrSataDisk)) {
            return;
        }
        LOGGER.info("Update hdd disk Model.");
        String cmd = "disktool -s";
        try {
            List data = CliResolverUtils.parseHorizontalTable((String)ssh.executeCmd(cmd), Arrays.asList("Device", "Product", "Rev"), (String)"\\s\\s\\s+");
            data.forEach(info -> {
                String name = info.getOrDefault("Device", "--");
                String model = info.getOrDefault("Product", "--");
                String ver = info.getOrDefault("Rev", "--");
                disks.stream().filter(disk -> name.endsWith(disk.getName())).findFirst().ifPresent(disk -> this.updateModelAndVer(model, (DeviceEntity.DiskModel)disk, ver));
            });
        }
        catch (ToolException e) {
            LOGGER.error("Update hdd disk model failed.", (Throwable)e);
        }
    }

    private void updateModelAndVer(String model, DeviceEntity.DiskModel disk, String ver) {
        String orgModel = disk.getModel();
        if ("DEFAULT".equals(orgModel) || "NUll".equals(orgModel) || orgModel.length() > model.length()) {
            return;
        }
        LOGGER.info("Update disk {} model {} to {} ,ver {}.", new Object[]{disk.getEsn(), disk.getModel(), model, ver});
        disk.setModel(model);
        disk.setFirmwareVersion(ver);
    }

    public List<DeviceEntity.DiskModel> queryAndBuildDisks(DeviceEntity device, FusionStorageSshConnector ssh) throws Exception {
        String cmd = "show_disk.sh";
        List<Map<String, String>> data = this.buildDiskData(ssh.executeCmd(cmd));
        List<DeviceEntity.DiskModel> disks = this.buildDisks(data, device);
        this.removeOtherNodeSriovDisk(device, disks);
        device.setSriovDevice(disks.stream().anyMatch(DeviceEntity.DiskModel::isSriovDisk));
        this.setSriovDiskDeriverLetter(ssh, disks);
        this.updateHDDDisksModelAndVer(disks, ssh);
        return disks;
    }

    public List<Map<String, String>> buildDiskData(String showDiskResult) throws ToolException {
        List data = CliResolverUtils.parseHorizontalTable((String)showDiskResult, Arrays.asList("VMR", "Name", "Type", "Esn", "VF"), (String)"\\|");
        if (CollectionUtils.isNotEmpty((Collection)data)) {
            return data;
        }
        return CliResolverUtils.parseHorizontalTable((String)showDiskResult, Arrays.asList("VMR", "Name", "Type", "Esn"), (String)"\\|");
    }

    public List<DeviceEntity.DiskModel> queryAndBuildDisksAndRemoveByCache(DeviceEntity device, FusionStorageSshConnector ssh) throws Exception {
        String cmd = "show_disk.sh";
        List<Map<String, String>> data = this.buildDiskData(ssh.executeCmd(cmd));
        List<DeviceEntity.DiskModel> disks = this.buildDisks(data, device);
        this.removeOtherNodeSriovDiskByCache(device, disks);
        this.updateHDDDisksModelAndVer(disks, ssh);
        return disks;
    }

    private void removeOtherNodeSriovDiskByCache(DeviceEntity device, List<DeviceEntity.DiskModel> disks) {
        disks.removeIf(disk -> device.getSriovDiskEsnInOtherNode().contains(disk.getEsn()));
    }

    private void setSriovDiskDeriverLetter(FusionStorageSshConnector ssh, List<DeviceEntity.DiskModel> disks) throws Exception {
        for (DeviceEntity.DiskModel disk : disks) {
            if (!disk.isSriovDisk()) continue;
            LOGGER.info("Setting the drive letter of the sirov disk {}", (Object)disk.getEsn());
            String cmd = "ll /dev/nvme*";
            String result = SshConnection.eliminatesResultColorCode((String)ssh.executeCmd(cmd)).replace(cmd, "");
            List<String> diskSnAndcntlId = this.parseDriverLetter(result);
            for (String findDiskSnCmd : diskSnAndcntlId) {
                if (!this.isMatchDeriverLetter(findDiskSnCmd, ssh, disk)) continue;
                Matcher matcher = BundleUpgradeConstants.DISK_NAME_REG.matcher(findDiskSnCmd);
                disk.setDriveLetter(matcher.find() ? matcher.group() : disk.getDriveLetter());
                return;
            }
        }
    }

    private void removeOtherNodeSriovDisk(DeviceEntity device, List<DeviceEntity.DiskModel> disks) throws ToolException {
        if (!device.isEastSeaDoubleServer() || UpgradeScenarioUtil.isYinglong()) {
            return;
        }
        String managementIp = this.getManagementIp(device);
        ResponseInfo responseInfo = this.executeCmd(managementIp, device);
        Iterator<DeviceEntity.DiskModel> iterator = disks.iterator();
        while (iterator.hasNext()) {
            DeviceEntity.DiskModel disk = iterator.next();
            if (!disk.isNVMeDisk() || this.isCurrentNodeDisk(disk, managementIp, responseInfo)) continue;
            device.getSriovDiskEsnInOtherNode().add(disk.getEsn());
            iterator.remove();
        }
    }

    private boolean isMatchDeriverLetter(String command, FusionStorageSshConnector ssh, DeviceEntity.DiskModel disk) throws Exception {
        String rec = SshConnection.eliminatesResultColorCode((String)ssh.executeCmd(command)).replace(command, "");
        String sn = this.parseResult(rec, BundleUpgradeConstants.SN_REG);
        String cntlId = this.parseResult(rec, BundleUpgradeConstants.CNTL_ID_REG);
        if (!Objects.equals(sn, disk.getEsn()) || !BundleUpgradeConstants.CNTL_ID_OF_PHYSICAL_DRIVE_LETTERS.contains(cntlId)) {
            return false;
        }
        LOGGER.info("Match Disk {} driver letter", (Object)disk.getEsn());
        return true;
    }

    private String parseResult(String commandOutput, Pattern pattern) {
        Matcher matcher = pattern.matcher(commandOutput);
        if (!matcher.find()) {
            return "";
        }
        return Objects.isNull(matcher.group()) ? "" : matcher.group();
    }

    private List<String> parseDriverLetter(String commandOutput) {
        ArrayList<String> nameSpaces = new ArrayList<String>();
        Matcher matcher = BundleUpgradeConstants.DISK_NAME_REG.matcher(commandOutput);
        while (matcher.find()) {
            nameSpaces.add(matcher.group());
        }
        return nameSpaces.stream().filter(nameSpace -> !Objects.isNull(nameSpace)).map(diskName -> "nvme id-ctrl " + diskName + " |grep -E \"sn|cntlid\"").collect(Collectors.toList());
    }

    private boolean isCurrentNodeDisk(DeviceEntity.DiskModel disk, String managementIp, ResponseInfo responseInfo) {
        if (Objects.isNull(disk)) {
            return false;
        }
        if (!responseInfo.isSuccess()) {
            LOGGER.error("Query {} disk info failed", (Object)managementIp);
            return false;
        }
        JSONObject servers = JSON.parseObject((String)responseInfo.getContent()).getJSONObject("servers");
        if (Objects.isNull(servers)) {
            LOGGER.warn("Node {} disk info is null", (Object)managementIp);
            return false;
        }
        JSONArray jsonArray = servers.getJSONArray(managementIp);
        return jsonArray.stream().map(json -> JSON.parseObject((String)json.toString())).map(jsonObject -> jsonObject.getString("phyDevEsn")).anyMatch(devSn -> devSn.contains(disk.getEsn()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResponseInfo executeCmd(String managementIp, DeviceEntity device) throws ToolException {
        JSONObject params = new JSONObject();
        params.put("nodeIpList", (Object)new String[]{managementIp});
        String url = "/dsware/service/vsan/scanServerMedia";
        Object object = LOCK;
        synchronized (object) {
            ResponseInfo responseInfo;
            DevNode devNode = ServiceUtil.buildDevNode(device);
            try {
                RestConnection conn = RestConnectionManager.getRestConnection((DevNode)devNode);
                responseInfo = conn.execPost(conn.getDstorageBaseUrlNoV2() + url, params.toJSONString());
            }
            catch (ToolException e) {
                ResponseInfo responseInfo2;
                try {
                    LOGGER.error("Query disk info error:", (Throwable)e);
                    responseInfo2 = new ResponseInfo();
                }
                catch (Throwable throwable) {
                    SshConnectionManager.releaseConnection((DevNode)devNode);
                    throw throwable;
                }
                SshConnectionManager.releaseConnection((DevNode)devNode);
                return responseInfo2;
            }
            SshConnectionManager.releaseConnection((DevNode)devNode);
            return responseInfo;
        }
    }

    private String getManagementIp(DeviceEntity device) {
        String managementIp = FusionStrgUpgradeContext.getInstance().getFsDeviceEntityByBmcIp(device.getIp()).getManagementIp();
        return org.apache.commons.lang3.StringUtils.defaultString((String)managementIp);
    }

    private List<DeviceEntity.DiskModel> buildDisks(List<Map<String, String>> data, DeviceEntity device) {
        return data.stream().map(diskInfo -> this.buildDisk(device, (Map<String, String>)diskInfo)).filter(Objects::nonNull).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<DeviceEntity.DiskModel>(Comparator.comparing(DeviceEntity.DiskModel::getEsn))), ArrayList::new));
    }

    private DeviceEntity.DiskModel buildDisk(DeviceEntity device, Map<String, String> diskInfo) {
        try {
            DeviceEntity.DiskModel disk = device.new DeviceEntity.DiskModel();
            disk.setName(diskInfo.get("Name"));
            disk.setDiskType(diskInfo.get("Type"));
            disk.setSriovDisk("1".equals(diskInfo.get("VF")));
            String[] eSns = diskInfo.get("Esn").split("\\+");
            disk.setEsn(eSns.length > 0 ? eSns[0] : "");
            String[] vmrData = diskInfo.get("VMR").split(",");
            disk.setVendor(vmrData[0].trim());
            disk.setModel(vmrData[1].trim());
            disk.setFirmwareVersion(vmrData[2].trim());
            return disk;
        }
        catch (Exception e) {
            LOGGER.error("Parse disk error, data: {}", diskInfo);
            return null;
        }
    }

    static {
        LOCK = new Object();
    }

    private class QueryTask
    implements Runnable {
        private UpgradeDeviceEntity node;

        public QueryTask(UpgradeDeviceEntity node) {
            this.node = node;
        }

        @Override
        public void run() {
            Thread.currentThread().setName("query-base-info-thread-".concat(this.node.getDeviceEntity().getIp()));
            this.node.setProcessStatus(UpgradeParamConstants.UpgradeStatus.QUERYDEVINFO);
            BundleUpgradeContext.getInstance().getMainDialog().resultCallBack(this.node);
            try (DeviceInfoByRedfishService service = new DeviceInfoByRedfishService(this.node.getDeviceEntity());){
                StringBuffer detailStr = new StringBuffer();
                this.queryDevInfoByRedfishOrSsh(service, detailStr);
                this.queryDevInfoResult(detailStr);
                if (!service.checkIsSupport().booleanValue()) {
                    this.node.setProcessStatus(UpgradeParamConstants.UpgradeStatus.NOSUPPORTED);
                } else {
                    this.node.setProcessStatus(UpgradeParamConstants.UpgradeStatus.NOTASSOCIATED);
                }
            }
            catch (Exception exception) {
                LOGGER.error(String.format(Locale.ENGLISH, "node %s obtain and query device info error", this.node.getDeviceEntity().getIp()), (Throwable)exception);
                this.node.setProcessStatus(UpgradeParamConstants.UpgradeStatus.UNKNOWN);
            }
            String productType = this.node.getDeviceEntity().getProductTypeShow();
            if (!comboBoxValues.contains(productType)) {
                comboBoxValues.add(productType);
                BundleUpgradeContext.getInstance().getMainDialog().getMainPanel().getTableContentPane().getPmMultiCombox().getMultiPopup().addItem(productType);
            }
            BundleUpgradeContext.getInstance().uiCallBack(this.node);
        }

        private void queryDevInfoResult(StringBuffer detailStr) {
            if (StringUtils.isNULLStr((String)detailStr.toString())) {
                BundleUpgradeContext.getInstance().getMainDialog().updateExecuteResult(this.node, RES.getString("bundle.upgrade.main.detail.info.empty"), (Double)0.1, true);
            } else {
                BundleUpgradeContext.getInstance().getMainDialog().updateExecuteResult(this.node, detailStr.toString(), (Double)0.1, false);
            }
        }

        public void queryDevInfoByRedfishOrSsh(DeviceInfoByRedfishService service, StringBuffer detailStr) throws UMateException {
            if (StringUtils.isNULLStr((String)service.getProductUniqueId())) {
                detailStr.append(RES.getString("bundle.upgrade.query.device.info.productuniqueid"));
            }
            DeviceEntity device = this.node.getDeviceEntity();
            device.setProductUniqueId(service.getProductUniqueId());
            QueryDeviceInfoService.this.updateFwInfo(service, this.node, detailStr);
            this.querySpInfo(service, detailStr, device);
            this.queryDeviceOriginalVersion();
            this.queryProductType(service);
        }

        private void querySpInfo(DeviceInfoByRedfishService service, StringBuffer detailStr, DeviceEntity device) {
            if (device.isDirectPlane() || device.isSnService()) {
                return;
            }
            if (!BundleUpgradeContext.getInstance().isBmcAuthCheckOpen() || !device.isSupportRedfish()) {
                device.setProcessorArchitecture(SystemConfig.createSystemConfig().getConfigVlaue("fw.product.architecture"));
                return;
            }
            device.setProcessorArchitecture(service.getProcessorArchitecture());
            device.setWatchDogModel(service.getDevWatchDogModle());
            OperationResultEntity getDevBaseInfoResult = service.getSPVersionPretty(device.isSupportSp());
            if (!getDevBaseInfoResult.isPassed()) {
                detailStr.append(getDevBaseInfoResult.getReturnParam());
            }
            device.setSpVersion(getDevBaseInfoResult.getReturnParam());
        }

        private void queryProductType(DeviceInfoByRedfishService service) {
            if (!BundleUpgradeContext.getInstance().isBmcAuthCheckOpen() || !this.node.getDeviceEntity().isSupportRedfish()) {
                return;
            }
            OperationResultEntity productName = service.obtainProductName(true);
            if (productName.isPassed()) {
                this.node.getDeviceEntity().setProductName(productName.getReturnParam());
            }
            OperationResultEntity aliasName = service.obtainProductName(false);
            if (productName.isPassed() && aliasName.isPassed()) {
                this.node.getDeviceEntity().setProductType(StringUtils.isNULLStr((String)aliasName.getReturnParam()) ? productName.getReturnParam() : String.format(Locale.ENGLISH, "%s(%s)", productName.getReturnParam(), aliasName.getReturnParam()));
            } else {
                if (StringUtils.isNULLStr((String)productName.getReturnParam())) {
                    return;
                }
                this.node.getDeviceEntity().setProductType(productName.getReturnParam());
            }
        }

        private void queryDeviceOriginalVersion() {
            if (StringUtils.isNULLStr((String)this.node.getDeviceEntity().getOriginalMasterBMC()) || this.node.getDeviceEntity().getOriginalMasterBMC().equals("--")) {
                this.node.getDeviceEntity().setOriginalMasterBMC(this.node.getDeviceEntity().getMasterBMC());
            }
            if (StringUtils.isNULLStr((String)this.node.getDeviceEntity().getOriginalActiveCPLDVersion()) || this.node.getDeviceEntity().getOriginalActiveCPLDVersion().equals("--")) {
                this.node.getDeviceEntity().setOriginalActiveCPLDVersion(this.node.getDeviceEntity().getActiveCPLDVersion());
            }
            if (StringUtils.isNULLStr((String)this.node.getDeviceEntity().getOriginalBiosVersion()) || this.node.getDeviceEntity().getOriginalBiosVersion().equals("--")) {
                this.node.getDeviceEntity().setOriginalBiosVersion(this.node.getDeviceEntity().getBiosVersion());
            }
        }
    }
}

