/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.ParserConfig;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.huawei.bundleupgrade.entity.AccountEntity;
import com.huawei.bundleupgrade.entity.DeviceEntity;
import com.huawei.bundleupgrade.entity.NodeServiceInfo;
import com.huawei.bundleupgrade.entity.UpgradeDeviceEntity;
import com.huawei.bundleupgrade.entity.fusionstrg.FusionStorageClusterInfoEntity;
import com.huawei.bundleupgrade.entity.fusionstrg.UpgDeviceExtendFSDataEntity;
import com.huawei.bundleupgrade.utils.BundleUpgradeContext;
import com.huawei.bundleupgrade.utils.fusionstrg.FusionStrgUpgradeContext;
import com.huawei.ism.tool.base.utils.AESEncrypt;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.obase.connection.MultiRouteNode;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.uMate.common.UMateException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ScenesParseDeviceInfoService {
    private static final Logger log = LoggerFactory.getLogger(ScenesParseDeviceInfoService.class);
    private static final String DEVICELIST_PATH = ApplicationContext.getInstance().getWorkPath().substring(0, ApplicationContext.getInstance().getWorkPath().lastIndexOf("tools")) + "temp" + File.separator + "sceneTemplates" + File.separator + "server" + File.separator + "sceneDevice.json";
    private static final String DEVICE_TYPE_IBMC = "ibmc";
    private static final Gson GSON = new Gson();
    private String deviceType = "";
    private String deviceDataContent = "";
    private List<UpgradeDeviceEntity> upgradeDeviceNodes = new ArrayList<UpgradeDeviceEntity>();

    ScenesParseDeviceInfoService() {
    }

    public List<UpgradeDeviceEntity> getDevicesList() throws UMateException {
        String deviceContent = this.getDeviceDataFileString();
        if (StringUtils.isNULLStr((String)deviceContent)) {
            log.error(String.format(Locale.ROOT, "%s  is empty", DEVICELIST_PATH));
            return Collections.emptyList();
        }
        ParserConfig.getGlobalInstance().setAutoTypeSupport(false);
        JSONObject devicesListInfo = JSONObject.parseObject((String)deviceContent);
        JSONArray deviceJson = devicesListInfo.getJSONArray("deviceList");
        if (deviceJson == null || deviceJson.isEmpty()) {
            log.error(String.format(Locale.ROOT, "%s  is error", DEVICELIST_PATH));
            return Collections.emptyList();
        }
        for (int i = 0; i < deviceJson.size(); ++i) {
            JSONObject object = deviceJson.getJSONObject(i);
            this.deviceType = object.getString("type");
            if (this.deviceType.toLowerCase(Locale.ENGLISH).equals(DEVICE_TYPE_IBMC)) {
                this.parseDeployDevNode(object);
                continue;
            }
            log.info(String.format(Locale.ROOT, "%s is not I_BMC ,unsupport BundleUpgrade", object.getString("ip")));
        }
        return this.upgradeDeviceNodes;
    }

    private String getDeviceDataFileString() {
        if (StringUtils.isNULLStr((String)this.deviceDataContent)) {
            log.info("start to parse device info from local directory");
            this.deviceDataContent = ScenesParseDeviceInfoService.readFile(DEVICELIST_PATH);
        }
        return this.deviceDataContent;
    }

    private void parseDeployDevNode(JSONObject object) throws UMateException {
        String productType = this.getString(object, "productType");
        String iBmcVersion = this.getString(object, "masterBMC");
        String biosVersion = this.getString(object, "biosVersion");
        String deviceProductIp = this.getString(object, "ip");
        DeviceEntity deploy = new DeviceEntity();
        deploy.setIp(deviceProductIp);
        deploy.setType(this.deviceType);
        deploy.setProductType(productType);
        deploy.setSerialNumber(this.getString(object, "serialNumber"));
        deploy.setActiveCPLDVersion(this.getString(object, "cpldVersion"));
        deploy.setBiosVersion(biosVersion);
        deploy.setMasterBMC(iBmcVersion);
        deploy.setSlaveBMC(this.getString(object, "slaveBMC"));
        deploy.setSshPort(this.getString(object, "sshPort"));
        deploy.setHttpsPort(this.getString(object, "httpsPort"));
        deploy.setSelected(Boolean.parseBoolean(this.getString(object, "select")));
        deploy.setChassisId(this.getString(object, "chassisId"));
        deploy.setStorageBackEndPortList(object.getJSONArray("storageBackEndPortList").toJavaList(String.class));
        deploy.setStorageFrontEndPortList(object.getJSONArray("storageFrontendEndPortList").toJavaList(String.class));
        deploy.setSshForwardList(this.getMultiRouteNodes(object));
        String supportRedfish = this.getString(object, "supportRedfish");
        String baseBoardTypeStr = this.getString(object, "baseBoardType");
        deploy.setManagementIps(this.getList(object, "managementIps"));
        ClusterNode.BaseBoardType.mappingEnum((String)baseBoardTypeStr).ifPresent(deploy::setBaseBoardType);
        if (StringUtils.isNULLStr((String)supportRedfish)) {
            deploy.setSupportRedfish(true);
        } else {
            deploy.setSupportRedfish(Boolean.parseBoolean(supportRedfish));
        }
        AccountEntity account = new AccountEntity(this.getString(object, "username"), this.decrypt(this.getString(object, "password")));
        deploy.setAccount(account);
        this.pareNodeServiceInfo(deploy, object);
        UpgradeDeviceEntity upgradeDevNode = new UpgradeDeviceEntity(deploy);
        this.upgradeDeviceNodes.add(upgradeDevNode);
        log.info(String.format(Locale.ROOT, "discover %s  device ,productType is %s,biosVersion version is %s ,iBMCversion is %s,", deviceProductIp, productType, biosVersion, iBmcVersion));
    }

    private List<MultiRouteNode> getMultiRouteNodes(JSONObject object) {
        String sshForwardList = object.getString("sshForwardList");
        if (sshForwardList == null) {
            return Collections.emptyList();
        }
        return (List)GSON.fromJson(sshForwardList, new TypeToken<List<MultiRouteNode>>(){}.getType());
    }

    private void pareNodeServiceInfo(DeviceEntity deploy, JSONObject object) {
        if (!object.containsKey((Object)"nodeServiceInfo")) {
            return;
        }
        try {
            JSONObject nodeServiceInfoJSONO = object.getJSONObject("nodeServiceInfo");
            NodeServiceInfo nodeServiceInfo = new NodeServiceInfo(nodeServiceInfoJSONO.getString("mgrIP"));
            nodeServiceInfo.setProductVersion(nodeServiceInfoJSONO.getString("productVersion"));
            nodeServiceInfo.setServiceInfo(new HashSet<String>(nodeServiceInfoJSONO.getJSONArray("serviceInfo").toJavaList(String.class)));
            nodeServiceInfo.setQueryServiceError(nodeServiceInfoJSONO.getBooleanValue("queryServiceError"));
            nodeServiceInfo.setStoragePoolId(nodeServiceInfoJSONO.getString("storagePoolId"));
            nodeServiceInfo.setDiskPoolId(nodeServiceInfoJSONO.getString("diskPoolId"));
            nodeServiceInfo.setSupportDiskPool(nodeServiceInfoJSONO.getBoolean("isSupportDiskPool"));
            nodeServiceInfo.setQueryStoragePoolError(nodeServiceInfoJSONO.getBooleanValue("queryStoragePoolError"));
            nodeServiceInfo.setVolumeNum(nodeServiceInfoJSONO.getIntValue("volumeNum"));
            nodeServiceInfo.resetNodeUpgradePriorityByNodeServiceInfo();
            deploy.setNodeServiceInfo(nodeServiceInfo);
        }
        catch (Exception e) {
            log.error("Pare NodeServiceInfo", (Throwable)e);
        }
    }

    public void parseFusionStorageInfo() throws UMateException {
        String deviceJson = this.getDeviceDataFileString();
        if (StringUtils.isNULLStr((String)deviceJson)) {
            log.error("scenario piped in server info is empty.");
            return;
        }
        ParserConfig.getGlobalInstance().setAutoTypeSupport(false);
        JSONObject devicesListInfo = JSONObject.parseObject((String)deviceJson);
        JSONArray fStorageInfos = devicesListInfo.getJSONArray("associatedFStorageInfo");
        if (fStorageInfos == null || fStorageInfos.isEmpty()) {
            log.error("no fusion storage info is passed to bundle upgrade tool, quit!");
            return;
        }
        this.parse4ClusterInfo(fStorageInfos);
    }

    private void parse4ClusterInfo(JSONArray fStorageInfos) throws UMateException {
        for (int poi = 0; poi < fStorageInfos.size(); ++poi) {
            JSONObject fStorageInfo = fStorageInfos.getJSONObject(poi);
            FusionStorageClusterInfoEntity fusionStorageClusterInfoEntity = new FusionStorageClusterInfoEntity();
            fusionStorageClusterInfoEntity.setProductVersion(this.getString(fStorageInfo, "productVersion"));
            fusionStorageClusterInfoEntity.setHotPatchVersion(this.getString(fStorageInfo, "hotPatchVersion"));
            fusionStorageClusterInfoEntity.setClusterSN(this.getString(fStorageInfo, "serialNumber"));
            fusionStorageClusterInfoEntity.setFloatIp(this.getString(fStorageInfo, "floatIp"));
            fusionStorageClusterInfoEntity.setProductModel(this.getString(fStorageInfo, "productModel"));
            fusionStorageClusterInfoEntity.setHttpPort(this.getString(fStorageInfo, "httpport"));
            fusionStorageClusterInfoEntity.setAccount(new AccountEntity(this.getString(fStorageInfo, "username"), this.decrypt(this.getString(fStorageInfo, "password"))));
            FusionStrgUpgradeContext.getInstance().getClusterList().add(fusionStorageClusterInfoEntity);
            JSONArray bmcIpMapping = fStorageInfo.getJSONArray("businessIpMapping");
            this.parseBmcAndStorageNodeMapping(bmcIpMapping, fusionStorageClusterInfoEntity);
            JSONArray sandboxClosedList = fStorageInfo.getJSONArray("sandboxClosedList");
            if (sandboxClosedList.isEmpty()) continue;
            fusionStorageClusterInfoEntity.setSandboxClosedList(sandboxClosedList.toJavaList(String.class));
            BundleUpgradeContext.getInstance().recordSandboxClose(fusionStorageClusterInfoEntity);
        }
    }

    private void parseBmcAndStorageNodeMapping(JSONArray bmcIpMapping, FusionStorageClusterInfoEntity fusionStorageClusterInfoEntity) throws UMateException {
        for (int loop = 0; loop < bmcIpMapping.size(); ++loop) {
            String bmcIp = this.getString(bmcIpMapping.getJSONObject(loop), "bmcIP");
            String storageIp = this.getString(bmcIpMapping.getJSONObject(loop), "storageIp");
            String sshUserName = this.getString(bmcIpMapping.getJSONObject(loop), "username");
            String sshPassword = this.decrypt(this.getString(bmcIpMapping.getJSONObject(loop), "password"));
            String sshOsRootPassword = this.decrypt(this.getString(bmcIpMapping.getJSONObject(loop), "rootpassword"));
            UpgradeDeviceEntity upgradeDeviceEntity = BundleUpgradeContext.getInstance().getDeviceNodeByIp(bmcIp);
            if (upgradeDeviceEntity == null) {
                log.error("[Fusion storage scene data parsing]the BMC IP mapping in the json file contains a bmc IP not in device list.");
                throw new UMateException("bmc ip invalid.");
            }
            UpgDeviceExtendFSDataEntity extendFSDataEntity = new UpgDeviceExtendFSDataEntity();
            extendFSDataEntity.setDeviceEntity(upgradeDeviceEntity);
            extendFSDataEntity.setBelongsClusterEntity(fusionStorageClusterInfoEntity);
            extendFSDataEntity.setManagementIp(storageIp);
            extendFSDataEntity.setSshAccount(new AccountEntity(sshUserName, sshPassword, sshOsRootPassword));
            FusionStrgUpgradeContext.getInstance().getBusinessIpMapper().put(upgradeDeviceEntity, extendFSDataEntity);
        }
    }

    String decrypt(String str) {
        return AESEncrypt.decrypt((String)str);
    }

    private String getString(JSONObject object, String key) {
        String result = null;
        try {
            result = object.getString(key);
        }
        catch (Exception e) {
            result = "";
            log.error(String.format(Locale.ROOT, " %s device %s is lost", object.getString("ip"), key));
        }
        if (StringUtils.isNULLStr((String)result)) {
            if (key.equals("productType")) {
                log.error(String.format(Locale.ROOT, " %s device %s is null or empty", object.getString("ip"), key));
            }
            log.info(String.format(Locale.ROOT, " %s device %s is null or empty", object.getString("ip"), key));
            return "";
        }
        return result;
    }

    private List<String> getList(JSONObject object, String key) {
        Object result = null;
        if (!object.containsKey((Object)key)) {
            log.error(String.format(Locale.ROOT, " %s device %s is lost", object.getString("ip"), key));
            return new ArrayList<String>();
        }
        return object.getJSONArray(key).toJavaList(String.class);
    }

    public static String readFile(String path) {
        File file = new File(path);
        return StreamUtils.readStringFormFile((File)file);
    }
}

