/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.service;

import com.huawei.bundleupgrade.constants.UpgradeParamConstants;
import com.huawei.bundleupgrade.entity.StrategySettingTableRowEntity;
import com.huawei.bundleupgrade.entity.UpgradeDeviceEntity;
import com.huawei.bundleupgrade.entity.UpgradeStrategyEntity;
import com.huawei.bundleupgrade.entity.fusionstrg.PanGeaPackageEntity;
import com.huawei.bundleupgrade.tasks.OnlineFirmwareDownloadTask;
import com.huawei.bundleupgrade.ui.BundleUpgradeMainDialog;
import com.huawei.bundleupgrade.ui.layout.UpgradeOrderSettingLayout;
import com.huawei.bundleupgrade.utils.BundleUpgradeContext;
import com.huawei.bundleupgrade.utils.ServiceUtil;
import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.uMate.common.utils.ResUtil;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StrategyOrderSettingService {
    private static final Logger LOGGER = LoggerFactory.getLogger(StrategyOrderSettingService.class);
    private static final ResUtil RES = ResUtil.getInstance((String)"BundleUpgrade");

    public List<StrategySettingTableRowEntity> getSelectedUpgradeModuleList(List<StrategySettingTableRowEntity> settingTableRowEntities) {
        ArrayList<StrategySettingTableRowEntity> selectedModuleList = new ArrayList<StrategySettingTableRowEntity>();
        for (StrategySettingTableRowEntity tableRowEntity : settingTableRowEntities) {
            if (!ServiceUtil.isStrategyTableRowSelected(tableRowEntity)) continue;
            selectedModuleList.add(tableRowEntity);
        }
        return selectedModuleList;
    }

    public List<StrategySettingTableRowEntity> reorderTableRowEntity(List<StrategySettingTableRowEntity> settingTableRowEntityList) {
        HashSet<String> moduleSet = new HashSet<String>();
        settingTableRowEntityList.forEach(entity -> moduleSet.add(entity.getModule()));
        List<StrategySettingTableRowEntity> mergedTableRowList = this.initMergedTableRowList(settingTableRowEntityList, moduleSet);
        this.reSortTableRowSetPCIeFirst(mergedTableRowList);
        this.reSortTableRowSetOnlineLast(mergedTableRowList);
        List<StrategySettingTableRowEntity> newMergedTableRowList = this.topoSort(mergedTableRowList);
        LOGGER.info("end sort pangea intra band module, len: {}", (Object)newMergedTableRowList.size());
        return newMergedTableRowList;
    }

    public List<StrategySettingTableRowEntity> topoSort(List<StrategySettingTableRowEntity> mergedTableRowList) {
        LinkedHashMap<String, Integer> inDegreeMap = new LinkedHashMap<String, Integer>();
        HashMap<String, List<String>> adjacencyMap = new HashMap<String, List<String>>();
        this.initDependenceTable(mergedTableRowList, inDegreeMap, adjacencyMap);
        ArrayList<StrategySettingTableRowEntity> orderList = new ArrayList<StrategySettingTableRowEntity>(mergedTableRowList.size());
        if (this.sortByDependence(mergedTableRowList, inDegreeMap, orderList, adjacencyMap) != 0) {
            LOGGER.error("Has cyclic dependence,config error.");
            return Collections.emptyList();
        }
        Collections.reverse(orderList);
        return orderList;
    }

    private int sortByDependence(List<StrategySettingTableRowEntity> mergedTableRowList, Map<String, Integer> inDegreeMap, List<StrategySettingTableRowEntity> orderList, Map<String, List<String>> adjacencyMap) {
        int size = mergedTableRowList.size();
        LinkedList<String> queue = new LinkedList<String>();
        List originModules = mergedTableRowList.stream().map(StrategySettingTableRowEntity::getModule).collect(Collectors.toList());
        inDegreeMap.keySet().stream().filter(module -> (Integer)inDegreeMap.get(module) == 0 && originModules.contains(module)).forEach(queue::add);
        while (!queue.isEmpty()) {
            String module2 = (String)queue.poll();
            StrategySettingTableRowEntity strategySettingTableRowEntity = mergedTableRowList.stream().filter(row -> row.getModule().equals(module2)).findFirst().orElse(null);
            if (ObjectUtils.isEmpty((Object)strategySettingTableRowEntity)) continue;
            orderList.add(strategySettingTableRowEntity);
            --size;
            for (String adjacencyModule : adjacencyMap.get(module2)) {
                int inDegree = inDegreeMap.get(adjacencyModule);
                inDegreeMap.put(adjacencyModule, --inDegree);
                if (inDegree != 0) continue;
                queue.add(adjacencyModule);
            }
        }
        return size;
    }

    private void initDependenceTable(List<StrategySettingTableRowEntity> mergedTableRowList, Map<String, Integer> inDegreeMap, Map<String, List<String>> adjacencyMap) {
        PanGeaPackageEntity panGeaPackage = BundleUpgradeContext.getInstance().getPanGeaPackageEntity();
        for (StrategySettingTableRowEntity row : mergedTableRowList) {
            List<String> dependenceModule = panGeaPackage.getSubModuleDependence(row.getModule());
            adjacencyMap.put(row.getModule(), dependenceModule);
            if (!inDegreeMap.containsKey(row.getModule())) {
                inDegreeMap.put(row.getModule(), 0);
            }
            if (dependenceModule.isEmpty()) continue;
            for (String module : dependenceModule) {
                this.increaseInDegree(inDegreeMap, module);
            }
        }
    }

    private void increaseInDegree(Map<String, Integer> inDegreeMap, String module) {
        int inDegree = inDegreeMap.getOrDefault(module, 0);
        inDegreeMap.put(module, ++inDegree);
    }

    private void reSortTableRowSetPCIeFirst(List<StrategySettingTableRowEntity> mergedTableRowList) {
        mergedTableRowList.sort((o1, o2) -> {
            if (o1.isPCIeModule() && !o2.isPCIeModule()) {
                return 1;
            }
            if (!o1.isPCIeModule() && o2.isPCIeModule()) {
                return -1;
            }
            return 0;
        });
    }

    private void reSortTableRowSetOnlineLast(List<StrategySettingTableRowEntity> mergedTableRowList) {
        List onlineModules = UpgradeParamConstants.ModuleType.getFsOnlineModules().stream().map(UpgradeParamConstants.ModuleType::getModule).collect(Collectors.toList());
        mergedTableRowList.sort((o1, o2) -> {
            if (onlineModules.contains(o1.getModule()) && !onlineModules.contains(o2.getModule())) {
                return 1;
            }
            if (!onlineModules.contains(o1.getModule()) && onlineModules.contains(o2.getModule())) {
                return -1;
            }
            return 0;
        });
    }

    private List<StrategySettingTableRowEntity> initMergedTableRowList(List<StrategySettingTableRowEntity> settingTableRowEntityList, Set<String> moduleSet) {
        ArrayList<StrategySettingTableRowEntity> mergedTableRowList = new ArrayList<StrategySettingTableRowEntity>();
        moduleSet.forEach(module -> {
            List tempList = settingTableRowEntityList.stream().filter(row -> row.getModule().equals(module)).collect(Collectors.toList());
            StrategySettingTableRowEntity mergedTableRow = new StrategySettingTableRowEntity();
            mergedTableRow.setModule(((StrategySettingTableRowEntity)tempList.get(0)).getModule());
            mergedTableRow.setUpgradeAgent(((StrategySettingTableRowEntity)tempList.get(0)).getUpgradeAgent());
            mergedTableRow.setActiveMode(((StrategySettingTableRowEntity)tempList.get(0)).getActiveMode());
            String supportModel = String.join((CharSequence)";", (CharSequence[])tempList.stream().map(StrategySettingTableRowEntity::getSupportModel).toArray(String[]::new));
            String supportModelUid = String.join((CharSequence)";", (CharSequence[])tempList.stream().map(StrategySettingTableRowEntity::getSupportModelUid).toArray(String[]::new));
            String targetVision = String.join((CharSequence)";", (CharSequence[])tempList.stream().map(StrategySettingTableRowEntity::getTargetVersion).toArray(String[]::new));
            String object = String.join((CharSequence)";", (CharSequence[])tempList.stream().map(StrategySettingTableRowEntity::getObject).toArray(String[]::new));
            String objectId = String.join((CharSequence)";", (CharSequence[])tempList.stream().map(StrategySettingTableRowEntity::getObjectId).toArray(String[]::new));
            mergedTableRow.setSupportModel(supportModel);
            mergedTableRow.setSupportModelUid(supportModelUid);
            mergedTableRow.setTargetVersion(targetVision);
            mergedTableRow.setObject(object);
            mergedTableRow.setObjectId(objectId);
            mergedTableRowList.add(mergedTableRow);
        });
        return mergedTableRowList;
    }

    public boolean isAllPcieModule(List<StrategySettingTableRowEntity> list) {
        for (StrategySettingTableRowEntity entity : list) {
            if (ServiceUtil.isPCIeModule(entity.getModule())) continue;
            return false;
        }
        return true;
    }

    public List<String> checkIfOrderSettingMatchDependence(List<StrategySettingTableRowEntity> reorderedTableRows) {
        ArrayList<String> res = new ArrayList<String>();
        HashSet<String> curModule = new HashSet<String>();
        PanGeaPackageEntity panGeaPackage = BundleUpgradeContext.getInstance().getPanGeaPackageEntity();
        for (StrategySettingTableRowEntity entity : reorderedTableRows) {
            String module = entity.getModule();
            if (!ServiceUtil.isPanGeaIntraBandModule(module)) continue;
            List<String> dependenceList = panGeaPackage.getSubModuleDependence(module);
            if (dependenceList.isEmpty()) {
                curModule.add(module);
                continue;
            }
            for (String dependModule : dependenceList) {
                if (UpgradeParamConstants.ModuleType.SAS.getModule().equals(dependModule) || curModule.contains(dependModule)) continue;
                res.add(dependModule);
                res.add(module);
                return res;
            }
            curModule.add(module);
        }
        return res;
    }

    public boolean saveUpgradeStrategy(List<StrategySettingTableRowEntity> strategySettingTableRowEntities, UpgradeOrderSettingLayout layout) {
        String strategyUUID = BundleUpgradeContext.getInstance().getLatestStrategyUuid();
        UpgradeStrategyEntity strategyEntity = BundleUpgradeContext.getInstance().getStrategyEntityMap().get(strategyUUID);
        ArrayList<List<UpgradeParamConstants.ModuleType>> upgradeOrders = new ArrayList<List<UpgradeParamConstants.ModuleType>>();
        ArrayList<UpgradeParamConstants.ModuleType> pcieList = new ArrayList<UpgradeParamConstants.ModuleType>();
        if (this.saveFirmwareUpgradeOrders(upgradeOrders, strategySettingTableRowEntities, pcieList)) {
            return false;
        }
        strategyEntity.setAlowAutoPowerSwitch(layout.getAutoReset().isSelected());
        strategyEntity.setFailLogPath(layout.getLogPathField().getText());
        List<UpgradeDeviceEntity> upgradeDeviceEntities = BundleUpgradeContext.getInstance().getSelectedDeviceEntities();
        upgradeDeviceEntities.forEach(UpgradeDeviceEntity::resetEntityStatus);
        strategyEntity.setAssociatedDevices(upgradeDeviceEntities);
        strategyEntity.setUpgradeOrders(upgradeOrders);
        for (int i = 0; i < upgradeOrders.size(); ++i) {
            LOGGER.info(String.format(Locale.ROOT, "The upgrade sequence is as follows: %s. module: %s", i + 1, upgradeOrders.get(i)));
        }
        upgradeDeviceEntities.forEach(deviceEntity -> deviceEntity.setAssociatedStrategyId(strategyUUID));
        this.lockDownloadingFirmwarePackages(strategyEntity);
        if (strategyEntity.getPackageImportMethod() == UpgradeParamConstants.PackageImportMethod.ONLINE) {
            AsyncExcutor.submit((Runnable)new OnlineFirmwareDownloadTask(strategyEntity));
        }
        LOGGER.info("save the upgrade order successfully.");
        return true;
    }

    private void lockDownloadingFirmwarePackages(UpgradeStrategyEntity strategyEntity) {
        if (BundleUpgradeContext.isOnlineFirmware()) {
            strategyEntity.getModuleTargetFirmwareMap().entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream()).map(firmwareKey -> BundleUpgradeContext.getInstance().getFirmwarePackageMap().get(firmwareKey)).filter(firmwarePackageEntity -> firmwarePackageEntity.getDownloadStatus() == null).forEach(firmwarePackageEntity -> firmwarePackageEntity.setDownloadStatus(UpgradeParamConstants.FirmwareDownloadStatus.NOT_DOWNLOADED));
        } else {
            strategyEntity.getModuleTargetFirmwareMap().entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream()).map(firmwareKey -> BundleUpgradeContext.getInstance().getFirmwarePackageMap().get(firmwareKey)).filter(firmwarePackageEntity -> firmwarePackageEntity.getDownloadStatus() == null).forEach(firmwarePackageEntity -> firmwarePackageEntity.setDownloadStatus(UpgradeParamConstants.FirmwareDownloadStatus.FINISHED));
        }
    }

    private boolean saveFirmwareUpgradeOrders(List<List<UpgradeParamConstants.ModuleType>> upgradeOrders, List<StrategySettingTableRowEntity> reorderedList, List<UpgradeParamConstants.ModuleType> pcieList) {
        boolean isFirstPCIe = true;
        for (StrategySettingTableRowEntity tableRowEntity : reorderedList) {
            String module = tableRowEntity.getModule();
            UpgradeParamConstants.ModuleType moduleType = ServiceUtil.convertModuleToEnum(module);
            if (null == moduleType) {
                DialogUtils.showInfoDialog((Frame)((Object)BundleUpgradeContext.getInstance().getMainDialog()), (String)RES.getString("bundle.upgrade.order.error"));
                return true;
            }
            boolean isPCIeModule = ServiceUtil.isPCIeModule(module);
            if (isPCIeModule) {
                if (isFirstPCIe) {
                    pcieList.add(moduleType);
                    upgradeOrders.add(pcieList);
                    isFirstPCIe = false;
                    continue;
                }
                pcieList.add(moduleType);
                continue;
            }
            ArrayList<UpgradeParamConstants.ModuleType> cardsList = new ArrayList<UpgradeParamConstants.ModuleType>();
            cardsList.add(moduleType);
            upgradeOrders.add(cardsList);
        }
        return false;
    }

    public void refreshMainDialog() {
        BundleUpgradeMainDialog mainDialog = BundleUpgradeContext.getInstance().getMainDialog();
        List<UpgradeDeviceEntity> deviceEntities = BundleUpgradeContext.getInstance().getSelectedDeviceEntities();
        this.refreshTableData(deviceEntities, mainDialog);
    }

    private void refreshTableData(List<UpgradeDeviceEntity> deviceEntities, BundleUpgradeMainDialog mainDialog) {
        for (UpgradeDeviceEntity deviceEntity : deviceEntities) {
            deviceEntity.setProcessStatus(UpgradeParamConstants.UpgradeStatus.ASSOCIATED);
            mainDialog.refreshTable(deviceEntity);
        }
    }
}

