/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.huawei.bundleupgrade.constants.UpgradeParamConstants;
import com.huawei.bundleupgrade.entity.BaselineFirmwareBundle;
import com.huawei.bundleupgrade.entity.DeviceEntity;
import com.huawei.bundleupgrade.entity.FirmwarePackageEntity;
import com.huawei.bundleupgrade.entity.FunctionMap;
import com.huawei.bundleupgrade.entity.OperationResultEntity;
import com.huawei.bundleupgrade.entity.PcieCardEntity;
import com.huawei.bundleupgrade.entity.StrategySettingTableRowEntity;
import com.huawei.bundleupgrade.entity.UpgradeDeviceEntity;
import com.huawei.bundleupgrade.entity.UpgradeStrategyEntity;
import com.huawei.bundleupgrade.entity.fusionstrg.PanGeaPackageEntity;
import com.huawei.bundleupgrade.model.Module;
import com.huawei.bundleupgrade.model.ModuleEnum;
import com.huawei.bundleupgrade.service.DeviceInfoByRedfishService;
import com.huawei.bundleupgrade.service.connection.fusionstrg.FusionStorageSshConnector;
import com.huawei.bundleupgrade.service.connection.fusionstrg.FusionStorageSshPool;
import com.huawei.bundleupgrade.service.system.impl.PowerOperationRedFishService;
import com.huawei.bundleupgrade.ui.layout.strategy.StrategySettingLayout;
import com.huawei.bundleupgrade.utils.BundleUpgradeContext;
import com.huawei.bundleupgrade.utils.ServiceUtil;
import com.huawei.bundleupgrade.utils.UpgradeConstants;
import com.huawei.bundleupgrade.utils.UpgradeCustomizationUtil;
import com.huawei.bundleupgrade.utils.UpgradeScenarioUtil;
import com.huawei.bundleupgrade.utils.WatchDogSettingUtil;
import com.huawei.bundleupgrade.utils.fusionstrg.FusionStrgUpgradeContext;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.houp.exception.HoupException;
import com.huawei.ism.tool.houp.utils.ClientUtils;
import com.huawei.ism.tool.houp.utils.HoupServer;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.uMate.common.UMateException;
import com.huawei.uMate.common.thread.CommonRunnable;
import com.huawei.uMate.common.utils.RedfishUtils;
import com.huawei.uMate.common.utils.ResUtil;
import java.awt.Frame;
import java.awt.event.ItemEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StrategyParamsSettingService {
    private static final Logger log = LoggerFactory.getLogger(StrategyParamsSettingService.class);
    private static final ResUtil RES = ResUtil.getInstance((String)"BundleUpgrade");
    private static final String CELL_VALUE_DEFAULT = "bundle.upgrade.param.strategy.table.cell.default";
    private static final String CELL_VALUE_UPGRADE = "bundle.upgrade.param.strategy.table.cell.upgrade";
    private StrategySettingLayout layout;

    public StrategyParamsSettingService(StrategySettingLayout layout) {
        this.layout = layout;
    }

    public List<StrategySettingTableRowEntity> matchDeviceModuleWithFwPackage(String deviceIp, String key) {
        log.info("{} modules start to match the firmware upgrade packages.", (Object)deviceIp);
        ArrayList<StrategySettingTableRowEntity> tableRowEntityList = new ArrayList<StrategySettingTableRowEntity>();
        UpgradeDeviceEntity selectedDevice = BundleUpgradeContext.getInstance().getDeviceNodeByIp(deviceIp);
        if (null == selectedDevice) {
            log.error("failed to get {} device from upgrade device list", (Object)deviceIp);
            return tableRowEntityList;
        }
        DeviceEntity device = selectedDevice.getDeviceEntity();
        BaselineFirmwareBundle firmwareBundle = BundleUpgradeContext.getInstance().getBaselineFirmwareBundleMap().get(key);
        if (null == firmwareBundle) {
            log.error("{} :the key of firmware package baseline is incorrect.", (Object)key);
            return tableRowEntityList;
        }
        try {
            List<FirmwarePackageEntity> firmwarePackageEntities = firmwareBundle.getPackageList();
            if (UpgradeScenarioUtil.isYinglong() && !UpgradeScenarioUtil.isOutBound()) {
                log.info("{} match module inband.", (Object)deviceIp);
                return this.buildSettingTableRowEntitiesBySsh(deviceIp, tableRowEntityList, device, firmwarePackageEntities);
            }
            this.matchAndCreatRowOutBand(tableRowEntityList, device, firmwarePackageEntities);
            if (!UpgradeCustomizationUtil.canConnectOs(device)) {
                log.info("{} The match was completed for outbound scene.", (Object)deviceIp);
                return tableRowEntityList;
            }
            return this.buildSettingTableRowEntitiesBySsh(deviceIp, tableRowEntityList, device, firmwarePackageEntities);
        }
        catch (Exception e) {
            log.error("Match pkg error.", (Throwable)e);
            return tableRowEntityList;
        }
    }

    private void matchAndCreatRowOutBand(List<StrategySettingTableRowEntity> tableRowEntityList, DeviceEntity device, List<FirmwarePackageEntity> firmwarePackageEntityList) {
        if (!UpgradeScenarioUtil.isYinglong()) {
            String[] spModels = (String[])UpgradeParamConstants.ModuleType.getSpAgentModel().stream().map(UpgradeParamConstants.ModuleType::getModule).toArray(String[]::new);
            this.matchModuleAndCreatRow(tableRowEntityList, device, firmwarePackageEntityList, spModels);
        }
        String[] outBandModules = this.initBmcAgentModules();
        this.matchModuleAndCreatRow(tableRowEntityList, device, firmwarePackageEntityList, outBandModules);
        this.matchPCIeModule(device, firmwarePackageEntityList, tableRowEntityList);
    }

    private List<StrategySettingTableRowEntity> buildSettingTableRowEntitiesBySsh(String deviceIp, List<StrategySettingTableRowEntity> tableRowEntityList, DeviceEntity device, List<FirmwarePackageEntity> firmwarePackageEntityList) {
        String[] sshAgentModules = this.initSshAgentModules();
        if (!this.isSshConnect(device)) {
            return tableRowEntityList;
        }
        this.matchModuleAndCreatRow(tableRowEntityList, device, firmwarePackageEntityList, sshAgentModules);
        this.matchPanGeaIntraBandModule(device, firmwarePackageEntityList, tableRowEntityList);
        log.info("{} The match was completed.", (Object)deviceIp);
        return tableRowEntityList;
    }

    private boolean isSshConnect(DeviceEntity device) {
        try {
            FusionStorageSshPool.getFsSshConnectionByBmcIp(device.getIp());
        }
        catch (UMateException e) {
            log.error("get ssh connector fail.", (Throwable)e);
            DialogUtils.showInfoDialog((Frame)((Object)BundleUpgradeContext.getInstance().getMainDialog()), (String)RES.getString("bundle.upgrade.ssh.match.error"));
            return false;
        }
        return true;
    }

    private String[] initBmcAgentModules() {
        return (String[])UpgradeParamConstants.ModuleType.getVersionByBmc().stream().map(UpgradeParamConstants.ModuleType::getModule).toArray(String[]::new);
    }

    private String[] initSshAgentModules() {
        return (String[])UpgradeParamConstants.ModuleType.getVersionByCustomMethod().stream().map(UpgradeParamConstants.ModuleType::getModule).toArray(String[]::new);
    }

    private void matchModuleAndCreatRow(List<StrategySettingTableRowEntity> tableRowEntityList, DeviceEntity device, List<FirmwarePackageEntity> firmwarePackageEntityList, String[] modules) {
        Arrays.stream(modules).map(FunctionMap.ModuleFunction::getModule).forEach(module -> tableRowEntityList.addAll(module.matchAndCreateRow(device, firmwarePackageEntityList)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void matchPanGeaIntraBandModule(DeviceEntity device, List<FirmwarePackageEntity> fwPackageList, List<StrategySettingTableRowEntity> rowEntities) {
        if (UpgradeScenarioUtil.isOutBound()) {
            log.info("End query when the scene is yinglong outbond.");
            return;
        }
        if (device.isDirectPlane()) {
            log.info("End query when the device is a Direct Plane.");
            return;
        }
        log.info("start to match pangea intra band module.");
        PanGeaPackageEntity entity = BundleUpgradeContext.getInstance().getPanGeaPackageEntity();
        if (entity == null) {
            log.info("No match pangea intra band module.");
            return;
        }
        List<String> modules = Arrays.asList(UpgradeConstants.PAN_GEA_INTRA_BAND_MODULE);
        List matchedFwList = fwPackageList.stream().filter(fwPackage -> modules.stream().anyMatch(module -> this.needBuildRow((String)module, (FirmwarePackageEntity)fwPackage))).collect(Collectors.toList());
        if (matchedFwList.isEmpty()) {
            log.info("No match pangea intra band module.");
            return;
        }
        try {
            String uid = device.getProductUniqueId();
            FusionStorageSshConnector ssh = FusionStorageSshPool.getFsSshConnectionByBmcIp(device.getIp());
            for (FirmwarePackageEntity fwEntity : matchedFwList) {
                if (!this.creatTableRowEntities(device, rowEntities, ssh, uid, fwEntity)) continue;
            }
        }
        catch (UMateException e) {
            log.error("get ssh connector fail.", (Throwable)e);
            DialogUtils.showInfoDialog((Frame)((Object)BundleUpgradeContext.getInstance().getMainDialog()), (String)RES.getString("bundle.upgrade.match.ssh.error"));
            return;
        }
        finally {
            FusionStorageSshPool.releaseFsSshConnection(FusionStrgUpgradeContext.getInstance().getFsDeviceEntityByBmcIp(device.getIp()));
        }
        log.info("match pangea intra band module finished.");
    }

    private boolean creatTableRowEntities(DeviceEntity device, List<StrategySettingTableRowEntity> rowEntities, FusionStorageSshConnector ssh, String uid, FirmwarePackageEntity fwEntity) {
        if (fwEntity.getPackageInfo() == null) {
            log.info("No pkg info do not need build table row entities");
            return true;
        }
        String supportUid = fwEntity.getPackageInfo().getSupportModelUID().toLowerCase(Locale.ENGLISH);
        if (!supportUid.equalsIgnoreCase("all") && !supportUid.contains(uid.toLowerCase(Locale.ENGLISH))) {
            return true;
        }
        if (this.isMatchCpuArchitecture(device, fwEntity) && this.isMatchKernelVersion(device, fwEntity)) {
            this.getVersionAndSetMatchInfo(rowEntities, ssh, fwEntity, device);
        }
        return false;
    }

    private boolean isMatchCpuArchitecture(DeviceEntity device, FirmwarePackageEntity fwEntity) {
        String cpuArchitecture = fwEntity.getPackageInfo().getCpuArchitecture().toLowerCase(Locale.ROOT);
        return "".equals(cpuArchitecture) || "all".equals(cpuArchitecture) || device.getCpuArchitecture().contains(cpuArchitecture);
    }

    private boolean isMatchKernelVersion(DeviceEntity device, FirmwarePackageEntity fwEntity) {
        String supportKernelVersion = fwEntity.getPackageInfo().getSupportKernelVersion().toLowerCase(Locale.ROOT);
        return "".equals(supportKernelVersion) || device.getKernelVersion().contains(supportKernelVersion);
    }

    private boolean needBuildRow(String module, FirmwarePackageEntity fwPackage) {
        String packageModule = fwPackage.getPackageInfo().getModule();
        if (Arrays.stream(this.initSshAgentModules()).anyMatch(str -> str.equalsIgnoreCase(packageModule))) {
            return false;
        }
        return module.equalsIgnoreCase(packageModule);
    }

    private void getVersionAndSetMatchInfo(List<StrategySettingTableRowEntity> rowEntities, FusionStorageSshConnector ssh, FirmwarePackageEntity fwEntity, DeviceEntity device) {
        String curVersion;
        String moduleName = fwEntity.getPackageInfo().getModule();
        log.info("begin to match {}", (Object)moduleName);
        StrategySettingTableRowEntity tableRowEntity = new StrategySettingTableRowEntity();
        tableRowEntity.setModule(fwEntity.getPackageInfo().getModule());
        String packageInfoKey = ServiceUtil.getPackageInfoKey(fwEntity);
        try {
            curVersion = this.getModuleCurVersion(ssh, fwEntity, device, moduleName, packageInfoKey);
        }
        catch (Exception e) {
            log.error("execute ssh cmd fail", (Throwable)e);
            return;
        }
        tableRowEntity.setCurrentVersion(curVersion);
        tableRowEntity.setMatch(UpgradeScenarioUtil.isValidVersion(curVersion, moduleName));
        tableRowEntity.setStrategyComboBoxCell(this.getDefaultComboBoxCell());
        this.setTableRowCommonInfo(tableRowEntity, fwEntity);
        rowEntities.add(tableRowEntity);
        device.getPanGeaInBandModuleVersion().put(packageInfoKey, curVersion);
        log.info("Module: {} end match, current version: {}", (Object)moduleName, (Object)curVersion);
    }

    private String getModuleCurVersion(FusionStorageSshConnector ssh, FirmwarePackageEntity fwEntity, DeviceEntity device, String moduleName, String packageInfoKey) throws Exception {
        String versionFromCache = device.getPanGeaInBandModuleVersion().get(packageInfoKey);
        if (StringUtils.isNULLStr((String)versionFromCache)) {
            return Module.getPanGeaInBandVersionOnServer(fwEntity, ssh);
        }
        log.info("Obtain the module: {} version: {} from the cache.", (Object)moduleName, (Object)versionFromCache);
        return versionFromCache;
    }

    private void matchPCIeModule(DeviceEntity device, List<FirmwarePackageEntity> fwPackageList, List<StrategySettingTableRowEntity> rowEntities) {
        log.info("start to match PCIe module.");
        fwPackageList.stream().filter(fw -> fw.isPCIeModulePackage() && fw.isSameProcessorArchitecture(device)).forEach(fw -> this.matchPCIeFwPackage(device, (FirmwarePackageEntity)fw, rowEntities));
        log.info("match PCIe module finished.");
    }

    private void matchPCIeFwPackage(DeviceEntity device, FirmwarePackageEntity fwPackage, List<StrategySettingTableRowEntity> rowEntities) {
        StrategySettingTableRowEntity tableRowEntity = this.initTableRowEntity(fwPackage);
        if (this.isSsdSpOrHdd(fwPackage)) {
            return;
        }
        rowEntities.add(tableRowEntity);
        device.getPcieCardsInfos().entrySet().stream().filter(entry -> this.isSameModule(fwPackage, (Map.Entry<String, List<PcieCardEntity>>)entry)).filter(entry -> this.isMatchModuleUID(fwPackage, (Map.Entry<String, List<PcieCardEntity>>)entry)).findFirst().ifPresent(entry -> this.assignMatchTableRowEntity(tableRowEntity, (Map.Entry<String, List<PcieCardEntity>>)entry, device, fwPackage));
    }

    private boolean isSsdSpOrHdd(FirmwarePackageEntity fwPackage) {
        return Stream.of(UpgradeParamConstants.ModuleType.HDD.getModule(), UpgradeParamConstants.ModuleType.SSD_SP.getModule()).anyMatch(module -> module.equalsIgnoreCase(fwPackage.getPackageInfo().getModule()));
    }

    private StrategySettingTableRowEntity initTableRowEntity(FirmwarePackageEntity fwPackage) {
        StrategySettingTableRowEntity tableRowEntity = new StrategySettingTableRowEntity();
        tableRowEntity.setCurrentVersion("--");
        tableRowEntity.setModule(fwPackage.getPackageInfo().getModule());
        this.setTableRowCommonInfo(tableRowEntity, fwPackage);
        tableRowEntity.setStrategyComboBoxCell(this.getInBandComboBoxCell());
        return tableRowEntity;
    }

    private boolean isSameModule(FirmwarePackageEntity fwPackage, Map.Entry<String, List<PcieCardEntity>> entry) {
        return entry.getValue().get(0).getCardType().toLowerCase(Locale.ROOT).contains(fwPackage.getPackageInfo().getModule().toLowerCase(Locale.ROOT));
    }

    private boolean isMatchModuleUID(FirmwarePackageEntity fwPackage, Map.Entry<String, List<PcieCardEntity>> entry) {
        Set<String> fwSet = this.getLowerCaseUIDSet(fwPackage.getPackageInfo().getSupportModelUID(), ";");
        Set<String> deviceModuleSet = this.getLowerCaseUIDSet(entry.getKey().substring(1, entry.getKey().length() - 1), ",");
        return fwSet.stream().anyMatch(deviceModuleSet::contains);
    }

    private Set<String> getLowerCaseUIDSet(String uidString, String separator) {
        return Arrays.stream(uidString.toLowerCase(Locale.ROOT).split(separator)).collect(Collectors.toSet());
    }

    private void assignMatchTableRowEntity(StrategySettingTableRowEntity tableRowEntity, Map.Entry<String, List<PcieCardEntity>> entry, DeviceEntity device, FirmwarePackageEntity fwPackage) {
        if (BundleUpgradeContext.isOnlineFirmware()) {
            tableRowEntity.setIsOnlineFirmwareMatch(fwPackage.isProductNameOrAllMatchOnlineFirmware(device));
        }
        tableRowEntity.setMatch(true);
        tableRowEntity.setCurrentVersion(this.getPCIeCardCurrentVersion(entry));
    }

    private String getPCIeCardCurrentVersion(Map.Entry<String, List<PcieCardEntity>> entry) {
        return String.join((CharSequence)";", (CharSequence[])entry.getValue().stream().map(PcieCardEntity::getFirmwareVersion).toArray(String[]::new));
    }

    private void setTableRowCommonInfo(StrategySettingTableRowEntity tableRowEntity, FirmwarePackageEntity fwEntity) {
        if (fwEntity.getPackageInfo().getModule().equalsIgnoreCase(ModuleEnum.CPLD.getName())) {
            tableRowEntity.setObject(fwEntity.getPackageInfo().getObject());
            tableRowEntity.setObjectId(fwEntity.getPackageInfo().getObjectID());
        }
        tableRowEntity.setSupportModel(fwEntity.getPackageInfo().getSupportModel());
        tableRowEntity.setSupportModelUid(fwEntity.getPackageInfo().getSupportModelUID());
        tableRowEntity.setActiveMode(fwEntity.getPackageInfo().getActiveMode());
        tableRowEntity.setTargetVersion(fwEntity.getPackageInfo().getVersion());
        tableRowEntity.setUpgradeAgent(fwEntity.getPackageInfo().getUpgradeAgent());
        tableRowEntity.setFwPackageName(fwEntity.getPackageInfo().getPackageName());
        tableRowEntity.setFirmwarePackageEntity(fwEntity);
    }

    public List<StrategySettingTableRowEntity> filterTableRowEntityList(List<StrategySettingTableRowEntity> settingTableRowEntityList, boolean isShowNotMatched) {
        ArrayList<StrategySettingTableRowEntity> filteredTableRowEntityList = new ArrayList<StrategySettingTableRowEntity>();
        boolean isOnlineMatch = this.isOnlineMatched(settingTableRowEntityList);
        for (StrategySettingTableRowEntity entity : settingTableRowEntityList) {
            if (!isShowNotMatched) {
                if (isOnlineMatch) {
                    if (!entity.isOnlineFirmwareMatch()) continue;
                    filteredTableRowEntityList.add(entity);
                    continue;
                }
                if (!entity.isMatch()) continue;
                filteredTableRowEntityList.add(entity);
                continue;
            }
            filteredTableRowEntityList.add(entity);
        }
        return filteredTableRowEntityList;
    }

    private boolean isOnlineMatched(List<StrategySettingTableRowEntity> settingTableRowEntityList) {
        return settingTableRowEntityList.stream().anyMatch(row -> row.isOnlineFirmwareMatch() && BundleUpgradeContext.isOnlineFirmware());
    }

    public List<StrategySettingTableRowEntity> getPreViewTableRowEntity(List<StrategySettingTableRowEntity> settingTableRowEntityList) {
        ArrayList<StrategySettingTableRowEntity> preViewTableRowEntities = new ArrayList<StrategySettingTableRowEntity>();
        settingTableRowEntityList.stream().filter(ServiceUtil::isStrategyTableRowSelected).forEach(row -> this.initPreViewRow((List<StrategySettingTableRowEntity>)preViewTableRowEntities, (StrategySettingTableRowEntity)row));
        this.setUpgradeExpectEffect(preViewTableRowEntities);
        return preViewTableRowEntities;
    }

    private void initPreViewRow(List<StrategySettingTableRowEntity> preViewTableRowEntities, StrategySettingTableRowEntity entity) {
        String[] versions = entity.getCurrentVersion().split(";");
        int index = 0;
        for (String version : versions) {
            StrategySettingTableRowEntity preViewEntity = new StrategySettingTableRowEntity();
            preViewEntity.setModule(entity.getModule());
            preViewEntity.setUpgradeAgent(entity.getUpgradeAgent());
            preViewEntity.setActiveMode(entity.getActiveMode());
            preViewEntity.setCurrentVersion(version);
            preViewEntity.setTargetVersion(this.getTargetVersion(entity, index));
            preViewEntity.setStrategyComboBoxCell(entity.getStrategyComboBoxCell());
            preViewEntity.setUpgradeStrategy(entity.getStrategyComboBoxCell().getSelectedItem().toString());
            preViewEntity.setSupportModel(entity.getSupportModel());
            preViewEntity.setFirmwarePackageEntity(entity.getFirmwarePackageEntity());
            preViewTableRowEntities.add(preViewEntity);
            ++index;
        }
    }

    private String getTargetVersion(StrategySettingTableRowEntity entity, int index) {
        if (UpgradeParamConstants.ModuleType.getDiskModule().stream().map(UpgradeParamConstants.ModuleType::getModule).anyMatch(module -> Objects.equals(module, entity.getModule()))) {
            String[] tarVersions = entity.getTargetVersion().split("\r");
            if (index >= tarVersions.length) {
                return "--";
            }
            return tarVersions[index];
        }
        return entity.getTargetVersion();
    }

    private void setUpgradeExpectEffect(List<StrategySettingTableRowEntity> tableRowEntities) {
        for (StrategySettingTableRowEntity tableRowEntity : tableRowEntities) {
            Module upgradeModule = FunctionMap.ModuleFunction.getModule(tableRowEntity.getModule());
            if (upgradeModule != null) {
                upgradeModule.setUpgradeExpectEffect(tableRowEntity);
                continue;
            }
            tableRowEntity.setExpectEffect(UpgradeParamConstants.UpgradeExpectEffect.UPGRADE);
        }
    }

    public boolean isUpgradeAgentContainsSp(List<StrategySettingTableRowEntity> filteredTableRowEntityList) {
        boolean result = false;
        for (StrategySettingTableRowEntity tableRowEntity : filteredTableRowEntityList) {
            String upgradeAgent = tableRowEntity.getUpgradeAgent();
            if (StringUtils.isNULLStr((String)upgradeAgent) || !upgradeAgent.trim().equals("SP")) continue;
            result = true;
            break;
        }
        return result;
    }

    public void setMutualExclusionEffect(List<StrategySettingTableRowEntity> tableRowEntities) {
        List<List<StrategySettingTableRowEntity>> totalEntities = this.getMutualExclusionEffectList(tableRowEntities);
        for (List<StrategySettingTableRowEntity> moduleList : totalEntities) {
            if (moduleList.size() <= 1) continue;
            this.addExclusion(moduleList);
        }
    }

    private List<List<StrategySettingTableRowEntity>> getMutualExclusionEffectList(List<StrategySettingTableRowEntity> tableRowEntities) {
        ArrayList<StrategySettingTableRowEntity> matchedList = new ArrayList<StrategySettingTableRowEntity>();
        HashSet<String> moduleSet = new HashSet<String>();
        boolean isOnlineMatched = this.isOnlineMatched(tableRowEntities);
        for (StrategySettingTableRowEntity tableRowEntity : tableRowEntities) {
            if (isOnlineMatched) {
                if (!tableRowEntity.isOnlineFirmwareMatch()) continue;
                moduleSet.add(tableRowEntity.getModule());
                matchedList.add(tableRowEntity);
                continue;
            }
            if (!tableRowEntity.isMatch()) continue;
            moduleSet.add(tableRowEntity.getModule());
            matchedList.add(tableRowEntity);
        }
        ArrayList<List<StrategySettingTableRowEntity>> totalEntities = new ArrayList<List<StrategySettingTableRowEntity>>();
        for (String module : moduleSet) {
            ArrayList moduleList = new ArrayList();
            matchedList.forEach(entity -> {
                if (module.equalsIgnoreCase(entity.getModule())) {
                    moduleList.add(entity);
                }
            });
            totalEntities.add(moduleList);
        }
        return totalEntities;
    }

    private void addExclusion(List<StrategySettingTableRowEntity> moduleList) {
        for (StrategySettingTableRowEntity entity : moduleList) {
            entity.getStrategyComboBoxCell().setItemListener(event -> {
                Object selectedObj = event.getItem();
                if (this.needChangedSelectStatus(event, selectedObj)) {
                    String thisSupportUid = entity.getSupportModelUid();
                    if (this.isCpldModule(entity)) {
                        this.makeOtherSameTypeCPLDPackageAssociated(moduleList, entity, thisSupportUid);
                        return;
                    }
                    for (StrategySettingTableRowEntity otherEntity : moduleList) {
                        if (entity != otherEntity && this.checkIOBFirmware(entity, otherEntity) || entity == otherEntity || !this.checkSupportModelUIDDifferent(otherEntity.getSupportModelUid(), thisSupportUid)) continue;
                        otherEntity.getStrategyComboBoxCell().setSelectedItem((Object)RES.getString(CELL_VALUE_DEFAULT));
                    }
                }
                this.layout.getStrategySettingTable().repaint();
            });
        }
    }

    private boolean isCpldModule(StrategySettingTableRowEntity entity) {
        return entity.getModule().toLowerCase(Locale.ENGLISH).contains(UpgradeParamConstants.ModuleType.CPLD.getModule().toLowerCase(Locale.ENGLISH));
    }

    private boolean needChangedSelectStatus(ItemEvent event, Object selectedObj) {
        return event.getStateChange() == 1 && selectedObj != null && !RES.getString(CELL_VALUE_DEFAULT).equals(selectedObj.toString());
    }

    private boolean checkIOBFirmware(StrategySettingTableRowEntity entity, StrategySettingTableRowEntity otherEntity) {
        if (entity.getModule().toLowerCase(Locale.ENGLISH).contains(UpgradeParamConstants.ModuleType.BIOS.getModule().toLowerCase(Locale.ENGLISH)) && otherEntity.getModule().toLowerCase(Locale.ENGLISH).contains(UpgradeParamConstants.ModuleType.BIOS.getModule().toLowerCase(Locale.ENGLISH))) {
            return entity.getFwPackageName().toLowerCase(Locale.ENGLISH).contains("iob") ^ otherEntity.getFwPackageName().toLowerCase(Locale.ENGLISH).contains("iob");
        }
        return false;
    }

    private boolean checkSupportModelUIDDifferent(String supportModelUid, String thisSupportUid) {
        if (StringUtils.isNULLStr((String)supportModelUid) || StringUtils.isNULLStr((String)thisSupportUid)) {
            return false;
        }
        if (org.apache.commons.lang3.StringUtils.equalsAnyIgnoreCase((CharSequence)"all", (CharSequence[])new CharSequence[]{supportModelUid, thisSupportUid})) {
            return true;
        }
        String[] supportModelUids = supportModelUid.contains(";") ? supportModelUid.split(";") : new String[]{supportModelUid};
        String[] thisSupportUids = thisSupportUid.contains(";") ? thisSupportUid.split(";") : new String[]{thisSupportUid};
        if (supportModelUids.length != 0 && thisSupportUids.length != 0) {
            for (String fwUID : supportModelUids) {
                for (String deviceUID : thisSupportUids) {
                    if (!fwUID.equalsIgnoreCase(deviceUID)) continue;
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private void makeOtherSameTypeCPLDPackageAssociated(List<StrategySettingTableRowEntity> moduleList, StrategySettingTableRowEntity entity, String thisSupportUid) {
        for (StrategySettingTableRowEntity otherEntity : moduleList) {
            if (entity == otherEntity || !this.checkSupportModelUIDDifferent(otherEntity.getSupportModelUid(), thisSupportUid) || otherEntity.getFirmwarePackageEntity().getPackageInfo() == null || entity.getFirmwarePackageEntity().getPackageInfo() == null || !entity.getFirmwarePackageEntity().getPackageInfo().getObject().equalsIgnoreCase(otherEntity.getFirmwarePackageEntity().getPackageInfo().getObject()) && !entity.getFirmwarePackageEntity().getPackageInfo().getObjectID().equalsIgnoreCase(otherEntity.getFirmwarePackageEntity().getPackageInfo().getObjectID())) continue;
            otherEntity.getStrategyComboBoxCell().setSelectedItem((Object)RES.getString(CELL_VALUE_DEFAULT));
        }
    }

    public OperationResultEntity saveUpgradeStrategy() {
        LinkedList<String> pathList;
        HashMap<String, UpgradeParamConstants.FirmwareUpgradeStrategy> upgradeStrategyMap;
        EnumMap<UpgradeParamConstants.ModuleType, List<String>> moduleTargetFirmwareMap;
        String strategyUUID = BundleUpgradeContext.getInstance().getLatestStrategyUuid();
        UpgradeStrategyEntity strategyEntity = BundleUpgradeContext.getInstance().getStrategyEntityMap().get(strategyUUID);
        List<StrategySettingTableRowEntity> tableRowEntityList = BundleUpgradeContext.getInstance().getSettingTableRowEntityList();
        if (this.getUpgradeStrategyInfo(tableRowEntityList, moduleTargetFirmwareMap = new EnumMap<UpgradeParamConstants.ModuleType, List<String>>(UpgradeParamConstants.ModuleType.class), upgradeStrategyMap = new HashMap<String, UpgradeParamConstants.FirmwareUpgradeStrategy>(), pathList = new LinkedList<String>())) {
            return new OperationResultEntity(false, "");
        }
        OperationResultEntity firmwareDownloadPermission = this.getCheckOperationResultEntity(strategyEntity, pathList);
        if (!firmwareDownloadPermission.isPassed()) {
            return firmwareDownloadPermission;
        }
        strategyEntity.setModuleTargetFirmwareMap(moduleTargetFirmwareMap);
        strategyEntity.setUpgradeStrategyMap(upgradeStrategyMap);
        strategyEntity.setPcieUpgradeMethod(UpgradeParamConstants.PCIeCardUpgradeMethod.SMART_PROVISIONING);
        log.info("save the upgrade strategy successfully.");
        return new OperationResultEntity(true, "");
    }

    private boolean getUpgradeStrategyInfo(List<StrategySettingTableRowEntity> tableRowEntityList, Map<UpgradeParamConstants.ModuleType, List<String>> moduleTargetFirmwareMap, Map<String, UpgradeParamConstants.FirmwareUpgradeStrategy> upgradeStrategyMap, List<String> pathList) {
        for (StrategySettingTableRowEntity tableRowEntity : tableRowEntityList) {
            List<Object> fwPackageInfoList;
            UpgradeParamConstants.ModuleType moduleEnum;
            if (!ServiceUtil.isStrategyTableRowSelected(tableRowEntity) || null == (moduleEnum = ServiceUtil.convertModuleToEnum(tableRowEntity.getModule()))) continue;
            String convertValue = ServiceUtil.getPackageInfoKey(tableRowEntity.getFirmwarePackageEntity());
            Object strategySelected = tableRowEntity.getStrategyComboBoxCell().getSelectedItem();
            if (BundleUpgradeContext.isOnlineFirmware()) {
                pathList.add(tableRowEntity.getFirmwarePackageEntity().getOnlineFilePath());
            }
            if (null == strategySelected) {
                log.error("the upgrade strategy selected is null");
                return true;
            }
            if (null == moduleTargetFirmwareMap.get((Object)moduleEnum)) {
                fwPackageInfoList = new ArrayList<String>();
                fwPackageInfoList.add(convertValue);
                moduleTargetFirmwareMap.put(moduleEnum, fwPackageInfoList);
            } else {
                fwPackageInfoList = moduleTargetFirmwareMap.get((Object)moduleEnum);
                fwPackageInfoList.add(convertValue);
            }
            upgradeStrategyMap.put(convertValue, this.convertValueToStrategyEnum(strategySelected.toString()));
        }
        return false;
    }

    private OperationResultEntity getCheckOperationResultEntity(UpgradeStrategyEntity strategyEntity, List<String> pathList) {
        if (BundleUpgradeContext.isOnlineFirmware() && !pathList.isEmpty()) {
            String checkDataMapStr = this.getCheckDataString(pathList, strategyEntity);
            OperationResultEntity firmwareDownloadPermission = StrategyParamsSettingService.checkFirmwareDownloadPermission(strategyEntity.getHoupUserName(), strategyEntity.getHoupPsd(), checkDataMapStr);
            JSONArray errorListStr = (JSONArray)RedfishUtils.getObjectAttr((String)firmwareDownloadPermission.getReturnParam(), JSONArray.class, (String[])new String[]{"errorList"});
            if (errorListStr == null || !errorListStr.isEmpty()) {
                log.info("Has error.");
                return new OperationResultEntity(false, firmwareDownloadPermission.getReturnParam());
            }
        }
        return new OperationResultEntity(true, "");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static OperationResultEntity checkFirmwareDownloadPermission(String userName, String password, String data) {
        BundleUpgradeContext context = BundleUpgradeContext.getInstance();
        String url = context.getHoupUrl().concat("/download/actions/checkDownloadList");
        try (CloseableHttpClient httpClient = ClientUtils.getCloseableHttpClient((boolean)context.isVerifyCert());){
            String postResult = HoupServer.houpPost((String)userName, (String)password, (String)url, (String)data, (CloseableHttpClient)httpClient);
            if (StringUtils.isNULLStr((String)postResult)) {
                OperationResultEntity operationResultEntity2 = new OperationResultEntity(false, "");
                return operationResultEntity2;
            }
            OperationResultEntity operationResultEntity = new OperationResultEntity(true, postResult);
            return operationResultEntity;
        }
        catch (HoupException e) {
            return new OperationResultEntity(false, "");
        }
        catch (IOException e) {
            log.error("check download list from houp error:", (Object)e.getMessage());
            return new OperationResultEntity(false, "");
        }
    }

    private String getCheckDataString(List<String> pathList, UpgradeStrategyEntity strategyEntity) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>(2);
        dataMap.put("rootUri", strategyEntity.getHoupAddr());
        dataMap.put("path", pathList);
        return JSON.toJSONString(dataMap);
    }

    private UpgradeParamConstants.FirmwareUpgradeStrategy convertValueToStrategyEnum(Object selected) {
        if (selected.toString().equals(RES.getString(CELL_VALUE_UPGRADE))) {
            return UpgradeParamConstants.FirmwareUpgradeStrategy.MANDATORY_UPGRADE;
        }
        return UpgradeParamConstants.FirmwareUpgradeStrategy.LOWER_VERSION_UPGRADE;
    }

    private IsmTableCell.ComboBoxCell getDefaultComboBoxCell() {
        Object[] comboValues = new String[]{RES.getString(CELL_VALUE_DEFAULT), RES.getString(CELL_VALUE_UPGRADE), RES.getString("bundle.upgrade.param.strategy.table.cell.demotion")};
        IsmTableCell.ComboBoxCell cell = new IsmTableCell.ComboBoxCell(comboValues, (Object)RES.getString(CELL_VALUE_DEFAULT));
        cell.getComboBox().setName("strategy_out_band_comboBox");
        return cell;
    }

    private IsmTableCell.ComboBoxCell getInBandComboBoxCell() {
        Object[] comboValues = new String[]{RES.getString(CELL_VALUE_DEFAULT), RES.getString(CELL_VALUE_UPGRADE)};
        IsmTableCell.ComboBoxCell cell = new IsmTableCell.ComboBoxCell(comboValues, (Object)RES.getString(CELL_VALUE_DEFAULT));
        cell.getComboBox().setName("strategy_in_band_comboBox");
        return cell;
    }

    public OperationResultEntity obtainPcieInfoBySP(UpgradeDeviceEntity upgradeDevice) throws UMateException, InterruptedException {
        log.info("[device {}] need to obtain PCIECards infomation by reboot sp...", (Object)upgradeDevice.getDeviceEntity().getIp());
        try (DeviceInfoByRedfishService service = new DeviceInfoByRedfishService(upgradeDevice.getDeviceEntity());){
            PowerOperationRedFishService powerSwitchService = new PowerOperationRedFishService(upgradeDevice.getDeviceEntity());
            OperationResultEntity powerState = service.getPowerState();
            if (powerState.isPassed()) {
                if (powerState.getReturnParam().equals("On")) {
                    OperationResultEntity powerOffResult = powerSwitchService.powerOffDevice();
                    if (!powerOffResult.isPassed()) {
                        log.error("device {} power off failed.", (Object)upgradeDevice.getDeviceEntity().getIp());
                        OperationResultEntity operationResultEntity = new OperationResultEntity(false, String.format(Locale.ENGLISH, "device %s power off failed.", upgradeDevice.getDeviceEntity().getIp()));
                        return operationResultEntity;
                    }
                }
            } else {
                log.error("device {} get power state failed.", (Object)upgradeDevice.getDeviceEntity().getIp());
                OperationResultEntity powerOffResult = new OperationResultEntity(false, String.format(Locale.ENGLISH, "device %s get power state failed.", upgradeDevice.getDeviceEntity().getIp()));
                return powerOffResult;
            }
            CommonRunnable.sleep((int)20000);
            service.startSp();
            OperationResultEntity spbootWatchDogResult = WatchDogSettingUtil.setSpbootWatchDog(upgradeDevice, service);
            if (!spbootWatchDogResult.isPassed()) {
                OperationResultEntity operationResultEntity = new OperationResultEntity(false, "");
                return operationResultEntity;
            }
            OperationResultEntity powerOnResult = powerSwitchService.powerOnDevice();
            if (!powerOnResult.isPassed()) {
                log.error("device {} power on failed.", (Object)upgradeDevice.getDeviceEntity().getIp());
                OperationResultEntity operationResultEntity = new OperationResultEntity(false, String.format(Locale.ENGLISH, "device %s power on failed.", upgradeDevice.getDeviceEntity().getIp()));
                return operationResultEntity;
            }
            OperationResultEntity checkStartSp = this.getPCIeInfoResultEntity(upgradeDevice, service);
            if (!checkStartSp.isPassed()) {
                OperationResultEntity operationResultEntity = checkStartSp;
                return operationResultEntity;
            }
            Map<String, List<PcieCardEntity>> pcieCardsInfos = service.getPcieCardsInfo(service.getPcieJsonArray());
            upgradeDevice.getDeviceEntity().setPcieCardsInfos(pcieCardsInfos);
        }
        return new OperationResultEntity(true, "");
    }

    private OperationResultEntity getPCIeInfoResultEntity(UpgradeDeviceEntity upgradeDevice, DeviceInfoByRedfishService service) throws InterruptedException {
        String slotId = service.getDeviceSlotId();
        if (StringUtils.isNULLStr((String)slotId)) {
            log.error("device {} get slotId failed.", (Object)upgradeDevice.getDeviceEntity().getIp());
        }
        CommonRunnable.sleep((int)180000);
        String url = String.format(Locale.ENGLISH, "/redfish/v1/Managers/%s", slotId);
        OperationResultEntity checkStartSP = service.checkStartSP(5000, 1800000, url);
        if (!checkStartSP.isPassed()) {
            log.error("{} Checking the Startup of the SP timeout ...", (Object)upgradeDevice.getDeviceEntity().getIp());
            return new OperationResultEntity(false, checkStartSP.getReturnParam());
        }
        String pcieInfoUrl = String.format(Locale.ENGLISH, "/redfish/v1/Managers/%s/SPService/DeviceInfo", slotId);
        OperationResultEntity checkGetPCIEinfo = service.checkGetPCIEinfo(5000, 1800000, pcieInfoUrl);
        if (!checkGetPCIEinfo.isPassed()) {
            log.error("{} Checking get PCIE info flag timeout ...", (Object)upgradeDevice.getDeviceEntity().getIp());
            return new OperationResultEntity(false, checkGetPCIEinfo.getReturnParam());
        }
        HashMap<String, String> orgBiosConfigItemMap = WatchDogSettingUtil.getBiosConfigItem(upgradeDevice.getDeviceEntity().getWatchDogModel());
        OperationResultEntity reSpbootWatchDogResult = WatchDogSettingUtil.resumSpbootWatchDog(upgradeDevice, service, WatchDogSettingUtil.getOrgBiosCfgItem(orgBiosConfigItemMap));
        if (!reSpbootWatchDogResult.isPassed()) {
            log.error("{} resuming spboot and watchDog status failed.", (Object)upgradeDevice.getDeviceEntity().getIp());
            return new OperationResultEntity(false, "");
        }
        return new OperationResultEntity(true, "");
    }

    public List<StrategySettingTableRowEntity> getSelectedUpgradeModuleList(List<StrategySettingTableRowEntity> settingTableRowEntities) {
        ArrayList<StrategySettingTableRowEntity> selectedModuleList = new ArrayList<StrategySettingTableRowEntity>();
        for (StrategySettingTableRowEntity tableRowEntity : settingTableRowEntities) {
            if (!ServiceUtil.isStrategyTableRowSelected(tableRowEntity)) continue;
            selectedModuleList.add(tableRowEntity);
        }
        return selectedModuleList;
    }
}

