/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.service;

import com.huawei.bundleupgrade.constants.BundleUpgradeConstants;
import com.huawei.bundleupgrade.constants.UpgradeParamConstants;
import com.huawei.bundleupgrade.entity.BaselineFirmwareBundle;
import com.huawei.bundleupgrade.entity.DiskPkgInfo;
import com.huawei.bundleupgrade.entity.FirmwarePackageEntity;
import com.huawei.bundleupgrade.entity.RetimerTypeEnum;
import com.huawei.bundleupgrade.entity.TaskResult;
import com.huawei.bundleupgrade.entity.UpgradeStrategyEntity;
import com.huawei.bundleupgrade.entity.fusionstrg.PanGeaPackageEntity;
import com.huawei.bundleupgrade.model.Module;
import com.huawei.bundleupgrade.service.DiskFwParseService;
import com.huawei.bundleupgrade.ui.card.UpgradeTypeSelectionCard;
import com.huawei.bundleupgrade.ui.dialog.RepeatedFwPackageViewDialog;
import com.huawei.bundleupgrade.ui.layout.type.SelectLocalUpgradeLayout;
import com.huawei.bundleupgrade.ui.layout.type.SelectOnlineUpgradeLayout;
import com.huawei.bundleupgrade.ui.layout.type.UpgradeTypeSelectMainLayout;
import com.huawei.bundleupgrade.utils.BundleUpgradeContext;
import com.huawei.bundleupgrade.utils.FirmwareXmlParseUtil;
import com.huawei.bundleupgrade.utils.SHAAndRSASignCheckUtil;
import com.huawei.bundleupgrade.utils.ServiceUtil;
import com.huawei.bundleupgrade.utils.UpgradeConstants;
import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.OSCmdUtils;
import com.huawei.ism.tool.base.utils.ZipUtils;
import com.huawei.ism.tool.certbase.integrity.CheckFileIntegrityUtils;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.platform.util.XmlEnums;
import com.huawei.ism.tool.houp.exception.HoupException;
import com.huawei.ism.tool.houp.utils.ClientUtils;
import com.huawei.ism.tool.houp.utils.HoupServer;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.util.Pair;
import com.huawei.uMate.common.UMateException;
import com.huawei.uMate.common.utils.ResUtil;
import com.huawei.uMate.common.utils.SecurityUtils;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JComboBox;
import javax.swing.JRadioButton;
import org.apache.commons.io.FileSystemUtils;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class UpgradeTypeSelectionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpgradeTypeSelectionService.class);
    private static final ResUtil RES = ResUtil.getInstance((String)"BundleUpgrade");
    private static final String SIGNATURE_FILE_SUFFIX = ".asc";
    private static Map<String, List<String>> tempFwPackageMap = new HashMap<String, List<String>>();
    private final DiskFwParseService diskFwParseService = new DiskFwParseService(this);
    private List<ArrayList<Object>> checkFailedPkg = new ArrayList<ArrayList<Object>>();
    private UpgradeTypeSelectionCard typeSelectionCard;

    public UpgradeTypeSelectionService(UpgradeTypeSelectionCard typeSelectionCard) {
        this.typeSelectionCard = typeSelectionCard;
    }

    public boolean testAndDownload(String url, String userName, char[] password) {
        String psd = new String(password);
        BundleUpgradeContext context = BundleUpgradeContext.getInstance();
        if (StringUtils.isNULLStr((String)userName) || StringUtils.isNULLStr((String)psd)) {
            DialogUtils.showInfoDialog((Frame)((Object)context.getMainDialog()), (String)RES.getString("bundle.upgrade.connection.error2"));
            return false;
        }
        try (CloseableHttpClient client = ClientUtils.getCloseableHttpClient((boolean)context.isVerifyCert());){
            this.downloadAndParseXml(userName, psd, url, client);
        }
        catch (UMateException ex) {
            FirmwareXmlParseUtil.deleteTempFile();
            DialogUtils.showInfoDialog((Frame)((Object)context.getMainDialog()), (String)ex.getMessage());
            return false;
        }
        catch (HoupException e) {
            FirmwareXmlParseUtil.deleteTempFile();
            DialogUtils.showInfoDialog((Frame)((Object)context.getMainDialog()), (String)e.getErrorMsg());
            return false;
        }
        catch (IOException e) {
            LOGGER.error("download index file from houp error:", (Object)e.getMessage());
        }
        return true;
    }

    private void downloadAndParseXml(String userName, String pwd, String urlPrefix, CloseableHttpClient httpClient) throws UMateException, HoupException {
        LOGGER.info("start to download and parse information from xml.");
        Map<String, BaselineFirmwareBundle> map = BundleUpgradeContext.getInstance().getBaselineFirmwareBundleMap();
        map.keySet().removeIf(key -> !"localUpgradePackage".equals(key));
        String sk = HoupServer.updateForNewSk((String)userName, (String)pwd, (CloseableHttpClient)httpClient);
        BundleUpgradeContext.getInstance().setHoupSk(sk);
        HoupServer.downloadFileByAksk((String)userName, (String)sk, (String)(urlPrefix.endsWith(".xml") ? urlPrefix : urlPrefix.concat("huawei_index.xml")), (String)UpgradeConstants.TEMP_XML_DOWNLOAD, (CloseableHttpClient)httpClient);
        List<String> baselineList = FirmwareXmlParseUtil.getBaselineXmlPathFromIndexXml(UpgradeConstants.TEMP_XML_DOWNLOAD, "huawei_index.xml");
        if (!baselineList.isEmpty()) {
            for (String baselinePath : baselineList) {
                HoupServer.downloadFileByAksk((String)userName, (String)sk, (String)(urlPrefix.endsWith(".xml") ? urlPrefix.substring(0, urlPrefix.lastIndexOf("/") + 1).concat(baselinePath) : urlPrefix.concat(baselinePath)), (String)UpgradeConstants.TEMP_XML_DOWNLOAD, (CloseableHttpClient)httpClient);
                String versionXMLPath = FirmwareXmlParseUtil.getVersionXmlPathFromBaselineXml(UpgradeConstants.TEMP_XML_DOWNLOAD, baselinePath);
                if (!StringUtils.isNULLStr((String)versionXMLPath)) {
                    HoupServer.downloadFileByAksk((String)userName, (String)sk, (String)(urlPrefix.endsWith(".xml") ? urlPrefix.substring(0, urlPrefix.lastIndexOf("/") + 1).concat(versionXMLPath) : urlPrefix.concat(versionXMLPath)), (String)UpgradeConstants.TEMP_XML_DOWNLOAD, (CloseableHttpClient)httpClient);
                    BaselineFirmwareBundle firmwareBundle = FirmwareXmlParseUtil.getPackageInfoFromVersionXml(UpgradeConstants.TEMP_XML_DOWNLOAD, versionXMLPath, urlPrefix);
                    if (firmwareBundle != null) {
                        int begin = baselinePath.indexOf(47);
                        int end = baselinePath.indexOf(46);
                        String key2 = baselinePath.substring(begin + 1, end);
                        BundleUpgradeContext.getInstance().getBaselineFirmwareBundleMap().put(key2, firmwareBundle);
                        continue;
                    }
                    throw new UMateException(RES.getStringWithParams("bundle.upgrade.connection.error5", new Object[]{"version.xml"}));
                }
                throw new UMateException(RES.getStringWithParams("bundle.upgrade.connection.error5", new Object[]{"baseline.xml"}));
            }
        } else {
            throw new UMateException(RES.getStringWithParams("bundle.upgrade.connection.error5", new Object[]{"huawei_index.xml"}));
        }
        FirmwareXmlParseUtil.deleteTempFile();
    }

    public boolean getLocalUpgradePackageInfo(String selectPath) {
        boolean result;
        File selectFile = org.apache.commons.io.FileUtils.getFile((String[])new String[]{FilePathUtils.checkFile((String)selectPath)});
        if (selectFile.isDirectory()) {
            result = this.getVersionFromUpgradePackage(selectPath);
        } else {
            LOGGER.error("The selected path is not a folder");
            result = false;
        }
        return result;
    }

    private boolean getVersionFromUpgradePackage(String selectPath) {
        LOGGER.info("start to get package information from firmware package.");
        Path path = Paths.get(selectPath, new String[0]);
        BaselineFirmwareBundle firmwareBundle = new BaselineFirmwareBundle();
        this.init();
        this.parseDependencyXml();
        this.parseFirmwareDir(path, firmwareBundle);
        BundleUpgradeContext.getInstance().getBaselineFirmwareBundleMap().put("localUpgradePackage", firmwareBundle);
        LOGGER.info("get package information from firmware package finished.");
        return !firmwareBundle.getPackageList().isEmpty();
    }

    private void init() {
        BundleUpgradeContext.getInstance().getBaselineFirmwareBundleMap().remove("localUpgradePackage");
        tempFwPackageMap.clear();
        this.checkFailedPkg.clear();
        File unzipPath = new File(BundleUpgradeContext.getInstance().getCurrentPangeaFwTempPath());
        if (unzipPath.exists()) {
            com.huawei.ism.tool.base.utils.FileUtils.deleteFile((File)unzipPath);
        }
    }

    private void parseFirmwareDir(Path path, final BaselineFirmwareBundle firmwareBundle) {
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    String absolutePath = file.toAbsolutePath().toString();
                    if (absolutePath.endsWith(".zip")) {
                        UpgradeTypeSelectionService.this.parsePackageInfo(absolutePath, firmwareBundle);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (Exception e) {
            LOGGER.error("failed to parse the version.xml from local file.", (Throwable)e);
        }
    }

    private void parsePackages(List<String> filePaths, BaselineFirmwareBundle firmwareBundle) {
        for (String path : filePaths) {
            try {
                if (!path.endsWith(".zip")) continue;
                this.parsePackageInfo(path, firmwareBundle);
            }
            catch (Exception e) {
                LOGGER.error(String.format(Locale.ENGLISH, " the firmware package %s information is incomplete. %s", path, e));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean parseDependencyXml() {
        String versionXmlPath = String.join((CharSequence)File.separator, ApplicationContext.getInstance().getWorkPath(), "packages", "version.xml");
        LOGGER.info("Begin parse dependency version.xml {}", (Object)versionXmlPath);
        File xmlFile = new File(versionXmlPath);
        if (!xmlFile.exists()) {
            return false;
        }
        try (FileInputStream xmlFileInputStream = new FileInputStream(xmlFile);){
            Document document = this.getDocument(xmlFileInputStream);
            if (document == null) {
                LOGGER.error("Failed to read the version.xml from {} through the local.", (Object)versionXmlPath);
                boolean bl2 = false;
                return bl2;
            }
            Element rootElement = document.getRootElement();
            List packageElement = rootElement.elements("Package");
            PanGeaPackageEntity panGeaPackageEntity = new PanGeaPackageEntity();
            packageElement.forEach(ele -> FirmwareXmlParseUtil.parsePanGeaIntraElement(ele, panGeaPackageEntity));
            BundleUpgradeContext.getInstance().setPanGeaPackageEntity(panGeaPackageEntity);
            LOGGER.info("Parse dependency version.xml success");
            boolean bl = true;
            return bl;
        }
        catch (IOException | DocumentException e) {
            LOGGER.error("failed to parse the dependency version.xml from {} through the local.", (Object)versionXmlPath);
            return false;
        }
        catch (SAXException e) {
            LOGGER.error("SAXException: ", (Throwable)e);
            return false;
        }
    }

    List<String> cmsCheckAndGetPassPaths(String absolutePath, String rootDir) {
        String cms;
        String crl;
        String certPath = BundleUpgradeConstants.Pangea.HUAWEI_ROOT_CA;
        String sourceFile = rootDir + File.separator + "sha256sum_sync";
        if (!CheckFileIntegrityUtils.checkFileByCms((String)certPath, (String)sourceFile, (String)(crl = rootDir + File.separator + "crldata.crl"), (String)(cms = rootDir + File.separator + "sha256sum_sync.cms"))) {
            LOGGER.warn("Pangea package check failed,ignore this package and clear unzip dir {}.", (Object)rootDir);
            FileUtils.clearDir((String)rootDir);
            return Collections.emptyList();
        }
        List<Pair<String, String>> fileAndSha256List = SHAAndRSASignCheckUtil.loadSha256File(rootDir, sourceFile);
        List<TaskResult<String>> resultList = SHAAndRSASignCheckUtil.checkSha256Sum(fileAndSha256List);
        this.recordFailedPkg(absolutePath, resultList.stream().filter(result -> !result.isSuccess()).collect(Collectors.toList()));
        List<String> paths = resultList.stream().filter(TaskResult::isSuccess).map(TaskResult::getSource).collect(Collectors.toList());
        if (paths.isEmpty()) {
            LOGGER.warn("Package check failed,result is empty,ignore this package and clear unzip dir {}.", (Object)rootDir);
            FileUtils.clearDir((String)rootDir);
            return Collections.emptyList();
        }
        return paths;
    }

    private void recordFailedPkg(String sourcePkgPath, List<TaskResult<String>> resultList) {
        String rootPath = new File(sourcePkgPath).getParent();
        resultList.stream().map(result -> {
            ArrayList<String> data = new ArrayList<String>();
            data.add(sourcePkgPath + "#" + ((String)result.getSource()).substring(((String)result.getSource()).lastIndexOf(File.separator) + 1));
            data.add(result.getDesc());
            data.add((String)new IsmTableCell.HyperlinkCell(RES.getString("parse.pangea.pkg.openDir"), e -> OSCmdUtils.exeExportFile((String)rootPath)));
            return data;
        }).forEach(this.checkFailedPkg::add);
    }

    private FirmwarePackageEntity parseVersionXml(String absolutePath, InputStream xmlInputStream, BaselineFirmwareBundle firmwareBundle) throws IOException {
        String fileName = Paths.get(absolutePath, new String[0]).getFileName().toString();
        FirmwarePackageEntity firmwarePackage = new FirmwarePackageEntity();
        try {
            Document document = this.getDocument(xmlInputStream);
            if (Objects.isNull(document)) {
                LOGGER.error("failed to read the version.xml from {} through the local.", (Object)fileName);
                return firmwarePackage;
            }
            Element rootElement = document.getRootElement();
            Element packageElement = rootElement.element("Package");
            String module = packageElement.elementText("Module");
            if (Stream.of("PANGEA_INBAND", "PSU_BBU").anyMatch(module::equals)) {
                return firmwarePackage;
            }
            Element interfaceElement = rootElement.element("Interfaces");
            List packages = rootElement.elements("Package");
            if (this.isSpEs3000(packages, interfaceElement)) {
                this.buildEs3000PackageInfo(absolutePath, packages, firmwareBundle);
                return firmwarePackage;
            }
            FirmwarePackageEntity.PackageInfo packageEntity = FirmwareXmlParseUtil.parsePackageElement(firmwarePackage, packageElement);
            String object = packageElement.elementText("Object");
            String objectID = packageElement.elementText("ObjectId");
            if (!StringUtils.isNULLStr((String)object) && !StringUtils.isNULLStr((String)objectID)) {
                packageEntity.setObject(object);
                packageEntity.setObjectID(objectID);
            }
            if (interfaceElement != null) {
                firmwarePackage.setInterfaceInfo(FirmwareXmlParseUtil.parseInterfaceElement(firmwarePackage, interfaceElement));
            }
            if (StringUtils.isNULLStr((String)packageEntity.getPackageName())) {
                LOGGER.error("{} the firmware package information is incomplete.", (Object)absolutePath);
            }
            this.savePackageInfo(firmwarePackage, absolutePath, packageEntity, firmwareBundle);
            LOGGER.info("parse the version.xml from {} successfully.", (Object)absolutePath);
        }
        catch (DocumentException e) {
            this.saveCheckFailedInfo(absolutePath, RES.getString("parse.pangea.pkg.err.unsupportedError"));
            LOGGER.error("failed to parse the version.xml from {} through the local. {}", (Object)fileName, (Object)e);
        }
        catch (SAXException saxE) {
            this.saveCheckFailedInfo(absolutePath, RES.getString("parse.pangea.pkg.err.unsupportedError"));
            LOGGER.error("SAXException: ", (Throwable)saxE);
        }
        return firmwarePackage;
    }

    private boolean isSpEs3000(List<Element> packages, Element interfaceElement) {
        Element firstPackage = packages.get(0);
        return "SSD".equals(firstPackage.elementText("Module").toUpperCase(Locale.ENGLISH)) && interfaceElement == null;
    }

    private void buildEs3000PackageInfo(String absolutePath, List<Element> packageElements, BaselineFirmwareBundle firmwareBundle) {
        FirmwarePackageEntity fwPkg = new FirmwarePackageEntity();
        List<DiskPkgInfo> disks = this.parseToDiskPkg(packageElements);
        String targetVersions = disks.stream().map(DiskPkgInfo::getTargetVersion).distinct().collect(Collectors.joining(";"));
        String supportUid = disks.stream().map(diskPkgInfo -> diskPkgInfo.getModel()).collect(Collectors.joining(";"));
        FirmwarePackageEntity.PackageInfo info = fwPkg.new FirmwarePackageEntity.PackageInfo();
        info.setPackageName(new File(absolutePath).getName());
        info.setSupportModel("OceanStor Pacific");
        info.setActiveMode("ResetOS");
        info.setModule(Module.SsdSp.getName());
        info.setFileType("Firmware");
        info.setUpgradeAgent("SP");
        info.setSupportModelUID(supportUid);
        info.setVersion(targetVersions);
        Element packageElement = packageElements.get(0);
        String processorArchitecture = packageElement.elementText("ProcessorArchitecture");
        info.setProcessorArchitecture(StringUtils.isNULLStr((String)processorArchitecture) ? "x86" : processorArchitecture);
        String object = packageElement.elementText("Object");
        String objectID = packageElement.elementText("ObjectID");
        if (!StringUtils.isNULLStr((String)object) && !StringUtils.isNULLStr((String)objectID)) {
            info.setObject(object);
            info.setObjectID(objectID);
        }
        if (!this.checkSignatureFileIsExisted(absolutePath + SIGNATURE_FILE_SUFFIX)) {
            String module = info.getModule() + RES.getString("bundle.upgrade.type.panel.local.no.signature");
            info.setModule(module);
        }
        fwPkg.setTempId(BundleUpgradeContext.getInstance().getFwTempId());
        fwPkg.setPackageInfo(info);
        fwPkg.setDiskPkgInfos(disks);
        fwPkg.setLocalPathAbs(absolutePath);
        firmwareBundle.getPackageList().add(fwPkg);
        BundleUpgradeContext.getInstance().getFirmwarePackageMap().put(ServiceUtil.getPackageInfoKey(fwPkg), fwPkg);
    }

    private List<DiskPkgInfo> parseToDiskPkg(List<Element> packageElements) {
        return packageElements.stream().map(this::buildDiskPkg).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<DiskPkgInfo> buildDiskPkg(Element packageElement) {
        String supportModels = packageElement.elementText("SupportModel");
        String version = packageElement.elementText("Version");
        String fileName = packageElement.elementText("FileName");
        return Arrays.stream(supportModels.split(",")).map(supportModel -> {
            DiskPkgInfo disk = new DiskPkgInfo();
            disk.setModel((String)supportModel);
            disk.setTargetVersion(version);
            disk.setFileName(fileName);
            return disk;
        }).collect(Collectors.toList());
    }

    private void saveCheckFailedInfo(String sourcePath, String errorDesc) {
        for (ArrayList<Object> failedInfo : this.checkFailedPkg) {
            if (!failedInfo.get(0).equals(sourcePath)) continue;
            return;
        }
        String rootPath = new File(sourcePath).getParent();
        ArrayList<String> data = new ArrayList<String>();
        data.add(sourcePath);
        data.add(errorDesc);
        data.add((String)new IsmTableCell.HyperlinkCell(RES.getString("parse.pangea.pkg.openDir"), e -> OSCmdUtils.exeExportFile((String)rootPath)));
        this.checkFailedPkg.add(data);
    }

    private Document getDocument(InputStream xmlInputStream) throws SAXException, DocumentException {
        SAXReader saxReader = new SAXReader();
        saxReader.setFeature(XmlEnums.DISALLOW_DOCTYPE_DECL.getResourceValue(), true);
        saxReader.setFeature(XmlEnums.EXTERNAL_GENERAL_ENTITY.getResourceValue(), false);
        saxReader.setFeature(XmlEnums.EXTERNAL_PARAMETER_ENTITY.getResourceValue(), false);
        return saxReader.read(xmlInputStream);
    }

    private void parsePackageInfo(String absolutePath, BaselineFirmwareBundle firmwareBundle) throws IOException {
        try (ZipFile zipFile = new ZipFile(absolutePath, Charset.forName("GBK"));){
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            boolean legalFile = false;
            while (enumeration.hasMoreElements()) {
                try {
                    ZipEntry zipEntry = enumeration.nextElement();
                    String fileName = zipEntry.getName();
                    if (this.isDiskFwPackage(fileName)) {
                        legalFile = this.parseDiskFwPackages(absolutePath, firmwareBundle);
                        continue;
                    }
                    if (UpgradeTypeSelectionService.isMultiLevelDirectory(fileName, absolutePath)) {
                        legalFile = this.shouldSkipVrd(fileName, legalFile);
                        continue;
                    }
                    if (fileName.endsWith(".zip")) {
                        LOGGER.info("{} is panGea or psu_bbu package, begin unzip", (Object)absolutePath);
                        this.parsePackages(absolutePath, firmwareBundle, BundleUpgradeContext.getInstance().getCurrentPanGeaAndPsuAndBbuPath());
                        legalFile = true;
                        break;
                    }
                    if (!fileName.endsWith("version.xml")) continue;
                    try (InputStream inputStream = zipFile.getInputStream(zipEntry);){
                        this.parseVersionXml(absolutePath, inputStream, firmwareBundle);
                    }
                    legalFile = true;
                }
                catch (Exception e) {
                    LOGGER.error("Parse file error, file name {}", (Object)zipFile.getName());
                }
            }
            if (!legalFile) {
                this.saveCheckFailedInfo(absolutePath, RES.getString("parse.pangea.pkg.err.unsupportedError"));
            }
        }
    }

    static boolean isMultiLevelDirectory(String fileName, String absolutePath) {
        Long conut = Arrays.stream(fileName.split("")).filter("/"::equals).count();
        String packageName = new File(absolutePath).getName().split(".zip")[0] + "/";
        if (fileName.startsWith(packageName) && conut == 1L) {
            return false;
        }
        return conut != 0L;
    }

    private boolean shouldSkipVrd(String fileName, boolean isLegalFile) {
        if (fileName.contains("VRD_PAC1220V6")) {
            return true;
        }
        return isLegalFile;
    }

    private boolean isDiskFwPackage(String fileName) {
        return Stream.of("diskfw_signature.tgz", "hssd_diskfw_signature.tgz").anyMatch(fileName::equalsIgnoreCase);
    }

    private boolean parseDiskFwPackages(String absolutePath, BaselineFirmwareBundle firmwareBundle) throws IOException {
        if (!this.unzipDiskFw(absolutePath, BundleUpgradeContext.getInstance().getCurrentDiskFwTempPath())) {
            return false;
        }
        List<String> strings = this.cmsCheckAndGetPassPaths(absolutePath, BundleUpgradeContext.getInstance().getCurrentDiskFwTempPath());
        Optional<String> versionXml = strings.stream().filter(path -> path.endsWith("version.xml")).findFirst();
        if (versionXml.isPresent()) {
            if (!new File(versionXml.get()).exists()) {
                LOGGER.error("parse diskfw_signature fails, {} not exists.", (Object)versionXml.get());
                return false;
            }
            try (FileInputStream inputStream = new FileInputStream(versionXml.get());){
                FirmwarePackageEntity firmwarePackageEntity = this.parseVersionXml(absolutePath, inputStream, firmwareBundle);
                if (firmwarePackageEntity.getPackageInfo() != null) {
                    firmwarePackageEntity.getPackageInfo().setNeedUnzipTwice(true);
                }
            }
            return true;
        }
        return this.parseDiskFwPkg(absolutePath, firmwareBundle);
    }

    private void parsePackages(String absolutePath, BaselineFirmwareBundle firmwareBundle, String tempPath) throws IOException {
        File bigFile = new File(absolutePath);
        ZipUtils.decompressFile((File)bigFile, (String)tempPath);
        List<String> paths = this.cmsCheckAndGetPassPaths(absolutePath, tempPath);
        this.parsePackages(paths, firmwareBundle);
    }

    private boolean parseDiskFwPkg(String diskFwPkgPath, BaselineFirmwareBundle firmwareBundle) {
        Optional<FirmwarePackageEntity> fwPkg = this.diskFwParseService.parseDiskFwPackage(diskFwPkgPath);
        if (fwPkg.isPresent()) {
            firmwareBundle.getPackageList().add(fwPkg.get());
            BundleUpgradeContext.getInstance().getFirmwarePackageMap().put(ServiceUtil.getPackageInfoKey(fwPkg.get()), fwPkg.get());
            return true;
        }
        return false;
    }

    private boolean unzipDiskFw(String disksFwFilePath, String unzipRootDir) {
        if (!new File(disksFwFilePath).exists()) {
            LOGGER.error("Unzip file fails, {} not exists.", (Object)disksFwFilePath);
            return false;
        }
        try {
            ZipUtils.decompressInnerFiles((File)new File(disksFwFilePath), (String)unzipRootDir, (String)"diskfw_signature");
        }
        catch (IOException e) {
            LOGGER.error("Unzip file {} failed.", (Object)disksFwFilePath, (Object)e);
            FileUtils.clearDir((String)unzipRootDir);
            return false;
        }
        return true;
    }

    private void savePackageInfo(FirmwarePackageEntity firmwarePackage, String absolutePath, FirmwarePackageEntity.PackageInfo packageEntity, BaselineFirmwareBundle firmwareBundle) {
        firmwarePackage.setLocalPathAbs(absolutePath);
        firmwarePackage.setPackageInfo(packageEntity);
        this.resetRaidModule(firmwarePackage);
        this.resetEs3000Module(firmwarePackage);
        this.resetPcieRetimerModule(firmwarePackage);
        if (ServiceUtil.isPCIeModule(packageEntity.getModule()) && !this.checkSignatureFileIsExisted(absolutePath + SIGNATURE_FILE_SUFFIX)) {
            String module = packageEntity.getModule() + RES.getString("bundle.upgrade.type.panel.local.no.signature");
            packageEntity.setModule(module);
        }
        firmwareBundle.getPackageList().add(firmwarePackage);
        String key = ServiceUtil.getPackageInfoKey(firmwarePackage);
        ConcurrentHashMap<String, FirmwarePackageEntity> firmwarePackageMap = BundleUpgradeContext.getInstance().getFirmwarePackageMap();
        firmwarePackageMap.put(key, firmwarePackage);
        this.addFwPackageInfoToTempMap(firmwarePackage, absolutePath);
    }

    void resetPcieRetimerModule(FirmwarePackageEntity pkg) {
        if (Objects.nonNull(pkg.getPackageInfo()) && UpgradeParamConstants.ModuleType.PCIE_RETIMER.getModule().equals(pkg.getPackageInfo().getModule())) {
            RetimerTypeEnum retimerType = RetimerTypeEnum.getRetimerTypeByKey(pkg.getPackageInfo().getRetimerId());
            pkg.getPackageInfo().setModule(retimerType.getModuleType().getModule());
        }
    }

    private void resetRaidModule(FirmwarePackageEntity pkg) {
        if (pkg.getPackageInfo() != null && pkg.getInterfaceInfo() != null && this.isRaidModule(pkg.getPackageInfo().getModule())) {
            String module = pkg.getPackageInfo().getModule();
            String packageType = pkg.getPackageInfo().getPackageType();
            pkg.getPackageInfo().setModule(module + "_" + packageType.toUpperCase(Locale.ROOT));
        }
    }

    private boolean isRaidModule(String module) {
        return Stream.of(UpgradeParamConstants.ModuleType.RAID.getModule(), UpgradeParamConstants.ModuleType.HIRAID.getModule()).anyMatch(module::equalsIgnoreCase);
    }

    private void resetEs3000Module(FirmwarePackageEntity pkg) {
        if (pkg.getPackageInfo() != null && UpgradeParamConstants.ModuleType.ES3000.getModule().equals(pkg.getPackageInfo().getRpmName()) && pkg.getInterfaceInfo() != null) {
            pkg.getPackageInfo().setModule(UpgradeParamConstants.ModuleType.ES3000.getModule());
            pkg.getPackageInfo().setSupportModel(pkg.getPackageInfo().getSupportModelUID());
        }
    }

    private void saveTheFwPackageLocalPath(String prefix, String keyOfBundleMap) {
        BaselineFirmwareBundle baselineFirmwareBundle = BundleUpgradeContext.getInstance().getBaselineFirmwareBundleMap().get(keyOfBundleMap);
        List<FirmwarePackageEntity> firmwarePackageEntityList = baselineFirmwareBundle.getPackageList();
        firmwarePackageEntityList.stream().filter(fw -> !fw.isDownloaded() || null == fw.getLocalPathAbs()).forEach(fw -> fw.setLocalPathAbs(prefix));
    }

    public boolean isSelectedDiskMeetRequirement(String baseLine, String path) {
        long residualCapacity;
        BaselineFirmwareBundle firmwareBundle = BundleUpgradeContext.getInstance().getBaselineFirmwareBundleMap().get(baseLine);
        long fwPackageSizeTotal = 0L;
        for (FirmwarePackageEntity fwPackage : firmwareBundle.getPackageList()) {
            fwPackageSizeTotal += (long)fwPackage.getSize();
        }
        try {
            residualCapacity = FileSystemUtils.freeSpace((String)path);
        }
        catch (IOException e) {
            DialogUtils.showInfoDialog((Frame)((Object)BundleUpgradeContext.getInstance().getMainDialog()), (String)RES.getString("bundle.upgrade.type.panel.online.download.addr.tip2"));
            LOGGER.error(String.format(Locale.ENGLISH, "failed to get the residual capacity of the selected path: %s.", path));
            return false;
        }
        if (fwPackageSizeTotal > residualCapacity) {
            DialogUtils.showInfoDialog((Frame)((Object)BundleUpgradeContext.getInstance().getMainDialog()), (String)RES.getString("bundle.upgrade.type.panel.online.download.addr.tip"));
            LOGGER.error(String.format(Locale.ENGLISH, "%s the hard disk capacity is insufficient...", path));
            return false;
        }
        return true;
    }

    public void checkAndSetPkgLocalPath(File selectedFile, String baseLine, SelectOnlineUpgradeLayout onlineLayout) {
        try {
            String canonicalPath = selectedFile.getCanonicalPath();
            if (this.isSelectedDiskMeetRequirement(baseLine, canonicalPath)) {
                onlineLayout.getDownloadToLocalField().setText(canonicalPath);
            }
            LOGGER.info("The firmware storage address is successfully selected.");
        }
        catch (IOException e) {
            DialogUtils.showInfoDialog((Frame)((Object)BundleUpgradeContext.getInstance().getMainDialog()), (String)RES.getString("bundle.upgrade.type.panel.online.download.addr.tip2"));
            LOGGER.error("failed to get the residual capacity of the selected path: {}.", (Object)selectedFile);
        }
    }

    public boolean saveSelection(UpgradeTypeSelectMainLayout layout, SelectLocalUpgradeLayout localLayout, SelectOnlineUpgradeLayout onlineLayout) {
        UpgradeStrategyEntity strategyEntity = new UpgradeStrategyEntity();
        JRadioButton localBtn = layout.getLocalBtn();
        JRadioButton onlineBtn = layout.getOnlineBtn();
        if (localBtn.isSelected() && this.saveLocalLayout(localLayout, strategyEntity)) {
            return false;
        }
        if (onlineBtn.isSelected() && this.saveOnlineLayout(onlineLayout, strategyEntity)) {
            return false;
        }
        String uuid = strategyEntity.getUuid().toString();
        BundleUpgradeContext.getInstance().setLatestStrategyUuid(uuid);
        BundleUpgradeContext.getInstance().getStrategyEntityMap().put(uuid, strategyEntity);
        LOGGER.info("save the upgrade type selection information successfully.");
        return true;
    }

    private boolean saveOnlineLayout(SelectOnlineUpgradeLayout onlineLayout, UpgradeStrategyEntity strategyEntity) {
        JComboBox<String> baseLineCombo = onlineLayout.getBaseLineCombo();
        if (null == baseLineCombo || baseLineCombo.getSelectedItem() == null) {
            DialogUtils.showInfoDialog((Frame)((Object)BundleUpgradeContext.getInstance().getMainDialog()), (String)RES.getString("bundle.upgrade.type.panel.next.step.tip2"));
            return true;
        }
        Object baselineSelected = baseLineCombo.getSelectedItem();
        String selectedDownloadToLocalPath = onlineLayout.getDownloadToLocalField().getText().trim();
        if (StringUtils.isNULLStr((String)selectedDownloadToLocalPath)) {
            DialogUtils.showInfoDialog((Frame)((Object)BundleUpgradeContext.getInstance().getMainDialog()), (String)RES.getString("bundle.upgrade.type.panel.next.step.tip3"));
            return true;
        }
        String baseline = baselineSelected.toString();
        baseline = baseline.contains(RES.getString("bundle.upgrade.recommend")) ? baseline.replace(RES.getString("bundle.upgrade.recommend"), "") : baseline;
        this.saveTheFwPackageLocalPath(selectedDownloadToLocalPath, baseline);
        strategyEntity.setPackageImportMethod(UpgradeParamConstants.PackageImportMethod.ONLINE);
        strategyEntity.setBaselineVersion(baseline);
        strategyEntity.setHoupUserName(onlineLayout.getHoupAccountField().getText().trim());
        strategyEntity.setHoupPsd(BundleUpgradeContext.getInstance().getHoupSk().toCharArray());
        strategyEntity.setHoupAddr(onlineLayout.getHoupAddrField().getText().trim());
        return false;
    }

    private boolean saveLocalLayout(SelectLocalUpgradeLayout localLayout, UpgradeStrategyEntity strategyEntity) {
        String selectedLocalImportPath = localLayout.getPackagePathField().getText().trim();
        if (StringUtils.isNULLStr((String)selectedLocalImportPath) || !SecurityUtils.isValidAndSafePath((String)selectedLocalImportPath)) {
            DialogUtils.showInfoDialog((Frame)((Object)BundleUpgradeContext.getInstance().getMainDialog()), (String)RES.getString("bundle.upgrade.type.panel.next.step.tip1"));
            return true;
        }
        if (!this.fwPackageListIsRepeated()) {
            return true;
        }
        strategyEntity.setPackageImportMethod(UpgradeParamConstants.PackageImportMethod.OFFLINE);
        strategyEntity.setBaselineVersion("localUpgradePackage");
        return false;
    }

    private void addFwPackageInfoToTempMap(FirmwarePackageEntity fwEntity, String path) {
        String key = ServiceUtil.getPackageInfoKeyWithoutPath(fwEntity);
        if (tempFwPackageMap.get(key) == null) {
            ArrayList<String> pathList = new ArrayList<String>();
            pathList.add(path);
            tempFwPackageMap.put(key, pathList);
        } else {
            tempFwPackageMap.get(key).add(path);
        }
    }

    public boolean fwPackageListIsRepeated() {
        if (!this.checkRepeated()) {
            RepeatedFwPackageViewDialog dialog = new RepeatedFwPackageViewDialog((Window)((Object)BundleUpgradeContext.getInstance().getMainDialog()), tempFwPackageMap, this.typeSelectionCard);
            UiMethod.putScreenCenter((Window)((Object)dialog));
            dialog.setVisible(true);
            return false;
        }
        return true;
    }

    private boolean checkRepeated() {
        for (Map.Entry<String, List<String>> entry : tempFwPackageMap.entrySet()) {
            if (entry.getValue().size() <= 1) continue;
            return false;
        }
        return true;
    }

    public void showFailedPkgInfo() {
        if (this.checkFailedPkg.isEmpty()) {
            return;
        }
        String[] tittle = new String[]{RES.getString("parse.pangea.pkg.col1"), RES.getString("parse.pangea.pkg.col2"), RES.getString("parse.pangea.pkg.col3")};
        DialogUtils.showMultiErrorDialog((Window)((Object)BundleUpgradeContext.getInstance().getMainDialog()), (String)RES.getString("parse.pangea.pkg.desc"), (String[])tittle, this.checkFailedPkg);
    }

    private boolean checkSignatureFileIsExisted(String filePath) {
        return org.apache.commons.io.FileUtils.getFile((String[])new String[]{filePath}).exists();
    }
}

