/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.service.connection;

import com.huawei.bundleupgrade.entity.DeviceEntity;
import com.huawei.uMate.common.UMateException;
import com.huawei.uMate.common.rest.RedfishConnestion;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestConnPool {
    private static final Logger log = LoggerFactory.getLogger(RestConnPool.class);
    private static ConcurrentHashMap<DeviceEntity, RedfishConnestion> connectionPool = new ConcurrentHashMap();

    private RestConnPool() {
    }

    public static RedfishConnestion getRedFishConnection(DeviceEntity deviceEntity) throws UMateException {
        if (connectionPool.containsKey(deviceEntity) && connectionPool.get(deviceEntity) != null) {
            return connectionPool.get(deviceEntity);
        }
        return RestConnPool.createRedFishConnector(deviceEntity);
    }

    private static RedfishConnestion createRedFishConnector(DeviceEntity deviceEntity) {
        RedfishConnestion restConn = new RedfishConnestion(deviceEntity.getIp(), deviceEntity.getHttpsPort(), deviceEntity.getAccount().getUserName(), deviceEntity.getAccount().getPassword());
        restConn.connect();
        connectionPool.put(deviceEntity, restConn);
        return restConn;
    }

    public static void releaseConnection(DeviceEntity deviceEntity) {
        if (deviceEntity == null) {
            return;
        }
        Optional.of(deviceEntity).map(connectionPool::remove).ifPresent(RedfishConnestion::release);
        log.info("release redfish connection: {}", (Object)deviceEntity.getIp());
    }
}

