/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.service.connection;

import com.huawei.bundleupgrade.entity.DeviceEntity;
import com.huawei.bundleupgrade.service.connection.SSHAndSFTPConnector;
import com.huawei.ism.tool.obase.connection.support.ConnUtils;
import com.huawei.uMate.common.UMateException;
import com.huawei.uMate.common.utils.ResUtil;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSHAndSFTPConnectionPool {
    private static final Logger log = LoggerFactory.getLogger(SSHAndSFTPConnectionPool.class);
    private static final ResUtil RES = ResUtil.getInstance((String)"BundleUpgrade");
    private static ConcurrentHashMap<DeviceEntity, SSHAndSFTPConnector> connectionPool = new ConcurrentHashMap();

    private SSHAndSFTPConnectionPool() {
    }

    public static SSHAndSFTPConnector getSSHAndSFTPConnection(DeviceEntity deviceEntity) throws UMateException {
        return SSHAndSFTPConnectionPool.createSshAndSFTPConnector(deviceEntity);
    }

    private static SSHAndSFTPConnector createSshAndSFTPConnector(DeviceEntity deviceEntity) throws UMateException {
        SSHAndSFTPConnectionPool.releaseConnection(deviceEntity);
        for (int tryTime = 1; tryTime <= 3; ++tryTime) {
            try {
                SSHAndSFTPConnector connector = new SSHAndSFTPConnector(deviceEntity);
                connectionPool.put(deviceEntity, connector);
                return connector;
            }
            catch (UMateException umExc) {
                log.error(String.format(Locale.ENGLISH, "exception occurred on creation of ssh and sftp instance: %s.", umExc.getMessage()));
                ConnUtils.sleep((int)(10000 * tryTime));
                continue;
            }
        }
        throw new UMateException(RES.getString("ssh.connection.failed"));
    }

    public static void releaseConnection(DeviceEntity deviceEntity) {
        if (connectionPool.containsKey(deviceEntity) && connectionPool.get(deviceEntity) != null) {
            connectionPool.get(deviceEntity).disconnect();
        }
    }
}

