/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.service.connection.fusionstrg;

import com.huawei.bundleupgrade.entity.UpgradeDeviceEntity;
import com.huawei.bundleupgrade.entity.fusionstrg.FusionStorageClusterInfoEntity;
import com.huawei.bundleupgrade.utils.UpgradeScenarioUtil;
import com.huawei.bundleupgrade.utils.fusionstrg.FusionStrgUpgradeContext;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.protocol.rest.RestConnection;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.uMate.common.UMateException;
import com.huawei.uMate.common.utils.ResUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FusionStorageRestConnector {
    private static final Logger log = LoggerFactory.getLogger(FusionStorageRestConnector.class);
    private static final ResUtil RES = ResUtil.getInstance((String)"BundleUpgrade");
    private volatile RestConnection restConnection;
    private String baseUri;
    private FusionStorageClusterInfoEntity clusterFloatNode;
    private DevNode devNode;
    private static final Object LOCK = new Object();

    public FusionStorageRestConnector(FusionStorageClusterInfoEntity floatIpAuthEntity) throws UMateException {
        this.clusterFloatNode = floatIpAuthEntity;
        this.devNode = FusionStorageRestConnector.buildDevNode(this.clusterFloatNode);
        this.connect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() throws UMateException {
        this.baseUri = "https://" + UpgradeScenarioUtil.foldIpWithBracketsIfIpV6(this.clusterFloatNode.getFloatIp()) + ":" + this.clusterFloatNode.getHttpPort();
        try {
            Object object = LOCK;
            synchronized (object) {
                this.restConnection = RestConnectionManager.getRestConnection((DevNode)this.devNode);
            }
        }
        catch (ToolException exception) {
            log.error("exception occurred connection to fusion storage's float ip", (Throwable)exception);
            throw new UMateException(RES.getString("connection.to.float.ip.failed"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String postRestResponse(String uri, Map<String, String> params) throws UMateException {
        Object object = LOCK;
        synchronized (object) {
            ResponseInfo response;
            String url = this.baseUri + uri;
            try {
                response = this.restConnection.execPost(url, params);
            }
            catch (ToolException e) {
                log.error(String.format(Locale.ENGLISH, "error occurred post url: %s.", url), (Throwable)e);
                throw new UMateException("http.connection.error.tool.exception");
            }
            return response.getContent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRestResponse(String uri, Map<String, String> params) throws UMateException {
        Object object = LOCK;
        synchronized (object) {
            ResponseInfo response;
            String url = this.baseUri + uri;
            try {
                response = this.restConnection.execGet(url, params);
            }
            catch (ToolException exception) {
                log.error(String.format(Locale.ENGLISH, "error occurred on url: %s.", url), (Throwable)exception);
                throw new UMateException("http.connection.error.tool.exception");
            }
            return response != null ? response.getContent() : null;
        }
    }

    public static DevNode buildDevNode(FusionStorageClusterInfoEntity clusterFloatNode) {
        DevNode floatNode = new DevNode();
        floatNode.setLoginUser(new User(clusterFloatNode.getAccount().getUserName(), clusterFloatNode.getAccount().getPassword()));
        floatNode.setDeviceSerialNumber(clusterFloatNode.getClusterSN());
        floatNode.setPort(Integer.parseInt(clusterFloatNode.getHttpPort()));
        floatNode.setIp(clusterFloatNode.getFloatIp());
        floatNode.setItDeviceType(ItDeviceType.DStorage);
        floatNode.setProductVersion(clusterFloatNode.getProductVersion());
        floatNode.setHotPatchVersion(clusterFloatNode.getHotPatchVersion());
        floatNode.setProductModel(clusterFloatNode.getProductModel());
        return floatNode;
    }

    public static void releaseConn(List<UpgradeDeviceEntity> upgradeDeviceEntityList) {
        Map<String, FusionStorageClusterInfoEntity> floatIpAndDevMap = FusionStorageRestConnector.getFloatIpAndDevMap(upgradeDeviceEntityList);
        floatIpAndDevMap.values().forEach(dev -> {
            DevNode devNode = FusionStorageRestConnector.buildDevNode(dev);
            log.info("release rest connection");
            FusionStorageRestConnector.releaseConnCacthException(devNode);
        });
    }

    public static void resetConn(List<UpgradeDeviceEntity> upgradeDeviceEntityList) {
        if (UpgradeScenarioUtil.isYinglong()) {
            return;
        }
        Map<String, FusionStorageClusterInfoEntity> floatIpAndDevMap = FusionStorageRestConnector.getFloatIpAndDevMap(upgradeDeviceEntityList);
        floatIpAndDevMap.values().forEach(dev -> {
            DevNode devNode = FusionStorageRestConnector.buildDevNode(dev);
            log.info("Reset connection");
            FusionStorageRestConnector.reSetConnCacthException(devNode);
        });
    }

    private static Map<String, FusionStorageClusterInfoEntity> getFloatIpAndDevMap(List<UpgradeDeviceEntity> upgradeDeviceEntityList) {
        HashMap<String, FusionStorageClusterInfoEntity> floatIpAndDevMap = new HashMap<String, FusionStorageClusterInfoEntity>();
        if (upgradeDeviceEntityList == null || upgradeDeviceEntityList.isEmpty()) {
            return floatIpAndDevMap;
        }
        upgradeDeviceEntityList.stream().forEach(dev -> {
            FusionStorageClusterInfoEntity value = FusionStrgUpgradeContext.getInstance().getBusinessIpMapper().get(dev).getBelongsClusterEntity();
            floatIpAndDevMap.put(value.getFloatIp(), value);
        });
        return floatIpAndDevMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseConn() {
        Object object = LOCK;
        synchronized (object) {
            FusionStorageRestConnector.releaseConnCacthException(this.devNode);
        }
    }

    private static void releaseConnCacthException(DevNode devNode) {
        try {
            log.info("release rest connection");
            RestConnectionManager.releaseConn((DevNode)devNode);
        }
        catch (Exception exception) {
            log.error("Release Conn error. ", (Throwable)exception);
        }
    }

    private static void reSetConnCacthException(DevNode devNode) {
        try {
            log.info("Reset connection");
            RestConnectionManager.releaseConn((DevNode)devNode);
            RestConnectionManager.getRestConnection((DevNode)devNode);
        }
        catch (Exception exception) {
            log.error("Reset Conn error. ", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reLogin() throws UMateException {
        try {
            Object object = LOCK;
            synchronized (object) {
                log.info("try to log again now");
                this.restConnection.reLogin();
            }
        }
        catch (ToolException e) {
            log.error("error occurred on connect");
            throw new UMateException("error occurred on connect");
        }
    }

    public boolean isLoginSuccess() {
        return this.restConnection != null && this.restConnection.isLogin();
    }

    public String getBaseUrl() {
        return "https://" + UpgradeScenarioUtil.foldIpWithBracketsIfIpV6(this.clusterFloatNode.getFloatIp()) + ":" + this.clusterFloatNode.getHttpPort();
    }

    public RestConnection getRestConnection() {
        return this.restConnection;
    }
}

