/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.service.connection.fusionstrg;

import com.huawei.bundleupgrade.entity.fusionstrg.UpgDeviceExtendFSDataEntity;
import com.huawei.bundleupgrade.utils.UpgradeScenarioUtil;
import com.huawei.ism.exception.IsmException;
import com.huawei.ism.tool.obase.connection.CustomDefaultSshJudge;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.connection.ISshJudge;
import com.huawei.ism.tool.obase.connection.SshConnection;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.protocol.factory.SftpConnector;
import com.huawei.ism.tool.protocol.sftp.SftpTransfer;
import com.huawei.uMate.common.UMateException;
import com.huawei.uMate.common.enums.CommonEnums;
import com.huawei.uMate.common.model.IPMIAndSNMPModel;
import com.huawei.uMate.common.ssh.Shell;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FusionStorageSshConnector
extends Shell {
    private static final Logger log = LoggerFactory.getLogger(FusionStorageSshConnector.class);
    private static final CustomDefaultSshJudge DEFAULT_SSH_JUDGE = new CustomDefaultSshJudge();
    private SshConnection ssh;
    private SftpTransfer sftpTransfer;
    private SftpConnector sftpConnector;
    private DevNode devNode;
    private boolean isLog = true;
    private boolean isSupportSSshForward;

    public FusionStorageSshConnector(UpgDeviceExtendFSDataEntity deviceEntity) throws UMateException {
        super((IPMIAndSNMPModel)UpgradeScenarioUtil.convertFSEntity2HWDiscoverModel(deviceEntity), CommonEnums.ShellType.ALL);
    }

    public FusionStorageSshConnector(DevNode devNode) throws ToolException {
        this.devNode = devNode;
        ICliConnection sshConnection = SshConnectionManager.getSshConnection((DevNode)devNode, (ISshJudge)DEFAULT_SSH_JUDGE);
        if (!(sshConnection instanceof SshConnection)) {
            throw new ToolException("exception when create ssh");
        }
        this.ssh = (SshConnection)sshConnection;
        this.sftpConnector = new SftpConnector(devNode);
        this.sftpTransfer = new SftpTransfer(devNode, true);
    }

    public String executeCmd(String cmd) throws Exception {
        if (this.isSupportSSshForward) {
            return this.ssh.execCmd(cmd);
        }
        return this.execute(cmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCmd(String cmd, boolean isLog) throws Exception {
        if (this.ssh != null) {
            return isLog ? this.ssh.execCmd(cmd) : this.ssh.execCmdNoLog(cmd);
        }
        try {
            this.setLog(isLog);
            String string = this.execute(cmd);
            return string;
        }
        finally {
            this.setLog(true);
        }
    }

    public void disconnect() {
        if (this.isSupportSSshForward) {
            this.ssh.close();
        } else {
            super.disconnect();
        }
    }

    public void mkdirs(String panGeaPackageUploadPath) {
        if (this.isSupportSSshForward) {
            try {
                this.sftpTransfer.getChannelSftp().mkdir(panGeaPackageUploadPath);
            }
            catch (IOException e) {
                log.error("mkdir on target device failed.", (Throwable)e);
            }
        } else {
            super.mkdirs(panGeaPackageUploadPath);
        }
    }

    public void uploadFile(String scriptToServer, String scriptFileName, boolean overwrite) throws IOException {
        if (this.isSupportSSshForward) {
            try {
                log.error("start upload to target device.");
                this.sftpConnector.putFile(scriptFileName, scriptToServer, null);
                log.error("finish upload to target device.");
            }
            catch (IsmException e) {
                log.error("upload to target device failed.", (Throwable)e);
                throw e;
            }
        } else {
            super.uploadFile(scriptToServer, scriptFileName, true);
        }
    }

    public synchronized boolean isConnected() {
        if (this.isSupportSSshForward) {
            return this.ssh.isConnected();
        }
        return super.isConnected();
    }

    public void getDeviceFile(String directory, String downloadFile, String saveFile) throws ToolException {
        if (this.isSupportSSshForward) {
            try {
                log.info("begin download...");
                String devPath = directory + downloadFile;
                this.sftpConnector.getFile(saveFile, devPath, null);
                log.info("finish download");
            }
            catch (IsmException e) {
                log.error("update file error", (Throwable)e);
                throw new ToolException("putFile file error.", false, (Throwable)e);
            }
        } else {
            super.getDeviceFile(directory, downloadFile, saveFile);
        }
    }

    public String execute(String cmd) throws Exception {
        String[] commands = new String[]{cmd};
        this.executeCommands(commands);
        return this.getResponse();
    }

    protected boolean isPrintLog(String cmd) {
        if (!this.isLog) {
            return false;
        }
        return super.isPrintLog(cmd);
    }

    protected boolean isPrintLog(String[] commands) {
        if (!this.isLog) {
            return false;
        }
        return super.isPrintLog(commands);
    }

    public SshConnection getSsh() {
        return this.ssh;
    }

    public SftpTransfer getSftpTransfer() {
        return this.sftpTransfer;
    }

    public SftpConnector getSftpConnector() {
        return this.sftpConnector;
    }

    public DevNode getDevNode() {
        return this.devNode;
    }

    public boolean isSupportSSshForward() {
        return this.isSupportSSshForward;
    }

    public void setLog(boolean isLog) {
        this.isLog = isLog;
    }

    public boolean isLog() {
        return this.isLog;
    }

    public void setSupportSSshForward(boolean isSupportSSshForward) {
        this.isSupportSSshForward = isSupportSSshForward;
    }
}

