/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.service.connection.fusionstrg;

import com.huawei.bundleupgrade.entity.fusionstrg.UpgDeviceExtendFSDataEntity;
import com.huawei.bundleupgrade.service.connection.fusionstrg.FusionStorageSshConnector;
import com.huawei.bundleupgrade.utils.fusionstrg.FusionStrgUpgradeContext;
import com.huawei.ism.tool.distributedfwupg.utils.CommonUtils;
import com.huawei.ism.tool.obase.connection.support.ConnUtils;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.uMate.common.UMateException;
import com.huawei.uMate.common.utils.ResUtil;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FusionStorageSshPool {
    private static final Logger log = LoggerFactory.getLogger(FusionStorageSshPool.class);
    private static final ResUtil RES = ResUtil.getInstance((String)"BundleUpgrade");
    private static ConcurrentHashMap<UpgDeviceExtendFSDataEntity, FusionStorageSshConnector> connectionPool = new ConcurrentHashMap();

    private FusionStorageSshPool() {
    }

    public static FusionStorageSshConnector getFsSshConnectionByBmcIp(String ip) throws UMateException {
        UpgDeviceExtendFSDataEntity deviceEntity = FusionStrgUpgradeContext.getInstance().getFsDeviceEntityByBmcIp(ip);
        if (deviceEntity != null) {
            return FusionStorageSshPool.getFsSshConnection(deviceEntity);
        }
        return null;
    }

    public static FusionStorageSshConnector getFsSshConnection(UpgDeviceExtendFSDataEntity deviceEntity) throws UMateException {
        return FusionStorageSshPool.createFsSshConnection(deviceEntity);
    }

    public static void releaseFsSshConnection(UpgDeviceExtendFSDataEntity deviceEntity) {
        if (connectionPool.containsKey(deviceEntity) && connectionPool.get(deviceEntity) != null) {
            connectionPool.get(deviceEntity).disconnect();
            connectionPool.remove(deviceEntity);
        }
    }

    private static FusionStorageSshConnector createFsSshConnection(UpgDeviceExtendFSDataEntity deviceEntity) throws UMateException {
        FusionStorageSshPool.releaseFsSshConnection(deviceEntity);
        DevNode devNode = CommonUtils.transUpgDeviceExtendFSDataEntity2DevNode(deviceEntity);
        for (int tryTime = 1; tryTime <= 3; ++tryTime) {
            try {
                FusionStorageSshConnector connector;
                if (CollectionUtils.isEmpty((Collection)devNode.getSshForwardList())) {
                    connector = new FusionStorageSshConnector(deviceEntity);
                } else {
                    connector = new FusionStorageSshConnector(devNode);
                    connector.setSupportSSshForward(true);
                }
                connectionPool.put(deviceEntity, connector);
                return connector;
            }
            catch (ToolException e) {
                log.error("exception when create ssh: {}.", (Object)e.getErrorLocaleDescription());
                ConnUtils.sleep((int)(10000 * tryTime));
                continue;
            }
        }
        throw new UMateException(RES.getString("ssh.connection.failed"));
    }
}

