/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.service.impl;

import com.huawei.bundleupgrade.constants.UpgradeParamConstants;
import com.huawei.bundleupgrade.entity.DeviceEntity;
import com.huawei.bundleupgrade.entity.DiskPkgInfo;
import com.huawei.bundleupgrade.entity.FirmwarePackageEntity;
import com.huawei.bundleupgrade.entity.UpgradeDeviceEntity;
import com.huawei.bundleupgrade.entity.UpgradeStrategyEntity;
import com.huawei.bundleupgrade.model.Module;
import com.huawei.bundleupgrade.service.QueryDeviceInfoService;
import com.huawei.bundleupgrade.service.connection.fusionstrg.FusionStorageSshConnector;
import com.huawei.bundleupgrade.service.connection.fusionstrg.FusionStorageSshPool;
import com.huawei.bundleupgrade.ui.BundleUpgradeMainDialog;
import com.huawei.bundleupgrade.utils.BundleUpgradeContext;
import com.huawei.bundleupgrade.utils.UpgradeConstants;
import com.huawei.bundleupgrade.utils.UpgradeCustomizationUtil;
import com.huawei.bundleupgrade.utils.UpgradeScenarioUtil;
import com.huawei.bundleupgrade.utils.fusionstrg.FusionStrgUpgradeContext;
import com.huawei.ism.tool.obase.utils.CliResolverUtils;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.uMate.common.UMateException;
import com.huawei.uMate.common.utils.ResUtil;
import java.io.File;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskUpgradeByDiskToolImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(DiskUpgradeByDiskToolImpl.class);
    private static final ResUtil RES = ResUtil.getInstance((String)"BundleUpgrade");
    private static final String EMPTY_INFO = RES.getString("bundle.upgrade.main.detail.info.empty");
    private BundleUpgradeMainDialog mainDialog = BundleUpgradeContext.getInstance().getMainDialog();
    private UpgradeDeviceEntity device;
    private FusionStorageSshConnector ssh;
    private FirmwarePackageEntity fwPkg;
    private List<DeviceEntity.DiskModel> needUpgradeDisk;
    private List<DeviceEntity.DiskModel> afterUpgradeDisk;
    private Map<String, DiskPkgInfo> updateUid2FwPkg;
    private Double maxProBlock;
    private Double basicPro;
    private String uploadPath;

    public DiskUpgradeByDiskToolImpl(UpgradeDeviceEntity device) {
        this.device = device;
    }

    private void upgradeModule(List<DeviceEntity.DiskModel> disks) throws Exception {
        disks.stream().filter(DeviceEntity.DiskModel::isSasOrSataDisk).forEach(this::upgradeSasOrSata);
        List<DeviceEntity.DiskModel> nvmeDisk = disks.stream().filter(DeviceEntity.DiskModel::isNVMeDisk).collect(Collectors.toList());
        this.offlineDiskAndFindDriveLetter(nvmeDisk);
        nvmeDisk.forEach(this::upgradeNVMeDisk);
        this.reStartSMIO();
    }

    private void upgradeNVMeDisk(DeviceEntity.DiskModel diskModel) {
        AtomicInteger maxSlot = new AtomicInteger(1);
        String driveLetter = diskModel.getDriveLetter();
        this.initMaxSlotNum(maxSlot, driveLetter);
        String cmd = "disktool -A N -z upgradefw -c %s -k 1 -w \"%s\" %s";
        int slot = maxSlot.get();
        String path = this.getFwPathOnServer(diskModel);
        for (int i = slot; i >= 1; --i) {
            try {
                String ret = this.ssh.executeCmd(String.format(Locale.ENGLISH, cmd, slot, path, driveLetter));
                if (!ret.contains("successed")) continue;
                break;
            }
            catch (Exception e) {
                LOGGER.error("Upgrade disk {} fw on slot {} failed.", (Object)diskModel.getEsn(), (Object)slot);
            }
        }
        if (!diskModel.isSriovDisk()) {
            return;
        }
        try {
            String resetCmd = "/opt/fusionstorage/persistence_layer/agent/tool/nvme subsystem-reset %s";
            this.ssh.executeCmd(String.format(Locale.ENGLISH, resetCmd, diskModel.getDriveLetter()));
        }
        catch (Exception e) {
            LOGGER.error("reset failed {} {}", (Object)diskModel.getEsn(), (Object)diskModel.getDriveLetter());
        }
    }

    private void initMaxSlotNum(AtomicInteger maxSlot, String driveLetter) {
        String key = "Number of Firmware Slots";
        String cmd = "disktool -A N -z idctrl %s | grep \"%s\"";
        Pattern maxSlotRegexPattern = Pattern.compile("0[xX]([1-9a-fA-F]|0(?![xX]))+\t");
        try {
            String[] ret = this.ssh.executeCmd(String.format(Locale.ENGLISH, cmd, driveLetter, key)).split("\r\n");
            Arrays.stream(ret).skip(1L).filter(line -> line.contains(key)).findFirst().ifPresent(line -> {
                Matcher matcher = maxSlotRegexPattern.matcher((CharSequence)line);
                if (matcher.find()) {
                    maxSlot.set(Integer.parseInt(matcher.group(0).replace("0x", ""), 16));
                }
                LOGGER.info("Disk {}'s max slot is {} .", (Object)driveLetter, (Object)maxSlot.get());
            });
        }
        catch (Exception e) {
            LOGGER.warn("Parse max slot num error,use default value.");
        }
    }

    private void reStartSMIO() {
        String cmd = "/opt/fusionstorage/persistence_layer/agent/script/dsware_smio_tool.sh restart";
        try {
            Thread.sleep(5000L);
            String ret = this.ssh.executeCmd(cmd);
            if (ret.contains("Input Yes continue")) {
                this.ssh.executeCmd("yes");
            }
            Thread.sleep(60000L);
        }
        catch (Exception e) {
            LOGGER.error("Restart smio error.", (Throwable)e);
        }
    }

    private void upgradeSasOrSata(DeviceEntity.DiskModel diskModel) {
        String cmd = "disktool -f u -w \"%s\" %s";
        String path = this.getFwPathOnServer(diskModel);
        try {
            this.ssh.executeCmd(String.format(Locale.ENGLISH, cmd, path, diskModel.getDriveLetter()));
            if (diskModel.isHuaweiSSD()) {
                LOGGER.info("Current disk is huawei sas ssd,need exec active cmd.");
                cmd = "disktool -A o -z restart %s";
                this.ssh.executeCmd(String.format(Locale.ENGLISH, cmd, diskModel.getDriveLetter()));
            }
        }
        catch (Exception e) {
            LOGGER.error("Upgrade disk {} failed.", (Object)diskModel.getEsn());
        }
    }

    private String getFwPathOnServer(DeviceEntity.DiskModel diskModel) {
        return UpgradeConstants.DISK_PACKAGE_UPLOAD_PATH + "/" + Module.DiskFw.findDiskInfo(this.updateUid2FwPkg, diskModel).map(DiskPkgInfo::getFileName).orElse("");
    }

    private boolean preCheckBeforeUpgrade(FirmwarePackageEntity fwPkg, UpgradeParamConstants.ModuleType module) {
        if (this.needUpgradeDisk.isEmpty()) {
            String msg = RES.getString("current.strategy.model.not.match");
            this.mainDialog.updateResult(this.device, msg, this.basicPro + this.maxProBlock, UpgradeParamConstants.SubProcessExecutionResult.NOT_INVOLVED, msg);
            return false;
        }
        Set<String> paths = this.needUpgradeDisk.stream().map(disk -> Module.DiskFw.findDiskInfo(this.updateUid2FwPkg, disk).get()).map(DiskPkgInfo::getLocalRelativePath).collect(Collectors.toSet());
        if (!this.uploadFwPackages(paths)) {
            LOGGER.error("upload package info fail");
            String msg = RES.getString("bundle.upgrade.main.detail.info.UPLOAD.FAILED", new Object[]{fwPkg.getPackageInfo().getModule()});
            this.mainDialog.updateExecuteResult(this.device, msg, (Double)(this.basicPro + this.maxProBlock), false);
            this.writeUpgradeResult(UpgradeParamConstants.FirmUpgradeStatus.FAILED, module, msg);
            return false;
        }
        List<DeviceEntity.DiskModel> hddDisk = this.needUpgradeDisk.stream().filter(DeviceEntity.DiskModel::isSasOrSataDisk).collect(Collectors.toList());
        if (!hddDisk.isEmpty()) {
            this.initHDDDiskLetter(hddDisk);
        }
        return true;
    }

    private void offlineDiskAndFindDriveLetter(List<DeviceEntity.DiskModel> disks) throws Exception {
        if (disks.isEmpty()) {
            return;
        }
        this.offlineDisks();
        Thread.sleep(60000L);
        this.initPCIeDriveLetter(disks);
    }

    private void initPCIeDriveLetter(List<DeviceEntity.DiskModel> disks) throws Exception {
        String cmd = "show_disk.sh";
        List datas = CliResolverUtils.parseHorizontalTable((String)this.ssh.executeCmd(cmd), Arrays.asList("Esn", "Name"), (String)"\\|");
        int retryTimes = 0;
        int maxRetryTimes = 3;
        while (datas.isEmpty() && ++retryTimes < 3) {
            Thread.sleep(60000L);
            LOGGER.warn("Query disk info is empty,try re-query {}", (Object)retryTimes);
            datas = CliResolverUtils.parseHorizontalTable((String)this.ssh.executeCmd(cmd), Arrays.asList("Esn", "Name"), (String)"\\|");
        }
        datas.forEach(data -> disks.stream().filter(disk -> disk.getEsn().equals(data.get("Esn"))).findFirst().ifPresent(disk -> disk.setName((String)data.get("Name"))));
    }

    private void offlineDisks() throws Exception {
        LOGGER.info("Try offline disk manager by SPDK.");
        String cmd = "/opt/fusionstorage/persistence_layer/agent/script/spdk_setup.sh status";
        List datas = CliResolverUtils.parseHorizontalTable((String)this.ssh.executeCmd(cmd), Arrays.asList("BDF", "Driver name", "Device name"), (String)"\t");
        datas.stream().filter(data -> !"nvme".equals(data.get("Driver name"))).map(data -> (String)data.get("BDF")).filter(Objects::nonNull).forEach(this::offlineManagerBySPDK);
    }

    private void offlineManagerBySPDK(String bdf) {
        String cmd = "/opt/fusionstorage/persistence_layer/agent/script/spdk_setup.sh reset_device %s";
        try {
            this.ssh.executeCmd(String.format(Locale.ENGLISH, cmd, bdf));
        }
        catch (Exception e) {
            LOGGER.error("Offline disk {} failed.", (Object)bdf);
        }
    }

    private boolean uploadFwPackages(Set<String> paths) {
        LOGGER.info("begin upload pkgs {} .", paths);
        try {
            this.uploadPath = UpgradeConstants.DISK_PACKAGE_UPLOAD_PATH;
            this.ssh.mkdirs(this.uploadPath);
            for (String path : paths) {
                File localFile = new File(path);
                String targetServerFwPath = this.uploadPath + "/" + localFile.getName();
                this.ssh.uploadFile(targetServerFwPath, localFile.getCanonicalPath(), true);
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Upload file failed. {}", (Object)e.getMessage());
            return false;
        }
    }

    private void clearEnv() {
        if (this.ssh == null) {
            return;
        }
        try {
            if (!StringUtils.isNULLStr((String)this.uploadPath)) {
                this.ssh.executeCmd("rm -rf " + this.uploadPath);
            }
        }
        catch (Exception e) {
            LOGGER.error("Clear env failed.");
        }
        FusionStorageSshPool.releaseFsSshConnection(FusionStrgUpgradeContext.getInstance().getFsDeviceEntityByBmcIp(this.device.getDeviceEntity().getIp()));
    }

    private void initHDDDiskLetter(List<DeviceEntity.DiskModel> diskList) {
        try {
            String cmd = "disktool -s";
            List data = CliResolverUtils.parseHorizontalTable((String)this.ssh.executeCmd(cmd), Arrays.asList("Device", "Rev"), (String)"\\s+");
            data.forEach(diskInfo -> {
                String diskLetter = diskInfo.getOrDefault("Device", "");
                diskList.stream().filter(disk -> diskLetter.endsWith(disk.getName())).findFirst().ifPresent(disk -> disk.setDriveLetter(diskLetter));
            });
        }
        catch (Exception e) {
            LOGGER.error("Create ssh error. ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upgrade(UpgradeParamConstants.ModuleType module, Double proStepLen) {
        try {
            this.init(module, proStepLen);
            if (!this.preCheckBeforeUpgrade(this.fwPkg, module)) {
                return;
            }
            this.upgradeModule(this.needUpgradeDisk);
            this.postCheck(module);
        }
        catch (Exception e) {
            LOGGER.error("Upgrade disk error.", (Throwable)e);
            String msg = RES.getString("bundle.upgrade.main.detail.info.DO_UPGRADE.FAILED", new Object[]{this.fwPkg.getPackageInfo().getModule()});
            this.mainDialog.updateExecuteResult(this.device, msg, (Double)(this.basicPro + this.maxProBlock), false);
            this.writeUpgradeResult(UpgradeParamConstants.FirmUpgradeStatus.FAILED, module, msg);
        }
        finally {
            this.clearEnv();
        }
    }

    private void postCheck(UpgradeParamConstants.ModuleType module) throws Exception {
        List<DeviceEntity.DiskModel> disks = this.queryDiskInfo();
        List<DeviceEntity.DiskModel> failedDisk = this.filterUpgradeFailedDisks(disks);
        this.afterUpgradeDisk = this.queryDiskInfoAfterUpgrade(disks);
        if (failedDisk.isEmpty()) {
            LOGGER.info("Failed disk is empty.");
            this.writeUpgradeResult(UpgradeParamConstants.FirmUpgradeStatus.SUCCESS, module, EMPTY_INFO);
            this.mainDialog.updateExecuteResult(this.device, EMPTY_INFO, (Double)(this.basicPro + this.maxProBlock), true);
        } else if (failedDisk.size() != this.needUpgradeDisk.size()) {
            String failedMsg = failedDisk.stream().map(DeviceEntity.DiskModel::getEsn).collect(Collectors.toList()).toString();
            String msg = RES.getStringWithParams("upgrade.disk.failed", new Object[]{failedMsg});
            this.mainDialog.updateExecuteResult(this.device, msg, (Double)(this.basicPro + this.maxProBlock), UpgradeParamConstants.SubProcessExecutionResult.PARITIAL_SUCC);
            this.writeUpgradeResult(UpgradeParamConstants.FirmUpgradeStatus.FAILED, module, msg);
        } else {
            String failedMsg = failedDisk.stream().map(DeviceEntity.DiskModel::getEsn).collect(Collectors.toList()).toString();
            String msg = RES.getStringWithParams("upgrade.disk.failed", new Object[]{failedMsg});
            this.mainDialog.updateExecuteResult(this.device, msg, (Double)(this.basicPro + this.maxProBlock), UpgradeParamConstants.SubProcessExecutionResult.FAILED);
            this.writeUpgradeResult(UpgradeParamConstants.FirmUpgradeStatus.FAILED, module, msg);
        }
    }

    private List<DeviceEntity.DiskModel> queryDiskInfoAfterUpgrade(List<DeviceEntity.DiskModel> disks) {
        return disks.stream().filter(disk -> this.needUpgradeDisk.stream().anyMatch(upDisk -> upDisk.getEsn().equals(disk.getEsn()))).collect(Collectors.toList());
    }

    private List<DeviceEntity.DiskModel> queryDiskInfo() throws Exception {
        QueryDeviceInfoService service = QueryDeviceInfoService.getInstance();
        if (this.device.getDeviceEntity().isEastSeaDoubleServer() && !UpgradeScenarioUtil.isYinglong()) {
            return service.queryAndBuildDisksAndRemoveByCache(this.device.getDeviceEntity(), this.ssh);
        }
        return service.queryAndBuildDisks(this.device.getDeviceEntity(), this.ssh);
    }

    private List<DeviceEntity.DiskModel> filterUpgradeFailedDisks(List<DeviceEntity.DiskModel> disks) {
        return this.needUpgradeDisk.stream().filter(upDisk -> {
            DeviceEntity.DiskModel newDisk = disks.stream().filter(disk -> upDisk.getEsn().equals(disk.getEsn())).findFirst().orElse(null);
            if (Objects.isNull(newDisk)) {
                LOGGER.error("Disk {} info lost.", (Object)upDisk.getEsn());
                return true;
            }
            return !this.getTargetVer((DeviceEntity.DiskModel)upDisk).equals(newDisk.getFirmwareVersion());
        }).collect(Collectors.toList());
    }

    private void init(UpgradeParamConstants.ModuleType module, Double progressStepLen) throws UMateException {
        String curDes = RES.getStringWithParams("upgrade.sub.process.title", new Object[]{module.getModule(), "ALL"});
        this.mainDialog.createExecuteResult(this.device, curDes);
        this.maxProBlock = progressStepLen;
        this.basicPro = this.device.getExecuteInfo().getTotalProcess();
        this.fwPkg = this.initFirmwarePackage(module);
        this.updateUid2FwPkg = Module.DiskFw.buildDiskUidMap(this.fwPkg.getDiskPkgInfos());
        UpgradeCustomizationUtil.resetDiskInfos(this.device.getDeviceEntity(), this.fwPkg);
        this.needUpgradeDisk = this.device.getDeviceEntity().getDiskInfo().stream().filter(disk -> Module.DiskFw.canUpgrade(this.updateUid2FwPkg, disk)).collect(Collectors.toList());
        this.afterUpgradeDisk = this.needUpgradeDisk;
        this.ssh = FusionStorageSshPool.getFsSshConnectionByBmcIp(this.device.getDeviceEntity().getIp());
    }

    public List<DeviceEntity.DiskModel> getNeedUpgradeDisk(UpgradeParamConstants.ModuleType module) {
        FirmwarePackageEntity fwPkgEntity = this.initFirmwarePackage(module);
        Map<String, DiskPkgInfo> stringDiskPkgInfoMap = Module.DiskFw.buildDiskUidMap(fwPkgEntity.getDiskPkgInfos());
        UpgradeCustomizationUtil.resetDiskInfos(this.device.getDeviceEntity(), fwPkgEntity);
        return this.device.getDeviceEntity().getDiskInfo().stream().filter(disk -> Module.DiskFw.canUpgrade(stringDiskPkgInfoMap, disk)).collect(Collectors.toList());
    }

    private FirmwarePackageEntity initFirmwarePackage(UpgradeParamConstants.ModuleType moduleType) {
        UpgradeStrategyEntity strategy = BundleUpgradeContext.getInstance().getStrategyEntityMap().get(this.device.getAssociatedStrategyId());
        Map<UpgradeParamConstants.ModuleType, List<String>> moduleTargetFirmwareMap = strategy.getModuleTargetFirmwareMap();
        ConcurrentHashMap<String, FirmwarePackageEntity> firmwarePackageMap = BundleUpgradeContext.getInstance().getFirmwarePackageMap();
        return (FirmwarePackageEntity)firmwarePackageMap.get(moduleTargetFirmwareMap.get((Object)moduleType).get(0));
    }

    private void writeUpgradeResult(UpgradeParamConstants.FirmUpgradeStatus status, UpgradeParamConstants.ModuleType module, String resultMsg) {
        LinkedList<UpgradeDeviceEntity.FirmUpgradeResult> newFirmUpgradeResultList = new LinkedList<UpgradeDeviceEntity.FirmUpgradeResult>();
        UpgradeDeviceEntity.FirmUpgradeResult firmUpgradeResult = new UpgradeDeviceEntity.FirmUpgradeResult();
        String split = ";</br>";
        String fromVer = this.needUpgradeDisk.stream().map(disk -> disk.getEsn() + ":" + disk.getFirmwareVersion()).collect(Collectors.joining(split));
        firmUpgradeResult.setFirmwareUid(this.fwPkg.getPackageInfo().getSupportModelUID());
        firmUpgradeResult.setFromVersion(fromVer);
        String toVer = this.afterUpgradeDisk.stream().map(disk -> disk.getEsn() + ":" + disk.getFirmwareVersion()).collect(Collectors.joining(split));
        firmUpgradeResult.setToVersion(toVer);
        firmUpgradeResult.setStatus(status);
        firmUpgradeResult.setResultMsg(resultMsg);
        firmUpgradeResult.setFirmwarePackage(this.fwPkg);
        newFirmUpgradeResultList.add(firmUpgradeResult);
        this.device.getUpgradeDetails().put(module, newFirmUpgradeResultList);
    }

    private String getTargetVer(DeviceEntity.DiskModel disk) {
        return Module.DiskFw.findDiskInfo(this.updateUid2FwPkg, disk).map(DiskPkgInfo::getTargetVersion).orElse("--");
    }
}

